/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import org.apache.activemq.broker.BrokerService;

public class ActiveMQFactory {
    private static final Method setThreadProperties;
    private static final Method createBroker;
    private static final Object instance;
    private static Class clazz;
    private static String brokerPrefix;

    public static String getBrokerMetaFile() {
        return brokerPrefix;
    }

    public static void setThreadProperties(Properties p) {
        try {
            setThreadProperties.invoke(instance, p);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ActiveMQFactory.setThreadProperties.IllegalAccessException", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("ActiveMQFactory.setThreadProperties.IllegalArgumentException", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("ActiveMQFactory.setThreadProperties.InvocationTargetException", e);
        }
    }

    public BrokerService createBroker(URI brokerURI) throws Exception {
        try {
            return (BrokerService)createBroker.invoke(instance, brokerURI);
        }
        catch (IllegalAccessException e) {
            throw new Exception("ActiveMQFactory.createBroker.IllegalAccessException", e);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("ActiveMQFactory.createBroker.IllegalArgumentException", e);
        }
        catch (InvocationTargetException e) {
            throw new Exception("ActiveMQFactory.createBroker.InvocationTargetException", e);
        }
    }

    static {
        try {
            clazz = Class.forName("org.apache.openejb.resource.activemq.ActiveMQ5Factory");
            brokerPrefix = "amq5factory:";
        }
        catch (Throwable t1) {
            try {
                clazz = Class.forName("org.apache.openejb.resource.activemq.ActiveMQ4Factory");
                brokerPrefix = "amq4factory:";
            }
            catch (Throwable t2) {
                throw new RuntimeException("Unable to load ActiveMQFactory");
            }
        }
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create ActiveMQFactory instance");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access ActiveMQFactory instance");
        }
        try {
            setThreadProperties = clazz.getDeclaredMethod("setThreadProperties", Properties.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to create ActiveMQFactory setThreadProperties method");
        }
        try {
            createBroker = clazz.getDeclaredMethod("createBroker", URI.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to create ActiveMQFactory setThreadProperties method");
        }
    }
}

