/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private static final HashMap<String, Class> primitives = new HashMap();

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int arrayDimentions = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++arrayDimentions;
        }
        Class<?> clazz = primitives.get(string);
        if (clazz == null) {
            clazz = Class.forName(string, true, classLoader);
        }
        if (arrayDimentions == 0) {
            return clazz;
        }
        return Array.newInstance(clazz, new int[arrayDimentions]).getClass();
    }

    public static String packageName(Class clazz) {
        return Classes.packageName(clazz.getName());
    }

    public static String packageName(String clazzName) {
        int i = clazzName.lastIndexOf(46);
        if (i > 0) {
            return clazzName.substring(0, i);
        }
        return "";
    }

    public static List<String> getSimpleNames(Class ... classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class aClass : classes) {
            list.add(aClass.getSimpleName());
        }
        return list;
    }

    static {
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
    }
}

