/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.beans.PropertyEditorManager;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.util.DurationEditor;
import org.apache.openejb.util.Join;

public class Duration {
    private long time;
    private TimeUnit unit;

    public Duration() {
    }

    public Duration(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    public Duration(String string) {
        String[] strings = string.split(",| and ");
        Duration total = new Duration();
        for (String s : strings) {
            char c;
            int i;
            Duration part = new Duration();
            s = s.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Duration.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Duration.invalidFormat(s);
                }
                ++i;
            }
            part.time = Integer.parseInt(t.toString());
            Unit unit1 = Duration.parseUnit(u.toString());
            if (unit1 != null) {
                switch (unit1) {
                    case days: {
                        part.time *= 86400L;
                        part.unit = TimeUnit.SECONDS;
                        break;
                    }
                    case hours: {
                        part.time *= 3600L;
                        part.unit = TimeUnit.SECONDS;
                        break;
                    }
                    case minutes: {
                        part.time *= 60L;
                        part.unit = TimeUnit.SECONDS;
                        break;
                    }
                    case seconds: {
                        part.unit = TimeUnit.SECONDS;
                        break;
                    }
                    case milliseconds: {
                        part.unit = TimeUnit.MILLISECONDS;
                        break;
                    }
                    case microseconds: {
                        part.unit = TimeUnit.MICROSECONDS;
                        break;
                    }
                    case nanoseconds: {
                        part.unit = TimeUnit.NANOSECONDS;
                    }
                }
            }
            total = total.add(part);
        }
        this.time = total.time;
        this.unit = total.unit;
    }

    public long getTime() {
        return this.time;
    }

    public long getTime(TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration that = (Duration)o;
        Normalize n = new Normalize(this, that);
        return n.a == n.b;
    }

    public Duration add(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a + n.b, n.base);
    }

    public Duration subtract(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a - n.b, n.base);
    }

    public static Duration parse(String text) {
        return new Duration(text);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal duration format: '" + text + "'.  Valid examples are '10s' or '10 seconds'.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.time);
        if (this.unit != null) {
            sb.append(" ");
            sb.append((Object)this.unit);
        }
        return sb.toString();
    }

    private static Unit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if (u.equalsIgnoreCase("NANOSECONDS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANOSECOND")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANOS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANO")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("MICROSECONDS")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICROSECOND")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICROS")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICRO")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MILLISECONDS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLISECOND")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLIS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLI")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("SECONDS")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("SECOND")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("SEC")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("S")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("MINUTES")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("MINUTE")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("MIN")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("M")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("HOURS")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HOUR")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HRS")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HR")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("H")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("DAYS")) {
            return Unit.days;
        }
        if (u.equalsIgnoreCase("DAY")) {
            return Unit.days;
        }
        if (u.equalsIgnoreCase("D")) {
            return Unit.days;
        }
        throw new IllegalArgumentException("Unknown time unit '" + u + "'.  Supported units " + Join.join(", ", (Object[])Unit.values()));
    }

    static {
        PropertyEditorManager.registerEditor(Duration.class, DurationEditor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        nanoseconds,
        microseconds,
        milliseconds,
        seconds,
        minutes,
        hours,
        days;

    }

    private static class Normalize {
        private long a;
        private long b;
        private TimeUnit base;

        private Normalize(Duration a, Duration b) {
            this.base = Normalize.lowest(a, b);
            this.a = a.unit == null ? a.time : this.base.convert(a.time, a.unit);
            this.b = b.unit == null ? b.time : this.base.convert(b.time, b.unit);
        }

        private static TimeUnit lowest(Duration a, Duration b) {
            if (a.unit == null) {
                return b.unit;
            }
            if (b.unit == null) {
                return a.unit;
            }
            if (a.time == 0L) {
                return b.unit;
            }
            if (b.time == 0L) {
                return a.unit;
            }
            return TimeUnit.values()[Math.min(a.unit.ordinal(), b.unit.ordinal())];
        }
    }
}

