/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.Logger;

public class JuliLogStream
implements LogStream {
    protected java.util.logging.Logger logger;

    public JuliLogStream(LogCategory logCategory) {
        this.logger = java.util.logging.Logger.getLogger(logCategory.getName());
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void fatal(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    private void log(Level level, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            OpenEJBLogRecord logRecord = new OpenEJBLogRecord(level, message);
            if (t != null) {
                logRecord.setThrown(t);
            }
            this.logger.log(logRecord);
        }
    }

    private static class OpenEJBLogRecord
    extends LogRecord {
        private String sourceClassName;
        private String sourceMethodName;
        private transient boolean sourceInited = false;

        public OpenEJBLogRecord(Level level, String message) {
            super(level, message);
        }

        public String getSourceClassName() {
            this.initSource();
            return this.sourceClassName;
        }

        public void setSourceClassName(String sourceClassName) {
            this.sourceInited = true;
            this.sourceClassName = sourceClassName;
        }

        public String getSourceMethodName() {
            this.initSource();
            return this.sourceMethodName;
        }

        public void setSourceMethodName(String sourceMethodName) {
            this.sourceInited = true;
            this.sourceMethodName = sourceMethodName;
        }

        private void initSource() {
            if (!this.sourceInited) {
                int i;
                StackTraceElement[] elements = new Throwable().getStackTrace();
                String current = null;
                for (i = 0; i < elements.length && !(current = elements[i].getClassName()).equals(Logger.class.getName()); ++i) {
                }
                while (++i < elements.length && elements[i].getClassName().equals(current)) {
                }
                if (i < elements.length) {
                    this.sourceClassName = elements[i].getClassName();
                    this.sourceMethodName = elements[i].getMethodName();
                }
                this.sourceInited = true;
            }
        }
    }
}

