/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkResolver<E> {
    private final Map<String, E> byFullName = new TreeMap<String, E>();
    private final Map<String, Collection<E>> byShortName = new TreeMap<String, Collection<E>>();

    public boolean add(String moduleId, String name, E value) {
        String fullName = moduleId + "#" + name;
        if (this.byFullName.containsKey(fullName)) {
            return false;
        }
        this.byFullName.put(fullName, value);
        Collection<E> values = this.byShortName.get(name);
        if (values == null) {
            values = new ArrayList();
            this.byShortName.put(name, values);
        }
        values.add(value);
        return true;
    }

    public Collection<E> values() {
        return this.byFullName.values();
    }

    public Collection<E> values(String shortName) {
        List es = this.byShortName.get(shortName);
        return es != null ? es : Collections.EMPTY_LIST;
    }

    public E resolveLink(String link, String moduleId) {
        URI moduleURI = URI.create(moduleId);
        return this.resolveLink(link, moduleURI);
    }

    public E resolveLink(String link, URI moduleUri) {
        if (!link.contains("#")) {
            E value = null;
            if (moduleUri != null) {
                value = this.byFullName.get(moduleUri.toString() + "#" + link);
            }
            if (value != null) {
                return value;
            }
            Collection<E> values = this.byShortName.get(link);
            if (values == null || values.size() != 1) {
                return null;
            }
            value = values.iterator().next();
            return value;
        }
        if (moduleUri != null) {
            String fullName = moduleUri.resolve(link).toString();
            E value = this.byFullName.get(fullName);
            return value;
        }
        return null;
    }

    protected E getUniqueMember() {
        if (this.byFullName.size() == 1) {
            return this.byFullName.values().iterator().next();
        }
        return null;
    }
}

