/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.openejb.util.proxy.LocalBeanProxyGenerator;
import org.apache.openejb.util.proxy.ProxyGenerationException;
import org.apache.xbean.asm.ClassWriter;
import org.apache.xbean.asm.FieldVisitor;
import org.apache.xbean.asm.Label;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.asm.Opcodes;
import org.apache.xbean.asm.Type;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBeanProxyGeneratorImpl
implements LocalBeanProxyGenerator,
Opcodes {
    private static final Unsafe unsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot get sun.misc.Unsafe", e);
            }
        }
    });

    @Override
    public Class createProxy(Class<?> clsToProxy, ClassLoader cl) {
        String proxyName = this.generateProxyName(clsToProxy.getName());
        return this.createProxy(clsToProxy, proxyName, cl);
    }

    private String generateProxyName(String clsName) {
        return clsName + "$LocalBeanProxy";
    }

    private Class createProxy(Class<?> clsToProxy, String proxyName, ClassLoader cl) {
        String clsName = proxyName.replaceAll("\\.", "/");
        try {
            return cl.loadClass(proxyName);
        }
        catch (Exception e) {
            try {
                byte[] proxyBytes = this.generateProxy(clsToProxy, clsName);
                return unsafe.defineClass(proxyName, proxyBytes, 0, proxyBytes.length, clsToProxy.getClassLoader(), clsToProxy.getProtectionDomain());
            }
            catch (ProxyGenerationException e2) {
                throw new InternalError(e2.toString());
            }
        }
    }

    private byte[] generateProxy(Class<?> clsToProxy, String proxyName) throws ProxyGenerationException {
        Method[] methods;
        ClassWriter cw = new ClassWriter(1);
        String clsToOverride = clsToProxy.getName().replaceAll("\\.", "/");
        String proxyClassName = proxyName.replaceAll("\\.", "/");
        cw.visit(49, 33, proxyClassName, null, clsToOverride, null);
        cw.visitSource(clsToOverride + ".java", null);
        FieldVisitor fv = cw.visitField(18, "invocationHandler", "Ljava/lang/reflect/InvocationHandler;", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, clsToOverride, "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, proxyName, "invocationHandler", "Ljava/lang/reflect/InvocationHandler;");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (Method method : methods = clsToProxy.getDeclaredMethods()) {
            this.processMethod(cw, method, proxyClassName, clsToOverride);
        }
        byte[] clsBytes = cw.toByteArray();
        return clsBytes;
    }

    private void processMethod(ClassWriter cw, Method method, String proxyName, String clsToOverride) throws ProxyGenerationException {
        if ("<init>".equals(method.getName())) {
            return;
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        MethodVisitor mv = cw.visitMethod(1, method.getName(), this.getMethodSignatureAsString(returnType, parameterTypes), null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        if (exceptionTypes.length > 0) {
            mv.visitTryCatchBlock(l0, l1, l2, "java/lang/reflect/InvocationTargetException");
        }
        mv.visitLabel(l0);
        mv.visitLdcInsn((Object)Type.getType((String)("L" + clsToOverride + ";")));
        mv.visitLdcInsn((Object)method.getName());
        this.createArrayDefinition(mv, parameterTypes.length, Class.class);
        int length = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitFieldInsn(178, wrapperType, "TYPE", "Ljava/lang/Class;");
            } else {
                mv.visitLdcInsn((Object)Type.getType((String)this.getAsmTypeAsString(parameterType, true)));
            }
            mv.visitInsn(83);
            if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                length += 2;
                continue;
            }
            ++length;
        }
        mv.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        mv.visitVarInsn(58, length);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyName, "invocationHandler", "Ljava/lang/reflect/InvocationHandler;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, length);
        this.createArrayDefinition(mv, parameterTypes.length, Object.class);
        int index = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitVarInsn(this.getVarInsn(parameterType), index);
                mv.visitMethodInsn(184, wrapperType, "valueOf", "(" + this.getPrimitiveLetter(parameterType) + ")L" + wrapperType + ";");
                mv.visitInsn(83);
                if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                    index += 2;
                    continue;
                }
                ++index;
                continue;
            }
            mv.visitVarInsn(25, index);
            mv.visitInsn(83);
            ++index;
        }
        mv.visitMethodInsn(185, "java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, this.getCastType(returnType));
        if (returnType.isPrimitive() && !Void.TYPE.equals(returnType)) {
            mv.visitMethodInsn(182, this.getWrapperType(returnType), this.getPrimitiveMethod(returnType), "()" + this.getPrimitiveLetter(returnType));
        }
        mv.visitLabel(l1);
        if (!Void.TYPE.equals(returnType)) {
            mv.visitInsn(this.getReturnInsn(returnType));
        } else {
            mv.visitInsn(87);
            mv.visitInsn(177);
        }
        if (exceptionTypes.length > 0) {
            mv.visitLabel(l2);
            mv.visitVarInsn(58, length);
            Label l5 = new Label();
            mv.visitLabel(l5);
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                mv.visitLdcInsn((Object)Type.getType((String)("L" + exceptionType.getCanonicalName().replaceAll("\\.", "/") + ";")));
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;");
                mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
                mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                Label l7 = new Label();
                mv.visitLabel(l7);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(182, "java/lang/reflect/InvocationTargetException", "getCause", "()Ljava/lang/Throwable;");
                mv.visitTypeInsn(192, exceptionType.getCanonicalName().replaceAll("\\.", "/"));
                mv.visitInsn(191);
                mv.visitLabel(l6);
                if (i != exceptionTypes.length - 1) continue;
                mv.visitTypeInsn(187, "java/lang/reflect/UndeclaredThrowableException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, length);
                mv.visitMethodInsn(183, "java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V");
                mv.visitInsn(191);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private int getReturnInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 172;
            }
            if (Boolean.TYPE.equals(type)) {
                return 172;
            }
            if (Character.TYPE.equals(type)) {
                return 172;
            }
            if (Byte.TYPE.equals(type)) {
                return 172;
            }
            if (Short.TYPE.equals(type)) {
                return 172;
            }
            if (Float.TYPE.equals(type)) {
                return 174;
            }
            if (Long.TYPE.equals(type)) {
                return 173;
            }
            if (Double.TYPE.equals(type)) {
                return 175;
            }
        }
        return 176;
    }

    private int getVarInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 21;
            }
            if (Boolean.TYPE.equals(type)) {
                return 21;
            }
            if (Character.TYPE.equals(type)) {
                return 21;
            }
            if (Byte.TYPE.equals(type)) {
                return 21;
            }
            if (Short.TYPE.equals(type)) {
                return 21;
            }
            if (Float.TYPE.equals(type)) {
                return 23;
            }
            if (Long.TYPE.equals(type)) {
                return 22;
            }
            if (Double.TYPE.equals(type)) {
                return 24;
            }
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    private String getPrimitiveMethod(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "intValue";
        }
        if (Boolean.TYPE.equals(type)) {
            return "booleanValue";
        }
        if (Character.TYPE.equals(type)) {
            return "charValue";
        }
        if (Byte.TYPE.equals(type)) {
            return "byteValue";
        }
        if (Short.TYPE.equals(type)) {
            return "shortValue";
        }
        if (Float.TYPE.equals(type)) {
            return "floatValue";
        }
        if (Long.TYPE.equals(type)) {
            return "longValue";
        }
        if (Double.TYPE.equals(type)) {
            return "doubleValue";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    String getCastType(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return this.getWrapperType(returnType);
        }
        return this.getAsmTypeAsString(returnType, false);
    }

    private String getWrapperType(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return Integer.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Character.TYPE.equals(type)) {
            return Character.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Short.TYPE.equals(type)) {
            return Short.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Float.TYPE.equals(type)) {
            return Float.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Long.TYPE.equals(type)) {
            return Long.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Double.TYPE.equals(type)) {
            return Double.class.getCanonicalName().replaceAll("\\.", "/");
        }
        if (Void.TYPE.equals(type)) {
            return Void.class.getCanonicalName().replaceAll("\\.", "/");
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    private void pushIntOntoStack(MethodVisitor mv, int i) {
        if (i == 0) {
            mv.visitInsn(3);
        } else if (i == 1) {
            mv.visitInsn(4);
        } else if (i == 2) {
            mv.visitInsn(5);
        } else if (i == 3) {
            mv.visitInsn(6);
        } else if (i == 4) {
            mv.visitInsn(7);
        } else if (i == 5) {
            mv.visitInsn(8);
        } else if (i > 5 && i <= 255) {
            mv.visitIntInsn(16, i);
        } else {
            mv.visitIntInsn(17, i);
        }
    }

    private void createArrayDefinition(MethodVisitor mv, int size, Class<?> type) throws ProxyGenerationException {
        if (size < 0) {
            throw new ProxyGenerationException("Array size cannot be less than zero");
        }
        this.pushIntOntoStack(mv, size);
        mv.visitTypeInsn(189, type.getCanonicalName().replaceAll("\\.", "/"));
    }

    String getMethodSignatureAsString(Class<?> returnType, Class<?>[] parameterTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (Class<?> parameterType : parameterTypes) {
            builder.append(this.getAsmTypeAsString(parameterType, true));
        }
        builder.append(")");
        builder.append(this.getAsmTypeAsString(returnType, true));
        return builder.toString();
    }

    private String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    public String getAsmTypeAsString(Class<?> parameterType, boolean wrap) {
        if (parameterType.isArray()) {
            if (parameterType.getComponentType().isPrimitive()) {
                Class<?> componentType = parameterType.getComponentType();
                return "[" + this.getPrimitiveLetter(componentType);
            }
            return "[" + this.getAsmTypeAsString(parameterType.getComponentType(), true);
        }
        if (!parameterType.isPrimitive()) {
            String clsName = parameterType.getCanonicalName();
            if (parameterType.isMemberClass()) {
                int lastDot = clsName.lastIndexOf(".");
                clsName = clsName.substring(0, lastDot) + "$" + clsName.substring(lastDot + 1);
            }
            if (wrap) {
                return "L" + clsName.replaceAll("\\.", "/") + ";";
            }
            return clsName.replaceAll("\\.", "/");
        }
        return this.getPrimitiveLetter(parameterType);
    }
}

