/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.JtaQuery;
import org.apache.openejb.persistence.JtaTypedQuery;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.Reflections;

public class JtaEntityManager
implements EntityManager,
Serializable {
    private static final Logger baseLogger = Logger.getInstance(LogCategory.OPENEJB.createChild("persistence"), JtaEntityManager.class);
    private static final Method CREATE_NAMED_QUERY_FROM_NAME = Reflections.findMethod("createNamedQuery", EntityManager.class, String.class);
    private static final Method CREATE_QUERY_FROM_NAME = Reflections.findMethod("createQuery", EntityManager.class, String.class);
    private static final Method CREATE_NATIVE_FROM_NAME = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class);
    private static final Method CREATE_NAMED_QUERY_FROM_NAME_CLASS = Reflections.findMethod("createNamedQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_QUERY_FROM_NAME_CLASS = Reflections.findMethod("createQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_QUERY_FROM_CRITERIA = Reflections.findMethod("createQuery", EntityManager.class, CriteriaQuery.class);
    private static final Method CREATE_NATIVE_FROM_NAME_CLASS = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_NATIVE_FROM_NAME_MAPPING = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class, String.class);
    private final JtaEntityManagerRegistry registry;
    private final EntityManagerFactory entityManagerFactory;
    private final Map properties;
    private final boolean extended;
    private final String unitName;
    private final Logger logger;

    public JtaEntityManager(JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, String unitName) {
        this(unitName, registry, entityManagerFactory, properties, false);
    }

    public JtaEntityManager(String unitName, JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, boolean extended) {
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        this.unitName = unitName;
        this.registry = registry;
        this.entityManagerFactory = entityManagerFactory;
        this.properties = properties;
        this.extended = extended;
        this.logger = unitName == null ? baseLogger : baseLogger.getChildLogger(unitName);
    }

    EntityManager getEntityManager() {
        return this.registry.getEntityManager(this.entityManagerFactory, this.properties, this.extended, this.unitName);
    }

    boolean isTransactionActive() {
        return this.registry.isTransactionActive();
    }

    private void assertTransactionActive() throws TransactionRequiredException {
        if (!this.extended && !this.isTransactionActive()) {
            throw new TransactionRequiredException();
        }
    }

    void closeIfNoTx(EntityManager entityManager) {
        if (!this.extended && !this.isTransactionActive()) {
            entityManager.close();
            this.logger.debug("Closed EntityManager(unit=" + this.unitName + ", hashCode=" + entityManager.hashCode() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getDelegate() {
        Timer timer = Op.getDelegate.start(this);
        try {
            EntityManager em = this.getEntityManager();
            em.getDelegate();
            EntityManager entityManager = em;
            return entityManager;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.persist.start(this);
        try {
            this.getEntityManager().persist(entity);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        this.assertTransactionActive();
        Timer timer = Op.merge.start(this);
        try {
            Object object = this.getEntityManager().merge(entity);
            return (T)object;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.remove.start(this);
        try {
            this.getEntityManager().remove(entity);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this);
            try {
                object = entityManager.find(entityClass, primaryKey);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.getReference.start(this);
            try {
                object = entityManager.getReference(entityClass, primaryKey);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.assertTransactionActive();
        Timer timer = Op.flush.start(this);
        try {
            this.getEntityManager().flush();
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.setFlushMode.start(this);
            try {
                entityManager.setFlushMode(flushMode);
            }
            finally {
                timer.stop();
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getFlushMode.start(this);
            try {
                FlushModeType flushModeType = entityManager.getFlushMode();
                timer.stop();
                return flushModeType;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        Timer timer = Op.lock.start(this);
        try {
            this.getEntityManager().lock(entity, lockMode);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this);
        try {
            this.getEntityManager().refresh(entity);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.extended && !this.isTransactionActive()) {
            return;
        }
        Timer timer = Op.clear.start(this);
        try {
            this.getEntityManager().clear();
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        Timer timer = Op.contains.start(this);
        try {
            boolean bl = (this.extended || this.isTransactionActive()) && this.getEntityManager().contains(entity);
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String qlString) {
        Timer timer = Op.createQuery.start(this);
        try {
            Query query = this.proxyIfNoTx(CREATE_QUERY_FROM_NAME, qlString);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        Timer timer = Op.createNamedQuery.start(this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NAMED_QUERY_FROM_NAME, name);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME, sqlString);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME_CLASS, sqlString, resultClass);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME_MAPPING, sqlString, resultSetMapping);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    private Query proxyIfNoTx(Method method, Object ... args) {
        if (!this.extended && !this.isTransactionActive()) {
            return new JtaQuery(this.getEntityManager(), this, method, args);
        }
        return this.createQuery(Query.class, this.getEntityManager(), method, args);
    }

    private <T> TypedQuery<T> typedProxyIfNoTx(Method method, Object ... args) {
        if (!this.extended && !this.isTransactionActive()) {
            return new JtaTypedQuery(this.getEntityManager(), this, method, args);
        }
        return this.createQuery(TypedQuery.class, this.getEntityManager(), method, args);
    }

    <T> T createQuery(Class<T> expected, EntityManager entityManager, Method method, Object ... args) {
        try {
            return expected.cast(method.invoke((Object)entityManager, args));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (RuntimeException.class.isInstance(t)) {
                throw (RuntimeException)RuntimeException.class.cast(t);
            }
            throw new OpenEJBRuntimeException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinTransaction() {
        Timer timer = Op.joinTransaction.start(this);
        try {
            this.getDelegate().joinTransaction();
        }
        finally {
            timer.stop();
        }
    }

    public void close() {
        throw new IllegalStateException("PersistenceUnit(name=" + this.unitName + ") - entityManager.close() call - See JPA 2.0 section 7.9.1", new Exception().fillInStackTrace());
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("A JTA EntityManager can not use the EntityTransaction API.  See JPA 1.0 section 5.5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        Timer timer = Op.createNamedQuery.start(this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_NAMED_QUERY_FROM_NAME_CLASS, name, resultClass);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        Timer timer = Op.createQuery.start(this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_QUERY_FROM_CRITERIA, criteriaQuery);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        Timer timer = Op.createQuery.start(this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_QUERY_FROM_NAME_CLASS, qlString, resultClass);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object entity) {
        Timer timer = Op.detach.start(this);
        try {
            if (!this.extended && this.isTransactionActive()) {
                this.getEntityManager().detach(entity);
            }
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this);
            try {
                object = entityManager.find(entityClass, primaryKey, properties);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this);
            try {
                object = entityManager.find(entityClass, primaryKey, lockMode);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this);
            try {
                object = entityManager.find(entityClass, primaryKey, lockMode, properties);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.getLockMode.start(this);
        try {
            LockModeType lockModeType = this.getEntityManager().getLockMode(entity);
            return lockModeType;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getMetamodel.start(this);
            try {
                Metamodel metamodel = entityManager.getMetamodel();
                timer.stop();
                return metamodel;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getProperties.start(this);
            try {
                Map map = entityManager.getProperties();
                timer.stop();
                return map;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getCriteriaBuilder.start(this);
            try {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                timer.stop();
                return criteriaBuilder;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.lock.start(this);
        try {
            this.getEntityManager().lock(entity, lockMode, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this);
        try {
            this.getEntityManager().refresh(entity, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this);
        try {
            this.getEntityManager().refresh(entity, lockMode);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this);
        try {
            this.getEntityManager().refresh(entity, lockMode, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object value) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.setProperty.start(this);
            try {
                entityManager.setProperty(name, value);
            }
            finally {
                timer.stop();
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEntityManager().unwrap(cls);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new IntraVmArtifact(this, true);
    }

    private static enum Op {
        clear,
        close,
        contains,
        createNamedQuery,
        createNativeQuery,
        createQuery,
        find,
        flush,
        getFlushMode,
        getReference,
        getTransaction,
        lock,
        merge,
        refresh,
        remove,
        setFlushMode,
        persist,
        detach,
        getLockMode,
        unwrap,
        setProperty,
        getCriteriaBuilder,
        getProperties,
        getMetamodel,
        joinTransaction,
        getDelegate;


        public Timer start(JtaEntityManager em) {
            return new Timer(this, em);
        }
    }

    public static class Timer {
        private final long start = System.nanoTime();
        private final Op operation;
        private final JtaEntityManager em;

        public Timer(Op operation, JtaEntityManager em) {
            this.operation = operation;
            this.em = em;
        }

        public void stop() {
            if (!this.em.logger.isDebugEnabled()) {
                return;
            }
            long time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            this.em.logger.debug("PersistenceUnit(name=" + this.em.unitName + ") - entityManager." + (Object)((Object)this.operation) + " - " + time + "ms");
        }
    }
}

