/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.openejb.resource.jdbc.managed.local.ManagedConnection;
import org.apache.openejb.util.reflection.Reflections;

public class ManagedDataSource
implements DataSource {
    private static final Class<?>[] CONNECTION_CLASS = new Class[]{Connection.class};
    protected final DataSource delegate;
    protected final TransactionManager transactionManager;
    protected final int hashCode;

    protected ManagedDataSource(DataSource ds, TransactionManager txMgr, int hc) {
        this.delegate = ds;
        this.hashCode = hc;
        this.transactionManager = txMgr;
        ManagedConnection.pushDataSource(this);
    }

    public ManagedDataSource(DataSource ds, TransactionManager txMgr) {
        this(ds, txMgr, ds.hashCode());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.managed(this.delegate.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.managed(this.delegate.getConnection(username, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return (Logger)Reflections.invokeByReflection(this.delegate, "getParentLogger", new Class[0], null);
    }

    private Connection managed(Connection connection) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_CLASS, (InvocationHandler)new ManagedConnection(this, connection, this.transactionManager));
    }

    public DataSource getDelegate() {
        return this.delegate;
    }

    public void clean() {
        ManagedConnection.cleanDataSource(this);
    }

    public boolean equals(Object o) {
        return CommonDataSource.class.isInstance(o) && this.hashCode == o.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

