/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.openejb.resource.jdbc.managed.xa.CommonDataSourceAdapter;
import org.apache.openejb.resource.jdbc.managed.xa.ManagedXAConnection;

public class ManagedXADataSource
extends ManagedDataSource {
    private static final Class<?>[] CONNECTION_CLASS = new Class[]{Connection.class};
    private final XADataSource xaDataSource;

    public ManagedXADataSource(CommonDataSource ds, TransactionManager txMgr) {
        super(CommonDataSourceAdapter.wrap(ds), txMgr, ds.hashCode());
        this.xaDataSource = (XADataSource)XADataSource.class.cast(ds);
    }

    @Override
    public Connection getConnection() throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection();
        return this.managedXA(xaConnection, xaConnection.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection(username, password);
        return this.managedXA(xaConnection, xaConnection.getConnection());
    }

    private Connection managedXA(XAConnection xaConnection, Connection connection) throws SQLException {
        return (Connection)Connection.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_CLASS, (InvocationHandler)new ManagedXAConnection(this.delegate, xaConnection, connection, this.transactionManager)));
    }
}

