/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.cdi.UpdatableSessionContextManager;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.web.context.ServletRequestContext;
import org.apache.webbeans.web.intercept.RequestScopedBeanInterceptorHandler;

public class CdiAppContextsService
extends AbstractContextsService
implements ContextsService,
ConversationService {
    public static final Object EJB_REQUEST_EVENT = new Object();
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), CdiAppContextsService.class);
    private static final String CID = "cid";
    private final ThreadLocal<ServletRequestContext> requestContext = new ThreadLocal();
    private final ThreadLocal<SessionContext> sessionContext = new ThreadLocal();
    private final UpdatableSessionContextManager sessionCtxManager = new UpdatableSessionContextManager();
    private final ThreadLocal<ConversationContext> conversationContext;
    private final DependentContext dependentContext = new DependentContext();
    private final ApplicationContext applicationContext = new ApplicationContext();
    private final SingletonContext singletonContext = new SingletonContext();
    private final WebBeansContext webBeansContext;
    private final ConversationService conversationService;
    private volatile Object appEvent;
    private final boolean useGetParameter;
    private static final ThreadLocal<Collection<Runnable>> endRequestRunnables = new ThreadLocal<Collection<Runnable>>(){

        @Override
        protected Collection<Runnable> initialValue() {
            return new ArrayList<Runnable>();
        }
    };
    private volatile boolean autoConversationCheck = true;

    public CdiAppContextsService(WebBeansContext wbc) {
        this(wbc, wbc.getOpenWebBeansConfiguration().supportsConversation());
    }

    public CdiAppContextsService(WebBeansContext wbc, boolean supportsConversation) {
        this.webBeansContext = wbc != null ? wbc : WebBeansContext.currentInstance();
        this.dependentContext.setActive(true);
        if (supportsConversation) {
            this.conversationService = (ConversationService)this.webBeansContext.getService(ConversationService.class);
            this.conversationContext = this.conversationService == null ? null : new ThreadLocal();
        } else {
            this.conversationService = null;
            this.conversationContext = null;
        }
        this.applicationContext.setActive(true);
        this.singletonContext.setActive(true);
        this.useGetParameter = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cdi.conversation.http.use-get-parameter", "false"));
    }

    private void endRequest() {
        for (Runnable r : endRequestRunnables.get()) {
            try {
                r.run();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        endRequestRunnables.remove();
    }

    public static void pushRequestReleasable(Runnable runnable) {
        endRequestRunnables.get().add(runnable);
    }

    public String getConversationId() {
        return this.getHttpParameter(CID);
    }

    public String getConversationSessionId() {
        return this.currentSessionId(false);
    }

    public String currentSessionId(boolean force) {
        HttpSession session;
        HttpServletRequest req;
        ServletRequestContext rc = this.requestContext.get();
        if (rc != null && (req = rc.getServletRequest()) != null && (session = req.getSession(force)) != null) {
            return session.getId();
        }
        return null;
    }

    public void init(Object initializeObject) {
        this.startContext(ApplicationScoped.class, initializeObject);
        this.startContext(Singleton.class, initializeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeStop(Object ignored) {
        this.applicationContext.destroy();
        this.webBeansContext.getBeanManagerImpl().fireEvent(this.appEvent, new EventMetadataImpl(null, ServletContext.class.isInstance(this.appEvent) ? ServletContext.class : Object.class, null, new Annotation[]{DestroyedLiteral.INSTANCE_APPLICATION_SCOPED}, this.webBeansContext), false);
        this.applicationContext.setActive(true);
        this.singletonContext.destroy();
        this.singletonContext.setActive(true);
        for (Map.Entry conversation : this.webBeansContext.getConversationManager().getAllConversationContexts().entrySet()) {
            ((ConversationContext)conversation.getValue()).destroy();
            String id = ((Conversation)conversation.getKey()).getId();
            if (id == null) continue;
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)id, new Annotation[]{DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
        }
        for (SessionContext sc : this.sessionCtxManager.getContextById().values()) {
            SessionContext event;
            Object object = event = HttpSessionContextSessionAware.class.isInstance(sc) ? ((HttpSessionContextSessionAware)((Object)HttpSessionContextSessionAware.class.cast(sc))).getSession() : sc;
            if (HttpSession.class.isInstance(event)) {
                HttpSession httpSession = (HttpSession)HttpSession.class.cast(event);
                if (httpSession.getId() == null) continue;
                this.initSessionContext(httpSession);
                try {
                    httpSession.invalidate();
                    continue;
                }
                finally {
                    this.destroySessionContext(event);
                    continue;
                }
            }
            this.destroySessionContext(event);
        }
        this.sessionCtxManager.getContextById().clear();
    }

    public void destroy(Object destroyObject) {
        this.endContext(ApplicationScoped.class, destroyObject);
        this.endContext(Singleton.class, destroyObject);
        this.removeThreadLocals();
    }

    public void removeThreadLocals() {
        this.requestContext.set(null);
        this.requestContext.remove();
        this.sessionContext.set(null);
        this.sessionContext.remove();
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.destroyRequestContext(endParameters);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.destroySessionContext((HttpSession)endParameters);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.destroyApplicationContext();
            } else if (!scopeType.equals(Dependent.class)) {
                if (scopeType.equals(Singleton.class)) {
                    this.destroySingletonContext();
                } else if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
                    this.destroyConversationContext(endParameters);
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext(true);
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext(true);
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.getApplicationContext();
        }
        if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return this.dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getSingletonContext();
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.initRequestContext(startParameter);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.initSessionContext((HttpSession)startParameter);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.initApplicationContext(startParameter);
            } else if (scopeType.equals(Dependent.class)) {
                this.initSingletonContext();
            } else if (!scopeType.equals(Singleton.class)) {
                if (this.supportsConversation() && scopeType.equals(ConversationScoped.class) && !this.isTimeout()) {
                    this.initConversationContext(startParameter);
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    private void initSingletonContext() {
        this.singletonContext.setActive(true);
    }

    private void initApplicationContext(Object init) {
        if (this.appEvent == null) {
            Object event = init;
            if (StartupObject.class.isInstance(init)) {
                StartupObject so = (StartupObject)StartupObject.class.cast(init);
                if (so.isFromWebApp()) {
                    event = so.getWebContext().getServletContext();
                } else if (so.getAppInfo().webAppAlone) {
                    event = SystemInstance.get().getComponent(ServletContext.class);
                }
            } else if (ServletContextEvent.class.isInstance(init)) {
                event = ((ServletContextEvent)ServletContextEvent.class.cast(init)).getServletContext();
            }
            this.appEvent = event != null ? event : this.applicationContext;
            this.webBeansContext.getBeanManagerImpl().fireEvent(this.appEvent, new EventMetadataImpl(null, ServletContext.class.isInstance(this.appEvent) ? ServletContext.class : Object.class, null, new Annotation[]{InitializedLiteral.INSTANCE_APPLICATION_SCOPED}, this.webBeansContext), false);
        }
    }

    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation();
    }

    private void initRequestContext(Object event) {
        ServletRequestContext rq = new ServletRequestContext();
        rq.setActive(true);
        this.requestContext.set(rq);
        if (event != null && ServletRequestEvent.class.isInstance(event)) {
            HttpServletRequest request = (HttpServletRequest)((ServletRequestEvent)ServletRequestEvent.class.cast(event)).getServletRequest();
            rq.setServletRequest(request);
            if (request != null) {
                this.webBeansContext.getBeanManagerImpl().fireEvent((Object)request, new Annotation[]{InitializedLiteral.INSTANCE_REQUEST_SCOPED});
            }
            if (request != null) {
                String cid;
                HttpSession session = request.getSession(false);
                String string = this.conversationService != null ? (!this.useGetParameter ? CdiAppContextsService.getCid(request) : request.getParameter(CID)) : (cid = null);
                if (session != null) {
                    ConversationManager conversationManager;
                    ConversationImpl c;
                    this.initSessionContext(session);
                    if (this.autoConversationCheck && this.conversationService != null && !this.isConversationSkipped(request) && cid != null && (c = (conversationManager = this.webBeansContext.getConversationManager()).getPropogatedConversation(cid, session.getId())) != null) {
                        ConversationContext context = conversationManager.getConversationContext((Conversation)c);
                        context.setActive(true);
                        this.conversationContext.set(context);
                        return;
                    }
                }
                if (cid == null && !this.isTimeout() && this.autoConversationCheck) {
                    this.initConversationContext(request);
                }
            }
        } else if (event == EJB_REQUEST_EVENT) {
            this.webBeansContext.getBeanManagerImpl().fireEvent(event, new Annotation[]{InitializedLiteral.INSTANCE_REQUEST_SCOPED});
        }
    }

    public static String getCid(HttpServletRequest req) {
        return CdiAppContextsService.getFromQuery(CID, req.getQueryString());
    }

    public static String getFromQuery(String name, String q) {
        int cid;
        int n = cid = q == null ? -1 : q.indexOf(name + "=");
        if (cid < 0) {
            return null;
        }
        int end = q.indexOf("&", cid);
        int end2 = q.indexOf("#", cid);
        if (end2 > 0 && end2 < end) {
            end = end2;
        }
        if (end < 0) {
            end = q.length();
        }
        return q.substring(cid + name.length() + 1, end);
    }

    public boolean isAutoConversationCheck() {
        return this.autoConversationCheck;
    }

    public void checkConversationState() {
        HttpSession session;
        ServletRequestContext rc = this.getRequestContext(false);
        if (rc != null && rc.getServletRequest() != null && this.conversationService != null && (session = rc.getServletRequest().getSession(false)) != null) {
            String cid;
            String string = cid = this.useGetParameter ? rc.getServletRequest().getParameter(CID) : CdiAppContextsService.getFromQuery(CID, rc.getServletRequest().getQueryString());
            if (cid != null) {
                ConversationManager conversationManager = this.webBeansContext.getConversationManager();
                ConversationImpl c = conversationManager.getPropogatedConversation(cid, session.getId());
                if (!this.autoConversationCheck) {
                    this.initConversationContext(rc.getServletRequest());
                }
                if (c != null) {
                    if (c.isTransient()) {
                        throw new IllegalStateException("Conversation " + cid + " missing");
                    }
                    if (c.iUseIt() > 1) {
                        throw new BusyConversationException("busy conversation " + c.getId() + '(' + c.getSessionId() + ')');
                    }
                }
            }
        }
    }

    private void destroyRequestContext(Object end) {
        ELContextStore elStore;
        this.endRequest();
        ServletRequestContext context = this.getRequestContext(false);
        if (context != null) {
            HttpServletRequest servletRequest;
            if (this.supportsConversation()) {
                this.cleanupConversation();
            }
            if ((servletRequest = context.getServletRequest()) != null) {
                this.webBeansContext.getBeanManagerImpl().fireEvent((Object)servletRequest, new Annotation[]{DestroyedLiteral.INSTANCE_REQUEST_SCOPED});
            } else if (end == EJB_REQUEST_EVENT) {
                this.webBeansContext.getBeanManagerImpl().fireEvent(end, new Annotation[]{DestroyedLiteral.INSTANCE_REQUEST_SCOPED});
            }
            context.destroy();
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.requestContext.remove();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
    }

    private void cleanupConversation() {
        if (this.conversationService == null) {
            return;
        }
        ConversationContext cc = this.getConversationContext();
        if (cc == null) {
            return;
        }
        cc.setActive(false);
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        Conversation conversation = conversationManager.getConversationBeanReference();
        if (conversation == null) {
            return;
        }
        ConversationImpl conversationImpl = (ConversationImpl)ConversationImpl.class.cast(conversation);
        conversationImpl.iDontUseItAnymore();
        try {
            if (conversation.isTransient()) {
                this.endContext(ConversationScoped.class, null);
                conversationManager.removeConversation(conversation);
            } else {
                conversationImpl.updateTimeOut();
            }
        }
        catch (BusyConversationException bce) {
            // empty catch block
        }
    }

    private void initSessionContext(HttpSession session) {
        if (session == null) {
            return;
        }
        String sessionId = session.getId();
        SessionContext currentSessionContext = sessionId == null ? null : this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
        boolean fire = false;
        if (currentSessionContext == null) {
            currentSessionContext = this.newSessionContext(session);
            this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
            fire = true;
        }
        currentSessionContext.setActive(true);
        this.sessionContext.set(currentSessionContext);
        if (fire) {
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)session, new Annotation[]{InitializedLiteral.INSTANCE_SESSION_SCOPED});
        }
    }

    private SessionContext newSessionContext(HttpSession session) {
        String classname = ((ThreadSingletonService)SystemInstance.get().getComponent(ThreadSingletonService.class)).sessionContextClass();
        if (classname != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
                try {
                    Constructor<?> constr = clazz.getConstructor(HttpSession.class);
                    return (SessionContext)constr.newInstance(session);
                }
                catch (Exception e) {
                    return (SessionContext)clazz.newInstance();
                }
            }
            catch (Exception e) {
                logger.error("Can't instantiate " + classname + ", using default session context", e);
            }
        }
        return new HttpSessionContextSessionAware(session);
    }

    private void destroySessionContext(final Object session) {
        if (session != null) {
            final SessionContext context = this.sessionContext.get();
            if (context != null && context.isActive()) {
                ServletRequestContext servletRequestContext = this.getRequestContext(false);
                if (servletRequestContext == null || servletRequestContext.getServletRequest() == null) {
                    this.doDestroySession(context, session);
                } else {
                    CdiAppContextsService.pushRequestReleasable(new Runnable(){

                        @Override
                        public void run() {
                            CdiAppContextsService.this.doDestroySession(context, session);
                        }
                    });
                }
            }
            this.sessionContext.set(null);
            this.sessionContext.remove();
            if (HttpSession.class.isInstance(session)) {
                this.sessionCtxManager.removeSessionContextWithSessionId(((HttpSession)HttpSession.class.cast(session)).getId());
            }
        }
    }

    private void doDestroySession(SessionContext context, Object event) {
        context.destroy();
        this.webBeansContext.getBeanManagerImpl().fireEvent(event, new Annotation[]{DestroyedLiteral.INSTANCE_SESSION_SCOPED});
    }

    private void destroyApplicationContext() {
        this.applicationContext.destroy();
    }

    private void destroySingletonContext() {
        this.singletonContext.destroy();
    }

    private ConversationContext initConversationContext(Object request) {
        if (this.conversationService == null) {
            return null;
        }
        HttpServletRequest req = HttpServletRequest.class.isInstance(request) ? (HttpServletRequest)HttpServletRequest.class.cast(request) : null;
        ConversationContext context = ConversationContext.class.isInstance(request) ? (ConversationContext)ConversationContext.class.cast(request) : null;
        Object event = null;
        if (context == null) {
            ConversationContext existingContext = this.conversationContext.get();
            if (existingContext == null) {
                ServletRequestContext servletRequestContext;
                context = new ConversationContext();
                context.setActive(true);
                event = req != null ? req : ((servletRequestContext = this.getRequestContext(true)) != null && servletRequestContext.getServletRequest() != null ? servletRequestContext.getServletRequest() : context);
            } else {
                context = existingContext;
            }
        }
        this.conversationContext.set(context);
        context.setActive(true);
        if (event != null) {
            this.webBeansContext.getBeanManagerImpl().fireEvent(event, new Annotation[]{InitializedLiteral.INSTANCE_CONVERSATION_SCOPED});
        }
        return context;
    }

    private void destroyConversationContext(Object destroy) {
        if (this.conversationService == null) {
            return;
        }
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
            ServletRequestContext servletRequestContext = this.getRequestContext(false);
            Object destroyObject = servletRequestContext != null && servletRequestContext.getServletRequest() != null ? servletRequestContext.getServletRequest() : destroy;
            this.webBeansContext.getBeanManagerImpl().fireEvent(destroyObject == null ? context : destroyObject, new Annotation[]{DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
        }
        if (null != context) {
            this.conversationContext.remove();
        }
    }

    public ServletRequestContext getRequestContext(boolean create) {
        ServletRequestContext context = this.requestContext.get();
        if (context == null && create) {
            this.initRequestContext(null);
            return this.requestContext.get();
        }
        return context;
    }

    private Context getSessionContext(boolean create) {
        SessionContext context = this.sessionContext.get();
        if ((context == null || !context.isActive()) && create) {
            this.lazyStartSessionContext();
            context = this.sessionContext.get();
            if (context == null) {
                context = new SessionContext();
                context.setActive(true);
                this.sessionContext.set(context);
            }
        }
        return context;
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private SingletonContext getSingletonContext() {
        return this.singletonContext;
    }

    private ConversationContext getConversationContext() {
        return this.conversationContext.get();
    }

    private boolean isConversationSkipped(HttpServletRequest servletRequest) {
        String queryString = servletRequest.getQueryString();
        return "none".equals(CdiAppContextsService.getFromQuery("conversationPropagation", queryString)) || "true".equals(CdiAppContextsService.getFromQuery("nocid", queryString));
    }

    private boolean isTimeout() {
        ThreadContext tc = ThreadContext.getThreadContext();
        return tc != null && tc.getCurrentOperation() == Operation.TIMEOUT;
    }

    private Context lazyStartSessionContext() {
        Context webContext = null;
        Context context = this.getCurrentContext(RequestScoped.class);
        if (context instanceof ServletRequestContext) {
            ServletRequestContext requestContext = (ServletRequestContext)context;
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            if (null != servletRequest) {
                try {
                    HttpSession currentSession = servletRequest.getSession();
                    this.initSessionContext(currentSession);
                }
                catch (Exception e) {
                    logger.error("ERROR_0013", e);
                }
            } else {
                logger.warning("Could NOT lazily initialize session context because NO active request context");
            }
        } else {
            logger.warning("Could NOT lazily initialize session context because of " + context + " RequestContext");
        }
        return webContext;
    }

    public void setAutoConversationCheck(boolean autoConversationCheck) {
        this.autoConversationCheck = autoConversationCheck;
    }

    private boolean supportsConversation() {
        return this.conversationContext != null;
    }

    public void updateSessionIdMapping(String oldId, String newId) {
        this.sessionCtxManager.updateSessionIdMapping(oldId, newId);
    }

    public State saveState() {
        return new State(this.requestContext.get(), this.sessionContext.get(), this.conversationContext.get());
    }

    public State restoreState(State state) {
        State old = this.saveState();
        this.requestContext.set(state.request);
        this.sessionContext.set(state.session);
        this.conversationContext.set(state.conversation);
        return old;
    }

    public String getHttpParameter(String name) {
        ServletRequestContext req = this.getRequestContext(false);
        if (req != null && req.getServletRequest() != null) {
            return this.useGetParameter ? req.getServletRequest().getParameter(name) : CdiAppContextsService.getFromQuery(name, req.getServletRequest().getQueryString());
        }
        return null;
    }

    public static class HttpSessionContextSessionAware
    extends SessionContext {
        private final HttpSession session;

        public HttpSessionContextSessionAware(HttpSession session) {
            this.session = session;
        }

        public HttpSession getSession() {
            return this.session;
        }
    }

    public static class State {
        private final ServletRequestContext request;
        private final SessionContext session;
        private final ConversationContext conversation;

        public State(ServletRequestContext request, SessionContext session, ConversationContext conversation) {
            this.request = request;
            this.session = session;
            this.conversation = conversation;
        }
    }
}

