/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.util.Duration;

public class GeronimoTransactionManagerFactory {
    private static final byte[] DEFAULT_TM_ID = new byte[]{71, 84, 77, 73, 68};
    private static final int DEFAULT_BUFFER_SIZE = 32;

    public static GeronimoTransactionManager create(Integer defaultTransactionTimeoutSeconds, Duration defaultTransactionTimeout, boolean txRecovery, byte[] tmId, String bufferClassName, int bufferSizeKb, boolean checksumEnabled, boolean adler32Checksum, Integer flushSleepTimeMilliseconds, Duration flushSleepTime, String logFileDir, String logFileExt, String logFileName, int maxBlocksPerFile, int maxBuffers, int maxLogFiles, int minBuffers, int threadsWaitingForceThreshold) throws Exception {
        if (flushSleepTime.getUnit() == null) {
            flushSleepTime.setUnit(TimeUnit.MILLISECONDS);
        }
        if (flushSleepTimeMilliseconds == null) {
            flushSleepTimeMilliseconds = (int)TimeUnit.MILLISECONDS.convert(flushSleepTime.getTime(), flushSleepTime.getUnit());
        }
        if (defaultTransactionTimeout.getUnit() == null) {
            defaultTransactionTimeout.setUnit(TimeUnit.SECONDS);
        }
        if (defaultTransactionTimeoutSeconds == null) {
            defaultTransactionTimeoutSeconds = (int)TimeUnit.SECONDS.convert(defaultTransactionTimeout.getTime(), defaultTransactionTimeout.getUnit());
        }
        XidFactoryImpl xidFactory = null;
        HOWLLog txLog = null;
        if (txRecovery) {
            SystemInstance.get().setComponent(XAResourceWrapper.class, (Object)new GeronimoXAResourceWrapper());
            xidFactory = new XidFactoryImpl(tmId == null ? DEFAULT_TM_ID : tmId);
            txLog = new HOWLLog(bufferClassName == null ? "org.objectweb.howl.log.BlockLogBuffer" : bufferClassName, bufferSizeKb == 0 ? 32 : bufferSizeKb, checksumEnabled, adler32Checksum, flushSleepTimeMilliseconds.intValue(), logFileDir, logFileExt, logFileName, maxBlocksPerFile, maxBuffers, maxLogFiles, minBuffers, threadsWaitingForceThreshold, (XidFactory)xidFactory, SystemInstance.get().getBase().getDirectory("."));
            txLog.doStart();
        }
        GeronimoTransactionManager geronimoTransactionManager = new GeronimoTransactionManager(defaultTransactionTimeoutSeconds.intValue(), xidFactory, txLog);
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management").set("j2eeType", "TransactionManager");
        LocalMBeanServer.registerDynamicWrapperSilently(new TransactionManagerMBean(geronimoTransactionManager, defaultTransactionTimeout, (TransactionLog)txLog), jmxName.build());
        return geronimoTransactionManager;
    }

    @MBean
    @Internal
    @Description(value="Transaction manager statistics")
    public static final class TransactionManagerMBean {
        private final GeronimoTransactionManager transactionManager;
        private final Duration defaultTransactionTimeout;
        private final TransactionLog txLog;

        public TransactionManagerMBean(GeronimoTransactionManager transactionManager, Duration defaultTransactionTimeout, TransactionLog txLog) {
            this.transactionManager = transactionManager;
            this.defaultTransactionTimeout = defaultTransactionTimeout;
            this.txLog = txLog;
        }

        @ManagedAttribute
        @Description(value="Number of active transactions")
        public long getActive() {
            return this.transactionManager.getActiveCount();
        }

        @ManagedAttribute
        @Description(value="Number of committed transactions")
        public long getCommits() {
            return this.transactionManager.getTotalCommits();
        }

        @ManagedAttribute
        @Description(value="Number of rolled back transactions")
        public long getRollbacks() {
            return this.transactionManager.getTotalRollbacks();
        }

        @ManagedOperation
        @Description(value="Reset statistics counters")
        public void resetStatistics() {
            this.transactionManager.resetStatistics();
        }

        @ManagedAttribute
        @Description(value="Display the default transaction timeout")
        public String getDefaultTransactionTimeout() {
            return this.defaultTransactionTimeout.toString();
        }
    }

    public static class GeronimoXAResourceWrapper
    implements XAResourceWrapper {
        @Override
        public XAResource wrap(XAResource xaResource, String name) {
            return new WrapperNamedXAResource(xaResource, name);
        }
    }
}

