/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.util.CountingLatch;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Pool;

public class Pool<T> {
    private final LinkedList<Entry> pool = new LinkedList();
    private final Semaphore instances;
    private final Semaphore available;
    private final Semaphore minimum;
    private final Executor executor;
    @Managed
    private final long maxAge;
    @Managed
    private final AtomicInteger poolVersion = new AtomicInteger();
    private final Supplier<T> supplier;
    private final AtomicReference<ScheduledExecutorService> scheduler = new AtomicReference();
    private final Sweeper sweeper;
    private final CountingLatch out = new CountingLatch();
    @Managed
    private final long sweepInterval;
    @Managed
    private final boolean replaceAged;
    @Managed
    private final boolean replaceFlushed;
    @Managed
    private final double maxAgeOffset;
    @Managed
    private final Stats stats;
    @Managed
    private final boolean garbageCollection;

    public Pool(int max, int min, boolean strict) {
        this(max, min, strict, 0L, 0L, 0L, null, null, false, -1.0, false, false);
    }

    public Pool(int max, int min, boolean strict, long maxAge, long idleTimeout, long sweepInterval, Executor executor, Supplier<T> supplier, boolean replaceAged, double maxAgeOffset, boolean garbageCollection, boolean replaceFlushed) {
        if (min > max) {
            this.greater("max", max, "min", min);
        }
        if (maxAge != 0L && idleTimeout > maxAge) {
            this.greater("MaxAge", maxAge, "IdleTimeout", idleTimeout);
        }
        this.executor = executor != null ? executor : this.createExecutor();
        this.supplier = supplier != null ? supplier : new NoSupplier();
        this.available = strict ? new Semaphore(max) : new Overdraft(max);
        this.minimum = new Semaphore(min);
        this.instances = new Semaphore(max);
        this.maxAge = maxAge;
        this.maxAgeOffset = maxAgeOffset;
        this.replaceAged = replaceAged;
        this.replaceFlushed = replaceFlushed;
        if (sweepInterval == 0L) {
            sweepInterval = 300000L;
        }
        this.sweepInterval = sweepInterval;
        this.sweeper = new Sweeper(idleTimeout, max);
        this.stats = new Stats(min, max, idleTimeout);
        this.garbageCollection = garbageCollection;
    }

    public Pool start() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new SchedulerThreadFactory());
        if (this.scheduler.compareAndSet(null, scheduledExecutorService)) {
            this.scheduler.get().scheduleAtFixedRate(this.sweeper, 0L, this.sweepInterval, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public void stop() {
        ScheduledExecutorService scheduler = this.scheduler.get();
        if (scheduler != null && this.scheduler.compareAndSet(scheduler, null)) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Pool scheduler termination timeout expired");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean running() {
        return this.scheduler.get() != null;
    }

    private Executor createExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(3, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2), new DaemonThreadFactory("org.apache.openejb.util.Pool", this.hashCode()));
        threadPoolExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                try {
                    if (!tpe.getQueue().offer(r, 20L, TimeUnit.SECONDS)) {
                        Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").warning("Default pool executor failed to run asynchronous process: " + r);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        return threadPoolExecutor;
    }

    private void greater(String maxName, long max, String minName, long min) {
        throw new IllegalArgumentException(minName + " cannot be greater than " + maxName + ": " + minName + "=" + min + ", " + maxName + "=" + max);
    }

    public void flush() {
        this.stats.flushes.record();
        this.poolVersion.incrementAndGet();
    }

    public Entry pop(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this.pop(timeout, unit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry pop(long timeout, TimeUnit unit, boolean record) throws InterruptedException, TimeoutException {
        if (timeout == -1L) {
            this.available.tryAcquire();
        } else if (!this.available.tryAcquire(timeout, unit)) {
            if (record) {
                this.stats.accessTimeouts.record();
            }
            throw new TimeoutException("Waited " + timeout + " " + (Object)((Object)unit));
        }
        while (true) {
            Entry entry;
            LinkedList<Entry> linkedList = this.pool;
            synchronized (linkedList) {
                try {
                    entry = this.pool.removeFirst();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
            }
            Entry.Instance instance = (Entry.Instance)entry.soft.get();
            if (instance != null) {
                boolean notBusy = entry.active.compareAndSet(null, instance);
                if (!notBusy) continue;
                return entry;
            }
            this.instances.release();
        }
    }

    public boolean add(T obj) {
        return this.add(obj, 0L);
    }

    public boolean add(T obj, long offset) {
        try {
            if (this.available.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                try {
                    if (this.push(obj, offset)) {
                        return true;
                    }
                    this.available.release();
                }
                catch (RuntimeException e) {
                    this.available.release();
                    throw e;
                }
            }
            return false;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            e.printStackTrace();
            return false;
        }
    }

    public boolean push(T obj) {
        return this.push(obj, 0L);
    }

    private boolean push(T obj, long offset) {
        if (this.instances.tryAcquire()) {
            return this.push(new Entry(obj, offset));
        }
        if (obj != null) {
            new Discard(obj, Event.FULL).run();
        }
        if (this.available instanceof Overdraft) {
            this.available.release();
        }
        return false;
    }

    public boolean push(Entry entry) {
        return this.push(entry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean push(Entry entry, boolean sweeper) {
        Entry.Instance obj;
        Event event;
        boolean added;
        block19: {
            added = false;
            boolean release = true;
            event = Event.FULL;
            obj = entry == null ? null : (Entry.Instance)entry.active.getAndSet(null);
            try {
                boolean flushed;
                if (entry == null) {
                    boolean bl = added;
                    return bl;
                }
                if (!sweeper) {
                    entry.markLastUsed();
                }
                long age = Pool.now() - entry.created;
                boolean aged = this.maxAge > 0L && age > this.maxAge;
                boolean bl = flushed = entry.version != this.poolVersion.get();
                if (aged || flushed) {
                    if (aged) {
                        event = Event.AGED;
                    }
                    if (flushed) {
                        event = Event.FLUSHED;
                    }
                    if (entry.hasHardReference() || aged && this.replaceAged || flushed && this.replaceFlushed) {
                        release = false;
                        entry.active.set(obj);
                        this.executor.execute(new Replace(entry));
                    }
                    break block19;
                }
                if (!entry.hasHardReference() && this.minimum.tryAcquire()) {
                    entry.hard.set(obj);
                }
                LinkedList<Entry> linkedList = this.pool;
                synchronized (linkedList) {
                    this.pool.addFirst(entry);
                }
                added = true;
            }
            finally {
                if (release) {
                    this.available.release();
                    if (entry != null && !added) {
                        this.instances.release();
                    }
                }
            }
        }
        if (!added && obj != null) {
            if (sweeper) {
                this.executor.execute(obj.discard(event));
            } else {
                obj.discard(event).run();
            }
        }
        return added;
    }

    public void discard() {
        this.discard(null);
    }

    public void discard(Entry entry) {
        if (entry != null) {
            if (entry.hasHardReference()) {
                this.minimum.release();
            }
            this.instances.release();
        }
        this.available.release();
    }

    public boolean close(long timeout, TimeUnit unit) throws InterruptedException {
        while (this.instances.tryAcquire()) {
            Thread.yield();
        }
        while (this.minimum.tryAcquire()) {
            Thread.yield();
        }
        this.instances.drainPermits();
        this.minimum.drainPermits();
        this.flush();
        try {
            this.sweeper.run();
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
        this.stop();
        if (!(this.available instanceof Overdraft)) {
            while (this.available.tryAcquire()) {
                Thread.yield();
            }
            this.available.drainPermits();
        }
        return this.out.await(timeout, unit);
    }

    private void discardAndReplace(Entry hard, Entry soft) {
        soft.hard.set(soft.active());
        this.push(soft);
        hard.hard.set(null);
        this.discard(hard);
    }

    private static long now() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    static class SchedulerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger count = new AtomicInteger(1);
        private final ThreadGroup group;

        SchedulerThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoader containerLoader = ParentClassLoaderFinder.Helper.get();
            Thread.currentThread().setContextClassLoader(containerLoader);
            try {
                Thread t = new Thread(this.group, r, "org.apache.openejb.pool.scheduler." + count.getAndIncrement());
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                t.setContextClassLoader(containerLoader);
                Thread thread = t;
                return thread;
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public static class HardReference<T>
    extends SoftReference<T> {
        private final T hard;

        public HardReference(T referent) {
            super(referent);
            this.hard = referent;
        }

        public T getHard() {
            return this.hard;
        }
    }

    public static class Builder<T> {
        private int max = 10;
        private int min;
        private boolean strict = true;
        private Duration maxAge = new Duration(0L, TimeUnit.MILLISECONDS);
        private double maxAgeOffset = -1.0;
        private Duration idleTimeout = new Duration(0L, TimeUnit.MILLISECONDS);
        private Duration interval = new Duration(300L, TimeUnit.SECONDS);
        private Supplier<T> supplier;
        private Executor executor;
        private boolean replaceAged;
        private boolean replaceFlushed;
        private boolean garbageCollection = true;

        public Builder(Builder<T> that) {
            this.max = that.max;
            this.min = that.min;
            this.strict = that.strict;
            this.maxAge = that.maxAge;
            this.idleTimeout = that.idleTimeout;
            this.interval = that.interval;
            this.executor = that.executor;
            this.supplier = that.supplier;
            this.maxAgeOffset = that.maxAgeOffset;
            this.replaceAged = that.replaceAged;
            this.replaceFlushed = that.replaceFlushed;
            this.garbageCollection = that.garbageCollection;
        }

        public Builder() {
        }

        public int getMin() {
            return this.min;
        }

        public boolean isGarbageCollection() {
            return this.garbageCollection;
        }

        public void setGarbageCollection(boolean garbageCollection) {
            this.garbageCollection = garbageCollection;
        }

        public void setReplaceAged(boolean replaceAged) {
            this.replaceAged = replaceAged;
        }

        public void setReplaceFlushed(boolean replaceFlushed) {
            this.replaceFlushed = replaceFlushed;
        }

        public void setMaxSize(int max) {
            this.max = max;
        }

        public void setPoolSize(int max) {
            this.setMaxSize(max);
        }

        public void setMinSize(int min) {
            this.min = min;
        }

        public void setStrictPooling(boolean strict) {
            this.strict = strict;
        }

        public void setMaxAge(Duration maxAge) {
            this.maxAge = maxAge;
        }

        public Duration getMaxAge() {
            return this.maxAge;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public boolean isReplaceAged() {
            return this.replaceAged;
        }

        public void setMaxAgeOffset(double maxAgeOffset) {
            this.maxAgeOffset = maxAgeOffset;
        }

        public double getMaxAgeOffset() {
            return this.maxAgeOffset;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public void setSweepInterval(Duration interval) {
            this.interval = interval;
        }

        public void setSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public void setExecutor(Executor executor) {
            this.executor = executor;
        }

        public Pool<T> build() {
            return new Pool<T>(this.max, this.min, this.strict, this.maxAge.getTime(TimeUnit.MILLISECONDS), this.idleTimeout.getTime(TimeUnit.MILLISECONDS), this.interval.getTime(TimeUnit.MILLISECONDS), this.executor, this.supplier, this.replaceAged, this.maxAgeOffset, this.garbageCollection, this.replaceFlushed);
        }
    }

    @Managed
    private final class Stats {
        @Managed
        private final org.apache.openejb.monitoring.Event sweeps = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event flushes = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event accessTimeouts = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event garbageCollected = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event idleTimeouts = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event aged = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event flushed = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event overdrafts = new org.apache.openejb.monitoring.Event();
        @Managed
        private final org.apache.openejb.monitoring.Event replaced = new org.apache.openejb.monitoring.Event();
        @Managed
        private final int minSize;
        @Managed
        private final int maxSize;
        @Managed
        private final long idleTimeout;

        private Stats(int minSize, int maxSize, long idleTimeout) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.idleTimeout = idleTimeout;
        }

        @Managed
        private boolean getStrictPooling() {
            return !(Pool.this.available instanceof Overdraft);
        }

        @Managed
        private int getAvailablePermits() {
            return Pool.this.available.availablePermits();
        }

        @Managed
        private int getInstancesPooled() {
            return this.maxSize - Pool.this.instances.availablePermits();
        }

        @Managed
        private int getInstancesIdle() {
            return Math.max(0, this.getInstancesPooled() - this.getInstancesActive());
        }

        @Managed
        private int getInstancesInitializing() {
            return Math.max(0, this.getInstancesActive() - this.getInstancesPooled());
        }

        @Managed
        private int getInstancesActive() {
            return this.maxSize - this.getAvailablePermits();
        }

        @Managed
        private int getMinimumInstances() {
            return this.minSize - Pool.this.minimum.availablePermits();
        }
    }

    private static final class Overdraft
    extends Semaphore {
        private static final long serialVersionUID = 1L;
        private final AtomicInteger permits = new AtomicInteger();

        public Overdraft(int permits) {
            super(0);
            this.permits.set(permits);
        }

        @Override
        public void acquire() throws InterruptedException {
            this.permits.decrementAndGet();
        }

        @Override
        public void acquireUninterruptibly() {
            this.permits.decrementAndGet();
        }

        @Override
        public boolean tryAcquire() {
            this.permits.decrementAndGet();
            return true;
        }

        @Override
        public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
            this.permits.decrementAndGet();
            return true;
        }

        @Override
        public void acquire(int permits) throws InterruptedException {
            this.permits.addAndGet(-permits);
        }

        @Override
        public void acquireUninterruptibly(int permits) {
            this.permits.addAndGet(-permits);
        }

        @Override
        public boolean tryAcquire(int permits) {
            this.permits.addAndGet(-permits);
            return true;
        }

        @Override
        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
            this.permits.addAndGet(-permits);
            return true;
        }

        @Override
        public void release() {
            this.permits.incrementAndGet();
        }

        @Override
        public void release(int permits) {
            this.permits.addAndGet(permits);
        }

        @Override
        public int availablePermits() {
            return this.permits.get();
        }

        @Override
        public int drainPermits() {
            return 0;
        }

        @Override
        protected void reducePermits(int reduction) {
        }
    }

    private static class NoSupplier
    implements Supplier {
        private NoSupplier() {
        }

        public void discard(Object o, Event reason) {
        }

        public Object create() {
            return null;
        }
    }

    public static interface Supplier<T> {
        public void discard(T var1, Event var2);

        public T create();
    }

    private final class Discard
    implements Runnable {
        private final T expired;
        private final Event event;

        private Discard(T expired, Event event) {
            Pool.this.out.countUp();
            if (expired == null) {
                throw new NullPointerException("expired object cannot be null");
            }
            this.expired = expired;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            switch (this.event) {
                case AGED: {
                    Pool.this.stats.aged.record();
                    break;
                }
                case FLUSHED: {
                    Pool.this.stats.flushed.record();
                    break;
                }
                case FULL: {
                    Pool.this.stats.overdrafts.record();
                    break;
                }
                case IDLE: {
                    Pool.this.stats.idleTimeouts.record();
                    break;
                }
                case GC: {
                    Pool.this.stats.garbageCollected.record();
                }
            }
            try {
                Pool.this.supplier.discard(this.expired, this.event);
            }
            finally {
                Pool.this.out.countDown();
            }
        }
    }

    private final class Replace
    implements Runnable {
        private final Entry expired;
        private final long offset;

        private Replace(Entry expired) {
            this(expired, 0L);
        }

        private Replace(Entry expired, long offset) {
            this.expired = expired;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Pool.this.running()) {
                Pool.this.discard(this.expired);
                return;
            }
            try {
                Object t = Pool.this.supplier.create();
                if (t == null) {
                    Pool.this.discard(this.expired);
                } else {
                    Entry entry = new Entry(t, this.offset);
                    if (this.expired.hasHardReference()) {
                        entry.harden();
                    }
                    Pool.this.push(entry);
                }
            }
            catch (Throwable e) {
                Pool.this.discard(this.expired);
            }
            finally {
                Pool.this.stats.replaced.record();
            }
        }
    }

    private final class Expired {
        private final Entry entry;
        private final AtomicBoolean discarded = new AtomicBoolean();
        private final Event event;

        private Expired(Entry entry, Event event) {
            this.entry = entry;
            this.event = event;
        }

        public boolean aged() {
            return this.event == Event.AGED;
        }

        public boolean tryDiscard() {
            if (this.discarded.getAndSet(true)) {
                return false;
            }
            Pool.this.discard(this.entry);
            return true;
        }

        public boolean replaceMinEntry(Entry replacement) {
            if (!this.entry.hasHardReference()) {
                return false;
            }
            if (replacement.hasHardReference()) {
                return false;
            }
            if (this.discarded.getAndSet(true)) {
                return false;
            }
            Pool.this.discardAndReplace(this.entry, replacement);
            return true;
        }
    }

    public static enum Event {
        FULL,
        IDLE,
        AGED,
        FLUSHED,
        GC;

    }

    private final class Sweeper
    implements Runnable {
        private final AtomicInteger previousVersion;
        private final long idleTimeout;
        private final boolean timeouts;
        private final int max;

        private Sweeper(long idleTimeout, int max) {
            this.previousVersion = new AtomicInteger(Pool.this.poolVersion.get());
            this.idleTimeout = idleTimeout;
            this.timeouts = Pool.this.maxAge > 0L || idleTimeout > 0L;
            this.max = max;
        }

        @Override
        public void run() {
            boolean isCurrent;
            Pool.this.stats.sweeps.record();
            int currentVersion = Pool.this.poolVersion.get();
            boolean bl = isCurrent = this.previousVersion.getAndSet(currentVersion) == currentVersion;
            if (!this.timeouts && isCurrent) {
                return;
            }
            long now = Pool.now();
            ArrayList<Entry> entries = new ArrayList<Entry>(this.max);
            try {
                while (true) {
                    Entry entry;
                    if ((entry = Pool.this.pop(0L, TimeUnit.MILLISECONDS, false)) == null) {
                        Pool.this.push(entry, true);
                        break;
                    }
                    entries.add(entry);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            ArrayList<Expired> expiredList = new ArrayList<Expired>(this.max);
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                boolean flushed;
                Entry entry = (Entry)iter.next();
                boolean aged = Pool.this.maxAge > 0L && now - entry.created > Pool.this.maxAge;
                boolean bl2 = flushed = entry.version != currentVersion;
                if (aged || flushed) {
                    iter.remove();
                    Expired expired = new Expired(entry, aged ? Event.AGED : Event.FLUSHED);
                    expiredList.add(expired);
                    if (expired.entry.hasHardReference() || aged && Pool.this.replaceAged) continue;
                    expired.tryDiscard();
                    continue;
                }
                if (!entry.hasHardReference()) continue;
                Pool.this.push(entry, true);
                iter.remove();
            }
            Iterator discardables = expiredList.iterator();
            while (discardables.hasNext() && entries.size() > 0) {
                if (!((Expired)discardables.next()).replaceMinEntry((Entry)entries.get(0))) continue;
                entries.remove(0);
            }
            Iterator iter2 = entries.iterator();
            while (iter2.hasNext()) {
                Entry entry = (Entry)iter2.next();
                iter2.remove();
                long idle = now - entry.used;
                if (this.idleTimeout > 0L && idle > this.idleTimeout) {
                    Expired expired = new Expired(entry, Event.IDLE);
                    expiredList.add(expired);
                    expired.tryDiscard();
                    continue;
                }
                Pool.this.push(entry, true);
            }
            ArrayList<Expired> replace = new ArrayList<Expired>();
            for (Expired expired : expiredList) {
                Pool.this.executor.execute(expired.entry.active().discard(expired.event));
                if (!expired.entry.hasHardReference() && (!expired.aged() || !Pool.this.replaceAged)) continue;
                replace.add(expired);
            }
            for (int i = 0; i < replace.size(); ++i) {
                long offset = Pool.this.maxAge > 0L ? (long)((double)(Pool.this.maxAge / (long)replace.size() * (long)i) * Pool.this.maxAgeOffset) % Pool.this.maxAge : 0L;
                Pool.this.executor.execute(new Replace(((Expired)replace.get(i)).entry, offset));
            }
        }
    }

    public final class Entry {
        private final long created;
        private long used;
        private final int version;
        private final SoftReference<org.apache.openejb.util.Pool$Entry.Instance> soft;
        private final AtomicReference<org.apache.openejb.util.Pool$Entry.Instance> hard = new AtomicReference();
        private final AtomicReference<org.apache.openejb.util.Pool$Entry.Instance> active = new AtomicReference();

        private Entry(T obj, long offset) {
            if (obj == null) {
                throw new NullPointerException("entry is null");
            }
            Instance instance = new Instance(obj);
            this.soft = Pool.this.garbageCollection ? new SoftReference<Instance>(instance) : new HardReference<Instance>(instance);
            this.version = Pool.this.poolVersion.get();
            this.active.set((org.apache.openejb.util.Pool$Entry.Instance)instance);
            this.used = this.created = Pool.now() + offset;
        }

        public T get() {
            return this.active().instance;
        }

        private org.apache.openejb.util.Pool$Entry.Instance active() {
            return (Instance)this.active.get();
        }

        public void harden() {
            this.hard.set((org.apache.openejb.util.Pool$Entry.Instance)this.active());
        }

        public void markLastUsed() {
            this.used = Pool.now();
        }

        public long getUsed() {
            return this.used;
        }

        public boolean hasHardReference() {
            return this.hard.get() != null;
        }

        public String toString() {
            long now = Pool.now();
            return "Entry{min=" + (this.hard.get() != null) + ", age=" + (now - this.created) + ", idle=" + (now - this.used) + ", bean=" + this.soft.get() + '}';
        }

        public class Instance {
            private final AtomicBoolean callback = new AtomicBoolean();
            private final T instance;

            public Instance(T instance) {
                this.instance = instance;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.discard(Event.GC).run();
                }
                finally {
                    super.finalize();
                }
            }

            public Runnable discard(Event event) {
                if (this.callback.compareAndSet(false, true)) {
                    return new Discard(this.instance, event);
                }
                return new Discarded();
            }
        }

        private class Discarded
        implements Runnable {
            private Discarded() {
            }

            @Override
            public void run() {
            }
        }
    }
}

