/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.batchee;

import java.util.Map;
import java.util.Properties;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.ServicesManagerLocator;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.ObserverAdded;
import org.apache.openejb.util.AppFinder;

public class BatchEEServiceManager
implements ServicesManagerLocator {
    public void initEnvironment(@Observes ObserverAdded event) {
        if (event.getObserver() == this) {
            ServicesManager.setServicesManagerLocator((ServicesManagerLocator)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClassLoader(@Observes AssemblerAfterApplicationCreated init) {
        Properties properties = new Properties(SystemInstance.get().getProperties());
        properties.putAll((Map<?, ?>)init.getApp().properties);
        Thread thread = Thread.currentThread();
        ClassLoader current = thread.getContextClassLoader();
        thread.setContextClassLoader(init.getContext().getClassLoader());
        ServicesManager servicesManager = new ServicesManager();
        try {
            servicesManager.init(properties);
        }
        finally {
            thread.setContextClassLoader(current);
        }
        init.getContext().set(ServicesManager.class, servicesManager);
    }

    public ServicesManager find() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        AppContext context = AppFinder.findAppContextOrWeb(contextClassLoader, AppFinder.AppContextTransformer.INSTANCE);
        if (context != null) {
            return context.get(ServicesManager.class);
        }
        throw new IllegalStateException("Can't find ServiceManager for " + contextClassLoader);
    }
}

