/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.ResultShape;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.AbstractExpressionVisitor;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.Constant;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.InMemoryExpressionFactory;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Resolver;
import org.apache.openjpa.kernel.exps.StringContains;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.exps.WildcardMatch;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

public class ExpressionStoreQuery
extends AbstractStoreQuery {
    private static final Localizer _loc = Localizer.forPackage(ExpressionStoreQuery.class);
    private static final FilterListener[] _listeners = new FilterListener[]{new StringContains(), new WildcardMatch()};
    protected final ExpressionParser _parser;
    protected transient Object _parsed;

    public ExpressionStoreQuery(ExpressionParser parser) {
        this._parser = parser;
    }

    public Resolver getResolver() {
        return new Resolver(){

            @Override
            public Class classForName(String name, String[] imports) {
                return ExpressionStoreQuery.this.ctx.classForName(name, imports);
            }

            @Override
            public FilterListener getFilterListener(String tag) {
                return ExpressionStoreQuery.this.ctx.getFilterListener(tag);
            }

            @Override
            public AggregateListener getAggregateListener(String tag) {
                return ExpressionStoreQuery.this.ctx.getAggregateListener(tag);
            }

            @Override
            public OpenJPAConfiguration getConfiguration() {
                return ExpressionStoreQuery.this.ctx.getStoreContext().getConfiguration();
            }

            @Override
            public QueryContext getQueryContext() {
                return ExpressionStoreQuery.this.ctx;
            }
        };
    }

    @Override
    public boolean setQuery(Object query) {
        this._parsed = query;
        return true;
    }

    @Override
    public FilterListener getFilterListener(String tag) {
        for (int i = 0; i < _listeners.length; ++i) {
            if (!_listeners[i].getTag().equals(tag)) continue;
            return _listeners[i];
        }
        return null;
    }

    @Override
    public Object newCompilation() {
        if (this._parsed != null) {
            return this._parsed;
        }
        return this._parser.parse(this.ctx.getQueryString(), this);
    }

    @Override
    public Object getCompilation() {
        return this._parsed;
    }

    @Override
    public void populateFromCompilation(Object comp) {
        this._parser.populate(comp, this);
    }

    @Override
    public void invalidateCompilation() {
        this._parsed = null;
    }

    @Override
    public boolean supportsInMemoryExecution() {
        return true;
    }

    @Override
    public StoreQuery.Executor newInMemoryExecutor(ClassMetaData meta, boolean subs) {
        return new InMemoryExecutor(this, meta, subs, this._parser, this.ctx.getCompilation(), new InMemoryExpressionFactory());
    }

    @Override
    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subs) {
        return new DataStoreExecutor(this, meta, subs, this._parser, this.ctx.getCompilation());
    }

    protected ResultObjectProvider executeQuery(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] types, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] parsed, Object[] params, StoreQuery.Range range) {
        throw new UnsupportedException();
    }

    protected Number executeDelete(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] types, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] parsed, Object[] params) {
        return null;
    }

    protected Number executeUpdate(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] types, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] parsed, Object[] params) {
        return null;
    }

    protected String[] getDataStoreActions(ClassMetaData base, ClassMetaData[] types, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] parsed, Object[] params, StoreQuery.Range range) {
        return StoreQuery.EMPTY_STRINGS;
    }

    protected ClassMetaData[] getIndependentExpressionCandidates(ClassMetaData type, boolean subclasses) {
        return new ClassMetaData[]{type};
    }

    protected ExpressionFactory getExpressionFactory(ClassMetaData type) {
        throw new UnsupportedException();
    }

    public static class DataStoreExecutor
    extends AbstractExpressionExecutor
    implements StoreQuery.Executor,
    Serializable {
        private ClassMetaData _meta;
        private ClassMetaData[] _metas;
        private boolean _subs;
        private ExpressionParser _parser;
        private ExpressionFactory[] _facts;
        private QueryExpressions[] _exps;
        private Class[] _projTypes;
        private Value[] _inMemOrdering;

        public DataStoreExecutor(ExpressionStoreQuery q, ClassMetaData meta, boolean subclasses, ExpressionParser parser, Object parsed) {
            int i;
            this._metas = q.getIndependentExpressionCandidates(meta, subclasses);
            if (this._metas.length == 0) {
                throw new UserException(_loc.get("query-unmapped", (Object)meta));
            }
            this._meta = meta;
            this._subs = subclasses;
            this._parser = parser;
            this._facts = new ExpressionFactory[this._metas.length];
            for (i = 0; i < this._facts.length; ++i) {
                this._facts[i] = q.getExpressionFactory(this._metas[i]);
            }
            this._exps = new QueryExpressions[this._metas.length];
            for (i = 0; i < this._exps.length; ++i) {
                this._exps[i] = parser.eval(parsed, q, this._facts[i], this._metas[i]);
            }
            if (this._exps[0].projections.length == 0) {
                this._projTypes = StoreQuery.EMPTY_CLASSES;
            } else {
                this._projTypes = new Class[this._exps[0].projections.length];
                for (i = 0; i < this._exps[0].projections.length; ++i) {
                    this.assertNotContainer(this._exps[0].projections[i], q);
                    this._projTypes[i] = this._exps[0].projections[i].getType();
                }
            }
        }

        @Override
        public QueryExpressions[] getQueryExpressions() {
            return this._exps;
        }

        @Override
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            range.lrs = range.lrs & (!this.isAggregate(q) && !this.hasGrouping(q));
            return ((ExpressionStoreQuery)q).executeQuery(this, this._meta, this._metas, this._subs, this._facts, this._exps, params, range);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number executeDelete(StoreQuery q, Object[] params) {
            try {
                Number num = ((ExpressionStoreQuery)q).executeDelete(this, this._meta, this._metas, this._subs, this._facts, this._exps, params);
                if (num == null) {
                    Number number = q.getContext().deleteInMemory(q, this, params);
                    return number;
                }
                Number number = num;
                return number;
            }
            finally {
                for (ClassMetaData cmd : this.getAccessPathMetaDatas(q)) {
                    DataCache cache = cmd.getDataCache();
                    if (cache == null || !cache.getEvictOnBulkUpdate()) continue;
                    cache.removeAll(cmd.getDescribedType(), true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number executeUpdate(StoreQuery q, Object[] params) {
            try {
                Number num = ((ExpressionStoreQuery)q).executeUpdate(this, this._meta, this._metas, this._subs, this._facts, this._exps, params);
                if (num == null) {
                    Number number = q.getContext().updateInMemory(q, this, params);
                    return number;
                }
                Number number = num;
                return number;
            }
            finally {
                for (ClassMetaData cmd : this.getAccessPathMetaDatas(q)) {
                    DataCache cache = cmd.getDataCache();
                    if (cache == null || !cache.getEvictOnBulkUpdate()) continue;
                    cache.removeAll(cmd.getDescribedType(), true);
                }
            }
        }

        @Override
        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return ((ExpressionStoreQuery)q).getDataStoreActions(this._meta, this._metas, this._subs, this._facts, this._exps, params, range);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getOrderingValue(StoreQuery q, Object[] params, Object resultObject, int orderIndex) {
            if (this._exps[0].projections.length > 0) {
                String ordering = this._exps[0].orderingClauses[orderIndex];
                for (int i = 0; i < this._exps[0].projectionClauses.length; ++i) {
                    if (!ordering.equals(this._exps[0].projectionClauses[i])) continue;
                    return ((Object[])resultObject)[i];
                }
                throw new InvalidStateException(_loc.get("merged-order-with-result", (Object)q.getContext().getLanguage(), (Object)q.getContext().getQueryString(), (Object)ordering));
            }
            DataStoreExecutor ordering = this;
            synchronized (ordering) {
                if (this._inMemOrdering == null) {
                    InMemoryExpressionFactory factory = new InMemoryExpressionFactory();
                    this._inMemOrdering = this._parser.eval(this._exps[0].orderingClauses, (ExpressionStoreQuery)q, (ExpressionFactory)factory, this._meta);
                }
                if (this._inMemOrdering == null) {
                    this._inMemOrdering = this._exps[0].ordering;
                }
            }
            Val val = (Val)this._inMemOrdering[orderIndex];
            return val.evaluate(resultObject, resultObject, q.getContext().getStoreContext(), params);
        }

        public Class[] getProjectionTypes(StoreQuery q) {
            return this._projTypes;
        }
    }

    public static class InMemoryExecutor
    extends AbstractExpressionExecutor
    implements StoreQuery.Executor,
    Serializable {
        private final ClassMetaData _meta;
        private final boolean _subs;
        private final InMemoryExpressionFactory _factory;
        private final QueryExpressions[] _exps;
        private final Class[] _projTypes;

        public InMemoryExecutor(ExpressionStoreQuery q, ClassMetaData candidate, boolean subclasses, ExpressionParser parser, Object parsed, InMemoryExpressionFactory factory) {
            this._meta = candidate;
            this._subs = subclasses;
            this._factory = factory;
            this._exps = new QueryExpressions[]{parser.eval(parsed, q, (ExpressionFactory)this._factory, this._meta)};
            if (this._exps[0].projections.length == 0) {
                this._projTypes = StoreQuery.EMPTY_CLASSES;
            } else {
                int i;
                AssertNoVariablesExpressionVisitor novars = new AssertNoVariablesExpressionVisitor(q.getContext());
                this._projTypes = new Class[this._exps[0].projections.length];
                for (i = 0; i < this._exps[0].projections.length; ++i) {
                    this._projTypes[i] = this._exps[0].projections[i].getType();
                    this.assertNotContainer(this._exps[0].projections[i], q);
                    this._exps[0].projections[i].acceptVisit(novars);
                }
                for (i = 0; i < this._exps[0].grouping.length; ++i) {
                    this._exps[0].grouping[i].acceptVisit(novars);
                }
            }
        }

        @Override
        public QueryExpressions[] getQueryExpressions() {
            return this._exps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            Collection<?> coll = q.getContext().getCandidateCollection();
            Iterator<Object> itr = coll != null ? coll.iterator() : q.getContext().getStoreContext().extentIterator(this._meta.getDescribedType(), this._subs, q.getContext().getFetchConfiguration(), q.getContext().getIgnoreChanges());
            List<Object> results = new ArrayList();
            StoreContext ctx = q.getContext().getStoreContext();
            try {
                while (itr.hasNext()) {
                    Object obj = itr.next();
                    if (!this._factory.matches(this._exps[0], this._meta, this._subs, obj, ctx, params)) continue;
                    results.add(obj);
                }
            }
            finally {
                ImplHelper.close(itr);
            }
            results = this._factory.group(this._exps[0], results, ctx, params);
            if (this._exps[0].having != null) {
                ArrayList<Collection> matches = new ArrayList<Collection>(results.size());
                for (Collection collection : results) {
                    if (!this._factory.matches(this._exps[0], collection, ctx, params)) continue;
                    matches.add(collection);
                }
                results = matches;
            }
            results = this._factory.project(this._exps[0], results, ctx, params);
            results = this._factory.order(this._exps[0], results, ctx, params);
            results = this._factory.distinct(this._exps[0], coll == null, results);
            ListResultObjectProvider rop = new ListResultObjectProvider(results);
            if (range.start != 0L || range.end != Long.MAX_VALUE) {
                rop = new RangeResultObjectProvider((ResultObjectProvider)rop, range.start, range.end);
            }
            return rop;
        }

        @Override
        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return StoreQuery.EMPTY_STRINGS;
        }

        @Override
        public Object getOrderingValue(StoreQuery q, Object[] params, Object resultObject, int orderIndex) {
            if (this._exps[0].projections.length > 0) {
                String ordering = this._exps[0].orderingClauses[orderIndex];
                for (int i = 0; i < this._exps[0].projectionClauses.length; ++i) {
                    if (!ordering.equals(this._exps[0].projectionClauses[i])) continue;
                    return ((Object[])resultObject)[i];
                }
                throw new InvalidStateException(_loc.get("merged-order-with-result", (Object)q.getContext().getLanguage(), (Object)q.getContext().getQueryString(), (Object)ordering));
            }
            Val val = (Val)this._exps[0].ordering[orderIndex];
            return val.evaluate(resultObject, resultObject, q.getContext().getStoreContext(), params);
        }

        public Class[] getProjectionTypes(StoreQuery q) {
            return this._projTypes;
        }

        private static class AssertNoVariablesExpressionVisitor
        extends AbstractExpressionVisitor {
            private final QueryContext _ctx;

            public AssertNoVariablesExpressionVisitor(QueryContext ctx) {
                this._ctx = ctx;
            }

            @Override
            public void enter(Value val) {
                if (!val.isVariable()) {
                    return;
                }
                throw new UnsupportedException(_loc.get("inmem-agg-proj-var", this._ctx.getCandidateType(), (Object)this._ctx.getQueryString()));
            }
        }
    }

    public static abstract class AbstractExpressionExecutor
    extends AbstractStoreQuery.AbstractExecutor
    implements StoreQuery.Executor {
        private QueryExpressions assertQueryExpression() {
            QueryExpressions[] exp = this.getQueryExpressions();
            if (exp == null || exp.length < 1) {
                throw new InvalidStateException(_loc.get("no-expressions"));
            }
            return exp[0];
        }

        protected void assertNotContainer(Value val, StoreQuery q) {
            FieldMetaData fmd;
            if (val.isVariable()) {
                return;
            }
            Class type = val instanceof Path ? ((fmd = ((Path)val).last()) == null ? val.getType() : fmd.getDeclaredType()) : val.getType();
            switch (JavaTypes.getTypeCode(type)) {
                case 11: 
                case 12: 
                case 13: {
                    throw new UserException(_loc.get("container-projection", (Object)q.getContext().getQueryString()));
                }
            }
        }

        @Override
        public final void validate(StoreQuery q) {
            QueryExpressions exps = this.assertQueryExpression();
            ValidateGroupingExpressionVisitor.validate(q.getContext(), exps);
        }

        @Override
        public void getRange(StoreQuery q, Object[] params, StoreQuery.Range range) {
            QueryExpressions exps = this.assertQueryExpression();
            if (exps.range.length == 0) {
                return;
            }
            if (exps.range.length == 2 && exps.range[0] instanceof Constant && exps.range[1] instanceof Constant) {
                try {
                    range.start = ((Number)((Constant)((Object)exps.range[0])).getValue(params)).longValue();
                    range.end = ((Number)((Constant)((Object)exps.range[1])).getValue(params)).longValue();
                    return;
                }
                catch (ClassCastException cce) {
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
            throw new UserException(_loc.get("only-range-constants", (Object)q.getContext().getQueryString()));
        }

        @Override
        public final Class<?> getResultClass(StoreQuery q) {
            return this.assertQueryExpression().resultClass;
        }

        @Override
        public final ResultShape<?> getResultShape(StoreQuery q) {
            return this.assertQueryExpression().shape;
        }

        @Override
        public final boolean[] getAscending(StoreQuery q) {
            return this.assertQueryExpression().ascending;
        }

        @Override
        public final String getAlias(StoreQuery q) {
            return this.assertQueryExpression().alias;
        }

        @Override
        public final String[] getProjectionAliases(StoreQuery q) {
            return this.assertQueryExpression().projectionAliases;
        }

        @Override
        public Class<?>[] getProjectionTypes(StoreQuery q) {
            return null;
        }

        @Override
        public final int getOperation(StoreQuery q) {
            return this.assertQueryExpression().operation;
        }

        @Override
        public final boolean isAggregate(StoreQuery q) {
            return this.assertQueryExpression().isAggregate();
        }

        @Override
        public final boolean isDistinct(StoreQuery q) {
            return this.assertQueryExpression().isDistinct();
        }

        @Override
        public final boolean hasGrouping(StoreQuery q) {
            return this.assertQueryExpression().grouping.length > 0;
        }

        @Override
        public final OrderedMap<Object, Class<?>> getOrderedParameterTypes(StoreQuery q) {
            return this.assertQueryExpression().parameterTypes;
        }

        @Override
        public Object[] toParameterArray(StoreQuery q, Map<?, ?> userParams) {
            if (userParams == null || userParams.isEmpty()) {
                return StoreQuery.EMPTY_OBJECTS;
            }
            OrderedMap<Object, Class<?>> paramTypes = this.getOrderedParameterTypes(q);
            Object[] arr = new Object[userParams.size()];
            int base = AbstractExpressionExecutor.positionalParameterBase(userParams.keySet());
            for (Map.Entry entry : paramTypes.entrySet()) {
                int idx;
                Object key = entry.getKey();
                int n = idx = key instanceof Integer ? (Integer)key - base : paramTypes.indexOf(key);
                if (idx >= arr.length || idx < 0) {
                    throw new UserException(_loc.get("gap-query-param", new Object[]{q.getContext().getQueryString(), key, userParams.size(), userParams}));
                }
                Object value = userParams.get(key);
                AbstractExpressionExecutor.validateParameterValue(key, value, (Class)entry.getValue());
                arr[idx] = value;
            }
            return arr;
        }

        private static int positionalParameterBase(Collection params) {
            int low = Integer.MAX_VALUE;
            for (Object obj : params) {
                if (!(obj instanceof Number)) {
                    return 0;
                }
                int val = ((Number)obj).intValue();
                if (val == 0) {
                    return val;
                }
                if (val >= low) continue;
                low = val;
            }
            return low;
        }

        private static void validateParameterValue(Object key, Object value, Class expected) {
            if (expected == null) {
                return;
            }
            if (value == null) {
                if (expected.isPrimitive()) {
                    throw new UserException(_loc.get("null-primitive-param", key, (Object)expected));
                }
            } else {
                boolean strict;
                Class<?> actual = value.getClass();
                if (!Filters.canConvert(actual, expected, strict = true)) {
                    throw new UserException(_loc.get("param-value-mismatch", new Object[]{key, expected, value, actual}));
                }
            }
        }

        public final Map getUpdates(StoreQuery q) {
            return this.assertQueryExpression().updates;
        }

        @Override
        public final ClassMetaData[] getAccessPathMetaDatas(StoreQuery q) {
            QueryExpressions[] exps = this.getQueryExpressions();
            if (exps.length == 1) {
                return exps[0].accessPath;
            }
            List<ClassMetaData> metas = null;
            for (int i = 0; i < exps.length; ++i) {
                metas = Filters.addAccessPathMetaDatas(metas, exps[i].accessPath);
            }
            if (metas == null) {
                return StoreQuery.EMPTY_METAS;
            }
            return metas.toArray(new ClassMetaData[metas.size()]);
        }

        @Override
        public boolean isPacking(StoreQuery q) {
            return false;
        }

        private static class ValidateGroupingExpressionVisitor
        extends AbstractExpressionVisitor {
            private final QueryContext _ctx;
            private boolean _grouping = false;
            private Set _grouped = null;
            private Value _agg = null;

            public static void validate(QueryContext ctx, QueryExpressions exps) {
                int i;
                if (exps.grouping.length == 0) {
                    return;
                }
                ValidateGroupingExpressionVisitor visitor = new ValidateGroupingExpressionVisitor(ctx);
                visitor._grouping = true;
                for (i = 0; i < exps.grouping.length; ++i) {
                    exps.grouping[i].acceptVisit(visitor);
                }
                visitor._grouping = false;
                if (exps.having != null) {
                    Class<?> cls = exps.having.getClass();
                    if (cls.getName().endsWith("Expression")) {
                        cls = cls.getSuperclass();
                    }
                    Object value2 = null;
                    Method getValue2 = null;
                    try {
                        getValue2 = cls.getMethod("getValue2", new Class[0]);
                        getValue2.setAccessible(true);
                        value2 = getValue2.invoke((Object)exps.having, (Object[])null);
                    }
                    catch (NoSuchMethodException name) {
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (InvocationTargetException ite) {
                        // empty catch block
                    }
                    if (value2 == null || !(value2 instanceof Subquery)) {
                        exps.having.acceptVisit(visitor);
                    }
                }
                for (i = 0; i < exps.projections.length; ++i) {
                    exps.projections[i].acceptVisit(visitor);
                }
            }

            public ValidateGroupingExpressionVisitor(QueryContext ctx) {
                this._ctx = ctx;
            }

            @Override
            public void enter(Value val) {
                if (this._grouping) {
                    if (val instanceof Path) {
                        if (this._grouped == null) {
                            this._grouped = new HashSet();
                        }
                        this._grouped.add(val);
                    }
                } else if (this._agg == null) {
                    if (val.isAggregate()) {
                        this._agg = val;
                    } else if (val instanceof Path && (this._grouped == null || !this._grouped.contains(val))) {
                        throw new UserException(_loc.get("bad-grouping", this._ctx.getCandidateType(), (Object)this._ctx.getQueryString()));
                    }
                }
            }

            @Override
            public void exit(Value val) {
                if (val == this._agg) {
                    this._agg = null;
                }
            }
        }
    }
}

