/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UserException;

public class ValueMetaDataImpl
implements ValueMetaData {
    private static final Localizer _loc = Localizer.forPackage(ValueMetaDataImpl.class);
    private FieldMetaData _owner;
    private Class _decType = Object.class;
    private int _decCode = 8;
    private ClassMetaData _decTypeMeta = null;
    private Class _type = null;
    private int _code = 8;
    private ClassMetaData _typeMeta = null;
    private Class _typeOverride = null;
    private int _delete = 0;
    private int _persist = 2;
    private int _attach = 1;
    private int _detach = 2;
    private int _refresh = 2;
    private boolean _serialized = false;
    private Boolean _embedded = null;
    private ClassMetaData _embeddedMeta = null;
    private int _resMode = 0;
    private String _mappedBy = null;
    private FieldMetaData _mappedByMeta = null;
    private boolean _checkPUDefaultCascadePersist = true;

    protected ValueMetaDataImpl(FieldMetaData owner) {
        this._owner = owner;
    }

    protected ValueMetaDataImpl() {
    }

    @Override
    public FieldMetaData getFieldMetaData() {
        return this._owner;
    }

    @Override
    public MetaDataRepository getRepository() {
        return this._owner.getRepository();
    }

    @Override
    public Class getType() {
        return this._type == null ? this._decType : this._type;
    }

    @Override
    public void setType(Class type) {
        this._type = type;
        this._typeMeta = null;
        if (type != null) {
            this.setTypeCode(JavaTypes.getTypeCode(type));
        }
    }

    @Override
    public int getTypeCode() {
        return this._type == null ? this._decCode : this._code;
    }

    @Override
    public void setTypeCode(int code) {
        this._code = code;
    }

    @Override
    public boolean isTypePC() {
        return this.getTypeCode() == 15 || this.getTypeCode() == 27;
    }

    @Override
    public ClassMetaData getTypeMetaData() {
        if (this._type == null) {
            return this.getDeclaredTypeMetaData();
        }
        if (this._typeMeta == null && this._code == 15) {
            ClassMetaData meta = this._owner.getDefiningMetaData();
            this._typeMeta = meta.getRepository().getMetaData(this._type, meta.getEnvClassLoader(), true);
        }
        return this._typeMeta;
    }

    @Override
    public Class getDeclaredType() {
        return this._decType;
    }

    @Override
    public void setDeclaredType(Class type) {
        this._decType = type;
        this._decTypeMeta = null;
        this._decCode = JavaTypes.getTypeCode(type);
        if (this._embeddedMeta != null) {
            this._embeddedMeta.setDescribedType(type);
        }
    }

    @Override
    public int getDeclaredTypeCode() {
        return this._decCode;
    }

    @Override
    public void setDeclaredTypeCode(int code) {
        this._decCode = code;
    }

    @Override
    public boolean isDeclaredTypePC() {
        return this._decCode == 15 || this._decCode == 27;
    }

    @Override
    public ClassMetaData getDeclaredTypeMetaData() {
        if (this._decTypeMeta == null && this._decCode == 15) {
            if (this.isEmbedded()) {
                this._decTypeMeta = this.getEmbeddedMetaData();
            } else {
                ClassMetaData meta = this._owner.getDefiningMetaData();
                this._decTypeMeta = meta.getRepository().getMetaData(this._decType, meta.getEnvClassLoader(), true);
            }
        }
        return this._decTypeMeta;
    }

    @Override
    public boolean isEmbedded() {
        if (this._owner.getManagement() != 3) {
            return false;
        }
        if (this._embedded == null) {
            switch (this._decCode) {
                case 12: 
                case 13: 
                case 15: 
                case 27: {
                    this._embedded = Boolean.FALSE;
                    break;
                }
                default: {
                    this._embedded = Boolean.TRUE;
                }
            }
        }
        return this._embedded;
    }

    @Override
    public void setEmbedded(boolean embedded) {
        if (embedded && this._embedded != Boolean.TRUE) {
            this._decTypeMeta = null;
            this._typeMeta = null;
        }
        this._embedded = embedded ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isEmbeddedPC() {
        return this._decCode == 15 && this.isEmbedded();
    }

    @Override
    public ClassMetaData getEmbeddedMetaData() {
        if (this._embeddedMeta == null && this.isEmbeddedPC()) {
            this.addEmbeddedMetaData();
        }
        return this._embeddedMeta;
    }

    @Override
    public ClassMetaData addEmbeddedMetaData(int access) {
        MetaDataRepository repos = this._owner.getRepository();
        this._embeddedMeta = repos.newEmbeddedClassMetaData(this);
        this._embeddedMeta.setDescribedType(this._decType);
        repos.getMetaDataFactory().getDefaults().populate(this._embeddedMeta, access);
        this.setEmbedded(true);
        return this._embeddedMeta;
    }

    @Override
    public ClassMetaData addEmbeddedMetaData() {
        return this.addEmbeddedMetaData(AccessCode.UNKNOWN);
    }

    @Override
    public int getCascadeDelete() {
        if (this._owner.getManagement() != 3) {
            return 0;
        }
        if (this.isEmbeddedPC()) {
            return 1;
        }
        switch (this._delete) {
            case 0: {
                if (this == this._owner.getValue() || !this.isTypePC() || ((ValueMetaDataImpl)this._owner.getValue())._delete != 2) break;
                return 2;
            }
            case 2: {
                if (!this.isTypePC()) break;
                return 2;
            }
            case 1: {
                if (!this.isDeclaredTypePC()) break;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void setCascadeDelete(int delete) {
        this._delete = delete;
    }

    @Override
    public int getCascadePersist() {
        if (this._owner.getManagement() != 3) {
            return 0;
        }
        if (this.isDeclaredTypePC()) {
            return this.checkPUDefaultCascadePersist();
        }
        if (!this.isTypePC()) {
            return 0;
        }
        return this._persist == 1 ? 2 : this.checkPUDefaultCascadePersist();
    }

    private int checkPUDefaultCascadePersist() {
        if (this._checkPUDefaultCascadePersist) {
            Boolean dcpe;
            boolean applyDefaultCascadePersist = false;
            switch (this._owner.getAssociationType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    applyDefaultCascadePersist = true;
                }
            }
            if (applyDefaultCascadePersist && (dcpe = this.getRepository().getMetaDataFactory().getDefaults().isDefaultCascadePersistEnabled()) != null && dcpe.equals(Boolean.TRUE) && this._persist == 0) {
                this._persist = 1;
            }
            this._checkPUDefaultCascadePersist = false;
        }
        return this._persist;
    }

    @Override
    public void setCascadePersist(int persist) {
        this.setCascadePersist(persist, true);
    }

    @Override
    public void setCascadePersist(int persist, boolean checkPUDefault) {
        this._persist = persist;
        this._checkPUDefaultCascadePersist = checkPUDefault;
    }

    @Override
    public int getCascadeAttach() {
        if (this._owner.getManagement() != 3 || !this.isDeclaredTypePC()) {
            return 0;
        }
        if (this.isEmbeddedPC()) {
            return 1;
        }
        return this._attach;
    }

    @Override
    public void setCascadeAttach(int attach) {
        if (attach == 2) {
            throw new IllegalArgumentException("CASCADE_AUTO");
        }
        this._attach = attach;
    }

    @Override
    public int getCascadeDetach() {
        if (this._owner.getManagement() != 3 || !this.isDeclaredTypePC()) {
            return 0;
        }
        if (this.isEmbedded()) {
            return 1;
        }
        return this._detach;
    }

    @Override
    public void setCascadeDetach(int detach) {
        this._detach = detach;
    }

    @Override
    public int getCascadeRefresh() {
        if (this._owner.getManagement() != 3 || !this.isDeclaredTypePC()) {
            return 0;
        }
        return this._refresh;
    }

    @Override
    public void setCascadeRefresh(int refresh) {
        this._refresh = refresh;
    }

    @Override
    public boolean isSerialized() {
        return this._serialized;
    }

    @Override
    public void setSerialized(boolean serialized) {
        this._serialized = serialized;
    }

    @Override
    public String getValueMappedBy() {
        if (this._mappedBy == "`pk`") {
            ClassMetaData meta = this.getRepository().getMetaData(this._owner.getElement().getType(), null, false);
            if (meta == null) {
                throw new MetaDataException(_loc.get("val-not-pc", (Object)this._owner));
            }
            if (meta.getPrimaryKeyFields().length != 1) {
                throw new MetaDataException(_loc.get("val-not-one-pk", (Object)this._owner));
            }
            this._mappedByMeta = meta.getPrimaryKeyFields()[0];
            this._mappedBy = this._mappedByMeta.getName();
        }
        return this._mappedBy;
    }

    @Override
    public void setValueMappedBy(String mapped) {
        if (this._owner.getKey() != this && mapped != null) {
            throw new UserException(_loc.get("mapped-by-not-key", (Object)this));
        }
        this._mappedBy = mapped;
        this._mappedByMeta = null;
    }

    @Override
    public FieldMetaData getValueMappedByMetaData() {
        if (this.getValueMappedBy() != null && this._mappedByMeta == null) {
            FieldMetaData field;
            ClassMetaData meta = this._owner.getElement().getTypeMetaData();
            FieldMetaData fieldMetaData = field = meta == null ? null : meta.getField(this.getValueMappedBy());
            if (field == null) {
                throw new MetaDataException(_loc.get("no-mapped-by", (Object)this, (Object)this.getValueMappedBy()));
            }
            if (field.getMappedBy() != null) {
                throw new MetaDataException(_loc.get("circ-mapped-by", (Object)this, (Object)this.getValueMappedBy()));
            }
            this._mappedByMeta = field;
        }
        return this._mappedByMeta;
    }

    @Override
    public Class getTypeOverride() {
        return this._typeOverride;
    }

    @Override
    public void setTypeOverride(Class val) {
        this._typeOverride = val;
    }

    public String toString() {
        String ret = this._owner.getFullName(true);
        if (this == this._owner.getKey()) {
            return ret + "<key:" + this._decType + ">";
        }
        if (this == this._owner.getElement()) {
            if (this._owner.getTypeCode() == 13) {
                return ret + "<value:" + this._decType + ">";
            }
            return ret + "<element:" + this._decType + ">";
        }
        return ret + "<" + this._decType + ">";
    }

    @Override
    public int getResolve() {
        return this._resMode;
    }

    @Override
    public void setResolve(int mode) {
        this._resMode = mode;
    }

    @Override
    public void setResolve(int mode, boolean on) {
        this._resMode = mode == 0 ? mode : (on ? (this._resMode |= mode) : (this._resMode &= ~mode));
    }

    @Override
    public boolean resolve(int mode) {
        if ((this._resMode & mode) == mode) {
            return true;
        }
        int cur = this._resMode;
        this._resMode |= mode;
        if ((mode & 1) == 0 || (cur & 1) != 0) {
            return false;
        }
        int codeOverride = 8;
        if (this._typeOverride != null) {
            codeOverride = JavaTypes.getTypeCode(this._typeOverride);
            if (this._owner.getExternalizerMethod() == null || this._owner.getValue() != this) {
                this._type = this._typeOverride;
                this._code = codeOverride;
            } else {
                this._decCode = codeOverride;
                if (JavaTypes.maybePC(codeOverride, this._typeOverride)) {
                    this.resolveDeclaredType(this._typeOverride);
                }
            }
        }
        if (JavaTypes.maybePC(this._code, this._type)) {
            this._typeMeta = this._owner.getRepository().getMetaData(this._type, this._owner.getDefiningMetaData().getEnvClassLoader(), false);
            if (this._typeMeta != null) {
                this._code = 15;
            }
        }
        if (this._typeOverride != null && this._owner.getExternalizerMethod() == null && this._owner.getExternalValues() == null) {
            this._decCode = this._code;
            this._decTypeMeta = this._typeMeta;
        } else if (JavaTypes.maybePC(this._decCode, this._decType)) {
            this.resolveDeclaredType(this._decType);
        }
        this.getValueMappedBy();
        ClassMetaData embed = this.getEmbeddedMetaData();
        if (embed != null) {
            embed.resolve(1);
        }
        if (this._decCode == 15 && this.isEmbedded() && this._owner.isPrimaryKey() && this._owner.getValue() == this) {
            this._decCode = 29;
            this._code = 29;
        }
        return false;
    }

    private void resolveDeclaredType(Class type) {
        ClassMetaData meta = this._owner.getRepository().getMetaData(type, this._owner.getDefiningMetaData().getEnvClassLoader(), false);
        if (meta != null) {
            this._decCode = 15;
        }
        if (meta != null && meta.isEmbeddedOnly() && !meta.isAbstract()) {
            this.setEmbedded(true);
        }
        if (!this.isEmbedded()) {
            this._decTypeMeta = meta;
        }
    }

    @Override
    public void copy(ValueMetaData vmd) {
        this._decType = vmd.getDeclaredType();
        this._decCode = vmd.getDeclaredTypeCode();
        if (this._decCode == 29) {
            this._decCode = 15;
        }
        this._delete = vmd.getCascadeDelete();
        this._persist = vmd.getCascadePersist();
        this._attach = vmd.getCascadeAttach();
        this._detach = vmd.getCascadeDetach();
        this._refresh = vmd.getCascadeRefresh();
        this._typeOverride = vmd.getTypeOverride();
        this._serialized = vmd.isSerialized();
        if (this._embeddedMeta != null) {
            this._embeddedMeta.setDescribedType(vmd.getDeclaredType());
        }
        if (this._embedded == null) {
            this.setEmbedded(vmd.isEmbedded());
        }
    }
}

