/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InterceptionType;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.InterceptorBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.ArrayUtil;

public class CdiInterceptorBeanBuilder<T>
extends InterceptorBeanBuilder<T, CdiInterceptorBean<T>> {
    private Set<Annotation> interceptorBindings;

    public CdiInterceptorBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes) {
        super(webBeansContext, annotatedType, beanAttributes);
    }

    public void defineCdiInterceptorRules() {
        this.checkInterceptorConditions();
        this.defineInterceptorMethods();
        this.defineInterceptorBindings();
        this.validateTarget();
        this.validateNoProducerOrObserverMethod(this.annotatedType);
        this.validateNoDisposerWithoutProducer(this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType), Collections.<ProducerMethodBean<?>>emptySet(), Collections.<ProducerFieldBean<?>>emptySet(), Collections.<AnnotatedMethod<?>>emptySet());
    }

    private void validateTarget() {
        boolean isLifecycleOnly;
        boolean bl = isLifecycleOnly = (this.interceptionMethods.containsKey(InterceptionType.POST_CONSTRUCT) || this.interceptionMethods.containsKey(InterceptionType.PRE_DESTROY)) && !this.interceptionMethods.containsKey(InterceptionType.AROUND_INVOKE) && !this.interceptionMethods.containsKey(InterceptionType.AROUND_TIMEOUT) && !this.interceptionMethods.containsKey(InterceptionType.AROUND_CONSTRUCT);
        if (isLifecycleOnly && this.interceptorBindings != null) {
            for (Annotation a : this.interceptorBindings) {
                Target target = a.annotationType().getAnnotation(Target.class);
                if (target != null && Arrays.asList(target.value()).equals(Arrays.asList(ElementType.TYPE))) continue;
                throw new WebBeansConfigurationException(a.annotationType().getName() + " doesn't have strictly @Target(TYPE) but has lifecycle methods. " + "Interceptor: " + this.annotatedType.getJavaClass().getName());
            }
        }
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.webBeansContext.getInterceptorsManager().isInterceptorClassEnabled(this.annotatedType.getJavaClass());
    }

    protected void defineInterceptorBindings() {
        Annotation[] bindings = this.webBeansContext.getAnnotationManager().getInterceptorBindingMetaAnnotations(this.annotatedType.getAnnotations());
        if (bindings == null || bindings.length == 0) {
            throw new WebBeansConfigurationException("WebBeans Interceptor class : " + this.annotatedType.getJavaClass() + " must have at least one @InterceptorBinding annotation");
        }
        this.interceptorBindings = ArrayUtil.asSet(bindings);
    }

    @Override
    protected CdiInterceptorBean<T> createBean(Class<T> beanClass, boolean enabled, Map<InterceptionType, Method[]> interceptionMethods) {
        return new CdiInterceptorBean<T>(this.webBeansContext, this.annotatedType, this.beanAttributes, beanClass, this.interceptorBindings, enabled, interceptionMethods);
    }
}

