/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;
import org.apache.webbeans.xml.ElementIterator;
import org.apache.webbeans.xml.WebBeansErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanArchiveService
implements BeanArchiveService {
    private static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    private static final String WEB_INF_CLASSES_MAVEN = "target/classes/";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(BeanArchiveService.class);
    private Map<String, BeanArchiveService.BeanArchiveInformation> beanArchiveInformations = new HashMap<String, BeanArchiveService.BeanArchiveInformation>();
    private UrlSet registeredBeanArchives = new UrlSet();

    public BeanArchiveService.BeanArchiveInformation getBeanArchiveInformation(URL beanArchiveUrl) {
        String beanArchiveLocation = beanArchiveUrl.toExternalForm();
        BeanArchiveService.BeanArchiveInformation bdaInfo = this.beanArchiveInformations.get(beanArchiveLocation);
        if (bdaInfo == null && !beanArchiveLocation.contains(".xml")) {
            String strippedBeanArchiveUrl = this.stripProtocol(beanArchiveLocation);
            for (Map.Entry<String, BeanArchiveService.BeanArchiveInformation> entry : this.beanArchiveInformations.entrySet()) {
                if (!this.stripProtocol(entry.getKey()).startsWith(strippedBeanArchiveUrl)) continue;
                bdaInfo = entry.getValue();
                break;
            }
        }
        if (bdaInfo == null && (beanArchiveLocation.contains(WEB_INF_CLASSES) || beanArchiveLocation.contains(WEB_INF_CLASSES_MAVEN))) {
            bdaInfo = this.readBeansXml(beanArchiveUrl, beanArchiveLocation);
            bdaInfo = this.mergeWithWebInfBeansXml(bdaInfo);
            this.beanArchiveInformations.put(beanArchiveLocation, bdaInfo);
            this.registeredBeanArchives.add(beanArchiveUrl);
        }
        if (bdaInfo == null) {
            bdaInfo = this.readBeansXml(beanArchiveUrl, beanArchiveLocation);
            this.beanArchiveInformations.put(beanArchiveLocation, bdaInfo);
            this.registeredBeanArchives.add(beanArchiveUrl);
        }
        return bdaInfo;
    }

    private BeanArchiveService.BeanArchiveInformation mergeWithWebInfBeansXml(BeanArchiveService.BeanArchiveInformation bdaWebClasses) {
        BeanArchiveService.BeanArchiveInformation bdaWebInf = null;
        for (Map.Entry<String, BeanArchiveService.BeanArchiveInformation> entry : this.beanArchiveInformations.entrySet()) {
            if (!entry.getKey().endsWith("WEB-INF/beans.xml")) continue;
            bdaWebInf = entry.getValue();
            break;
        }
        if (bdaWebInf == null) {
            return bdaWebClasses;
        }
        DefaultBeanArchiveInformation mergedBdaInfo = new DefaultBeanArchiveInformation();
        mergedBdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.max((BeanArchiveService.BeanDiscoveryMode)bdaWebClasses.getBeanDiscoveryMode(), (BeanArchiveService.BeanDiscoveryMode)bdaWebInf.getBeanDiscoveryMode()));
        mergedBdaInfo.setVersion(bdaWebClasses.getVersion() != null ? bdaWebClasses.getVersion() : bdaWebInf.getVersion());
        mergedBdaInfo.setExcludedClasses(this.mergeLists(bdaWebClasses.getExcludedClasses(), bdaWebInf.getExcludedClasses()));
        mergedBdaInfo.setExcludedPackages(this.mergeLists(bdaWebClasses.getExcludedPackages(), bdaWebInf.getExcludedPackages()));
        mergedBdaInfo.setInterceptors(this.mergeLists(bdaWebClasses.getInterceptors(), bdaWebInf.getInterceptors()));
        mergedBdaInfo.setDecorators(this.mergeLists(bdaWebClasses.getDecorators(), bdaWebInf.getDecorators()));
        mergedBdaInfo.getAlternativeClasses().addAll(this.mergeLists(bdaWebClasses.getAlternativeClasses(), bdaWebInf.getAlternativeClasses()));
        mergedBdaInfo.getAlternativeStereotypes().addAll(this.mergeLists(bdaWebClasses.getAlternativeStereotypes(), bdaWebInf.getAlternativeStereotypes()));
        return mergedBdaInfo;
    }

    private List<String> mergeLists(List<String> list1, List<String> list2) {
        if (list1 == null || list1.isEmpty()) {
            return list2;
        }
        if (list2 == null) {
            return null;
        }
        ArrayList<String> mergedList = new ArrayList<String>(list1);
        for (String val : list2) {
            if (mergedList.contains(val)) continue;
            mergedList.add(val);
        }
        return mergedList;
    }

    public Set<URL> getRegisteredBeanArchives() {
        return this.registeredBeanArchives;
    }

    protected DefaultBeanArchiveInformation createBeanArchiveInformation() {
        return new DefaultBeanArchiveInformation();
    }

    private BeanArchiveService.BeanArchiveInformation readBeansXml(URL beansXmlUrl, String beansXmlLocation) {
        if (beansXmlUrl == null) {
            throw new WebBeansConfigurationException("beans.xml URL must be given!");
        }
        if (!beansXmlLocation.endsWith(".xml")) {
            DefaultBeanArchiveInformation bdaInfo = this.createBeanArchiveInformation();
            bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ANNOTATED);
            return bdaInfo;
        }
        InputStream xmlStream = null;
        try {
            xmlStream = beansXmlUrl.openStream();
            BeanArchiveService.BeanArchiveInformation beanArchiveInformation = this.readBeansXml(xmlStream, beansXmlUrl.toExternalForm());
            return beanArchiveInformation;
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException("Error while parsing the beans.xml file " + beansXmlLocation, e);
        }
        finally {
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
            }
            catch (IOException ioe) {
                throw new WebBeansDeploymentException("Error while closing the input stream!", ioe);
            }
        }
    }

    protected String stripProtocol(String urlPath) {
        int pos = urlPath.lastIndexOf(":/");
        if (pos > 0) {
            return urlPath.substring(pos + 1);
        }
        return urlPath;
    }

    protected BeanArchiveService.BeanArchiveInformation readBeansXml(InputStream xmlStreamIn, String beansXmlLocation) throws IOException {
        DefaultBeanArchiveInformation bdaInfo = this.createBeanArchiveInformation();
        if (xmlStreamIn != null) {
            PushbackInputStream xmlStream = new PushbackInputStream(xmlStreamIn);
            int firstVal = xmlStream.read();
            if (firstVal < 0) {
                bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
            } else {
                xmlStream.unread(firstVal);
                Element webBeansRoot = this.getBeansRootElement(xmlStream);
                if (webBeansRoot == null) {
                    bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
                } else {
                    if (!"beans".equalsIgnoreCase(webBeansRoot.getLocalName())) {
                        throw new WebBeansConfigurationException("beans.xml must have a <beans> root element, but has: " + webBeansRoot.getLocalName() + " in " + beansXmlLocation);
                    }
                    bdaInfo.setVersion(this.getTrimmedAttribute(webBeansRoot, "version"));
                    String beanDiscoveryMode = this.getTrimmedAttribute(webBeansRoot, "bean-discovery-mode");
                    bdaInfo.setBeanDiscoveryMode(beanDiscoveryMode != null ? BeanArchiveService.BeanDiscoveryMode.valueOf((String)beanDiscoveryMode.toUpperCase()) : null);
                    this.readBeanChildren(bdaInfo, webBeansRoot, beansXmlLocation);
                }
                if (bdaInfo.getVersion() != null && !"1.0".equals(bdaInfo.getVersion()) && bdaInfo.getBeanDiscoveryMode() == null) {
                    throw new WebBeansConfigurationException("beans.xml with version 1.1 and higher must declare a bean-discovery-mode! url=" + beansXmlLocation);
                }
                if (bdaInfo.getBeanDiscoveryMode() == null) {
                    bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
                }
            }
        }
        if (bdaInfo.getBeanDiscoveryMode() == null) {
            bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ANNOTATED);
        }
        return bdaInfo;
    }

    private void readBeanChildren(DefaultBeanArchiveInformation bdaInfo, Element webBeansRoot, String beansXmlLocation) {
        ElementIterator elit = new ElementIterator(webBeansRoot);
        while (elit.hasNext()) {
            Element child = elit.next();
            if ("decorators".equalsIgnoreCase(child.getLocalName())) {
                this.fillDecorators(bdaInfo, child);
                continue;
            }
            if ("interceptors".equalsIgnoreCase(child.getLocalName())) {
                this.fillInterceptors(bdaInfo, child);
                continue;
            }
            if ("alternatives".equalsIgnoreCase(child.getLocalName())) {
                this.fillAlternatives(bdaInfo, child);
                continue;
            }
            if ("scan".equalsIgnoreCase(child.getLocalName())) {
                this.fillExcludes(bdaInfo, child);
                continue;
            }
            if ("allowProxying".equalsIgnoreCase(child.getLocalName())) {
                this.fillAllowProxying(bdaInfo, child);
                continue;
            }
            if (!"scopedBeansOnly".equalsIgnoreCase(child.getLocalName())) continue;
            logger.info("OWB specific feature detected: force bean-discovery-mode=\"scopex\" for " + beansXmlLocation);
            bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.SCOPED);
        }
    }

    private void fillDecorators(DefaultBeanArchiveInformation bdaInfo, Element decoratorsElement) {
        ElementIterator elit = new ElementIterator(decoratorsElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if (!"class".equalsIgnoreCase(child.getLocalName())) continue;
            String clazz = child.getTextContent().trim();
            if (clazz.isEmpty()) {
                throw new WebBeansConfigurationException("decorators <class> element must not be empty!");
            }
            bdaInfo.getDecorators().add(clazz);
        }
    }

    private void fillInterceptors(DefaultBeanArchiveInformation bdaInfo, Element interceptorsElement) {
        ElementIterator elit = new ElementIterator(interceptorsElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if (!"class".equalsIgnoreCase(child.getLocalName())) continue;
            String clazz = child.getTextContent().trim();
            if (clazz.isEmpty()) {
                throw new WebBeansConfigurationException("interceptors <class> element must not be empty!");
            }
            bdaInfo.getInterceptors().add(clazz);
        }
    }

    private void fillAlternatives(DefaultBeanArchiveInformation bdaInfo, Element alternativesElement) {
        ElementIterator elit = new ElementIterator(alternativesElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if ("class".equalsIgnoreCase(child.getLocalName())) {
                String clazz = child.getTextContent().trim();
                if (clazz.isEmpty()) {
                    throw new WebBeansConfigurationException("alternatives <class> element must not be empty!");
                }
                bdaInfo.getAlternativeClasses().add(clazz);
            }
            if (!"stereotype".equalsIgnoreCase(child.getLocalName())) continue;
            String stereotype = child.getTextContent().trim();
            if (stereotype.isEmpty()) {
                throw new WebBeansConfigurationException("alternatives <stereotype> element must not be empty!");
            }
            bdaInfo.getAlternativeStereotypes().add(stereotype);
        }
    }

    private void fillExcludes(DefaultBeanArchiveInformation bdaInfo, Element scanElement) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        NodeList childNodes = scanElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element child;
            Node nd = childNodes.item(i);
            if (!Element.class.isInstance(nd) || !"exclude".equalsIgnoreCase((child = (Element)Element.class.cast(nd)).getLocalName())) continue;
            String name = this.getTrimmedAttribute(child, "name");
            NodeList children = child.getChildNodes();
            boolean skip = false;
            for (int j = 0; j < children.getLength(); ++j) {
                Node ndChild = children.item(j);
                if (!Element.class.isInstance(ndChild)) continue;
                Element condition = (Element)Element.class.cast(ndChild);
                String localName = condition.getLocalName();
                if ("if-class-available".equalsIgnoreCase(localName)) {
                    if (DefaultBeanArchiveService.isClassAvailable(loader, this.getTrimmedAttribute(condition, "name"))) continue;
                    skip = true;
                    break;
                }
                if ("if-class-not-available".equalsIgnoreCase(localName)) {
                    if (!DefaultBeanArchiveService.isClassAvailable(loader, this.getTrimmedAttribute(condition, "name"))) continue;
                    skip = true;
                    break;
                }
                if (!"if-system-property ".equalsIgnoreCase(localName)) continue;
                String value = this.getTrimmedAttribute(condition, "value");
                String systProp = System.getProperty(this.getTrimmedAttribute(condition, "name"));
                if ((value != null || systProp != null) && value != null && value.equals(systProp)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            if (name.endsWith(".*")) {
                bdaInfo.addClassExclude(name.substring(0, name.length() - 2));
                continue;
            }
            if (name.endsWith(".**")) {
                bdaInfo.addPackageExclude(name.substring(0, name.length() - 3));
                continue;
            }
            bdaInfo.addClassExclude(name);
        }
    }

    private void fillAllowProxying(DefaultBeanArchiveInformation bdaInfo, Element allowProxyingElement) {
        ElementIterator elit = new ElementIterator(allowProxyingElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if (!"class".equalsIgnoreCase(child.getLocalName())) continue;
            String clazz = child.getTextContent().trim();
            if (clazz.isEmpty()) {
                throw new WebBeansConfigurationException("allowProxying <class> element must not be empty!");
            }
            bdaInfo.getAllowProxyingClasses().add(clazz);
        }
    }

    private static boolean isClassAvailable(ClassLoader loader, String name) {
        try {
            loader.loadClass(name);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void release() {
        this.beanArchiveInformations.clear();
    }

    protected Element getBeansRootElement(InputStream xmlStream) throws WebBeansException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new WebBeansErrorHandler());
            Element root = documentBuilder.parse(xmlStream).getDocumentElement();
            return root;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "FATAL_0002", e);
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString("EXCEPT_0013"), e);
        }
    }

    protected String getTrimmedAttribute(Element element, String attributeName) {
        String val = element.getAttribute(attributeName);
        if (val != null && !(val = val.trim()).isEmpty()) {
            return val;
        }
        return null;
    }
}

