/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.BeanAttributesConfiguratorImpl;
import org.apache.webbeans.portable.events.AfterObserver;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessBeanAttributesImpl<T>
extends EventBase
implements ProcessBeanAttributes<T>,
AfterObserver {
    private final WebBeansContext webBeansContext;
    private Annotated annotated;
    private BeanAttributes<T> attributes;
    private boolean veto;
    private Throwable definitionError;
    private boolean ignoreFinalMethods;
    private boolean set;
    private BeanAttributesConfiguratorImpl beanAttributesConfigurator;

    public ProcessBeanAttributesImpl(WebBeansContext webBeansContext, Annotated annotated, BeanAttributes<T> attributes) {
        this.webBeansContext = webBeansContext;
        this.annotated = annotated;
        this.attributes = attributes;
    }

    public Annotated getAnnotated() {
        this.checkState();
        return this.annotated;
    }

    public BeanAttributes<T> getBeanAttributes() {
        this.checkState();
        return this.attributes;
    }

    public void setBeanAttributes(BeanAttributes<T> tBeanAttributes) {
        this.checkState();
        if (this.beanAttributesConfigurator != null) {
            throw new IllegalStateException("you can't configure and set the bean attributes in the same extension");
        }
        this.set = true;
        this.attributes = tBeanAttributes;
    }

    public void veto() {
        this.checkState();
        this.veto = true;
    }

    public void addDefinitionError(Throwable throwable) {
        this.checkState();
        this.definitionError = throwable;
    }

    public void ignoreFinalMethods() {
        this.ignoreFinalMethods = true;
    }

    public BeanAttributesConfigurator<T> configureBeanAttributes() {
        this.checkState();
        if (this.set) {
            throw new IllegalStateException("you can't configure and set the bean attributes in the same extension");
        }
        if (this.beanAttributesConfigurator == null) {
            this.beanAttributesConfigurator = new BeanAttributesConfiguratorImpl<T>(this.webBeansContext, this.attributes);
        }
        return this.beanAttributesConfigurator;
    }

    public BeanAttributes<T> getAttributes() {
        if (this.beanAttributesConfigurator != null) {
            return this.beanAttributesConfigurator.getBeanAttributes();
        }
        return this.attributes;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isIgnoreFinalMethods() {
        return this.ignoreFinalMethods;
    }

    public Throwable getDefinitionError() {
        return this.definitionError;
    }

    @Override
    public void afterObserver() {
        if (this.beanAttributesConfigurator != null) {
            this.attributes = this.beanAttributesConfigurator.getBeanAttributes();
            this.beanAttributesConfigurator = null;
        } else if (this.set) {
            this.set = false;
        }
    }
}

