/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.EncryptionAlgorithm;
import org.apache.orc.InMemoryKeystore;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.KeyProvider;

public class InMemoryEncryptionReader {
    public static void main(Configuration conf, String[] args) throws IOException {
        byte[] kmsKey = "secret123".getBytes(StandardCharsets.UTF_8);
        InMemoryKeystore keyProvider = new InMemoryKeystore().addKey("pii", EncryptionAlgorithm.AES_CTR_128, kmsKey);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).setKeyProvider((KeyProvider)keyProvider);
        Reader reader = OrcFile.createReader((Path)new Path("encrypted.orc"), (OrcFile.ReaderOptions)readerOptions);
        System.out.println("File schema: " + reader.getSchema());
        System.out.println("Row count: " + reader.getNumberOfRows());
        TypeDescription schema = TypeDescription.fromString((String)"struct<x:int,y:string>");
        VectorizedRowBatch batch = schema.createRowBatch();
        RecordReader rowIterator = reader.rows(reader.options().schema(schema));
        LongColumnVector x = (LongColumnVector)batch.cols[0];
        BytesColumnVector y = (BytesColumnVector)batch.cols[1];
        while (rowIterator.nextBatch(batch)) {
            for (int row = 0; row < batch.size; ++row) {
                System.out.println("x: " + x.vector[row]);
                System.out.println("y: " + y.toString(row));
            }
        }
        rowIterator.close();
    }

    public static void main(String[] args) throws IOException {
        InMemoryEncryptionReader.main(new Configuration(), args);
    }
}

