/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page.mem;

import java.util.Iterator;
import java.util.Objects;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemPageReader
implements PageReader {
    private static final Logger LOG = LoggerFactory.getLogger(MemPageReader.class);
    private final long totalValueCount;
    private final Iterator<DataPage> pages;
    private final DictionaryPage dictionaryPage;

    public MemPageReader(long totalValueCount, Iterator<DataPage> pages, DictionaryPage dictionaryPage) {
        this.pages = Objects.requireNonNull(pages, "pages cannot be null");
        this.totalValueCount = totalValueCount;
        this.dictionaryPage = dictionaryPage;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public DataPage readPage() {
        if (this.pages.hasNext()) {
            DataPage next = this.pages.next();
            LOG.debug("read page {}", (Object)next);
            return next;
        }
        throw new ParquetDecodingException("after last page");
    }

    public DictionaryPage readDictionaryPage() {
        return this.dictionaryPage;
    }
}

