/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestValuesReaderImpl {
    @Test
    public void testInvalidValuesReaderImpl() throws IOException {
        InvalidValuesReaderImpl reader = new InvalidValuesReaderImpl();
        try {
            this.validateWithByteArray(reader);
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.validateWithByteBuffer(reader);
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.validateWithByteBufferInputStream(reader);
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testByteBufferValuesReaderImpl() throws IOException {
        ByteBufferValuesReaderImpl reader = new ByteBufferValuesReaderImpl();
        this.validateWithByteArray(reader);
        this.validateWithByteBuffer(reader);
        this.validateWithByteBufferInputStream(reader);
    }

    @Test
    public void testByteBufferInputStreamValuesReaderImpl() throws IOException {
        ByteBufferInputStreamValuesReaderImpl reader = new ByteBufferInputStreamValuesReaderImpl();
        this.validateWithByteArray(reader);
        this.validateWithByteBuffer(reader);
        this.validateWithByteBufferInputStream(reader);
    }

    private void validateWithByteArray(ValuesReader reader) throws IOException {
        reader.initFromPage(25, "==padding==The expected page content".getBytes(), 11);
        Assert.assertEquals((Object)"The expected page content", (Object)reader.readBytes().toStringUsingUTF8());
    }

    private void validateWithByteBuffer(ValuesReader reader) throws IOException {
        reader.initFromPage(25, ByteBuffer.wrap("==padding==The expected page content".getBytes()), 11);
        Assert.assertEquals((Object)"The expected page content", (Object)reader.readBytes().toStringUsingUTF8());
    }

    private void validateWithByteBufferInputStream(ValuesReader reader) throws IOException {
        ByteBufferInputStream bbis = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap("==padding==".getBytes()), ByteBuffer.wrap("The expected ".getBytes()), ByteBuffer.wrap("page content".getBytes())});
        bbis.skipFully(11L);
        reader.initFromPage(25, bbis);
        Assert.assertEquals((Object)"The expected page content", (Object)reader.readBytes().toStringUsingUTF8());
    }

    private static class ByteBufferInputStreamValuesReaderImpl
    extends ValuesReader {
        private byte[] data;

        private ByteBufferInputStreamValuesReaderImpl() {
        }

        public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
            int read;
            this.data = new byte[valueCount];
            int off = 0;
            for (int len = valueCount; (read = in.read(this.data, off, len)) != -1 && len > 0; len -= read) {
                off += read;
            }
        }

        public void skip() {
        }

        public Binary readBytes() {
            return Binary.fromConstantByteArray((byte[])this.data);
        }
    }

    private static class ByteBufferValuesReaderImpl
    extends ValuesReader {
        private byte[] data;

        private ByteBufferValuesReaderImpl() {
        }

        public void initFromPage(int valueCount, ByteBuffer page, int offset) throws IOException {
            this.data = new byte[valueCount];
            ByteBuffer buffer = page.duplicate();
            buffer.position(offset);
            buffer.get(this.data);
        }

        public void assertPageEquals(String expected) {
            Assert.assertEquals((Object)expected, (Object)new String(this.data));
        }

        public void skip() {
        }

        public Binary readBytes() {
            return Binary.fromConstantByteArray((byte[])this.data);
        }
    }

    private static class InvalidValuesReaderImpl
    extends ValuesReader {
        private InvalidValuesReaderImpl() {
        }

        public void skip() {
        }
    }
}

