/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bytestreamsplit;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForDouble;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFloat;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesWriter;
import org.junit.Assert;
import org.junit.Test;

public class ByteStreamSplitValuesEndToEndTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFloatPipeline() throws Exception {
        Random rand = new Random(1337L);
        int numElements = 1024;
        float[] values = new float[1024];
        for (int i = 0; i < 1024; ++i) {
            float f;
            values[i] = f = rand.nextFloat() * 4096.0f;
        }
        ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter writer = null;
        try {
            writer = new ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter(4096, 4096, (ByteBufferAllocator)new DirectByteBufferAllocator());
            for (float v : values) {
                writer.writeFloat(v);
            }
            Assert.assertEquals((long)4096L, (long)writer.getBufferedSize());
            BytesInput input = writer.getBytes();
            Assert.assertEquals((long)4096L, (long)input.size());
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
            for (float expectedValue : values) {
                float newValue = reader.readFloat();
                Assert.assertEquals((float)expectedValue, (float)newValue, (float)0.0f);
            }
        }
        finally {
            if (writer != null) {
                writer.reset();
                writer.close();
            }
        }
    }

    @Test
    public void testDoublePipeline() throws Exception {
        Random rand = new Random(18990L);
        int numElements = 1024;
        double[] values = new double[1024];
        for (int i = 0; i < 1024; ++i) {
            double f;
            values[i] = f = rand.nextDouble() * 16384.0;
        }
        ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter writer = new ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter(8192, 8192, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (double v : values) {
            writer.writeDouble(v);
        }
        Assert.assertEquals((long)8192L, (long)writer.getBufferedSize());
        BytesInput input = writer.getBytes();
        Assert.assertEquals((long)8192L, (long)input.size());
        ByteStreamSplitValuesReaderForDouble reader = new ByteStreamSplitValuesReaderForDouble();
        reader.initFromPage(1024, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{input.toByteBuffer()}));
        for (double expectedValue : values) {
            double newValue = reader.readDouble();
            Assert.assertEquals((double)expectedValue, (double)newValue, (double)0.0);
        }
        writer.reset();
        writer.close();
    }
}

