/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bytestreamsplit;

import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesWriter;
import org.junit.Assert;
import org.junit.Test;

public class ByteStreamSplitValuesWriterTest {

    public static class DoubleTest {
        static double convertType(byte[] bytes) {
            long v = 0L;
            for (int i = 0; i < bytes.length; ++i) {
                v |= (long)(bytes[i] & 0xFF) << i * 8;
            }
            return Double.longBitsToDouble(v);
        }

        private ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter getWriter(int capacity) {
            return new ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter(capacity, capacity, (ByteBufferAllocator)new DirectByteBufferAllocator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSingleElement() throws Exception {
            double value = 23.6718811111112;
            ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter writer = null;
            try {
                writer = this.getWriter(1);
                writer.writeDouble(23.6718811111112);
                Assert.assertEquals((long)8L, (long)writer.getBufferedSize());
                BytesInput bytesInput = writer.getBytes();
                Assert.assertEquals((long)8L, (long)writer.getBufferedSize());
                Assert.assertEquals((long)8L, (long)bytesInput.size());
                double newValue = DoubleTest.convertType(bytesInput.toByteArray());
                Assert.assertEquals((double)23.6718811111112, (double)newValue, (double)0.0);
                writer.reset();
                Assert.assertEquals((long)0L, (long)writer.getBufferedSize());
                Assert.assertEquals((long)0L, (long)writer.getBytes().size());
            }
            finally {
                if (writer != null) {
                    writer.reset();
                    writer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSmallBuffer() throws Exception {
            ByteStreamSplitValuesWriter.DoubleByteStreamSplitValuesWriter writer = null;
            try {
                writer = this.getWriter(3);
                writer.writeDouble(13.6288992);
                writer.writeDouble(671.99901111);
                writer.writeDouble(3.5001999093019013E9);
                Assert.assertEquals((long)24L, (long)writer.getBufferedSize());
                byte[] rawBytes = writer.getBytes().toByteArray();
                Assert.assertEquals((long)24L, (long)rawBytes.length);
                byte[] expectedBytes = new byte[]{12, 83, 45, -10, 110, -87, 112, -119, -87, 19, -7, -4, -1, -3, 25, 65, -1, 20, 43, -124, -22, 64, 64, 65};
                for (int i = 0; i < 24; ++i) {
                    Assert.assertEquals((long)expectedBytes[i], (long)rawBytes[i]);
                }
            }
            finally {
                if (writer != null) {
                    writer.reset();
                    writer.close();
                }
            }
        }
    }

    public static class FloatTest {
        static float convertType(byte[] bytes) {
            int v = 0;
            for (int i = 0; i < bytes.length; ++i) {
                v |= (bytes[i] & 0xFF) << i * 8;
            }
            return Float.intBitsToFloat(v);
        }

        private ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter getWriter(int capacity) {
            return new ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter(capacity, capacity, (ByteBufferAllocator)new DirectByteBufferAllocator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSingleElement() throws Exception {
            float value = 0.56274414f;
            ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter writer = null;
            try {
                writer = this.getWriter(1);
                writer.writeFloat(0.56274414f);
                Assert.assertEquals((long)4L, (long)writer.getBufferedSize());
                BytesInput bytesInput = writer.getBytes();
                Assert.assertEquals((long)4L, (long)writer.getBufferedSize());
                Assert.assertEquals((long)4L, (long)bytesInput.size());
                float newValue = FloatTest.convertType(bytesInput.toByteArray());
                Assert.assertEquals((float)0.56274414f, (float)newValue, (float)0.0f);
                writer.reset();
                Assert.assertEquals((long)0L, (long)writer.getBufferedSize());
                Assert.assertEquals((long)0L, (long)writer.getBytes().size());
            }
            finally {
                if (writer != null) {
                    writer.reset();
                    writer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSmallBuffer() throws Exception {
            ByteStreamSplitValuesWriter.FloatByteStreamSplitValuesWriter writer = null;
            try {
                writer = this.getWriter(3);
                writer.writeFloat(202.625f);
                writer.writeFloat(1024.9219f);
                writer.writeFloat(2024.5f);
                Assert.assertEquals((long)12L, (long)writer.getBufferedSize());
                byte[] rawBytes = writer.getBytes().toByteArray();
                Assert.assertEquals((long)12L, (long)rawBytes.length);
                byte[] expectedBytes = new byte[]{0, -128, 0, -96, 29, 16, 74, -128, -3, 67, 68, 68};
                for (int i = 0; i < 12; ++i) {
                    Assert.assertEquals((long)expectedBytes[i], (long)rawBytes[i]);
                }
            }
            finally {
                if (writer != null) {
                    writer.reset();
                    writer.close();
                }
            }
        }
    }
}

