/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.bytes.ConcatenatingByteBufferCollector;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConcatenatingByteBufferCollector {
    private TrackingByteBufferAllocator allocator;

    @Before
    public void initAllocator() {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    @Test
    public void test() throws IOException {
        byte[] result;
        try (ConcatenatingByteBufferCollector outer = new ConcatenatingByteBufferCollector((ByteBufferAllocator)this.allocator);
             ConcatenatingByteBufferCollector inner = new ConcatenatingByteBufferCollector((ByteBufferAllocator)this.allocator);){
            outer.collect(BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((ByteBuffer[])new ByteBuffer[]{TestConcatenatingByteBufferCollector.byteBuffer("This"), TestConcatenatingByteBufferCollector.byteBuffer(" "), TestConcatenatingByteBufferCollector.byteBuffer("is")}), BytesInput.from(Arrays.asList(TestConcatenatingByteBufferCollector.byteBuffer(" a"), TestConcatenatingByteBufferCollector.byteBuffer(" "), TestConcatenatingByteBufferCollector.byteBuffer("test"))), BytesInput.from((InputStream)TestConcatenatingByteBufferCollector.inputStream(" text to blabla"), (int)8), BytesInput.from((byte[])TestConcatenatingByteBufferCollector.bytes(" ")), BytesInput.from((byte[])TestConcatenatingByteBufferCollector.bytes("blabla validate blabla"), (int)7, (int)9), BytesInput.from((ByteArrayOutputStream)TestConcatenatingByteBufferCollector.byteArrayOutputStream("the class ")), BytesInput.from((CapacityByteArrayOutputStream)TestConcatenatingByteBufferCollector.capacityByteArrayOutputStream("ConcatenatingByteBufferCollector"))}));
            inner.collect(BytesInput.fromInt((int)12345));
            inner.collect(BytesInput.fromUnsignedVarInt((int)67891));
            inner.collect(BytesInput.fromUnsignedVarLong((long)2345678901L));
            inner.collect(BytesInput.fromZigZagVarInt((int)-234567));
            inner.collect(BytesInput.fromZigZagVarLong((long)-890123456789L));
            outer.collect((BytesInput)inner);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            outer.writeAllTo((OutputStream)baos);
            result = baos.toByteArray();
        }
        Assert.assertEquals((Object)"This is a test text to validate the class ConcatenatingByteBufferCollector", (Object)new String(result, 0, 74));
        ByteArrayInputStream in = new ByteArrayInputStream(result, 74, result.length - 74);
        Assert.assertEquals((long)12345L, (long)BytesUtils.readIntLittleEndian((InputStream)in));
        Assert.assertEquals((long)67891L, (long)BytesUtils.readUnsignedVarInt((InputStream)in));
        Assert.assertEquals((long)2345678901L, (long)BytesUtils.readUnsignedVarLong((InputStream)in));
        Assert.assertEquals((long)-234567L, (long)BytesUtils.readZigZagVarInt((InputStream)in));
        Assert.assertEquals((long)-890123456789L, (long)BytesUtils.readZigZagVarLong((InputStream)in));
    }

    private static byte[] bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private static ByteBuffer byteBuffer(String str) {
        return ByteBuffer.wrap(TestConcatenatingByteBufferCollector.bytes(str));
    }

    private static InputStream inputStream(String str) {
        return new ByteArrayInputStream(TestConcatenatingByteBufferCollector.bytes(str));
    }

    private static ByteArrayOutputStream byteArrayOutputStream(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(TestConcatenatingByteBufferCollector.bytes(str));
        return baos;
    }

    private static CapacityByteArrayOutputStream capacityByteArrayOutputStream(String str) {
        CapacityByteArrayOutputStream cbaos = new CapacityByteArrayOutputStream(2, Integer.MAX_VALUE, (ByteBufferAllocator)new HeapByteBufferAllocator());
        for (byte b : TestConcatenatingByteBufferCollector.bytes(str)) {
            cbaos.write((int)b);
        }
        return cbaos;
    }
}

