package org.apache.parquet.column.values.bitpacking;
import java.nio.ByteBuffer;

/**
 * Packs from the Least Significant Bit first
 * 
 * See ByteBasedBitPackingGenerator to make changes to this file
 * Automatically generated
 *
 */
public abstract class ByteBitPackingForLongLE {

  private static final BytePackerForLong[] packers = new BytePackerForLong[65];
  static {
    packers[0] = new Packer0();
    packers[1] = new Packer1();
    packers[2] = new Packer2();
    packers[3] = new Packer3();
    packers[4] = new Packer4();
    packers[5] = new Packer5();
    packers[6] = new Packer6();
    packers[7] = new Packer7();
    packers[8] = new Packer8();
    packers[9] = new Packer9();
    packers[10] = new Packer10();
    packers[11] = new Packer11();
    packers[12] = new Packer12();
    packers[13] = new Packer13();
    packers[14] = new Packer14();
    packers[15] = new Packer15();
    packers[16] = new Packer16();
    packers[17] = new Packer17();
    packers[18] = new Packer18();
    packers[19] = new Packer19();
    packers[20] = new Packer20();
    packers[21] = new Packer21();
    packers[22] = new Packer22();
    packers[23] = new Packer23();
    packers[24] = new Packer24();
    packers[25] = new Packer25();
    packers[26] = new Packer26();
    packers[27] = new Packer27();
    packers[28] = new Packer28();
    packers[29] = new Packer29();
    packers[30] = new Packer30();
    packers[31] = new Packer31();
    packers[32] = new Packer32();
    packers[33] = new Packer33();
    packers[34] = new Packer34();
    packers[35] = new Packer35();
    packers[36] = new Packer36();
    packers[37] = new Packer37();
    packers[38] = new Packer38();
    packers[39] = new Packer39();
    packers[40] = new Packer40();
    packers[41] = new Packer41();
    packers[42] = new Packer42();
    packers[43] = new Packer43();
    packers[44] = new Packer44();
    packers[45] = new Packer45();
    packers[46] = new Packer46();
    packers[47] = new Packer47();
    packers[48] = new Packer48();
    packers[49] = new Packer49();
    packers[50] = new Packer50();
    packers[51] = new Packer51();
    packers[52] = new Packer52();
    packers[53] = new Packer53();
    packers[54] = new Packer54();
    packers[55] = new Packer55();
    packers[56] = new Packer56();
    packers[57] = new Packer57();
    packers[58] = new Packer58();
    packers[59] = new Packer59();
    packers[60] = new Packer60();
    packers[61] = new Packer61();
    packers[62] = new Packer62();
    packers[63] = new Packer63();
    packers[64] = new Packer64();
  }

  public static final BytePackerForLongFactory factory = new BytePackerForLongFactory() {
    public BytePackerForLong newBytePackerForLong(int bitWidth) {
      return packers[bitWidth];
    }
  };

  private static final class Packer0 extends BytePackerForLong {

    private Packer0() {
      super(0);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
    }
  }

  private static final class Packer1 extends BytePackerForLong {

    private Packer1() {
      super(1);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [_______0]
          //                  [0]
           ((in[ 0 + inPos] & 1L))
        | //           [______1_]
          //                 [0]
           ((in[ 1 + inPos] & 1L) <<  1)
        | //           [_____2__]
          //                [0]
           ((in[ 2 + inPos] & 1L) <<  2)
        | //           [____3___]
          //               [0]
           ((in[ 3 + inPos] & 1L) <<  3)
        | //           [___4____]
          //              [0]
           ((in[ 4 + inPos] & 1L) <<  4)
        | //           [__5_____]
          //             [0]
           ((in[ 5 + inPos] & 1L) <<  5)
        | //           [_6______]
          //            [0]
           ((in[ 6 + inPos] & 1L) <<  6)
        | //           [7_______]
          //           [0]
           ((in[ 7 + inPos] & 1L) <<  7)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [_______0]
          //                  [0]
           ((in[ 0 + inPos] & 1L))
        | //           [______1_]
          //                 [0]
           ((in[ 1 + inPos] & 1L) <<  1)
        | //           [_____2__]
          //                [0]
           ((in[ 2 + inPos] & 1L) <<  2)
        | //           [____3___]
          //               [0]
           ((in[ 3 + inPos] & 1L) <<  3)
        | //           [___4____]
          //              [0]
           ((in[ 4 + inPos] & 1L) <<  4)
        | //           [__5_____]
          //             [0]
           ((in[ 5 + inPos] & 1L) <<  5)
        | //           [_6______]
          //            [0]
           ((in[ 6 + inPos] & 1L) <<  6)
        | //           [7_______]
          //           [0]
           ((in[ 7 + inPos] & 1L) <<  7)) & 255);
      out[ 1 + outPos] = (byte)((
          //           [_______0]
          //                  [0]
           ((in[ 8 + inPos] & 1L))
        | //           [______1_]
          //                 [0]
           ((in[ 9 + inPos] & 1L) <<  1)
        | //           [_____2__]
          //                [0]
           ((in[10 + inPos] & 1L) <<  2)
        | //           [____3___]
          //               [0]
           ((in[11 + inPos] & 1L) <<  3)
        | //           [___4____]
          //              [0]
           ((in[12 + inPos] & 1L) <<  4)
        | //           [__5_____]
          //             [0]
           ((in[13 + inPos] & 1L) <<  5)
        | //           [_6______]
          //            [0]
           ((in[14 + inPos] & 1L) <<  6)
        | //           [7_______]
          //           [0]
           ((in[15 + inPos] & 1L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //           [_______0]
          //                  [0]
           ((in[16 + inPos] & 1L))
        | //           [______1_]
          //                 [0]
           ((in[17 + inPos] & 1L) <<  1)
        | //           [_____2__]
          //                [0]
           ((in[18 + inPos] & 1L) <<  2)
        | //           [____3___]
          //               [0]
           ((in[19 + inPos] & 1L) <<  3)
        | //           [___4____]
          //              [0]
           ((in[20 + inPos] & 1L) <<  4)
        | //           [__5_____]
          //             [0]
           ((in[21 + inPos] & 1L) <<  5)
        | //           [_6______]
          //            [0]
           ((in[22 + inPos] & 1L) <<  6)
        | //           [7_______]
          //           [0]
           ((in[23 + inPos] & 1L) <<  7)) & 255);
      out[ 3 + outPos] = (byte)((
          //           [_______0]
          //                  [0]
           ((in[24 + inPos] & 1L))
        | //           [______1_]
          //                 [0]
           ((in[25 + inPos] & 1L) <<  1)
        | //           [_____2__]
          //                [0]
           ((in[26 + inPos] & 1L) <<  2)
        | //           [____3___]
          //               [0]
           ((in[27 + inPos] & 1L) <<  3)
        | //           [___4____]
          //              [0]
           ((in[28 + inPos] & 1L) <<  4)
        | //           [__5_____]
          //             [0]
           ((in[29 + inPos] & 1L) <<  5)
        | //           [_6______]
          //            [0]
           ((in[30 + inPos] & 1L) <<  6)
        | //           [7_______]
          //           [0]
           ((in[31 + inPos] & 1L) <<  7)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 0 + inPos]) ) & 1L);
      out[ 1 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 0 + inPos]) >>  1) & 1L);
      out[ 2 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 0 + inPos]) >>  2) & 1L);
      out[ 3 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 0 + inPos]) >>  3) & 1L);
      out[ 4 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 0 + inPos]) >>  4) & 1L);
      out[ 5 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 0 + inPos]) >>  5) & 1L);
      out[ 6 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 0 + inPos]) >>  6) & 1L);
      out[ 7 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 0 + inPos)) ) & 1L);
      out[ 1 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 0 + inPos)) >>  1) & 1L);
      out[ 2 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 0 + inPos)) >>  2) & 1L);
      out[ 3 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 0 + inPos)) >>  3) & 1L);
      out[ 4 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 0 + inPos)) >>  4) & 1L);
      out[ 5 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 0 + inPos)) >>  5) & 1L);
      out[ 6 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 0 + inPos)) >>  6) & 1L);
      out[ 7 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 0 + inPos]) ) & 1L);
      out[ 1 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 0 + inPos]) >>  1) & 1L);
      out[ 2 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 0 + inPos]) >>  2) & 1L);
      out[ 3 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 0 + inPos]) >>  3) & 1L);
      out[ 4 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 0 + inPos]) >>  4) & 1L);
      out[ 5 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 0 + inPos]) >>  5) & 1L);
      out[ 6 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 0 + inPos]) >>  6) & 1L);
      out[ 7 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L);
      out[ 8 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 1 + inPos]) ) & 1L);
      out[ 9 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 1 + inPos]) >>  1) & 1L);
      out[10 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 1 + inPos]) >>  2) & 1L);
      out[11 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 1 + inPos]) >>  3) & 1L);
      out[12 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 1 + inPos]) >>  4) & 1L);
      out[13 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 1 + inPos]) >>  5) & 1L);
      out[14 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 1 + inPos]) >>  6) & 1L);
      out[15 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[16 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 2 + inPos]) ) & 1L);
      out[17 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 2 + inPos]) >>  1) & 1L);
      out[18 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 2 + inPos]) >>  2) & 1L);
      out[19 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 2 + inPos]) >>  3) & 1L);
      out[20 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 2 + inPos]) >>  4) & 1L);
      out[21 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 2 + inPos]) >>  5) & 1L);
      out[22 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 2 + inPos]) >>  6) & 1L);
      out[23 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L);
      out[24 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 3 + inPos]) ) & 1L);
      out[25 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 3 + inPos]) >>  1) & 1L);
      out[26 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 3 + inPos]) >>  2) & 1L);
      out[27 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 3 + inPos]) >>  3) & 1L);
      out[28 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 3 + inPos]) >>  4) & 1L);
      out[29 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 3 + inPos]) >>  5) & 1L);
      out[30 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 3 + inPos]) >>  6) & 1L);
      out[31 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 3 + inPos]) >>  7) & 1L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 0 + inPos)) ) & 1L);
      out[ 1 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 0 + inPos)) >>  1) & 1L);
      out[ 2 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 0 + inPos)) >>  2) & 1L);
      out[ 3 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 0 + inPos)) >>  3) & 1L);
      out[ 4 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 0 + inPos)) >>  4) & 1L);
      out[ 5 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 0 + inPos)) >>  5) & 1L);
      out[ 6 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 0 + inPos)) >>  6) & 1L);
      out[ 7 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L);
      out[ 8 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 1 + inPos)) ) & 1L);
      out[ 9 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 1 + inPos)) >>  1) & 1L);
      out[10 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 1 + inPos)) >>  2) & 1L);
      out[11 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 1 + inPos)) >>  3) & 1L);
      out[12 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 1 + inPos)) >>  4) & 1L);
      out[13 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 1 + inPos)) >>  5) & 1L);
      out[14 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 1 + inPos)) >>  6) & 1L);
      out[15 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[16 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 2 + inPos)) ) & 1L);
      out[17 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 2 + inPos)) >>  1) & 1L);
      out[18 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 2 + inPos)) >>  2) & 1L);
      out[19 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 2 + inPos)) >>  3) & 1L);
      out[20 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 2 + inPos)) >>  4) & 1L);
      out[21 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 2 + inPos)) >>  5) & 1L);
      out[22 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 2 + inPos)) >>  6) & 1L);
      out[23 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 2 + inPos)) >>  7) & 1L);
      out[24 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 3 + inPos)) ) & 1L);
      out[25 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 3 + inPos)) >>  1) & 1L);
      out[26 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 3 + inPos)) >>  2) & 1L);
      out[27 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 3 + inPos)) >>  3) & 1L);
      out[28 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 3 + inPos)) >>  4) & 1L);
      out[29 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 3 + inPos)) >>  5) & 1L);
      out[30 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 3 + inPos)) >>  6) & 1L);
      out[31 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 3 + inPos)) >>  7) & 1L);
    }
  }

  private static final class Packer2 extends BytePackerForLong {

    private Packer2() {
      super(2);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[ 0 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[ 1 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[ 2 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[ 3 + inPos] & 3L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[ 4 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[ 5 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[ 6 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[ 7 + inPos] & 3L) <<  6)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[ 0 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[ 1 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[ 2 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[ 3 + inPos] & 3L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[ 4 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[ 5 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[ 6 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[ 7 + inPos] & 3L) <<  6)) & 255);
      out[ 2 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[ 8 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[ 9 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[10 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[11 + inPos] & 3L) <<  6)) & 255);
      out[ 3 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[12 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[13 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[14 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[15 + inPos] & 3L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[16 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[17 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[18 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[19 + inPos] & 3L) <<  6)) & 255);
      out[ 5 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[20 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[21 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[22 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[23 + inPos] & 3L) <<  6)) & 255);
      out[ 6 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[24 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[25 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[26 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[27 + inPos] & 3L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //            [______10]
          //                  [10]
           ((in[28 + inPos] & 3L))
        | //            [____32__]
          //                [10]
           ((in[29 + inPos] & 3L) <<  2)
        | //            [__54____]
          //              [10]
           ((in[30 + inPos] & 3L) <<  4)
        | //            [76______]
          //            [10]
           ((in[31 + inPos] & 3L) <<  6)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 0 + inPos]) ) & 3L);
      out[ 1 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 0 + inPos]) >>  2) & 3L);
      out[ 2 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 0 + inPos]) >>  4) & 3L);
      out[ 3 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L);
      out[ 4 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 1 + inPos]) ) & 3L);
      out[ 5 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 1 + inPos]) >>  2) & 3L);
      out[ 6 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 1 + inPos]) >>  4) & 3L);
      out[ 7 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 0 + inPos)) ) & 3L);
      out[ 1 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 0 + inPos)) >>  2) & 3L);
      out[ 2 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 0 + inPos)) >>  4) & 3L);
      out[ 3 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L);
      out[ 4 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 1 + inPos)) ) & 3L);
      out[ 5 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 1 + inPos)) >>  2) & 3L);
      out[ 6 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 1 + inPos)) >>  4) & 3L);
      out[ 7 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 0 + inPos]) ) & 3L);
      out[ 1 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 0 + inPos]) >>  2) & 3L);
      out[ 2 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 0 + inPos]) >>  4) & 3L);
      out[ 3 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L);
      out[ 4 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 1 + inPos]) ) & 3L);
      out[ 5 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 1 + inPos]) >>  2) & 3L);
      out[ 6 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 1 + inPos]) >>  4) & 3L);
      out[ 7 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 8 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 2 + inPos]) ) & 3L);
      out[ 9 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 2 + inPos]) >>  2) & 3L);
      out[10 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 2 + inPos]) >>  4) & 3L);
      out[11 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[12 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 3 + inPos]) ) & 3L);
      out[13 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 3 + inPos]) >>  2) & 3L);
      out[14 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 3 + inPos]) >>  4) & 3L);
      out[15 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L);
      out[16 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 4 + inPos]) ) & 3L);
      out[17 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 4 + inPos]) >>  2) & 3L);
      out[18 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 4 + inPos]) >>  4) & 3L);
      out[19 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L);
      out[20 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 5 + inPos]) ) & 3L);
      out[21 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 5 + inPos]) >>  2) & 3L);
      out[22 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 5 + inPos]) >>  4) & 3L);
      out[23 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[24 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 6 + inPos]) ) & 3L);
      out[25 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 6 + inPos]) >>  2) & 3L);
      out[26 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 6 + inPos]) >>  4) & 3L);
      out[27 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L);
      out[28 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 7 + inPos]) ) & 3L);
      out[29 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 7 + inPos]) >>  2) & 3L);
      out[30 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 7 + inPos]) >>  4) & 3L);
      out[31 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 7 + inPos]) >>  6) & 3L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 0 + inPos)) ) & 3L);
      out[ 1 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 0 + inPos)) >>  2) & 3L);
      out[ 2 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 0 + inPos)) >>  4) & 3L);
      out[ 3 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L);
      out[ 4 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 1 + inPos)) ) & 3L);
      out[ 5 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 1 + inPos)) >>  2) & 3L);
      out[ 6 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 1 + inPos)) >>  4) & 3L);
      out[ 7 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 8 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 2 + inPos)) ) & 3L);
      out[ 9 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 2 + inPos)) >>  2) & 3L);
      out[10 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 2 + inPos)) >>  4) & 3L);
      out[11 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[12 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 3 + inPos)) ) & 3L);
      out[13 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 3 + inPos)) >>  2) & 3L);
      out[14 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 3 + inPos)) >>  4) & 3L);
      out[15 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L);
      out[16 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 4 + inPos)) ) & 3L);
      out[17 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 4 + inPos)) >>  2) & 3L);
      out[18 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 4 + inPos)) >>  4) & 3L);
      out[19 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L);
      out[20 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 5 + inPos)) ) & 3L);
      out[21 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 5 + inPos)) >>  2) & 3L);
      out[22 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 5 + inPos)) >>  4) & 3L);
      out[23 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[24 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 6 + inPos)) ) & 3L);
      out[25 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 6 + inPos)) >>  2) & 3L);
      out[26 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 6 + inPos)) >>  4) & 3L);
      out[27 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L);
      out[28 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 7 + inPos)) ) & 3L);
      out[29 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 7 + inPos)) >>  2) & 3L);
      out[30 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 7 + inPos)) >>  4) & 3L);
      out[31 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 7 + inPos)) >>  6) & 3L);
    }
  }

  private static final class Packer3 extends BytePackerForLong {

    private Packer3() {
      super(3);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [_____210]
          //                  [210]
           ((in[ 0 + inPos] & 7L))
        | //             [__543___]
          //               [210]
           ((in[ 1 + inPos] & 7L) <<  3)
        | //             [76______]
          //            [_10]
           ((in[ 2 + inPos] & 7L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [_______0]
          //                    [2__]
           ((in[ 2 + inPos] & 7L) >>> 2)
        | //             [____321_]
          //                 [210]
           ((in[ 3 + inPos] & 7L) <<  1)
        | //             [_654____]
          //              [210]
           ((in[ 4 + inPos] & 7L) <<  4)
        | //             [7_______]
          //           [__0]
           ((in[ 5 + inPos] & 7L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [______10]
          //                   [21_]
           ((in[ 5 + inPos] & 7L) >>> 1)
        | //             [___432__]
          //                [210]
           ((in[ 6 + inPos] & 7L) <<  2)
        | //             [765_____]
          //             [210]
           ((in[ 7 + inPos] & 7L) <<  5)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [_____210]
          //                  [210]
           ((in[ 0 + inPos] & 7L))
        | //             [__543___]
          //               [210]
           ((in[ 1 + inPos] & 7L) <<  3)
        | //             [76______]
          //            [_10]
           ((in[ 2 + inPos] & 7L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [_______0]
          //                    [2__]
           ((in[ 2 + inPos] & 7L) >>> 2)
        | //             [____321_]
          //                 [210]
           ((in[ 3 + inPos] & 7L) <<  1)
        | //             [_654____]
          //              [210]
           ((in[ 4 + inPos] & 7L) <<  4)
        | //             [7_______]
          //           [__0]
           ((in[ 5 + inPos] & 7L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [______10]
          //                   [21_]
           ((in[ 5 + inPos] & 7L) >>> 1)
        | //             [___432__]
          //                [210]
           ((in[ 6 + inPos] & 7L) <<  2)
        | //             [765_____]
          //             [210]
           ((in[ 7 + inPos] & 7L) <<  5)) & 255);
      out[ 3 + outPos] = (byte)((
          //             [_____210]
          //                  [210]
           ((in[ 8 + inPos] & 7L))
        | //             [__543___]
          //               [210]
           ((in[ 9 + inPos] & 7L) <<  3)
        | //             [76______]
          //            [_10]
           ((in[10 + inPos] & 7L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //             [_______0]
          //                    [2__]
           ((in[10 + inPos] & 7L) >>> 2)
        | //             [____321_]
          //                 [210]
           ((in[11 + inPos] & 7L) <<  1)
        | //             [_654____]
          //              [210]
           ((in[12 + inPos] & 7L) <<  4)
        | //             [7_______]
          //           [__0]
           ((in[13 + inPos] & 7L) <<  7)) & 255);
      out[ 5 + outPos] = (byte)((
          //             [______10]
          //                   [21_]
           ((in[13 + inPos] & 7L) >>> 1)
        | //             [___432__]
          //                [210]
           ((in[14 + inPos] & 7L) <<  2)
        | //             [765_____]
          //             [210]
           ((in[15 + inPos] & 7L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //             [_____210]
          //                  [210]
           ((in[16 + inPos] & 7L))
        | //             [__543___]
          //               [210]
           ((in[17 + inPos] & 7L) <<  3)
        | //             [76______]
          //            [_10]
           ((in[18 + inPos] & 7L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //             [_______0]
          //                    [2__]
           ((in[18 + inPos] & 7L) >>> 2)
        | //             [____321_]
          //                 [210]
           ((in[19 + inPos] & 7L) <<  1)
        | //             [_654____]
          //              [210]
           ((in[20 + inPos] & 7L) <<  4)
        | //             [7_______]
          //           [__0]
           ((in[21 + inPos] & 7L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //             [______10]
          //                   [21_]
           ((in[21 + inPos] & 7L) >>> 1)
        | //             [___432__]
          //                [210]
           ((in[22 + inPos] & 7L) <<  2)
        | //             [765_____]
          //             [210]
           ((in[23 + inPos] & 7L) <<  5)) & 255);
      out[ 9 + outPos] = (byte)((
          //             [_____210]
          //                  [210]
           ((in[24 + inPos] & 7L))
        | //             [__543___]
          //               [210]
           ((in[25 + inPos] & 7L) <<  3)
        | //             [76______]
          //            [_10]
           ((in[26 + inPos] & 7L) <<  6)) & 255);
      out[10 + outPos] = (byte)((
          //             [_______0]
          //                    [2__]
           ((in[26 + inPos] & 7L) >>> 2)
        | //             [____321_]
          //                 [210]
           ((in[27 + inPos] & 7L) <<  1)
        | //             [_654____]
          //              [210]
           ((in[28 + inPos] & 7L) <<  4)
        | //             [7_______]
          //           [__0]
           ((in[29 + inPos] & 7L) <<  7)) & 255);
      out[11 + outPos] = (byte)((
          //             [______10]
          //                   [21_]
           ((in[29 + inPos] & 7L) >>> 1)
        | //             [___432__]
          //                [210]
           ((in[30 + inPos] & 7L) <<  2)
        | //             [765_____]
          //             [210]
           ((in[31 + inPos] & 7L) <<  5)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 0 + inPos]) ) & 7L);
      out[ 1 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 0 + inPos]) >>  3) & 7L);
      out[ 2 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in[ 1 + inPos]) <<  2) & 7L);
      out[ 3 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 1 + inPos]) >>  1) & 7L);
      out[ 4 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 1 + inPos]) >>  4) & 7L);
      out[ 5 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in[ 2 + inPos]) <<  1) & 7L);
      out[ 6 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 2 + inPos]) >>  2) & 7L);
      out[ 7 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 0 + inPos)) ) & 7L);
      out[ 1 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 0 + inPos)) >>  3) & 7L);
      out[ 2 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in.get( 1 + inPos)) <<  2) & 7L);
      out[ 3 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 1 + inPos)) >>  1) & 7L);
      out[ 4 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 1 + inPos)) >>  4) & 7L);
      out[ 5 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in.get( 2 + inPos)) <<  1) & 7L);
      out[ 6 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 2 + inPos)) >>  2) & 7L);
      out[ 7 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 0 + inPos]) ) & 7L);
      out[ 1 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 0 + inPos]) >>  3) & 7L);
      out[ 2 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in[ 1 + inPos]) <<  2) & 7L);
      out[ 3 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 1 + inPos]) >>  1) & 7L);
      out[ 4 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 1 + inPos]) >>  4) & 7L);
      out[ 5 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in[ 2 + inPos]) <<  1) & 7L);
      out[ 6 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 2 + inPos]) >>  2) & 7L);
      out[ 7 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L);
      out[ 8 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 3 + inPos]) ) & 7L);
      out[ 9 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 3 + inPos]) >>  3) & 7L);
      out[10 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in[ 4 + inPos]) <<  2) & 7L);
      out[11 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 4 + inPos]) >>  1) & 7L);
      out[12 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 4 + inPos]) >>  4) & 7L);
      out[13 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in[ 5 + inPos]) <<  1) & 7L);
      out[14 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 5 + inPos]) >>  2) & 7L);
      out[15 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L);
      out[16 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 6 + inPos]) ) & 7L);
      out[17 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 6 + inPos]) >>  3) & 7L);
      out[18 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in[ 7 + inPos]) <<  2) & 7L);
      out[19 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 7 + inPos]) >>  1) & 7L);
      out[20 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 7 + inPos]) >>  4) & 7L);
      out[21 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in[ 8 + inPos]) <<  1) & 7L);
      out[22 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 8 + inPos]) >>  2) & 7L);
      out[23 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 8 + inPos]) >>  5) & 7L);
      out[24 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 9 + inPos]) ) & 7L);
      out[25 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 9 + inPos]) >>  3) & 7L);
      out[26 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in[ 9 + inPos]) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in[10 + inPos]) <<  2) & 7L);
      out[27 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[10 + inPos]) >>  1) & 7L);
      out[28 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[10 + inPos]) >>  4) & 7L);
      out[29 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in[10 + inPos]) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in[11 + inPos]) <<  1) & 7L);
      out[30 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[11 + inPos]) >>  2) & 7L);
      out[31 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[11 + inPos]) >>  5) & 7L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 0 + inPos)) ) & 7L);
      out[ 1 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 0 + inPos)) >>  3) & 7L);
      out[ 2 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in.get( 1 + inPos)) <<  2) & 7L);
      out[ 3 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 1 + inPos)) >>  1) & 7L);
      out[ 4 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 1 + inPos)) >>  4) & 7L);
      out[ 5 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in.get( 2 + inPos)) <<  1) & 7L);
      out[ 6 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 2 + inPos)) >>  2) & 7L);
      out[ 7 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L);
      out[ 8 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 3 + inPos)) ) & 7L);
      out[ 9 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 3 + inPos)) >>  3) & 7L);
      out[10 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in.get( 4 + inPos)) <<  2) & 7L);
      out[11 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 4 + inPos)) >>  1) & 7L);
      out[12 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 4 + inPos)) >>  4) & 7L);
      out[13 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in.get( 5 + inPos)) <<  1) & 7L);
      out[14 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 5 + inPos)) >>  2) & 7L);
      out[15 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L);
      out[16 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 6 + inPos)) ) & 7L);
      out[17 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 6 + inPos)) >>  3) & 7L);
      out[18 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in.get( 7 + inPos)) <<  2) & 7L);
      out[19 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 7 + inPos)) >>  1) & 7L);
      out[20 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 7 + inPos)) >>  4) & 7L);
      out[21 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in.get( 8 + inPos)) <<  1) & 7L);
      out[22 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 8 + inPos)) >>  2) & 7L);
      out[23 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 8 + inPos)) >>  5) & 7L);
      out[24 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 9 + inPos)) ) & 7L);
      out[25 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 9 + inPos)) >>  3) & 7L);
      out[26 + outPos] =
          //             [76______]
          //            [_10]
            ((((long)in.get( 9 + inPos)) >>  6) & 3L)
        | //             [_______0]
          //                    [2__]
            ((((long)in.get(10 + inPos)) <<  2) & 7L);
      out[27 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get(10 + inPos)) >>  1) & 7L);
      out[28 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get(10 + inPos)) >>  4) & 7L);
      out[29 + outPos] =
          //             [7_______]
          //           [__0]
            ((((long)in.get(10 + inPos)) >>  7) & 1L)
        | //             [______10]
          //                   [21_]
            ((((long)in.get(11 + inPos)) <<  1) & 7L);
      out[30 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get(11 + inPos)) >>  2) & 7L);
      out[31 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get(11 + inPos)) >>  5) & 7L);
    }
  }

  private static final class Packer4 extends BytePackerForLong {

    private Packer4() {
      super(4);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 0 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 1 + inPos] & 15L) <<  4)) & 255);
      out[ 1 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 2 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 3 + inPos] & 15L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 4 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 5 + inPos] & 15L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 6 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 7 + inPos] & 15L) <<  4)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 0 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 1 + inPos] & 15L) <<  4)) & 255);
      out[ 1 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 2 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 3 + inPos] & 15L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 4 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 5 + inPos] & 15L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 6 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 7 + inPos] & 15L) <<  4)) & 255);
      out[ 4 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[ 8 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[ 9 + inPos] & 15L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[10 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[11 + inPos] & 15L) <<  4)) & 255);
      out[ 6 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[12 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[13 + inPos] & 15L) <<  4)) & 255);
      out[ 7 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[14 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[15 + inPos] & 15L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[16 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[17 + inPos] & 15L) <<  4)) & 255);
      out[ 9 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[18 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[19 + inPos] & 15L) <<  4)) & 255);
      out[10 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[20 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[21 + inPos] & 15L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[22 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[23 + inPos] & 15L) <<  4)) & 255);
      out[12 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[24 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[25 + inPos] & 15L) <<  4)) & 255);
      out[13 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[26 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[27 + inPos] & 15L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[28 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[29 + inPos] & 15L) <<  4)) & 255);
      out[15 + outPos] = (byte)((
          //              [____3210]
          //                  [3210]
           ((in[30 + inPos] & 15L))
        | //              [7654____]
          //              [3210]
           ((in[31 + inPos] & 15L) <<  4)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 0 + inPos]) ) & 15L);
      out[ 1 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 0 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 1 + inPos]) ) & 15L);
      out[ 3 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 2 + inPos]) ) & 15L);
      out[ 5 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 3 + inPos]) ) & 15L);
      out[ 7 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 0 + inPos)) ) & 15L);
      out[ 1 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 0 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 1 + inPos)) ) & 15L);
      out[ 3 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 2 + inPos)) ) & 15L);
      out[ 5 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 3 + inPos)) ) & 15L);
      out[ 7 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 0 + inPos]) ) & 15L);
      out[ 1 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 0 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 1 + inPos]) ) & 15L);
      out[ 3 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 2 + inPos]) ) & 15L);
      out[ 5 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 3 + inPos]) ) & 15L);
      out[ 7 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 8 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 4 + inPos]) ) & 15L);
      out[ 9 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 5 + inPos]) ) & 15L);
      out[11 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 6 + inPos]) ) & 15L);
      out[13 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 7 + inPos]) ) & 15L);
      out[15 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[16 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 8 + inPos]) ) & 15L);
      out[17 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 9 + inPos]) ) & 15L);
      out[19 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[10 + inPos]) ) & 15L);
      out[21 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[11 + inPos]) ) & 15L);
      out[23 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[11 + inPos]) >>  4) & 15L);
      out[24 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[12 + inPos]) ) & 15L);
      out[25 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[13 + inPos]) ) & 15L);
      out[27 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[14 + inPos]) ) & 15L);
      out[29 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[14 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[15 + inPos]) ) & 15L);
      out[31 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[15 + inPos]) >>  4) & 15L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 0 + inPos)) ) & 15L);
      out[ 1 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 0 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 1 + inPos)) ) & 15L);
      out[ 3 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 2 + inPos)) ) & 15L);
      out[ 5 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 3 + inPos)) ) & 15L);
      out[ 7 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 8 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 4 + inPos)) ) & 15L);
      out[ 9 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 5 + inPos)) ) & 15L);
      out[11 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 6 + inPos)) ) & 15L);
      out[13 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 7 + inPos)) ) & 15L);
      out[15 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[16 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 8 + inPos)) ) & 15L);
      out[17 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 9 + inPos)) ) & 15L);
      out[19 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(10 + inPos)) ) & 15L);
      out[21 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(11 + inPos)) ) & 15L);
      out[23 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(11 + inPos)) >>  4) & 15L);
      out[24 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(12 + inPos)) ) & 15L);
      out[25 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(13 + inPos)) ) & 15L);
      out[27 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(14 + inPos)) ) & 15L);
      out[29 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(14 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(15 + inPos)) ) & 15L);
      out[31 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(15 + inPos)) >>  4) & 15L);
    }
  }

  private static final class Packer5 extends BytePackerForLong {

    private Packer5() {
      super(5);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [___43210]
          //                  [43210]
           ((in[ 0 + inPos] & 31L))
        | //               [765_____]
          //             [__210]
           ((in[ 1 + inPos] & 31L) <<  5)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [______10]
          //                     [43___]
           ((in[ 1 + inPos] & 31L) >>> 3)
        | //               [_65432__]
          //                [43210]
           ((in[ 2 + inPos] & 31L) <<  2)
        | //               [7_______]
          //           [____0]
           ((in[ 3 + inPos] & 31L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [____3210]
          //                   [4321_]
           ((in[ 3 + inPos] & 31L) >>> 1)
        | //               [7654____]
          //              [_3210]
           ((in[ 4 + inPos] & 31L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [_______0]
          //                      [4____]
           ((in[ 4 + inPos] & 31L) >>> 4)
        | //               [__54321_]
          //                 [43210]
           ((in[ 5 + inPos] & 31L) <<  1)
        | //               [76______]
          //            [___10]
           ((in[ 6 + inPos] & 31L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [_____210]
          //                    [432__]
           ((in[ 6 + inPos] & 31L) >>> 2)
        | //               [76543___]
          //               [43210]
           ((in[ 7 + inPos] & 31L) <<  3)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [___43210]
          //                  [43210]
           ((in[ 0 + inPos] & 31L))
        | //               [765_____]
          //             [__210]
           ((in[ 1 + inPos] & 31L) <<  5)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [______10]
          //                     [43___]
           ((in[ 1 + inPos] & 31L) >>> 3)
        | //               [_65432__]
          //                [43210]
           ((in[ 2 + inPos] & 31L) <<  2)
        | //               [7_______]
          //           [____0]
           ((in[ 3 + inPos] & 31L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [____3210]
          //                   [4321_]
           ((in[ 3 + inPos] & 31L) >>> 1)
        | //               [7654____]
          //              [_3210]
           ((in[ 4 + inPos] & 31L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [_______0]
          //                      [4____]
           ((in[ 4 + inPos] & 31L) >>> 4)
        | //               [__54321_]
          //                 [43210]
           ((in[ 5 + inPos] & 31L) <<  1)
        | //               [76______]
          //            [___10]
           ((in[ 6 + inPos] & 31L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [_____210]
          //                    [432__]
           ((in[ 6 + inPos] & 31L) >>> 2)
        | //               [76543___]
          //               [43210]
           ((in[ 7 + inPos] & 31L) <<  3)) & 255);
      out[ 5 + outPos] = (byte)((
          //               [___43210]
          //                  [43210]
           ((in[ 8 + inPos] & 31L))
        | //               [765_____]
          //             [__210]
           ((in[ 9 + inPos] & 31L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //               [______10]
          //                     [43___]
           ((in[ 9 + inPos] & 31L) >>> 3)
        | //               [_65432__]
          //                [43210]
           ((in[10 + inPos] & 31L) <<  2)
        | //               [7_______]
          //           [____0]
           ((in[11 + inPos] & 31L) <<  7)) & 255);
      out[ 7 + outPos] = (byte)((
          //               [____3210]
          //                   [4321_]
           ((in[11 + inPos] & 31L) >>> 1)
        | //               [7654____]
          //              [_3210]
           ((in[12 + inPos] & 31L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //               [_______0]
          //                      [4____]
           ((in[12 + inPos] & 31L) >>> 4)
        | //               [__54321_]
          //                 [43210]
           ((in[13 + inPos] & 31L) <<  1)
        | //               [76______]
          //            [___10]
           ((in[14 + inPos] & 31L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //               [_____210]
          //                    [432__]
           ((in[14 + inPos] & 31L) >>> 2)
        | //               [76543___]
          //               [43210]
           ((in[15 + inPos] & 31L) <<  3)) & 255);
      out[10 + outPos] = (byte)((
          //               [___43210]
          //                  [43210]
           ((in[16 + inPos] & 31L))
        | //               [765_____]
          //             [__210]
           ((in[17 + inPos] & 31L) <<  5)) & 255);
      out[11 + outPos] = (byte)((
          //               [______10]
          //                     [43___]
           ((in[17 + inPos] & 31L) >>> 3)
        | //               [_65432__]
          //                [43210]
           ((in[18 + inPos] & 31L) <<  2)
        | //               [7_______]
          //           [____0]
           ((in[19 + inPos] & 31L) <<  7)) & 255);
      out[12 + outPos] = (byte)((
          //               [____3210]
          //                   [4321_]
           ((in[19 + inPos] & 31L) >>> 1)
        | //               [7654____]
          //              [_3210]
           ((in[20 + inPos] & 31L) <<  4)) & 255);
      out[13 + outPos] = (byte)((
          //               [_______0]
          //                      [4____]
           ((in[20 + inPos] & 31L) >>> 4)
        | //               [__54321_]
          //                 [43210]
           ((in[21 + inPos] & 31L) <<  1)
        | //               [76______]
          //            [___10]
           ((in[22 + inPos] & 31L) <<  6)) & 255);
      out[14 + outPos] = (byte)((
          //               [_____210]
          //                    [432__]
           ((in[22 + inPos] & 31L) >>> 2)
        | //               [76543___]
          //               [43210]
           ((in[23 + inPos] & 31L) <<  3)) & 255);
      out[15 + outPos] = (byte)((
          //               [___43210]
          //                  [43210]
           ((in[24 + inPos] & 31L))
        | //               [765_____]
          //             [__210]
           ((in[25 + inPos] & 31L) <<  5)) & 255);
      out[16 + outPos] = (byte)((
          //               [______10]
          //                     [43___]
           ((in[25 + inPos] & 31L) >>> 3)
        | //               [_65432__]
          //                [43210]
           ((in[26 + inPos] & 31L) <<  2)
        | //               [7_______]
          //           [____0]
           ((in[27 + inPos] & 31L) <<  7)) & 255);
      out[17 + outPos] = (byte)((
          //               [____3210]
          //                   [4321_]
           ((in[27 + inPos] & 31L) >>> 1)
        | //               [7654____]
          //              [_3210]
           ((in[28 + inPos] & 31L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //               [_______0]
          //                      [4____]
           ((in[28 + inPos] & 31L) >>> 4)
        | //               [__54321_]
          //                 [43210]
           ((in[29 + inPos] & 31L) <<  1)
        | //               [76______]
          //            [___10]
           ((in[30 + inPos] & 31L) <<  6)) & 255);
      out[19 + outPos] = (byte)((
          //               [_____210]
          //                    [432__]
           ((in[30 + inPos] & 31L) >>> 2)
        | //               [76543___]
          //               [43210]
           ((in[31 + inPos] & 31L) <<  3)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 0 + inPos]) ) & 31L);
      out[ 1 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in[ 0 + inPos]) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in[ 1 + inPos]) <<  3) & 31L);
      out[ 2 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 1 + inPos]) >>  2) & 31L);
      out[ 3 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in[ 2 + inPos]) <<  1) & 31L);
      out[ 4 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in[ 3 + inPos]) <<  4) & 31L);
      out[ 5 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 3 + inPos]) >>  1) & 31L);
      out[ 6 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in[ 4 + inPos]) <<  2) & 31L);
      out[ 7 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 4 + inPos]) >>  3) & 31L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 0 + inPos)) ) & 31L);
      out[ 1 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in.get( 0 + inPos)) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in.get( 1 + inPos)) <<  3) & 31L);
      out[ 2 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 1 + inPos)) >>  2) & 31L);
      out[ 3 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 31L);
      out[ 4 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in.get( 3 + inPos)) <<  4) & 31L);
      out[ 5 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 3 + inPos)) >>  1) & 31L);
      out[ 6 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 31L);
      out[ 7 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 4 + inPos)) >>  3) & 31L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 0 + inPos]) ) & 31L);
      out[ 1 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in[ 0 + inPos]) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in[ 1 + inPos]) <<  3) & 31L);
      out[ 2 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 1 + inPos]) >>  2) & 31L);
      out[ 3 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in[ 2 + inPos]) <<  1) & 31L);
      out[ 4 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in[ 3 + inPos]) <<  4) & 31L);
      out[ 5 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 3 + inPos]) >>  1) & 31L);
      out[ 6 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in[ 4 + inPos]) <<  2) & 31L);
      out[ 7 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 4 + inPos]) >>  3) & 31L);
      out[ 8 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 5 + inPos]) ) & 31L);
      out[ 9 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in[ 6 + inPos]) <<  3) & 31L);
      out[10 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 6 + inPos]) >>  2) & 31L);
      out[11 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in[ 6 + inPos]) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in[ 7 + inPos]) <<  1) & 31L);
      out[12 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in[ 8 + inPos]) <<  4) & 31L);
      out[13 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 8 + inPos]) >>  1) & 31L);
      out[14 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in[ 9 + inPos]) <<  2) & 31L);
      out[15 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L);
      out[16 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[10 + inPos]) ) & 31L);
      out[17 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in[10 + inPos]) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in[11 + inPos]) <<  3) & 31L);
      out[18 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[11 + inPos]) >>  2) & 31L);
      out[19 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in[11 + inPos]) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in[12 + inPos]) <<  1) & 31L);
      out[20 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in[12 + inPos]) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in[13 + inPos]) <<  4) & 31L);
      out[21 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[13 + inPos]) >>  1) & 31L);
      out[22 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in[13 + inPos]) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in[14 + inPos]) <<  2) & 31L);
      out[23 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[14 + inPos]) >>  3) & 31L);
      out[24 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[15 + inPos]) ) & 31L);
      out[25 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in[15 + inPos]) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in[16 + inPos]) <<  3) & 31L);
      out[26 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[16 + inPos]) >>  2) & 31L);
      out[27 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in[16 + inPos]) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in[17 + inPos]) <<  1) & 31L);
      out[28 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in[18 + inPos]) <<  4) & 31L);
      out[29 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[18 + inPos]) >>  1) & 31L);
      out[30 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in[18 + inPos]) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in[19 + inPos]) <<  2) & 31L);
      out[31 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[19 + inPos]) >>  3) & 31L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 0 + inPos)) ) & 31L);
      out[ 1 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in.get( 0 + inPos)) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in.get( 1 + inPos)) <<  3) & 31L);
      out[ 2 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 1 + inPos)) >>  2) & 31L);
      out[ 3 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 31L);
      out[ 4 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in.get( 3 + inPos)) <<  4) & 31L);
      out[ 5 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 3 + inPos)) >>  1) & 31L);
      out[ 6 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 31L);
      out[ 7 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 4 + inPos)) >>  3) & 31L);
      out[ 8 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 5 + inPos)) ) & 31L);
      out[ 9 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in.get( 6 + inPos)) <<  3) & 31L);
      out[10 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 6 + inPos)) >>  2) & 31L);
      out[11 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in.get( 6 + inPos)) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 31L);
      out[12 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in.get( 8 + inPos)) <<  4) & 31L);
      out[13 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 8 + inPos)) >>  1) & 31L);
      out[14 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 31L);
      out[15 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L);
      out[16 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get(10 + inPos)) ) & 31L);
      out[17 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in.get(10 + inPos)) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in.get(11 + inPos)) <<  3) & 31L);
      out[18 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get(11 + inPos)) >>  2) & 31L);
      out[19 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in.get(11 + inPos)) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in.get(12 + inPos)) <<  1) & 31L);
      out[20 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in.get(13 + inPos)) <<  4) & 31L);
      out[21 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get(13 + inPos)) >>  1) & 31L);
      out[22 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in.get(13 + inPos)) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in.get(14 + inPos)) <<  2) & 31L);
      out[23 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get(14 + inPos)) >>  3) & 31L);
      out[24 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get(15 + inPos)) ) & 31L);
      out[25 + outPos] =
          //               [765_____]
          //             [__210]
            ((((long)in.get(15 + inPos)) >>  5) & 7L)
        | //               [______10]
          //                     [43___]
            ((((long)in.get(16 + inPos)) <<  3) & 31L);
      out[26 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get(16 + inPos)) >>  2) & 31L);
      out[27 + outPos] =
          //               [7_______]
          //           [____0]
            ((((long)in.get(16 + inPos)) >>  7) & 1L)
        | //               [____3210]
          //                   [4321_]
            ((((long)in.get(17 + inPos)) <<  1) & 31L);
      out[28 + outPos] =
          //               [7654____]
          //              [_3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //               [_______0]
          //                      [4____]
            ((((long)in.get(18 + inPos)) <<  4) & 31L);
      out[29 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get(18 + inPos)) >>  1) & 31L);
      out[30 + outPos] =
          //               [76______]
          //            [___10]
            ((((long)in.get(18 + inPos)) >>  6) & 3L)
        | //               [_____210]
          //                    [432__]
            ((((long)in.get(19 + inPos)) <<  2) & 31L);
      out[31 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get(19 + inPos)) >>  3) & 31L);
    }
  }

  private static final class Packer6 extends BytePackerForLong {

    private Packer6() {
      super(6);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[ 0 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[ 1 + inPos] & 63L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[ 1 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[ 2 + inPos] & 63L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[ 2 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[ 3 + inPos] & 63L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[ 4 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[ 5 + inPos] & 63L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[ 5 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[ 6 + inPos] & 63L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[ 6 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[ 7 + inPos] & 63L) <<  2)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[ 0 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[ 1 + inPos] & 63L) <<  6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[ 1 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[ 2 + inPos] & 63L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[ 2 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[ 3 + inPos] & 63L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[ 4 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[ 5 + inPos] & 63L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[ 5 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[ 6 + inPos] & 63L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[ 6 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[ 7 + inPos] & 63L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[ 8 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[ 9 + inPos] & 63L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[ 9 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[10 + inPos] & 63L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[10 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[11 + inPos] & 63L) <<  2)) & 255);
      out[ 9 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[12 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[13 + inPos] & 63L) <<  6)) & 255);
      out[10 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[13 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[14 + inPos] & 63L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[14 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[15 + inPos] & 63L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[16 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[17 + inPos] & 63L) <<  6)) & 255);
      out[13 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[17 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[18 + inPos] & 63L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[18 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[19 + inPos] & 63L) <<  2)) & 255);
      out[15 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[20 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[21 + inPos] & 63L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[21 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[22 + inPos] & 63L) <<  4)) & 255);
      out[17 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[22 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[23 + inPos] & 63L) <<  2)) & 255);
      out[18 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[24 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[25 + inPos] & 63L) <<  6)) & 255);
      out[19 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[25 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[26 + inPos] & 63L) <<  4)) & 255);
      out[20 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[26 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[27 + inPos] & 63L) <<  2)) & 255);
      out[21 + outPos] = (byte)((
          //                [__543210]
          //                  [543210]
           ((in[28 + inPos] & 63L))
        | //                [76______]
          //            [____10]
           ((in[29 + inPos] & 63L) <<  6)) & 255);
      out[22 + outPos] = (byte)((
          //                [____3210]
          //                    [5432__]
           ((in[29 + inPos] & 63L) >>> 2)
        | //                [7654____]
          //              [__3210]
           ((in[30 + inPos] & 63L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                [______10]
          //                      [54____]
           ((in[30 + inPos] & 63L) >>> 4)
        | //                [765432__]
          //                [543210]
           ((in[31 + inPos] & 63L) <<  2)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 0 + inPos]) ) & 63L);
      out[ 1 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[ 1 + inPos]) <<  2) & 63L);
      out[ 2 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[ 2 + inPos]) <<  4) & 63L);
      out[ 3 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 4 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 3 + inPos]) ) & 63L);
      out[ 5 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[ 4 + inPos]) <<  2) & 63L);
      out[ 6 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[ 5 + inPos]) <<  4) & 63L);
      out[ 7 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 0 + inPos)) ) & 63L);
      out[ 1 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 63L);
      out[ 2 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get( 2 + inPos)) <<  4) & 63L);
      out[ 3 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 4 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 3 + inPos)) ) & 63L);
      out[ 5 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 63L);
      out[ 6 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get( 5 + inPos)) <<  4) & 63L);
      out[ 7 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 0 + inPos]) ) & 63L);
      out[ 1 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[ 1 + inPos]) <<  2) & 63L);
      out[ 2 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[ 2 + inPos]) <<  4) & 63L);
      out[ 3 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 4 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 3 + inPos]) ) & 63L);
      out[ 5 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[ 4 + inPos]) <<  2) & 63L);
      out[ 6 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[ 5 + inPos]) <<  4) & 63L);
      out[ 7 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L);
      out[ 8 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 6 + inPos]) ) & 63L);
      out[ 9 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[ 7 + inPos]) <<  2) & 63L);
      out[10 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[ 8 + inPos]) <<  4) & 63L);
      out[11 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[12 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 9 + inPos]) ) & 63L);
      out[13 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[ 9 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[10 + inPos]) <<  2) & 63L);
      out[14 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[11 + inPos]) <<  4) & 63L);
      out[15 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[11 + inPos]) >>  2) & 63L);
      out[16 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[12 + inPos]) ) & 63L);
      out[17 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[12 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[13 + inPos]) <<  2) & 63L);
      out[18 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[13 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[14 + inPos]) <<  4) & 63L);
      out[19 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[14 + inPos]) >>  2) & 63L);
      out[20 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[15 + inPos]) ) & 63L);
      out[21 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[16 + inPos]) <<  2) & 63L);
      out[22 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[16 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[17 + inPos]) <<  4) & 63L);
      out[23 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[17 + inPos]) >>  2) & 63L);
      out[24 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[18 + inPos]) ) & 63L);
      out[25 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[18 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[19 + inPos]) <<  2) & 63L);
      out[26 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[19 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[20 + inPos]) <<  4) & 63L);
      out[27 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[20 + inPos]) >>  2) & 63L);
      out[28 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[21 + inPos]) ) & 63L);
      out[29 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in[21 + inPos]) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in[22 + inPos]) <<  2) & 63L);
      out[30 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in[23 + inPos]) <<  4) & 63L);
      out[31 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[23 + inPos]) >>  2) & 63L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 0 + inPos)) ) & 63L);
      out[ 1 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 63L);
      out[ 2 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get( 2 + inPos)) <<  4) & 63L);
      out[ 3 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 4 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 3 + inPos)) ) & 63L);
      out[ 5 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 63L);
      out[ 6 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get( 5 + inPos)) <<  4) & 63L);
      out[ 7 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L);
      out[ 8 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 6 + inPos)) ) & 63L);
      out[ 9 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 63L);
      out[10 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get( 8 + inPos)) <<  4) & 63L);
      out[11 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[12 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 9 + inPos)) ) & 63L);
      out[13 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get( 9 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get(10 + inPos)) <<  2) & 63L);
      out[14 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get(11 + inPos)) <<  4) & 63L);
      out[15 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L);
      out[16 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(12 + inPos)) ) & 63L);
      out[17 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get(13 + inPos)) <<  2) & 63L);
      out[18 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get(14 + inPos)) <<  4) & 63L);
      out[19 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(14 + inPos)) >>  2) & 63L);
      out[20 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(15 + inPos)) ) & 63L);
      out[21 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get(16 + inPos)) <<  2) & 63L);
      out[22 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get(17 + inPos)) <<  4) & 63L);
      out[23 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(17 + inPos)) >>  2) & 63L);
      out[24 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(18 + inPos)) ) & 63L);
      out[25 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get(18 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get(19 + inPos)) <<  2) & 63L);
      out[26 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get(20 + inPos)) <<  4) & 63L);
      out[27 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(20 + inPos)) >>  2) & 63L);
      out[28 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(21 + inPos)) ) & 63L);
      out[29 + outPos] =
          //                [76______]
          //            [____10]
            ((((long)in.get(21 + inPos)) >>  6) & 3L)
        | //                [____3210]
          //                    [5432__]
            ((((long)in.get(22 + inPos)) <<  2) & 63L);
      out[30 + outPos] =
          //                [7654____]
          //              [__3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                [______10]
          //                      [54____]
            ((((long)in.get(23 + inPos)) <<  4) & 63L);
      out[31 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(23 + inPos)) >>  2) & 63L);
    }
  }

  private static final class Packer7 extends BytePackerForLong {

    private Packer7() {
      super(7);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [_6543210]
          //                  [6543210]
           ((in[ 0 + inPos] & 127L))
        | //                 [7_______]
          //           [______0]
           ((in[ 1 + inPos] & 127L) <<  7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [__543210]
          //                   [654321_]
           ((in[ 1 + inPos] & 127L) >>> 1)
        | //                 [76______]
          //            [_____10]
           ((in[ 2 + inPos] & 127L) <<  6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [___43210]
          //                    [65432__]
           ((in[ 2 + inPos] & 127L) >>> 2)
        | //                 [765_____]
          //             [____210]
           ((in[ 3 + inPos] & 127L) <<  5)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [____3210]
          //                     [6543___]
           ((in[ 3 + inPos] & 127L) >>> 3)
        | //                 [7654____]
          //              [___3210]
           ((in[ 4 + inPos] & 127L) <<  4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [_____210]
          //                      [654____]
           ((in[ 4 + inPos] & 127L) >>> 4)
        | //                 [76543___]
          //               [__43210]
           ((in[ 5 + inPos] & 127L) <<  3)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [______10]
          //                       [65_____]
           ((in[ 5 + inPos] & 127L) >>> 5)
        | //                 [765432__]
          //                [_543210]
           ((in[ 6 + inPos] & 127L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [_______0]
          //                        [6______]
           ((in[ 6 + inPos] & 127L) >>> 6)
        | //                 [7654321_]
          //                 [6543210]
           ((in[ 7 + inPos] & 127L) <<  1)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [_6543210]
          //                  [6543210]
           ((in[ 0 + inPos] & 127L))
        | //                 [7_______]
          //           [______0]
           ((in[ 1 + inPos] & 127L) <<  7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [__543210]
          //                   [654321_]
           ((in[ 1 + inPos] & 127L) >>> 1)
        | //                 [76______]
          //            [_____10]
           ((in[ 2 + inPos] & 127L) <<  6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [___43210]
          //                    [65432__]
           ((in[ 2 + inPos] & 127L) >>> 2)
        | //                 [765_____]
          //             [____210]
           ((in[ 3 + inPos] & 127L) <<  5)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [____3210]
          //                     [6543___]
           ((in[ 3 + inPos] & 127L) >>> 3)
        | //                 [7654____]
          //              [___3210]
           ((in[ 4 + inPos] & 127L) <<  4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [_____210]
          //                      [654____]
           ((in[ 4 + inPos] & 127L) >>> 4)
        | //                 [76543___]
          //               [__43210]
           ((in[ 5 + inPos] & 127L) <<  3)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [______10]
          //                       [65_____]
           ((in[ 5 + inPos] & 127L) >>> 5)
        | //                 [765432__]
          //                [_543210]
           ((in[ 6 + inPos] & 127L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [_______0]
          //                        [6______]
           ((in[ 6 + inPos] & 127L) >>> 6)
        | //                 [7654321_]
          //                 [6543210]
           ((in[ 7 + inPos] & 127L) <<  1)) & 255);
      out[ 7 + outPos] = (byte)((
          //                 [_6543210]
          //                  [6543210]
           ((in[ 8 + inPos] & 127L))
        | //                 [7_______]
          //           [______0]
           ((in[ 9 + inPos] & 127L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //                 [__543210]
          //                   [654321_]
           ((in[ 9 + inPos] & 127L) >>> 1)
        | //                 [76______]
          //            [_____10]
           ((in[10 + inPos] & 127L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                 [___43210]
          //                    [65432__]
           ((in[10 + inPos] & 127L) >>> 2)
        | //                 [765_____]
          //             [____210]
           ((in[11 + inPos] & 127L) <<  5)) & 255);
      out[10 + outPos] = (byte)((
          //                 [____3210]
          //                     [6543___]
           ((in[11 + inPos] & 127L) >>> 3)
        | //                 [7654____]
          //              [___3210]
           ((in[12 + inPos] & 127L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                 [_____210]
          //                      [654____]
           ((in[12 + inPos] & 127L) >>> 4)
        | //                 [76543___]
          //               [__43210]
           ((in[13 + inPos] & 127L) <<  3)) & 255);
      out[12 + outPos] = (byte)((
          //                 [______10]
          //                       [65_____]
           ((in[13 + inPos] & 127L) >>> 5)
        | //                 [765432__]
          //                [_543210]
           ((in[14 + inPos] & 127L) <<  2)) & 255);
      out[13 + outPos] = (byte)((
          //                 [_______0]
          //                        [6______]
           ((in[14 + inPos] & 127L) >>> 6)
        | //                 [7654321_]
          //                 [6543210]
           ((in[15 + inPos] & 127L) <<  1)) & 255);
      out[14 + outPos] = (byte)((
          //                 [_6543210]
          //                  [6543210]
           ((in[16 + inPos] & 127L))
        | //                 [7_______]
          //           [______0]
           ((in[17 + inPos] & 127L) <<  7)) & 255);
      out[15 + outPos] = (byte)((
          //                 [__543210]
          //                   [654321_]
           ((in[17 + inPos] & 127L) >>> 1)
        | //                 [76______]
          //            [_____10]
           ((in[18 + inPos] & 127L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                 [___43210]
          //                    [65432__]
           ((in[18 + inPos] & 127L) >>> 2)
        | //                 [765_____]
          //             [____210]
           ((in[19 + inPos] & 127L) <<  5)) & 255);
      out[17 + outPos] = (byte)((
          //                 [____3210]
          //                     [6543___]
           ((in[19 + inPos] & 127L) >>> 3)
        | //                 [7654____]
          //              [___3210]
           ((in[20 + inPos] & 127L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //                 [_____210]
          //                      [654____]
           ((in[20 + inPos] & 127L) >>> 4)
        | //                 [76543___]
          //               [__43210]
           ((in[21 + inPos] & 127L) <<  3)) & 255);
      out[19 + outPos] = (byte)((
          //                 [______10]
          //                       [65_____]
           ((in[21 + inPos] & 127L) >>> 5)
        | //                 [765432__]
          //                [_543210]
           ((in[22 + inPos] & 127L) <<  2)) & 255);
      out[20 + outPos] = (byte)((
          //                 [_______0]
          //                        [6______]
           ((in[22 + inPos] & 127L) >>> 6)
        | //                 [7654321_]
          //                 [6543210]
           ((in[23 + inPos] & 127L) <<  1)) & 255);
      out[21 + outPos] = (byte)((
          //                 [_6543210]
          //                  [6543210]
           ((in[24 + inPos] & 127L))
        | //                 [7_______]
          //           [______0]
           ((in[25 + inPos] & 127L) <<  7)) & 255);
      out[22 + outPos] = (byte)((
          //                 [__543210]
          //                   [654321_]
           ((in[25 + inPos] & 127L) >>> 1)
        | //                 [76______]
          //            [_____10]
           ((in[26 + inPos] & 127L) <<  6)) & 255);
      out[23 + outPos] = (byte)((
          //                 [___43210]
          //                    [65432__]
           ((in[26 + inPos] & 127L) >>> 2)
        | //                 [765_____]
          //             [____210]
           ((in[27 + inPos] & 127L) <<  5)) & 255);
      out[24 + outPos] = (byte)((
          //                 [____3210]
          //                     [6543___]
           ((in[27 + inPos] & 127L) >>> 3)
        | //                 [7654____]
          //              [___3210]
           ((in[28 + inPos] & 127L) <<  4)) & 255);
      out[25 + outPos] = (byte)((
          //                 [_____210]
          //                      [654____]
           ((in[28 + inPos] & 127L) >>> 4)
        | //                 [76543___]
          //               [__43210]
           ((in[29 + inPos] & 127L) <<  3)) & 255);
      out[26 + outPos] = (byte)((
          //                 [______10]
          //                       [65_____]
           ((in[29 + inPos] & 127L) >>> 5)
        | //                 [765432__]
          //                [_543210]
           ((in[30 + inPos] & 127L) <<  2)) & 255);
      out[27 + outPos] = (byte)((
          //                 [_______0]
          //                        [6______]
           ((in[30 + inPos] & 127L) >>> 6)
        | //                 [7654321_]
          //                 [6543210]
           ((in[31 + inPos] & 127L) <<  1)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[ 0 + inPos]) ) & 127L);
      out[ 1 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in[ 1 + inPos]) <<  1) & 127L);
      out[ 2 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in[ 2 + inPos]) <<  2) & 127L);
      out[ 3 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in[ 3 + inPos]) <<  3) & 127L);
      out[ 4 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in[ 4 + inPos]) <<  4) & 127L);
      out[ 5 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in[ 4 + inPos]) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in[ 5 + inPos]) <<  5) & 127L);
      out[ 6 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in[ 6 + inPos]) <<  6) & 127L);
      out[ 7 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[ 6 + inPos]) >>  1) & 127L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get( 0 + inPos)) ) & 127L);
      out[ 1 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in.get( 1 + inPos)) <<  1) & 127L);
      out[ 2 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 127L);
      out[ 3 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 127L);
      out[ 4 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 127L);
      out[ 5 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in.get( 4 + inPos)) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in.get( 5 + inPos)) <<  5) & 127L);
      out[ 6 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in.get( 6 + inPos)) <<  6) & 127L);
      out[ 7 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get( 6 + inPos)) >>  1) & 127L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[ 0 + inPos]) ) & 127L);
      out[ 1 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in[ 1 + inPos]) <<  1) & 127L);
      out[ 2 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in[ 2 + inPos]) <<  2) & 127L);
      out[ 3 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in[ 3 + inPos]) <<  3) & 127L);
      out[ 4 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in[ 4 + inPos]) <<  4) & 127L);
      out[ 5 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in[ 4 + inPos]) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in[ 5 + inPos]) <<  5) & 127L);
      out[ 6 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in[ 6 + inPos]) <<  6) & 127L);
      out[ 7 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[ 6 + inPos]) >>  1) & 127L);
      out[ 8 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[ 7 + inPos]) ) & 127L);
      out[ 9 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in[ 8 + inPos]) <<  1) & 127L);
      out[10 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in[ 9 + inPos]) <<  2) & 127L);
      out[11 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in[10 + inPos]) <<  3) & 127L);
      out[12 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in[11 + inPos]) <<  4) & 127L);
      out[13 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in[11 + inPos]) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in[12 + inPos]) <<  5) & 127L);
      out[14 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in[12 + inPos]) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in[13 + inPos]) <<  6) & 127L);
      out[15 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[13 + inPos]) >>  1) & 127L);
      out[16 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[14 + inPos]) ) & 127L);
      out[17 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in[14 + inPos]) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in[15 + inPos]) <<  1) & 127L);
      out[18 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in[16 + inPos]) <<  2) & 127L);
      out[19 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in[16 + inPos]) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in[17 + inPos]) <<  3) & 127L);
      out[20 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in[18 + inPos]) <<  4) & 127L);
      out[21 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in[18 + inPos]) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in[19 + inPos]) <<  5) & 127L);
      out[22 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in[19 + inPos]) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in[20 + inPos]) <<  6) & 127L);
      out[23 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[20 + inPos]) >>  1) & 127L);
      out[24 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[21 + inPos]) ) & 127L);
      out[25 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in[21 + inPos]) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in[22 + inPos]) <<  1) & 127L);
      out[26 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in[22 + inPos]) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in[23 + inPos]) <<  2) & 127L);
      out[27 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in[23 + inPos]) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in[24 + inPos]) <<  3) & 127L);
      out[28 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in[24 + inPos]) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in[25 + inPos]) <<  4) & 127L);
      out[29 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in[25 + inPos]) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in[26 + inPos]) <<  5) & 127L);
      out[30 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in[26 + inPos]) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in[27 + inPos]) <<  6) & 127L);
      out[31 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[27 + inPos]) >>  1) & 127L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get( 0 + inPos)) ) & 127L);
      out[ 1 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in.get( 1 + inPos)) <<  1) & 127L);
      out[ 2 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 127L);
      out[ 3 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 127L);
      out[ 4 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 127L);
      out[ 5 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in.get( 4 + inPos)) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in.get( 5 + inPos)) <<  5) & 127L);
      out[ 6 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in.get( 6 + inPos)) <<  6) & 127L);
      out[ 7 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get( 6 + inPos)) >>  1) & 127L);
      out[ 8 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get( 7 + inPos)) ) & 127L);
      out[ 9 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in.get( 8 + inPos)) <<  1) & 127L);
      out[10 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 127L);
      out[11 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in.get(10 + inPos)) <<  3) & 127L);
      out[12 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in.get(11 + inPos)) <<  4) & 127L);
      out[13 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in.get(11 + inPos)) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in.get(12 + inPos)) <<  5) & 127L);
      out[14 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in.get(13 + inPos)) <<  6) & 127L);
      out[15 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get(13 + inPos)) >>  1) & 127L);
      out[16 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get(14 + inPos)) ) & 127L);
      out[17 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in.get(14 + inPos)) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in.get(15 + inPos)) <<  1) & 127L);
      out[18 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in.get(16 + inPos)) <<  2) & 127L);
      out[19 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in.get(16 + inPos)) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in.get(17 + inPos)) <<  3) & 127L);
      out[20 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in.get(18 + inPos)) <<  4) & 127L);
      out[21 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in.get(18 + inPos)) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in.get(19 + inPos)) <<  5) & 127L);
      out[22 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in.get(19 + inPos)) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in.get(20 + inPos)) <<  6) & 127L);
      out[23 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get(20 + inPos)) >>  1) & 127L);
      out[24 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get(21 + inPos)) ) & 127L);
      out[25 + outPos] =
          //                 [7_______]
          //           [______0]
            ((((long)in.get(21 + inPos)) >>  7) & 1L)
        | //                 [__543210]
          //                   [654321_]
            ((((long)in.get(22 + inPos)) <<  1) & 127L);
      out[26 + outPos] =
          //                 [76______]
          //            [_____10]
            ((((long)in.get(22 + inPos)) >>  6) & 3L)
        | //                 [___43210]
          //                    [65432__]
            ((((long)in.get(23 + inPos)) <<  2) & 127L);
      out[27 + outPos] =
          //                 [765_____]
          //             [____210]
            ((((long)in.get(23 + inPos)) >>  5) & 7L)
        | //                 [____3210]
          //                     [6543___]
            ((((long)in.get(24 + inPos)) <<  3) & 127L);
      out[28 + outPos] =
          //                 [7654____]
          //              [___3210]
            ((((long)in.get(24 + inPos)) >>  4) & 15L)
        | //                 [_____210]
          //                      [654____]
            ((((long)in.get(25 + inPos)) <<  4) & 127L);
      out[29 + outPos] =
          //                 [76543___]
          //               [__43210]
            ((((long)in.get(25 + inPos)) >>  3) & 31L)
        | //                 [______10]
          //                       [65_____]
            ((((long)in.get(26 + inPos)) <<  5) & 127L);
      out[30 + outPos] =
          //                 [765432__]
          //                [_543210]
            ((((long)in.get(26 + inPos)) >>  2) & 63L)
        | //                 [_______0]
          //                        [6______]
            ((((long)in.get(27 + inPos)) <<  6) & 127L);
      out[31 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get(27 + inPos)) >>  1) & 127L);
    }
  }

  private static final class Packer8 extends BytePackerForLong {

    private Packer8() {
      super(8);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 8 + inPos] & 255L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 9 + inPos] & 255L))) & 255);
      out[10 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[10 + inPos] & 255L))) & 255);
      out[11 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[11 + inPos] & 255L))) & 255);
      out[12 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[12 + inPos] & 255L))) & 255);
      out[13 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[13 + inPos] & 255L))) & 255);
      out[14 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[14 + inPos] & 255L))) & 255);
      out[15 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[15 + inPos] & 255L))) & 255);
      out[16 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[16 + inPos] & 255L))) & 255);
      out[17 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[17 + inPos] & 255L))) & 255);
      out[18 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[18 + inPos] & 255L))) & 255);
      out[19 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[19 + inPos] & 255L))) & 255);
      out[20 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[20 + inPos] & 255L))) & 255);
      out[21 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[21 + inPos] & 255L))) & 255);
      out[22 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[22 + inPos] & 255L))) & 255);
      out[23 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[23 + inPos] & 255L))) & 255);
      out[24 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[24 + inPos] & 255L))) & 255);
      out[25 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[25 + inPos] & 255L))) & 255);
      out[26 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[26 + inPos] & 255L))) & 255);
      out[27 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[27 + inPos] & 255L))) & 255);
      out[28 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[28 + inPos] & 255L))) & 255);
      out[29 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[29 + inPos] & 255L))) & 255);
      out[30 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[30 + inPos] & 255L))) & 255);
      out[31 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[31 + inPos] & 255L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 0 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 0 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 9 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[10 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[10 + inPos]) ) & 255L);
      out[11 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[11 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[12 + inPos]) ) & 255L);
      out[13 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[13 + inPos]) ) & 255L);
      out[14 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[15 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[15 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[16 + inPos]) ) & 255L);
      out[17 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[18 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[18 + inPos]) ) & 255L);
      out[19 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[19 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[20 + inPos]) ) & 255L);
      out[21 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[21 + inPos]) ) & 255L);
      out[22 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[22 + inPos]) ) & 255L);
      out[23 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[23 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[24 + inPos]) ) & 255L);
      out[25 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[25 + inPos]) ) & 255L);
      out[26 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[26 + inPos]) ) & 255L);
      out[27 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[27 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[28 + inPos]) ) & 255L);
      out[29 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[30 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[30 + inPos]) ) & 255L);
      out[31 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[31 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 9 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[10 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
      out[11 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(12 + inPos)) ) & 255L);
      out[13 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
      out[14 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[15 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(15 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(16 + inPos)) ) & 255L);
      out[17 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[18 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(18 + inPos)) ) & 255L);
      out[19 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
      out[21 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
      out[22 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(22 + inPos)) ) & 255L);
      out[23 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(23 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(24 + inPos)) ) & 255L);
      out[25 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(25 + inPos)) ) & 255L);
      out[26 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(26 + inPos)) ) & 255L);
      out[27 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(27 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(28 + inPos)) ) & 255L);
      out[29 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[30 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(30 + inPos)) ) & 255L);
      out[31 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(31 + inPos)) ) & 255L);
    }
  }

  private static final class Packer9 extends BytePackerForLong {

    private Packer9() {
      super(9);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 0 + inPos] & 511L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [_______0]
          //                          [8________]
           ((in[ 0 + inPos] & 511L) >>> 8)
        | //                   [7654321_]
          //                 [__6543210]
           ((in[ 1 + inPos] & 511L) <<  1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [______10]
          //                         [87_______]
           ((in[ 1 + inPos] & 511L) >>> 7)
        | //                   [765432__]
          //                [___543210]
           ((in[ 2 + inPos] & 511L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [_____210]
          //                        [876______]
           ((in[ 2 + inPos] & 511L) >>> 6)
        | //                   [76543___]
          //               [____43210]
           ((in[ 3 + inPos] & 511L) <<  3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [____3210]
          //                       [8765_____]
           ((in[ 3 + inPos] & 511L) >>> 5)
        | //                   [7654____]
          //              [_____3210]
           ((in[ 4 + inPos] & 511L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [___43210]
          //                      [87654____]
           ((in[ 4 + inPos] & 511L) >>> 4)
        | //                   [765_____]
          //             [______210]
           ((in[ 5 + inPos] & 511L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [__543210]
          //                     [876543___]
           ((in[ 5 + inPos] & 511L) >>> 3)
        | //                   [76______]
          //            [_______10]
           ((in[ 6 + inPos] & 511L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [_6543210]
          //                    [8765432__]
           ((in[ 6 + inPos] & 511L) >>> 2)
        | //                   [7_______]
          //           [________0]
           ((in[ 7 + inPos] & 511L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 7 + inPos] & 511L) >>> 1)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 0 + inPos] & 511L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [_______0]
          //                          [8________]
           ((in[ 0 + inPos] & 511L) >>> 8)
        | //                   [7654321_]
          //                 [__6543210]
           ((in[ 1 + inPos] & 511L) <<  1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [______10]
          //                         [87_______]
           ((in[ 1 + inPos] & 511L) >>> 7)
        | //                   [765432__]
          //                [___543210]
           ((in[ 2 + inPos] & 511L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [_____210]
          //                        [876______]
           ((in[ 2 + inPos] & 511L) >>> 6)
        | //                   [76543___]
          //               [____43210]
           ((in[ 3 + inPos] & 511L) <<  3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [____3210]
          //                       [8765_____]
           ((in[ 3 + inPos] & 511L) >>> 5)
        | //                   [7654____]
          //              [_____3210]
           ((in[ 4 + inPos] & 511L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [___43210]
          //                      [87654____]
           ((in[ 4 + inPos] & 511L) >>> 4)
        | //                   [765_____]
          //             [______210]
           ((in[ 5 + inPos] & 511L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [__543210]
          //                     [876543___]
           ((in[ 5 + inPos] & 511L) >>> 3)
        | //                   [76______]
          //            [_______10]
           ((in[ 6 + inPos] & 511L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [_6543210]
          //                    [8765432__]
           ((in[ 6 + inPos] & 511L) >>> 2)
        | //                   [7_______]
          //           [________0]
           ((in[ 7 + inPos] & 511L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 7 + inPos] & 511L) >>> 1)) & 255);
      out[ 9 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 8 + inPos] & 511L))) & 255);
      out[10 + outPos] = (byte)((
          //                   [_______0]
          //                          [8________]
           ((in[ 8 + inPos] & 511L) >>> 8)
        | //                   [7654321_]
          //                 [__6543210]
           ((in[ 9 + inPos] & 511L) <<  1)) & 255);
      out[11 + outPos] = (byte)((
          //                   [______10]
          //                         [87_______]
           ((in[ 9 + inPos] & 511L) >>> 7)
        | //                   [765432__]
          //                [___543210]
           ((in[10 + inPos] & 511L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                   [_____210]
          //                        [876______]
           ((in[10 + inPos] & 511L) >>> 6)
        | //                   [76543___]
          //               [____43210]
           ((in[11 + inPos] & 511L) <<  3)) & 255);
      out[13 + outPos] = (byte)((
          //                   [____3210]
          //                       [8765_____]
           ((in[11 + inPos] & 511L) >>> 5)
        | //                   [7654____]
          //              [_____3210]
           ((in[12 + inPos] & 511L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //                   [___43210]
          //                      [87654____]
           ((in[12 + inPos] & 511L) >>> 4)
        | //                   [765_____]
          //             [______210]
           ((in[13 + inPos] & 511L) <<  5)) & 255);
      out[15 + outPos] = (byte)((
          //                   [__543210]
          //                     [876543___]
           ((in[13 + inPos] & 511L) >>> 3)
        | //                   [76______]
          //            [_______10]
           ((in[14 + inPos] & 511L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                   [_6543210]
          //                    [8765432__]
           ((in[14 + inPos] & 511L) >>> 2)
        | //                   [7_______]
          //           [________0]
           ((in[15 + inPos] & 511L) <<  7)) & 255);
      out[17 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[15 + inPos] & 511L) >>> 1)) & 255);
      out[18 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[16 + inPos] & 511L))) & 255);
      out[19 + outPos] = (byte)((
          //                   [_______0]
          //                          [8________]
           ((in[16 + inPos] & 511L) >>> 8)
        | //                   [7654321_]
          //                 [__6543210]
           ((in[17 + inPos] & 511L) <<  1)) & 255);
      out[20 + outPos] = (byte)((
          //                   [______10]
          //                         [87_______]
           ((in[17 + inPos] & 511L) >>> 7)
        | //                   [765432__]
          //                [___543210]
           ((in[18 + inPos] & 511L) <<  2)) & 255);
      out[21 + outPos] = (byte)((
          //                   [_____210]
          //                        [876______]
           ((in[18 + inPos] & 511L) >>> 6)
        | //                   [76543___]
          //               [____43210]
           ((in[19 + inPos] & 511L) <<  3)) & 255);
      out[22 + outPos] = (byte)((
          //                   [____3210]
          //                       [8765_____]
           ((in[19 + inPos] & 511L) >>> 5)
        | //                   [7654____]
          //              [_____3210]
           ((in[20 + inPos] & 511L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                   [___43210]
          //                      [87654____]
           ((in[20 + inPos] & 511L) >>> 4)
        | //                   [765_____]
          //             [______210]
           ((in[21 + inPos] & 511L) <<  5)) & 255);
      out[24 + outPos] = (byte)((
          //                   [__543210]
          //                     [876543___]
           ((in[21 + inPos] & 511L) >>> 3)
        | //                   [76______]
          //            [_______10]
           ((in[22 + inPos] & 511L) <<  6)) & 255);
      out[25 + outPos] = (byte)((
          //                   [_6543210]
          //                    [8765432__]
           ((in[22 + inPos] & 511L) >>> 2)
        | //                   [7_______]
          //           [________0]
           ((in[23 + inPos] & 511L) <<  7)) & 255);
      out[26 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[23 + inPos] & 511L) >>> 1)) & 255);
      out[27 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[24 + inPos] & 511L))) & 255);
      out[28 + outPos] = (byte)((
          //                   [_______0]
          //                          [8________]
           ((in[24 + inPos] & 511L) >>> 8)
        | //                   [7654321_]
          //                 [__6543210]
           ((in[25 + inPos] & 511L) <<  1)) & 255);
      out[29 + outPos] = (byte)((
          //                   [______10]
          //                         [87_______]
           ((in[25 + inPos] & 511L) >>> 7)
        | //                   [765432__]
          //                [___543210]
           ((in[26 + inPos] & 511L) <<  2)) & 255);
      out[30 + outPos] = (byte)((
          //                   [_____210]
          //                        [876______]
           ((in[26 + inPos] & 511L) >>> 6)
        | //                   [76543___]
          //               [____43210]
           ((in[27 + inPos] & 511L) <<  3)) & 255);
      out[31 + outPos] = (byte)((
          //                   [____3210]
          //                       [8765_____]
           ((in[27 + inPos] & 511L) >>> 5)
        | //                   [7654____]
          //              [_____3210]
           ((in[28 + inPos] & 511L) <<  4)) & 255);
      out[32 + outPos] = (byte)((
          //                   [___43210]
          //                      [87654____]
           ((in[28 + inPos] & 511L) >>> 4)
        | //                   [765_____]
          //             [______210]
           ((in[29 + inPos] & 511L) <<  5)) & 255);
      out[33 + outPos] = (byte)((
          //                   [__543210]
          //                     [876543___]
           ((in[29 + inPos] & 511L) >>> 3)
        | //                   [76______]
          //            [_______10]
           ((in[30 + inPos] & 511L) <<  6)) & 255);
      out[34 + outPos] = (byte)((
          //                   [_6543210]
          //                    [8765432__]
           ((in[30 + inPos] & 511L) >>> 2)
        | //                   [7_______]
          //           [________0]
           ((in[31 + inPos] & 511L) <<  7)) & 255);
      out[35 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[31 + inPos] & 511L) >>> 1)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in[ 1 + inPos]) <<  8) & 511L);
      out[ 1 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in[ 1 + inPos]) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in[ 2 + inPos]) <<  7) & 511L);
      out[ 2 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in[ 3 + inPos]) <<  6) & 511L);
      out[ 3 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in[ 3 + inPos]) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 511L);
      out[ 4 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in[ 5 + inPos]) <<  4) & 511L);
      out[ 5 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in[ 6 + inPos]) <<  3) & 511L);
      out[ 6 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 511L);
      out[ 7 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in[ 8 + inPos]) <<  1) & 511L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in.get( 1 + inPos)) <<  8) & 511L);
      out[ 1 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get( 1 + inPos)) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in.get( 2 + inPos)) <<  7) & 511L);
      out[ 2 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 511L);
      out[ 3 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in.get( 3 + inPos)) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 511L);
      out[ 4 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 511L);
      out[ 5 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in.get( 6 + inPos)) <<  3) & 511L);
      out[ 6 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 511L);
      out[ 7 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in.get( 8 + inPos)) <<  1) & 511L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in[ 1 + inPos]) <<  8) & 511L);
      out[ 1 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in[ 1 + inPos]) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in[ 2 + inPos]) <<  7) & 511L);
      out[ 2 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in[ 3 + inPos]) <<  6) & 511L);
      out[ 3 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in[ 3 + inPos]) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 511L);
      out[ 4 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in[ 5 + inPos]) <<  4) & 511L);
      out[ 5 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in[ 6 + inPos]) <<  3) & 511L);
      out[ 6 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 511L);
      out[ 7 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in[ 8 + inPos]) <<  1) & 511L);
      out[ 8 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in[ 9 + inPos]) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in[10 + inPos]) <<  8) & 511L);
      out[ 9 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in[10 + inPos]) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in[11 + inPos]) <<  7) & 511L);
      out[10 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in[12 + inPos]) <<  6) & 511L);
      out[11 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in[12 + inPos]) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in[13 + inPos]) <<  5) & 511L);
      out[12 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in[13 + inPos]) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in[14 + inPos]) <<  4) & 511L);
      out[13 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in[14 + inPos]) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in[15 + inPos]) <<  3) & 511L);
      out[14 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in[16 + inPos]) <<  2) & 511L);
      out[15 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in[16 + inPos]) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in[17 + inPos]) <<  1) & 511L);
      out[16 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in[18 + inPos]) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in[19 + inPos]) <<  8) & 511L);
      out[17 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in[19 + inPos]) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in[20 + inPos]) <<  7) & 511L);
      out[18 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in[20 + inPos]) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in[21 + inPos]) <<  6) & 511L);
      out[19 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in[21 + inPos]) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in[22 + inPos]) <<  5) & 511L);
      out[20 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in[23 + inPos]) <<  4) & 511L);
      out[21 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in[23 + inPos]) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in[24 + inPos]) <<  3) & 511L);
      out[22 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in[24 + inPos]) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in[25 + inPos]) <<  2) & 511L);
      out[23 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in[25 + inPos]) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in[26 + inPos]) <<  1) & 511L);
      out[24 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in[27 + inPos]) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in[28 + inPos]) <<  8) & 511L);
      out[25 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in[28 + inPos]) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in[29 + inPos]) <<  7) & 511L);
      out[26 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in[29 + inPos]) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in[30 + inPos]) <<  6) & 511L);
      out[27 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in[30 + inPos]) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in[31 + inPos]) <<  5) & 511L);
      out[28 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in[31 + inPos]) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in[32 + inPos]) <<  4) & 511L);
      out[29 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in[32 + inPos]) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in[33 + inPos]) <<  3) & 511L);
      out[30 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in[33 + inPos]) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in[34 + inPos]) <<  2) & 511L);
      out[31 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in[34 + inPos]) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in[35 + inPos]) <<  1) & 511L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in.get( 1 + inPos)) <<  8) & 511L);
      out[ 1 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get( 1 + inPos)) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in.get( 2 + inPos)) <<  7) & 511L);
      out[ 2 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 511L);
      out[ 3 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in.get( 3 + inPos)) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 511L);
      out[ 4 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 511L);
      out[ 5 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in.get( 6 + inPos)) <<  3) & 511L);
      out[ 6 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 511L);
      out[ 7 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in.get( 8 + inPos)) <<  1) & 511L);
      out[ 8 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in.get(10 + inPos)) <<  8) & 511L);
      out[ 9 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(10 + inPos)) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in.get(11 + inPos)) <<  7) & 511L);
      out[10 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in.get(12 + inPos)) <<  6) & 511L);
      out[11 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in.get(12 + inPos)) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(13 + inPos)) <<  5) & 511L);
      out[12 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in.get(14 + inPos)) <<  4) & 511L);
      out[13 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in.get(14 + inPos)) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in.get(15 + inPos)) <<  3) & 511L);
      out[14 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 511L);
      out[15 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in.get(16 + inPos)) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in.get(17 + inPos)) <<  1) & 511L);
      out[16 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in.get(18 + inPos)) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in.get(19 + inPos)) <<  8) & 511L);
      out[17 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(19 + inPos)) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in.get(20 + inPos)) <<  7) & 511L);
      out[18 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in.get(20 + inPos)) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in.get(21 + inPos)) <<  6) & 511L);
      out[19 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in.get(21 + inPos)) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(22 + inPos)) <<  5) & 511L);
      out[20 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in.get(23 + inPos)) <<  4) & 511L);
      out[21 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in.get(23 + inPos)) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in.get(24 + inPos)) <<  3) & 511L);
      out[22 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in.get(24 + inPos)) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 511L);
      out[23 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in.get(25 + inPos)) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in.get(26 + inPos)) <<  1) & 511L);
      out[24 + outPos] =
          //                   [76543210]
          //                  [_76543210]
            ((((long)in.get(27 + inPos)) ) & 255L)
        | //                   [_______0]
          //                          [8________]
            ((((long)in.get(28 + inPos)) <<  8) & 511L);
      out[25 + outPos] =
          //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(28 + inPos)) >>  1) & 127L)
        | //                   [______10]
          //                         [87_______]
            ((((long)in.get(29 + inPos)) <<  7) & 511L);
      out[26 + outPos] =
          //                   [765432__]
          //                [___543210]
            ((((long)in.get(29 + inPos)) >>  2) & 63L)
        | //                   [_____210]
          //                        [876______]
            ((((long)in.get(30 + inPos)) <<  6) & 511L);
      out[27 + outPos] =
          //                   [76543___]
          //               [____43210]
            ((((long)in.get(30 + inPos)) >>  3) & 31L)
        | //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(31 + inPos)) <<  5) & 511L);
      out[28 + outPos] =
          //                   [7654____]
          //              [_____3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L)
        | //                   [___43210]
          //                      [87654____]
            ((((long)in.get(32 + inPos)) <<  4) & 511L);
      out[29 + outPos] =
          //                   [765_____]
          //             [______210]
            ((((long)in.get(32 + inPos)) >>  5) & 7L)
        | //                   [__543210]
          //                     [876543___]
            ((((long)in.get(33 + inPos)) <<  3) & 511L);
      out[30 + outPos] =
          //                   [76______]
          //            [_______10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L)
        | //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(34 + inPos)) <<  2) & 511L);
      out[31 + outPos] =
          //                   [7_______]
          //           [________0]
            ((((long)in.get(34 + inPos)) >>  7) & 1L)
        | //                   [76543210]
          //                   [87654321_]
            ((((long)in.get(35 + inPos)) <<  1) & 511L);
    }
  }

  private static final class Packer10 extends BytePackerForLong {

    private Packer10() {
      super(10);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 0 + inPos] & 1023L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[ 0 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[ 1 + inPos] & 1023L) <<  2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[ 1 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[ 2 + inPos] & 1023L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[ 2 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[ 3 + inPos] & 1023L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 3 + inPos] & 1023L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 4 + inPos] & 1023L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[ 4 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[ 5 + inPos] & 1023L) <<  2)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[ 5 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[ 6 + inPos] & 1023L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[ 6 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[ 7 + inPos] & 1023L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 7 + inPos] & 1023L) >>> 2)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 0 + inPos] & 1023L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[ 0 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[ 1 + inPos] & 1023L) <<  2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[ 1 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[ 2 + inPos] & 1023L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[ 2 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[ 3 + inPos] & 1023L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 3 + inPos] & 1023L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 4 + inPos] & 1023L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[ 4 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[ 5 + inPos] & 1023L) <<  2)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[ 5 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[ 6 + inPos] & 1023L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[ 6 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[ 7 + inPos] & 1023L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 7 + inPos] & 1023L) >>> 2)) & 255);
      out[10 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 8 + inPos] & 1023L))) & 255);
      out[11 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[ 8 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[ 9 + inPos] & 1023L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[ 9 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[10 + inPos] & 1023L) <<  4)) & 255);
      out[13 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[10 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[11 + inPos] & 1023L) <<  6)) & 255);
      out[14 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[11 + inPos] & 1023L) >>> 2)) & 255);
      out[15 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[12 + inPos] & 1023L))) & 255);
      out[16 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[12 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[13 + inPos] & 1023L) <<  2)) & 255);
      out[17 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[13 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[14 + inPos] & 1023L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[14 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[15 + inPos] & 1023L) <<  6)) & 255);
      out[19 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[15 + inPos] & 1023L) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[16 + inPos] & 1023L))) & 255);
      out[21 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[16 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[17 + inPos] & 1023L) <<  2)) & 255);
      out[22 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[17 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[18 + inPos] & 1023L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[18 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[19 + inPos] & 1023L) <<  6)) & 255);
      out[24 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[19 + inPos] & 1023L) >>> 2)) & 255);
      out[25 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[20 + inPos] & 1023L))) & 255);
      out[26 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[20 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[21 + inPos] & 1023L) <<  2)) & 255);
      out[27 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[21 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[22 + inPos] & 1023L) <<  4)) & 255);
      out[28 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[22 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[23 + inPos] & 1023L) <<  6)) & 255);
      out[29 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[23 + inPos] & 1023L) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[24 + inPos] & 1023L))) & 255);
      out[31 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[24 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[25 + inPos] & 1023L) <<  2)) & 255);
      out[32 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[25 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[26 + inPos] & 1023L) <<  4)) & 255);
      out[33 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[26 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[27 + inPos] & 1023L) <<  6)) & 255);
      out[34 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[27 + inPos] & 1023L) >>> 2)) & 255);
      out[35 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[28 + inPos] & 1023L))) & 255);
      out[36 + outPos] = (byte)((
          //                    [______10]
          //                          [98________]
           ((in[28 + inPos] & 1023L) >>> 8)
        | //                    [765432__]
          //                [____543210]
           ((in[29 + inPos] & 1023L) <<  2)) & 255);
      out[37 + outPos] = (byte)((
          //                    [____3210]
          //                        [9876______]
           ((in[29 + inPos] & 1023L) >>> 6)
        | //                    [7654____]
          //              [______3210]
           ((in[30 + inPos] & 1023L) <<  4)) & 255);
      out[38 + outPos] = (byte)((
          //                    [__543210]
          //                      [987654____]
           ((in[30 + inPos] & 1023L) >>> 4)
        | //                    [76______]
          //            [________10]
           ((in[31 + inPos] & 1023L) <<  6)) & 255);
      out[39 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[31 + inPos] & 1023L) >>> 2)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[ 1 + inPos]) <<  8) & 1023L);
      out[ 1 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[ 2 + inPos]) <<  6) & 1023L);
      out[ 2 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 1023L);
      out[ 3 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 5 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[ 6 + inPos]) <<  8) & 1023L);
      out[ 5 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[ 7 + inPos]) <<  6) & 1023L);
      out[ 6 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 1023L);
      out[ 7 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 9 + inPos]) <<  2) & 1023L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get( 1 + inPos)) <<  8) & 1023L);
      out[ 1 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 1023L);
      out[ 2 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 1023L);
      out[ 3 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get( 6 + inPos)) <<  8) & 1023L);
      out[ 5 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 1023L);
      out[ 6 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 1023L);
      out[ 7 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 1023L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[ 1 + inPos]) <<  8) & 1023L);
      out[ 1 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[ 2 + inPos]) <<  6) & 1023L);
      out[ 2 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 1023L);
      out[ 3 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 5 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[ 6 + inPos]) <<  8) & 1023L);
      out[ 5 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[ 7 + inPos]) <<  6) & 1023L);
      out[ 6 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 1023L);
      out[ 7 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 9 + inPos]) <<  2) & 1023L);
      out[ 8 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[10 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[11 + inPos]) <<  8) & 1023L);
      out[ 9 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[12 + inPos]) <<  6) & 1023L);
      out[10 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[12 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[13 + inPos]) <<  4) & 1023L);
      out[11 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[13 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[14 + inPos]) <<  2) & 1023L);
      out[12 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[15 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[16 + inPos]) <<  8) & 1023L);
      out[13 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[16 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[17 + inPos]) <<  6) & 1023L);
      out[14 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[18 + inPos]) <<  4) & 1023L);
      out[15 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[18 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[19 + inPos]) <<  2) & 1023L);
      out[16 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[20 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[21 + inPos]) <<  8) & 1023L);
      out[17 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[21 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[22 + inPos]) <<  6) & 1023L);
      out[18 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[23 + inPos]) <<  4) & 1023L);
      out[19 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[23 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[24 + inPos]) <<  2) & 1023L);
      out[20 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[25 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[26 + inPos]) <<  8) & 1023L);
      out[21 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[26 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[27 + inPos]) <<  6) & 1023L);
      out[22 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[27 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[28 + inPos]) <<  4) & 1023L);
      out[23 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[28 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[29 + inPos]) <<  2) & 1023L);
      out[24 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[30 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[31 + inPos]) <<  8) & 1023L);
      out[25 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[31 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[32 + inPos]) <<  6) & 1023L);
      out[26 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[32 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[33 + inPos]) <<  4) & 1023L);
      out[27 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[33 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[34 + inPos]) <<  2) & 1023L);
      out[28 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in[35 + inPos]) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in[36 + inPos]) <<  8) & 1023L);
      out[29 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in[36 + inPos]) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in[37 + inPos]) <<  6) & 1023L);
      out[30 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in[37 + inPos]) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in[38 + inPos]) <<  4) & 1023L);
      out[31 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in[38 + inPos]) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in[39 + inPos]) <<  2) & 1023L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get( 1 + inPos)) <<  8) & 1023L);
      out[ 1 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 1023L);
      out[ 2 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 1023L);
      out[ 3 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get( 6 + inPos)) <<  8) & 1023L);
      out[ 5 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 1023L);
      out[ 6 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 1023L);
      out[ 7 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 1023L);
      out[ 8 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(10 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(11 + inPos)) <<  8) & 1023L);
      out[ 9 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(12 + inPos)) <<  6) & 1023L);
      out[10 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(13 + inPos)) <<  4) & 1023L);
      out[11 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(13 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(14 + inPos)) <<  2) & 1023L);
      out[12 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(15 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(16 + inPos)) <<  8) & 1023L);
      out[13 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(16 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(17 + inPos)) <<  6) & 1023L);
      out[14 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 1023L);
      out[15 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(18 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(19 + inPos)) <<  2) & 1023L);
      out[16 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(20 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(21 + inPos)) <<  8) & 1023L);
      out[17 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(21 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(22 + inPos)) <<  6) & 1023L);
      out[18 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 1023L);
      out[19 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(23 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(24 + inPos)) <<  2) & 1023L);
      out[20 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(25 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(26 + inPos)) <<  8) & 1023L);
      out[21 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(26 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(27 + inPos)) <<  6) & 1023L);
      out[22 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(28 + inPos)) <<  4) & 1023L);
      out[23 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(28 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(29 + inPos)) <<  2) & 1023L);
      out[24 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(30 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(31 + inPos)) <<  8) & 1023L);
      out[25 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(31 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(32 + inPos)) <<  6) & 1023L);
      out[26 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(33 + inPos)) <<  4) & 1023L);
      out[27 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(34 + inPos)) <<  2) & 1023L);
      out[28 + outPos] =
          //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(35 + inPos)) ) & 255L)
        | //                    [______10]
          //                          [98________]
            ((((long)in.get(36 + inPos)) <<  8) & 1023L);
      out[29 + outPos] =
          //                    [765432__]
          //                [____543210]
            ((((long)in.get(36 + inPos)) >>  2) & 63L)
        | //                    [____3210]
          //                        [9876______]
            ((((long)in.get(37 + inPos)) <<  6) & 1023L);
      out[30 + outPos] =
          //                    [7654____]
          //              [______3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L)
        | //                    [__543210]
          //                      [987654____]
            ((((long)in.get(38 + inPos)) <<  4) & 1023L);
      out[31 + outPos] =
          //                    [76______]
          //            [________10]
            ((((long)in.get(38 + inPos)) >>  6) & 3L)
        | //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(39 + inPos)) <<  2) & 1023L);
    }
  }

  private static final class Packer11 extends BytePackerForLong {

    private Packer11() {
      super(11);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 0 + inPos] & 2047L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [_____210]
          //                          [098________]
           ((in[ 0 + inPos] & 2047L) >>> 8)
        | //                     [76543___]
          //               [______43210]
           ((in[ 1 + inPos] & 2047L) <<  3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [__543210]
          //                       [098765_____]
           ((in[ 1 + inPos] & 2047L) >>> 5)
        | //                     [76______]
          //            [_________10]
           ((in[ 2 + inPos] & 2047L) <<  6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 2 + inPos] & 2047L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [_______0]
          //                            [0__________]
           ((in[ 2 + inPos] & 2047L) >>> 10)
        | //                     [7654321_]
          //                 [____6543210]
           ((in[ 3 + inPos] & 2047L) <<  1)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [____3210]
          //                         [0987_______]
           ((in[ 3 + inPos] & 2047L) >>> 7)
        | //                     [7654____]
          //              [_______3210]
           ((in[ 4 + inPos] & 2047L) <<  4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [_6543210]
          //                      [0987654____]
           ((in[ 4 + inPos] & 2047L) >>> 4)
        | //                     [7_______]
          //           [__________0]
           ((in[ 5 + inPos] & 2047L) <<  7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 5 + inPos] & 2047L) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [______10]
          //                           [09_________]
           ((in[ 5 + inPos] & 2047L) >>> 9)
        | //                     [765432__]
          //                [_____543210]
           ((in[ 6 + inPos] & 2047L) <<  2)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [___43210]
          //                        [09876______]
           ((in[ 6 + inPos] & 2047L) >>> 6)
        | //                     [765_____]
          //             [________210]
           ((in[ 7 + inPos] & 2047L) <<  5)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 7 + inPos] & 2047L) >>> 3)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 0 + inPos] & 2047L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [_____210]
          //                          [098________]
           ((in[ 0 + inPos] & 2047L) >>> 8)
        | //                     [76543___]
          //               [______43210]
           ((in[ 1 + inPos] & 2047L) <<  3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [__543210]
          //                       [098765_____]
           ((in[ 1 + inPos] & 2047L) >>> 5)
        | //                     [76______]
          //            [_________10]
           ((in[ 2 + inPos] & 2047L) <<  6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 2 + inPos] & 2047L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [_______0]
          //                            [0__________]
           ((in[ 2 + inPos] & 2047L) >>> 10)
        | //                     [7654321_]
          //                 [____6543210]
           ((in[ 3 + inPos] & 2047L) <<  1)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [____3210]
          //                         [0987_______]
           ((in[ 3 + inPos] & 2047L) >>> 7)
        | //                     [7654____]
          //              [_______3210]
           ((in[ 4 + inPos] & 2047L) <<  4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [_6543210]
          //                      [0987654____]
           ((in[ 4 + inPos] & 2047L) >>> 4)
        | //                     [7_______]
          //           [__________0]
           ((in[ 5 + inPos] & 2047L) <<  7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 5 + inPos] & 2047L) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [______10]
          //                           [09_________]
           ((in[ 5 + inPos] & 2047L) >>> 9)
        | //                     [765432__]
          //                [_____543210]
           ((in[ 6 + inPos] & 2047L) <<  2)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [___43210]
          //                        [09876______]
           ((in[ 6 + inPos] & 2047L) >>> 6)
        | //                     [765_____]
          //             [________210]
           ((in[ 7 + inPos] & 2047L) <<  5)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 7 + inPos] & 2047L) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 8 + inPos] & 2047L))) & 255);
      out[12 + outPos] = (byte)((
          //                     [_____210]
          //                          [098________]
           ((in[ 8 + inPos] & 2047L) >>> 8)
        | //                     [76543___]
          //               [______43210]
           ((in[ 9 + inPos] & 2047L) <<  3)) & 255);
      out[13 + outPos] = (byte)((
          //                     [__543210]
          //                       [098765_____]
           ((in[ 9 + inPos] & 2047L) >>> 5)
        | //                     [76______]
          //            [_________10]
           ((in[10 + inPos] & 2047L) <<  6)) & 255);
      out[14 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[10 + inPos] & 2047L) >>> 2)) & 255);
      out[15 + outPos] = (byte)((
          //                     [_______0]
          //                            [0__________]
           ((in[10 + inPos] & 2047L) >>> 10)
        | //                     [7654321_]
          //                 [____6543210]
           ((in[11 + inPos] & 2047L) <<  1)) & 255);
      out[16 + outPos] = (byte)((
          //                     [____3210]
          //                         [0987_______]
           ((in[11 + inPos] & 2047L) >>> 7)
        | //                     [7654____]
          //              [_______3210]
           ((in[12 + inPos] & 2047L) <<  4)) & 255);
      out[17 + outPos] = (byte)((
          //                     [_6543210]
          //                      [0987654____]
           ((in[12 + inPos] & 2047L) >>> 4)
        | //                     [7_______]
          //           [__________0]
           ((in[13 + inPos] & 2047L) <<  7)) & 255);
      out[18 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[13 + inPos] & 2047L) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                     [______10]
          //                           [09_________]
           ((in[13 + inPos] & 2047L) >>> 9)
        | //                     [765432__]
          //                [_____543210]
           ((in[14 + inPos] & 2047L) <<  2)) & 255);
      out[20 + outPos] = (byte)((
          //                     [___43210]
          //                        [09876______]
           ((in[14 + inPos] & 2047L) >>> 6)
        | //                     [765_____]
          //             [________210]
           ((in[15 + inPos] & 2047L) <<  5)) & 255);
      out[21 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[15 + inPos] & 2047L) >>> 3)) & 255);
      out[22 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[16 + inPos] & 2047L))) & 255);
      out[23 + outPos] = (byte)((
          //                     [_____210]
          //                          [098________]
           ((in[16 + inPos] & 2047L) >>> 8)
        | //                     [76543___]
          //               [______43210]
           ((in[17 + inPos] & 2047L) <<  3)) & 255);
      out[24 + outPos] = (byte)((
          //                     [__543210]
          //                       [098765_____]
           ((in[17 + inPos] & 2047L) >>> 5)
        | //                     [76______]
          //            [_________10]
           ((in[18 + inPos] & 2047L) <<  6)) & 255);
      out[25 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[18 + inPos] & 2047L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                     [_______0]
          //                            [0__________]
           ((in[18 + inPos] & 2047L) >>> 10)
        | //                     [7654321_]
          //                 [____6543210]
           ((in[19 + inPos] & 2047L) <<  1)) & 255);
      out[27 + outPos] = (byte)((
          //                     [____3210]
          //                         [0987_______]
           ((in[19 + inPos] & 2047L) >>> 7)
        | //                     [7654____]
          //              [_______3210]
           ((in[20 + inPos] & 2047L) <<  4)) & 255);
      out[28 + outPos] = (byte)((
          //                     [_6543210]
          //                      [0987654____]
           ((in[20 + inPos] & 2047L) >>> 4)
        | //                     [7_______]
          //           [__________0]
           ((in[21 + inPos] & 2047L) <<  7)) & 255);
      out[29 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[21 + inPos] & 2047L) >>> 1)) & 255);
      out[30 + outPos] = (byte)((
          //                     [______10]
          //                           [09_________]
           ((in[21 + inPos] & 2047L) >>> 9)
        | //                     [765432__]
          //                [_____543210]
           ((in[22 + inPos] & 2047L) <<  2)) & 255);
      out[31 + outPos] = (byte)((
          //                     [___43210]
          //                        [09876______]
           ((in[22 + inPos] & 2047L) >>> 6)
        | //                     [765_____]
          //             [________210]
           ((in[23 + inPos] & 2047L) <<  5)) & 255);
      out[32 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[23 + inPos] & 2047L) >>> 3)) & 255);
      out[33 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[24 + inPos] & 2047L))) & 255);
      out[34 + outPos] = (byte)((
          //                     [_____210]
          //                          [098________]
           ((in[24 + inPos] & 2047L) >>> 8)
        | //                     [76543___]
          //               [______43210]
           ((in[25 + inPos] & 2047L) <<  3)) & 255);
      out[35 + outPos] = (byte)((
          //                     [__543210]
          //                       [098765_____]
           ((in[25 + inPos] & 2047L) >>> 5)
        | //                     [76______]
          //            [_________10]
           ((in[26 + inPos] & 2047L) <<  6)) & 255);
      out[36 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[26 + inPos] & 2047L) >>> 2)) & 255);
      out[37 + outPos] = (byte)((
          //                     [_______0]
          //                            [0__________]
           ((in[26 + inPos] & 2047L) >>> 10)
        | //                     [7654321_]
          //                 [____6543210]
           ((in[27 + inPos] & 2047L) <<  1)) & 255);
      out[38 + outPos] = (byte)((
          //                     [____3210]
          //                         [0987_______]
           ((in[27 + inPos] & 2047L) >>> 7)
        | //                     [7654____]
          //              [_______3210]
           ((in[28 + inPos] & 2047L) <<  4)) & 255);
      out[39 + outPos] = (byte)((
          //                     [_6543210]
          //                      [0987654____]
           ((in[28 + inPos] & 2047L) >>> 4)
        | //                     [7_______]
          //           [__________0]
           ((in[29 + inPos] & 2047L) <<  7)) & 255);
      out[40 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[29 + inPos] & 2047L) >>> 1)) & 255);
      out[41 + outPos] = (byte)((
          //                     [______10]
          //                           [09_________]
           ((in[29 + inPos] & 2047L) >>> 9)
        | //                     [765432__]
          //                [_____543210]
           ((in[30 + inPos] & 2047L) <<  2)) & 255);
      out[42 + outPos] = (byte)((
          //                     [___43210]
          //                        [09876______]
           ((in[30 + inPos] & 2047L) >>> 6)
        | //                     [765_____]
          //             [________210]
           ((in[31 + inPos] & 2047L) <<  5)) & 255);
      out[43 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[31 + inPos] & 2047L) >>> 3)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in[ 1 + inPos]) <<  8) & 2047L);
      out[ 1 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in[ 1 + inPos]) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in[ 2 + inPos]) <<  5) & 2047L);
      out[ 2 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in[ 4 + inPos]) <<  10) & 2047L);
      out[ 3 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in[ 4 + inPos]) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in[ 5 + inPos]) <<  7) & 2047L);
      out[ 4 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 2047L);
      out[ 5 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in[ 6 + inPos]) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[ 7 + inPos]) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in[ 8 + inPos]) <<  9) & 2047L);
      out[ 6 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in[ 9 + inPos]) <<  6) & 2047L);
      out[ 7 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in[10 + inPos]) <<  3) & 2047L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 2047L);
      out[ 1 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in.get( 1 + inPos)) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in.get( 2 + inPos)) <<  5) & 2047L);
      out[ 2 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in.get( 4 + inPos)) <<  10) & 2047L);
      out[ 3 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get( 4 + inPos)) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in.get( 5 + inPos)) <<  7) & 2047L);
      out[ 4 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 2047L);
      out[ 5 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in.get( 6 + inPos)) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in.get( 8 + inPos)) <<  9) & 2047L);
      out[ 6 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in.get( 9 + inPos)) <<  6) & 2047L);
      out[ 7 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(10 + inPos)) <<  3) & 2047L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in[ 1 + inPos]) <<  8) & 2047L);
      out[ 1 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in[ 1 + inPos]) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in[ 2 + inPos]) <<  5) & 2047L);
      out[ 2 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in[ 4 + inPos]) <<  10) & 2047L);
      out[ 3 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in[ 4 + inPos]) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in[ 5 + inPos]) <<  7) & 2047L);
      out[ 4 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 2047L);
      out[ 5 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in[ 6 + inPos]) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[ 7 + inPos]) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in[ 8 + inPos]) <<  9) & 2047L);
      out[ 6 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in[ 9 + inPos]) <<  6) & 2047L);
      out[ 7 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in[10 + inPos]) <<  3) & 2047L);
      out[ 8 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in[11 + inPos]) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in[12 + inPos]) <<  8) & 2047L);
      out[ 9 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in[12 + inPos]) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in[13 + inPos]) <<  5) & 2047L);
      out[10 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in[13 + inPos]) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[14 + inPos]) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in[15 + inPos]) <<  10) & 2047L);
      out[11 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in[15 + inPos]) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in[16 + inPos]) <<  7) & 2047L);
      out[12 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in[16 + inPos]) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in[17 + inPos]) <<  4) & 2047L);
      out[13 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in[17 + inPos]) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[18 + inPos]) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in[19 + inPos]) <<  9) & 2047L);
      out[14 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in[19 + inPos]) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in[20 + inPos]) <<  6) & 2047L);
      out[15 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in[20 + inPos]) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in[21 + inPos]) <<  3) & 2047L);
      out[16 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in[22 + inPos]) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in[23 + inPos]) <<  8) & 2047L);
      out[17 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in[23 + inPos]) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in[24 + inPos]) <<  5) & 2047L);
      out[18 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in[24 + inPos]) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in[26 + inPos]) <<  10) & 2047L);
      out[19 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in[26 + inPos]) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in[27 + inPos]) <<  7) & 2047L);
      out[20 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in[27 + inPos]) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in[28 + inPos]) <<  4) & 2047L);
      out[21 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in[28 + inPos]) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[29 + inPos]) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in[30 + inPos]) <<  9) & 2047L);
      out[22 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in[30 + inPos]) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in[31 + inPos]) <<  6) & 2047L);
      out[23 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in[31 + inPos]) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in[32 + inPos]) <<  3) & 2047L);
      out[24 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in[33 + inPos]) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in[34 + inPos]) <<  8) & 2047L);
      out[25 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in[34 + inPos]) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in[35 + inPos]) <<  5) & 2047L);
      out[26 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in[35 + inPos]) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[36 + inPos]) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in[37 + inPos]) <<  10) & 2047L);
      out[27 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in[37 + inPos]) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in[38 + inPos]) <<  7) & 2047L);
      out[28 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in[38 + inPos]) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in[39 + inPos]) <<  4) & 2047L);
      out[29 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in[39 + inPos]) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[40 + inPos]) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in[41 + inPos]) <<  9) & 2047L);
      out[30 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in[41 + inPos]) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in[42 + inPos]) <<  6) & 2047L);
      out[31 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in[42 + inPos]) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in[43 + inPos]) <<  3) & 2047L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 2047L);
      out[ 1 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in.get( 1 + inPos)) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in.get( 2 + inPos)) <<  5) & 2047L);
      out[ 2 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in.get( 4 + inPos)) <<  10) & 2047L);
      out[ 3 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get( 4 + inPos)) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in.get( 5 + inPos)) <<  7) & 2047L);
      out[ 4 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 2047L);
      out[ 5 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in.get( 6 + inPos)) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in.get( 8 + inPos)) <<  9) & 2047L);
      out[ 6 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in.get( 9 + inPos)) <<  6) & 2047L);
      out[ 7 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(10 + inPos)) <<  3) & 2047L);
      out[ 8 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(11 + inPos)) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in.get(12 + inPos)) <<  8) & 2047L);
      out[ 9 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in.get(12 + inPos)) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(13 + inPos)) <<  5) & 2047L);
      out[10 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in.get(13 + inPos)) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(14 + inPos)) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in.get(15 + inPos)) <<  10) & 2047L);
      out[11 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(15 + inPos)) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(16 + inPos)) <<  7) & 2047L);
      out[12 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(17 + inPos)) <<  4) & 2047L);
      out[13 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in.get(17 + inPos)) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(18 + inPos)) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in.get(19 + inPos)) <<  9) & 2047L);
      out[14 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in.get(19 + inPos)) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in.get(20 + inPos)) <<  6) & 2047L);
      out[15 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in.get(20 + inPos)) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(21 + inPos)) <<  3) & 2047L);
      out[16 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(22 + inPos)) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in.get(23 + inPos)) <<  8) & 2047L);
      out[17 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in.get(23 + inPos)) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(24 + inPos)) <<  5) & 2047L);
      out[18 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in.get(24 + inPos)) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in.get(26 + inPos)) <<  10) & 2047L);
      out[19 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(26 + inPos)) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(27 + inPos)) <<  7) & 2047L);
      out[20 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(28 + inPos)) <<  4) & 2047L);
      out[21 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in.get(28 + inPos)) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(29 + inPos)) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in.get(30 + inPos)) <<  9) & 2047L);
      out[22 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in.get(30 + inPos)) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in.get(31 + inPos)) <<  6) & 2047L);
      out[23 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in.get(31 + inPos)) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(32 + inPos)) <<  3) & 2047L);
      out[24 + outPos] =
          //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(33 + inPos)) ) & 255L)
        | //                     [_____210]
          //                          [098________]
            ((((long)in.get(34 + inPos)) <<  8) & 2047L);
      out[25 + outPos] =
          //                     [76543___]
          //               [______43210]
            ((((long)in.get(34 + inPos)) >>  3) & 31L)
        | //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(35 + inPos)) <<  5) & 2047L);
      out[26 + outPos] =
          //                     [76______]
          //            [_________10]
            ((((long)in.get(35 + inPos)) >>  6) & 3L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(36 + inPos)) <<  2) & 1023L)
        | //                     [_______0]
          //                            [0__________]
            ((((long)in.get(37 + inPos)) <<  10) & 2047L);
      out[27 + outPos] =
          //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(37 + inPos)) >>  1) & 127L)
        | //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(38 + inPos)) <<  7) & 2047L);
      out[28 + outPos] =
          //                     [7654____]
          //              [_______3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L)
        | //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(39 + inPos)) <<  4) & 2047L);
      out[29 + outPos] =
          //                     [7_______]
          //           [__________0]
            ((((long)in.get(39 + inPos)) >>  7) & 1L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(40 + inPos)) <<  1) & 511L)
        | //                     [______10]
          //                           [09_________]
            ((((long)in.get(41 + inPos)) <<  9) & 2047L);
      out[30 + outPos] =
          //                     [765432__]
          //                [_____543210]
            ((((long)in.get(41 + inPos)) >>  2) & 63L)
        | //                     [___43210]
          //                        [09876______]
            ((((long)in.get(42 + inPos)) <<  6) & 2047L);
      out[31 + outPos] =
          //                     [765_____]
          //             [________210]
            ((((long)in.get(42 + inPos)) >>  5) & 7L)
        | //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(43 + inPos)) <<  3) & 2047L);
    }
  }

  private static final class Packer12 extends BytePackerForLong {

    private Packer12() {
      super(12);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 0 + inPos] & 4095L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 0 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 1 + inPos] & 4095L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 1 + inPos] & 4095L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 2 + inPos] & 4095L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 2 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 3 + inPos] & 4095L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 3 + inPos] & 4095L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 4 + inPos] & 4095L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 4 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 5 + inPos] & 4095L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 5 + inPos] & 4095L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 6 + inPos] & 4095L))) & 255);
      out[10 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 6 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 7 + inPos] & 4095L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 7 + inPos] & 4095L) >>> 4)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 0 + inPos] & 4095L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 0 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 1 + inPos] & 4095L) <<  4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 1 + inPos] & 4095L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 2 + inPos] & 4095L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 2 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 3 + inPos] & 4095L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 3 + inPos] & 4095L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 4 + inPos] & 4095L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 4 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 5 + inPos] & 4095L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 5 + inPos] & 4095L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 6 + inPos] & 4095L))) & 255);
      out[10 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 6 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 7 + inPos] & 4095L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 7 + inPos] & 4095L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 8 + inPos] & 4095L))) & 255);
      out[13 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[ 8 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[ 9 + inPos] & 4095L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 9 + inPos] & 4095L) >>> 4)) & 255);
      out[15 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[10 + inPos] & 4095L))) & 255);
      out[16 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[10 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[11 + inPos] & 4095L) <<  4)) & 255);
      out[17 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[11 + inPos] & 4095L) >>> 4)) & 255);
      out[18 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[12 + inPos] & 4095L))) & 255);
      out[19 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[12 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[13 + inPos] & 4095L) <<  4)) & 255);
      out[20 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[13 + inPos] & 4095L) >>> 4)) & 255);
      out[21 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[14 + inPos] & 4095L))) & 255);
      out[22 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[14 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[15 + inPos] & 4095L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[15 + inPos] & 4095L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[16 + inPos] & 4095L))) & 255);
      out[25 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[16 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[17 + inPos] & 4095L) <<  4)) & 255);
      out[26 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[17 + inPos] & 4095L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[18 + inPos] & 4095L))) & 255);
      out[28 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[18 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[19 + inPos] & 4095L) <<  4)) & 255);
      out[29 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[19 + inPos] & 4095L) >>> 4)) & 255);
      out[30 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[20 + inPos] & 4095L))) & 255);
      out[31 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[20 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[21 + inPos] & 4095L) <<  4)) & 255);
      out[32 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[21 + inPos] & 4095L) >>> 4)) & 255);
      out[33 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[22 + inPos] & 4095L))) & 255);
      out[34 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[22 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[23 + inPos] & 4095L) <<  4)) & 255);
      out[35 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[23 + inPos] & 4095L) >>> 4)) & 255);
      out[36 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[24 + inPos] & 4095L))) & 255);
      out[37 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[24 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[25 + inPos] & 4095L) <<  4)) & 255);
      out[38 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[25 + inPos] & 4095L) >>> 4)) & 255);
      out[39 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[26 + inPos] & 4095L))) & 255);
      out[40 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[26 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[27 + inPos] & 4095L) <<  4)) & 255);
      out[41 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[27 + inPos] & 4095L) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[28 + inPos] & 4095L))) & 255);
      out[43 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[28 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[29 + inPos] & 4095L) <<  4)) & 255);
      out[44 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[29 + inPos] & 4095L) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[30 + inPos] & 4095L))) & 255);
      out[46 + outPos] = (byte)((
          //                      [____3210]
          //                          [1098________]
           ((in[30 + inPos] & 4095L) >>> 8)
        | //                      [7654____]
          //              [________3210]
           ((in[31 + inPos] & 4095L) <<  4)) & 255);
      out[47 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[31 + inPos] & 4095L) >>> 4)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 1 + inPos]) <<  8) & 4095L);
      out[ 1 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 2 + inPos]) <<  4) & 4095L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 3 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 4 + inPos]) <<  8) & 4095L);
      out[ 3 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 6 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 7 + inPos]) <<  8) & 4095L);
      out[ 5 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 9 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[10 + inPos]) <<  8) & 4095L);
      out[ 7 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 4095L);
      out[ 1 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 4095L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 4095L);
      out[ 3 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 4095L);
      out[ 5 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(10 + inPos)) <<  8) & 4095L);
      out[ 7 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 1 + inPos]) <<  8) & 4095L);
      out[ 1 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 2 + inPos]) <<  4) & 4095L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 3 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 4 + inPos]) <<  8) & 4095L);
      out[ 3 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 6 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[ 7 + inPos]) <<  8) & 4095L);
      out[ 5 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 9 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[10 + inPos]) <<  8) & 4095L);
      out[ 7 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L);
      out[ 8 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[12 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[13 + inPos]) <<  8) & 4095L);
      out[ 9 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[14 + inPos]) <<  4) & 4095L);
      out[10 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[15 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[16 + inPos]) <<  8) & 4095L);
      out[11 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[17 + inPos]) <<  4) & 4095L);
      out[12 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[18 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[19 + inPos]) <<  8) & 4095L);
      out[13 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[19 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[20 + inPos]) <<  4) & 4095L);
      out[14 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[21 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[22 + inPos]) <<  8) & 4095L);
      out[15 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[23 + inPos]) <<  4) & 4095L);
      out[16 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[24 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[25 + inPos]) <<  8) & 4095L);
      out[17 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[25 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[26 + inPos]) <<  4) & 4095L);
      out[18 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[27 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[28 + inPos]) <<  8) & 4095L);
      out[19 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[28 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[29 + inPos]) <<  4) & 4095L);
      out[20 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[30 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[31 + inPos]) <<  8) & 4095L);
      out[21 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[32 + inPos]) <<  4) & 4095L);
      out[22 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[33 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[34 + inPos]) <<  8) & 4095L);
      out[23 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[34 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[35 + inPos]) <<  4) & 4095L);
      out[24 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[36 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[37 + inPos]) <<  8) & 4095L);
      out[25 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[38 + inPos]) <<  4) & 4095L);
      out[26 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[39 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[40 + inPos]) <<  8) & 4095L);
      out[27 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[40 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[41 + inPos]) <<  4) & 4095L);
      out[28 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[42 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[43 + inPos]) <<  8) & 4095L);
      out[29 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[43 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[44 + inPos]) <<  4) & 4095L);
      out[30 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in[45 + inPos]) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in[46 + inPos]) <<  8) & 4095L);
      out[31 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in[46 + inPos]) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in[47 + inPos]) <<  4) & 4095L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 4095L);
      out[ 1 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 4095L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 4095L);
      out[ 3 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 4095L);
      out[ 5 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(10 + inPos)) <<  8) & 4095L);
      out[ 7 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L);
      out[ 8 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(12 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(13 + inPos)) <<  8) & 4095L);
      out[ 9 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(14 + inPos)) <<  4) & 4095L);
      out[10 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(15 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(16 + inPos)) <<  8) & 4095L);
      out[11 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(17 + inPos)) <<  4) & 4095L);
      out[12 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(18 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(19 + inPos)) <<  8) & 4095L);
      out[13 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(20 + inPos)) <<  4) & 4095L);
      out[14 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(21 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(22 + inPos)) <<  8) & 4095L);
      out[15 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 4095L);
      out[16 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(24 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(25 + inPos)) <<  8) & 4095L);
      out[17 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(25 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 4095L);
      out[18 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(27 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(28 + inPos)) <<  8) & 4095L);
      out[19 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(28 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(29 + inPos)) <<  4) & 4095L);
      out[20 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(30 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(31 + inPos)) <<  8) & 4095L);
      out[21 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(32 + inPos)) <<  4) & 4095L);
      out[22 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(33 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(34 + inPos)) <<  8) & 4095L);
      out[23 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(34 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(35 + inPos)) <<  4) & 4095L);
      out[24 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(36 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(37 + inPos)) <<  8) & 4095L);
      out[25 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(38 + inPos)) <<  4) & 4095L);
      out[26 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(39 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(40 + inPos)) <<  8) & 4095L);
      out[27 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(40 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(41 + inPos)) <<  4) & 4095L);
      out[28 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(42 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(43 + inPos)) <<  8) & 4095L);
      out[29 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(43 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(44 + inPos)) <<  4) & 4095L);
      out[30 + outPos] =
          //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(45 + inPos)) ) & 255L)
        | //                      [____3210]
          //                          [1098________]
            ((((long)in.get(46 + inPos)) <<  8) & 4095L);
      out[31 + outPos] =
          //                      [7654____]
          //              [________3210]
            ((((long)in.get(46 + inPos)) >>  4) & 15L)
        | //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(47 + inPos)) <<  4) & 4095L);
    }
  }

  private static final class Packer13 extends BytePackerForLong {

    private Packer13() {
      super(13);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 0 + inPos] & 8191L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [___43210]
          //                          [21098________]
           ((in[ 0 + inPos] & 8191L) >>> 8)
        | //                       [765_____]
          //             [__________210]
           ((in[ 1 + inPos] & 8191L) <<  5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 1 + inPos] & 8191L) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [______10]
          //                             [21___________]
           ((in[ 1 + inPos] & 8191L) >>> 11)
        | //                       [765432__]
          //                [_______543210]
           ((in[ 2 + inPos] & 8191L) <<  2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [_6543210]
          //                        [2109876______]
           ((in[ 2 + inPos] & 8191L) >>> 6)
        | //                       [7_______]
          //           [____________0]
           ((in[ 3 + inPos] & 8191L) <<  7)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 3 + inPos] & 8191L) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [____3210]
          //                           [2109_________]
           ((in[ 3 + inPos] & 8191L) >>> 9)
        | //                       [7654____]
          //              [_________3210]
           ((in[ 4 + inPos] & 8191L) <<  4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 4 + inPos] & 8191L) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [_______0]
          //                              [2____________]
           ((in[ 4 + inPos] & 8191L) >>> 12)
        | //                       [7654321_]
          //                 [______6543210]
           ((in[ 5 + inPos] & 8191L) <<  1)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [__543210]
          //                         [210987_______]
           ((in[ 5 + inPos] & 8191L) >>> 7)
        | //                       [76______]
          //            [___________10]
           ((in[ 6 + inPos] & 8191L) <<  6)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 6 + inPos] & 8191L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                       [_____210]
          //                            [210__________]
           ((in[ 6 + inPos] & 8191L) >>> 10)
        | //                       [76543___]
          //               [________43210]
           ((in[ 7 + inPos] & 8191L) <<  3)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 7 + inPos] & 8191L) >>> 5)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 0 + inPos] & 8191L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [___43210]
          //                          [21098________]
           ((in[ 0 + inPos] & 8191L) >>> 8)
        | //                       [765_____]
          //             [__________210]
           ((in[ 1 + inPos] & 8191L) <<  5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 1 + inPos] & 8191L) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [______10]
          //                             [21___________]
           ((in[ 1 + inPos] & 8191L) >>> 11)
        | //                       [765432__]
          //                [_______543210]
           ((in[ 2 + inPos] & 8191L) <<  2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [_6543210]
          //                        [2109876______]
           ((in[ 2 + inPos] & 8191L) >>> 6)
        | //                       [7_______]
          //           [____________0]
           ((in[ 3 + inPos] & 8191L) <<  7)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 3 + inPos] & 8191L) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [____3210]
          //                           [2109_________]
           ((in[ 3 + inPos] & 8191L) >>> 9)
        | //                       [7654____]
          //              [_________3210]
           ((in[ 4 + inPos] & 8191L) <<  4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 4 + inPos] & 8191L) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [_______0]
          //                              [2____________]
           ((in[ 4 + inPos] & 8191L) >>> 12)
        | //                       [7654321_]
          //                 [______6543210]
           ((in[ 5 + inPos] & 8191L) <<  1)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [__543210]
          //                         [210987_______]
           ((in[ 5 + inPos] & 8191L) >>> 7)
        | //                       [76______]
          //            [___________10]
           ((in[ 6 + inPos] & 8191L) <<  6)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 6 + inPos] & 8191L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                       [_____210]
          //                            [210__________]
           ((in[ 6 + inPos] & 8191L) >>> 10)
        | //                       [76543___]
          //               [________43210]
           ((in[ 7 + inPos] & 8191L) <<  3)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 7 + inPos] & 8191L) >>> 5)) & 255);
      out[13 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 8 + inPos] & 8191L))) & 255);
      out[14 + outPos] = (byte)((
          //                       [___43210]
          //                          [21098________]
           ((in[ 8 + inPos] & 8191L) >>> 8)
        | //                       [765_____]
          //             [__________210]
           ((in[ 9 + inPos] & 8191L) <<  5)) & 255);
      out[15 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 9 + inPos] & 8191L) >>> 3)) & 255);
      out[16 + outPos] = (byte)((
          //                       [______10]
          //                             [21___________]
           ((in[ 9 + inPos] & 8191L) >>> 11)
        | //                       [765432__]
          //                [_______543210]
           ((in[10 + inPos] & 8191L) <<  2)) & 255);
      out[17 + outPos] = (byte)((
          //                       [_6543210]
          //                        [2109876______]
           ((in[10 + inPos] & 8191L) >>> 6)
        | //                       [7_______]
          //           [____________0]
           ((in[11 + inPos] & 8191L) <<  7)) & 255);
      out[18 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[11 + inPos] & 8191L) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                       [____3210]
          //                           [2109_________]
           ((in[11 + inPos] & 8191L) >>> 9)
        | //                       [7654____]
          //              [_________3210]
           ((in[12 + inPos] & 8191L) <<  4)) & 255);
      out[20 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[12 + inPos] & 8191L) >>> 4)) & 255);
      out[21 + outPos] = (byte)((
          //                       [_______0]
          //                              [2____________]
           ((in[12 + inPos] & 8191L) >>> 12)
        | //                       [7654321_]
          //                 [______6543210]
           ((in[13 + inPos] & 8191L) <<  1)) & 255);
      out[22 + outPos] = (byte)((
          //                       [__543210]
          //                         [210987_______]
           ((in[13 + inPos] & 8191L) >>> 7)
        | //                       [76______]
          //            [___________10]
           ((in[14 + inPos] & 8191L) <<  6)) & 255);
      out[23 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[14 + inPos] & 8191L) >>> 2)) & 255);
      out[24 + outPos] = (byte)((
          //                       [_____210]
          //                            [210__________]
           ((in[14 + inPos] & 8191L) >>> 10)
        | //                       [76543___]
          //               [________43210]
           ((in[15 + inPos] & 8191L) <<  3)) & 255);
      out[25 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[15 + inPos] & 8191L) >>> 5)) & 255);
      out[26 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[16 + inPos] & 8191L))) & 255);
      out[27 + outPos] = (byte)((
          //                       [___43210]
          //                          [21098________]
           ((in[16 + inPos] & 8191L) >>> 8)
        | //                       [765_____]
          //             [__________210]
           ((in[17 + inPos] & 8191L) <<  5)) & 255);
      out[28 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[17 + inPos] & 8191L) >>> 3)) & 255);
      out[29 + outPos] = (byte)((
          //                       [______10]
          //                             [21___________]
           ((in[17 + inPos] & 8191L) >>> 11)
        | //                       [765432__]
          //                [_______543210]
           ((in[18 + inPos] & 8191L) <<  2)) & 255);
      out[30 + outPos] = (byte)((
          //                       [_6543210]
          //                        [2109876______]
           ((in[18 + inPos] & 8191L) >>> 6)
        | //                       [7_______]
          //           [____________0]
           ((in[19 + inPos] & 8191L) <<  7)) & 255);
      out[31 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[19 + inPos] & 8191L) >>> 1)) & 255);
      out[32 + outPos] = (byte)((
          //                       [____3210]
          //                           [2109_________]
           ((in[19 + inPos] & 8191L) >>> 9)
        | //                       [7654____]
          //              [_________3210]
           ((in[20 + inPos] & 8191L) <<  4)) & 255);
      out[33 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[20 + inPos] & 8191L) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                       [_______0]
          //                              [2____________]
           ((in[20 + inPos] & 8191L) >>> 12)
        | //                       [7654321_]
          //                 [______6543210]
           ((in[21 + inPos] & 8191L) <<  1)) & 255);
      out[35 + outPos] = (byte)((
          //                       [__543210]
          //                         [210987_______]
           ((in[21 + inPos] & 8191L) >>> 7)
        | //                       [76______]
          //            [___________10]
           ((in[22 + inPos] & 8191L) <<  6)) & 255);
      out[36 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[22 + inPos] & 8191L) >>> 2)) & 255);
      out[37 + outPos] = (byte)((
          //                       [_____210]
          //                            [210__________]
           ((in[22 + inPos] & 8191L) >>> 10)
        | //                       [76543___]
          //               [________43210]
           ((in[23 + inPos] & 8191L) <<  3)) & 255);
      out[38 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[23 + inPos] & 8191L) >>> 5)) & 255);
      out[39 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[24 + inPos] & 8191L))) & 255);
      out[40 + outPos] = (byte)((
          //                       [___43210]
          //                          [21098________]
           ((in[24 + inPos] & 8191L) >>> 8)
        | //                       [765_____]
          //             [__________210]
           ((in[25 + inPos] & 8191L) <<  5)) & 255);
      out[41 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[25 + inPos] & 8191L) >>> 3)) & 255);
      out[42 + outPos] = (byte)((
          //                       [______10]
          //                             [21___________]
           ((in[25 + inPos] & 8191L) >>> 11)
        | //                       [765432__]
          //                [_______543210]
           ((in[26 + inPos] & 8191L) <<  2)) & 255);
      out[43 + outPos] = (byte)((
          //                       [_6543210]
          //                        [2109876______]
           ((in[26 + inPos] & 8191L) >>> 6)
        | //                       [7_______]
          //           [____________0]
           ((in[27 + inPos] & 8191L) <<  7)) & 255);
      out[44 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[27 + inPos] & 8191L) >>> 1)) & 255);
      out[45 + outPos] = (byte)((
          //                       [____3210]
          //                           [2109_________]
           ((in[27 + inPos] & 8191L) >>> 9)
        | //                       [7654____]
          //              [_________3210]
           ((in[28 + inPos] & 8191L) <<  4)) & 255);
      out[46 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[28 + inPos] & 8191L) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                       [_______0]
          //                              [2____________]
           ((in[28 + inPos] & 8191L) >>> 12)
        | //                       [7654321_]
          //                 [______6543210]
           ((in[29 + inPos] & 8191L) <<  1)) & 255);
      out[48 + outPos] = (byte)((
          //                       [__543210]
          //                         [210987_______]
           ((in[29 + inPos] & 8191L) >>> 7)
        | //                       [76______]
          //            [___________10]
           ((in[30 + inPos] & 8191L) <<  6)) & 255);
      out[49 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[30 + inPos] & 8191L) >>> 2)) & 255);
      out[50 + outPos] = (byte)((
          //                       [_____210]
          //                            [210__________]
           ((in[30 + inPos] & 8191L) >>> 10)
        | //                       [76543___]
          //               [________43210]
           ((in[31 + inPos] & 8191L) <<  3)) & 255);
      out[51 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[31 + inPos] & 8191L) >>> 5)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in[ 1 + inPos]) <<  8) & 8191L);
      out[ 1 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in[ 1 + inPos]) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[ 2 + inPos]) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in[ 3 + inPos]) <<  11) & 8191L);
      out[ 2 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in[ 4 + inPos]) <<  6) & 8191L);
      out[ 3 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[ 5 + inPos]) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in[ 6 + inPos]) <<  9) & 8191L);
      out[ 4 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[ 7 + inPos]) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in[ 8 + inPos]) <<  12) & 8191L);
      out[ 5 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in[ 8 + inPos]) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in[ 9 + inPos]) <<  7) & 8191L);
      out[ 6 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in[ 9 + inPos]) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in[11 + inPos]) <<  10) & 8191L);
      out[ 7 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in[11 + inPos]) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in[12 + inPos]) <<  5) & 8191L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 8191L);
      out[ 1 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in.get( 1 + inPos)) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get( 2 + inPos)) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in.get( 3 + inPos)) <<  11) & 8191L);
      out[ 2 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get( 4 + inPos)) <<  6) & 8191L);
      out[ 3 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get( 5 + inPos)) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in.get( 6 + inPos)) <<  9) & 8191L);
      out[ 4 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get( 7 + inPos)) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 8191L);
      out[ 5 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get( 8 + inPos)) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in.get( 9 + inPos)) <<  7) & 8191L);
      out[ 6 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in.get( 9 + inPos)) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in.get(11 + inPos)) <<  10) & 8191L);
      out[ 7 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in.get(11 + inPos)) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(12 + inPos)) <<  5) & 8191L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in[ 1 + inPos]) <<  8) & 8191L);
      out[ 1 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in[ 1 + inPos]) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[ 2 + inPos]) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in[ 3 + inPos]) <<  11) & 8191L);
      out[ 2 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in[ 4 + inPos]) <<  6) & 8191L);
      out[ 3 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[ 5 + inPos]) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in[ 6 + inPos]) <<  9) & 8191L);
      out[ 4 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[ 7 + inPos]) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in[ 8 + inPos]) <<  12) & 8191L);
      out[ 5 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in[ 8 + inPos]) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in[ 9 + inPos]) <<  7) & 8191L);
      out[ 6 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in[ 9 + inPos]) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in[11 + inPos]) <<  10) & 8191L);
      out[ 7 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in[11 + inPos]) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in[12 + inPos]) <<  5) & 8191L);
      out[ 8 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in[13 + inPos]) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in[14 + inPos]) <<  8) & 8191L);
      out[ 9 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in[14 + inPos]) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[15 + inPos]) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in[16 + inPos]) <<  11) & 8191L);
      out[10 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in[16 + inPos]) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in[17 + inPos]) <<  6) & 8191L);
      out[11 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in[17 + inPos]) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[18 + inPos]) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in[19 + inPos]) <<  9) & 8191L);
      out[12 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in[19 + inPos]) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[20 + inPos]) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in[21 + inPos]) <<  12) & 8191L);
      out[13 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in[21 + inPos]) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in[22 + inPos]) <<  7) & 8191L);
      out[14 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in[22 + inPos]) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[23 + inPos]) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in[24 + inPos]) <<  10) & 8191L);
      out[15 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in[24 + inPos]) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in[25 + inPos]) <<  5) & 8191L);
      out[16 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in[26 + inPos]) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in[27 + inPos]) <<  8) & 8191L);
      out[17 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in[27 + inPos]) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[28 + inPos]) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in[29 + inPos]) <<  11) & 8191L);
      out[18 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in[29 + inPos]) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in[30 + inPos]) <<  6) & 8191L);
      out[19 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in[30 + inPos]) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[31 + inPos]) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in[32 + inPos]) <<  9) & 8191L);
      out[20 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in[32 + inPos]) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[33 + inPos]) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in[34 + inPos]) <<  12) & 8191L);
      out[21 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in[34 + inPos]) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in[35 + inPos]) <<  7) & 8191L);
      out[22 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in[35 + inPos]) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[36 + inPos]) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in[37 + inPos]) <<  10) & 8191L);
      out[23 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in[37 + inPos]) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in[38 + inPos]) <<  5) & 8191L);
      out[24 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in[39 + inPos]) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in[40 + inPos]) <<  8) & 8191L);
      out[25 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in[40 + inPos]) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[41 + inPos]) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in[42 + inPos]) <<  11) & 8191L);
      out[26 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in[42 + inPos]) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in[43 + inPos]) <<  6) & 8191L);
      out[27 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in[43 + inPos]) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[44 + inPos]) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in[45 + inPos]) <<  9) & 8191L);
      out[28 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in[45 + inPos]) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[46 + inPos]) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in[47 + inPos]) <<  12) & 8191L);
      out[29 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in[47 + inPos]) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in[48 + inPos]) <<  7) & 8191L);
      out[30 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in[48 + inPos]) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[49 + inPos]) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in[50 + inPos]) <<  10) & 8191L);
      out[31 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in[50 + inPos]) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in[51 + inPos]) <<  5) & 8191L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 8191L);
      out[ 1 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in.get( 1 + inPos)) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get( 2 + inPos)) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in.get( 3 + inPos)) <<  11) & 8191L);
      out[ 2 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get( 4 + inPos)) <<  6) & 8191L);
      out[ 3 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get( 5 + inPos)) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in.get( 6 + inPos)) <<  9) & 8191L);
      out[ 4 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get( 7 + inPos)) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 8191L);
      out[ 5 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get( 8 + inPos)) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in.get( 9 + inPos)) <<  7) & 8191L);
      out[ 6 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in.get( 9 + inPos)) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in.get(11 + inPos)) <<  10) & 8191L);
      out[ 7 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in.get(11 + inPos)) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(12 + inPos)) <<  5) & 8191L);
      out[ 8 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(13 + inPos)) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in.get(14 + inPos)) <<  8) & 8191L);
      out[ 9 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in.get(14 + inPos)) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(15 + inPos)) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in.get(16 + inPos)) <<  11) & 8191L);
      out[10 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in.get(16 + inPos)) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(17 + inPos)) <<  6) & 8191L);
      out[11 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in.get(17 + inPos)) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(18 + inPos)) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(19 + inPos)) <<  9) & 8191L);
      out[12 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(20 + inPos)) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in.get(21 + inPos)) <<  12) & 8191L);
      out[13 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(21 + inPos)) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(22 + inPos)) <<  7) & 8191L);
      out[14 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in.get(22 + inPos)) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(23 + inPos)) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in.get(24 + inPos)) <<  10) & 8191L);
      out[15 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in.get(24 + inPos)) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(25 + inPos)) <<  5) & 8191L);
      out[16 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(26 + inPos)) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in.get(27 + inPos)) <<  8) & 8191L);
      out[17 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in.get(27 + inPos)) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(28 + inPos)) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in.get(29 + inPos)) <<  11) & 8191L);
      out[18 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in.get(29 + inPos)) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(30 + inPos)) <<  6) & 8191L);
      out[19 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in.get(30 + inPos)) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(31 + inPos)) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(32 + inPos)) <<  9) & 8191L);
      out[20 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(33 + inPos)) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in.get(34 + inPos)) <<  12) & 8191L);
      out[21 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(34 + inPos)) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(35 + inPos)) <<  7) & 8191L);
      out[22 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in.get(35 + inPos)) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(36 + inPos)) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in.get(37 + inPos)) <<  10) & 8191L);
      out[23 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in.get(37 + inPos)) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(38 + inPos)) <<  5) & 8191L);
      out[24 + outPos] =
          //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(39 + inPos)) ) & 255L)
        | //                       [___43210]
          //                          [21098________]
            ((((long)in.get(40 + inPos)) <<  8) & 8191L);
      out[25 + outPos] =
          //                       [765_____]
          //             [__________210]
            ((((long)in.get(40 + inPos)) >>  5) & 7L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(41 + inPos)) <<  3) & 2047L)
        | //                       [______10]
          //                             [21___________]
            ((((long)in.get(42 + inPos)) <<  11) & 8191L);
      out[26 + outPos] =
          //                       [765432__]
          //                [_______543210]
            ((((long)in.get(42 + inPos)) >>  2) & 63L)
        | //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(43 + inPos)) <<  6) & 8191L);
      out[27 + outPos] =
          //                       [7_______]
          //           [____________0]
            ((((long)in.get(43 + inPos)) >>  7) & 1L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(44 + inPos)) <<  1) & 511L)
        | //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(45 + inPos)) <<  9) & 8191L);
      out[28 + outPos] =
          //                       [7654____]
          //              [_________3210]
            ((((long)in.get(45 + inPos)) >>  4) & 15L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(46 + inPos)) <<  4) & 4095L)
        | //                       [_______0]
          //                              [2____________]
            ((((long)in.get(47 + inPos)) <<  12) & 8191L);
      out[29 + outPos] =
          //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(47 + inPos)) >>  1) & 127L)
        | //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(48 + inPos)) <<  7) & 8191L);
      out[30 + outPos] =
          //                       [76______]
          //            [___________10]
            ((((long)in.get(48 + inPos)) >>  6) & 3L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(49 + inPos)) <<  2) & 1023L)
        | //                       [_____210]
          //                            [210__________]
            ((((long)in.get(50 + inPos)) <<  10) & 8191L);
      out[31 + outPos] =
          //                       [76543___]
          //               [________43210]
            ((((long)in.get(50 + inPos)) >>  3) & 31L)
        | //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(51 + inPos)) <<  5) & 8191L);
    }
  }

  private static final class Packer14 extends BytePackerForLong {

    private Packer14() {
      super(14);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 0 + inPos] & 16383L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[ 0 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[ 1 + inPos] & 16383L) <<  6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 1 + inPos] & 16383L) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[ 1 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[ 2 + inPos] & 16383L) <<  4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 2 + inPos] & 16383L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[ 2 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[ 3 + inPos] & 16383L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 3 + inPos] & 16383L) >>> 6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 4 + inPos] & 16383L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[ 4 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[ 5 + inPos] & 16383L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 5 + inPos] & 16383L) >>> 2)) & 255);
      out[10 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[ 5 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[ 6 + inPos] & 16383L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 6 + inPos] & 16383L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[ 6 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[ 7 + inPos] & 16383L) <<  2)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 7 + inPos] & 16383L) >>> 6)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 0 + inPos] & 16383L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[ 0 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[ 1 + inPos] & 16383L) <<  6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 1 + inPos] & 16383L) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[ 1 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[ 2 + inPos] & 16383L) <<  4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 2 + inPos] & 16383L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[ 2 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[ 3 + inPos] & 16383L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 3 + inPos] & 16383L) >>> 6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 4 + inPos] & 16383L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[ 4 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[ 5 + inPos] & 16383L) <<  6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 5 + inPos] & 16383L) >>> 2)) & 255);
      out[10 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[ 5 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[ 6 + inPos] & 16383L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 6 + inPos] & 16383L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[ 6 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[ 7 + inPos] & 16383L) <<  2)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 7 + inPos] & 16383L) >>> 6)) & 255);
      out[14 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 8 + inPos] & 16383L))) & 255);
      out[15 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[ 8 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[ 9 + inPos] & 16383L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 9 + inPos] & 16383L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[ 9 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[10 + inPos] & 16383L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[10 + inPos] & 16383L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[10 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[11 + inPos] & 16383L) <<  2)) & 255);
      out[20 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[11 + inPos] & 16383L) >>> 6)) & 255);
      out[21 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[12 + inPos] & 16383L))) & 255);
      out[22 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[12 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[13 + inPos] & 16383L) <<  6)) & 255);
      out[23 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[13 + inPos] & 16383L) >>> 2)) & 255);
      out[24 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[13 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[14 + inPos] & 16383L) <<  4)) & 255);
      out[25 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[14 + inPos] & 16383L) >>> 4)) & 255);
      out[26 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[14 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[15 + inPos] & 16383L) <<  2)) & 255);
      out[27 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[15 + inPos] & 16383L) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[16 + inPos] & 16383L))) & 255);
      out[29 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[16 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[17 + inPos] & 16383L) <<  6)) & 255);
      out[30 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[17 + inPos] & 16383L) >>> 2)) & 255);
      out[31 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[17 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[18 + inPos] & 16383L) <<  4)) & 255);
      out[32 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[18 + inPos] & 16383L) >>> 4)) & 255);
      out[33 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[18 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[19 + inPos] & 16383L) <<  2)) & 255);
      out[34 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[19 + inPos] & 16383L) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[20 + inPos] & 16383L))) & 255);
      out[36 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[20 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[21 + inPos] & 16383L) <<  6)) & 255);
      out[37 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[21 + inPos] & 16383L) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[21 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[22 + inPos] & 16383L) <<  4)) & 255);
      out[39 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[22 + inPos] & 16383L) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[22 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[23 + inPos] & 16383L) <<  2)) & 255);
      out[41 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[23 + inPos] & 16383L) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[24 + inPos] & 16383L))) & 255);
      out[43 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[24 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[25 + inPos] & 16383L) <<  6)) & 255);
      out[44 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[25 + inPos] & 16383L) >>> 2)) & 255);
      out[45 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[25 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[26 + inPos] & 16383L) <<  4)) & 255);
      out[46 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[26 + inPos] & 16383L) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[26 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[27 + inPos] & 16383L) <<  2)) & 255);
      out[48 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[27 + inPos] & 16383L) >>> 6)) & 255);
      out[49 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[28 + inPos] & 16383L))) & 255);
      out[50 + outPos] = (byte)((
          //                        [__543210]
          //                          [321098________]
           ((in[28 + inPos] & 16383L) >>> 8)
        | //                        [76______]
          //            [____________10]
           ((in[29 + inPos] & 16383L) <<  6)) & 255);
      out[51 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[29 + inPos] & 16383L) >>> 2)) & 255);
      out[52 + outPos] = (byte)((
          //                        [____3210]
          //                            [3210__________]
           ((in[29 + inPos] & 16383L) >>> 10)
        | //                        [7654____]
          //              [__________3210]
           ((in[30 + inPos] & 16383L) <<  4)) & 255);
      out[53 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[30 + inPos] & 16383L) >>> 4)) & 255);
      out[54 + outPos] = (byte)((
          //                        [______10]
          //                              [32____________]
           ((in[30 + inPos] & 16383L) >>> 12)
        | //                        [765432__]
          //                [________543210]
           ((in[31 + inPos] & 16383L) <<  2)) & 255);
      out[55 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[31 + inPos] & 16383L) >>> 6)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 16383L);
      out[ 1 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 2 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 16383L);
      out[ 2 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[ 5 + inPos]) <<  12) & 16383L);
      out[ 3 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 6 + inPos]) <<  6) & 16383L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 7 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 16383L);
      out[ 5 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 9 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[10 + inPos]) <<  10) & 16383L);
      out[ 6 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[12 + inPos]) <<  12) & 16383L);
      out[ 7 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[12 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[13 + inPos]) <<  6) & 16383L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 16383L);
      out[ 1 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 16383L);
      out[ 2 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 16383L);
      out[ 3 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 6 + inPos)) <<  6) & 16383L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 16383L);
      out[ 5 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(10 + inPos)) <<  10) & 16383L);
      out[ 6 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(12 + inPos)) <<  12) & 16383L);
      out[ 7 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(13 + inPos)) <<  6) & 16383L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 16383L);
      out[ 1 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 2 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 16383L);
      out[ 2 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[ 5 + inPos]) <<  12) & 16383L);
      out[ 3 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 6 + inPos]) <<  6) & 16383L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 7 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 16383L);
      out[ 5 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 9 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[10 + inPos]) <<  10) & 16383L);
      out[ 6 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[12 + inPos]) <<  12) & 16383L);
      out[ 7 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[12 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[13 + inPos]) <<  6) & 16383L);
      out[ 8 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[14 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[15 + inPos]) <<  8) & 16383L);
      out[ 9 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[17 + inPos]) <<  10) & 16383L);
      out[10 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[18 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[19 + inPos]) <<  12) & 16383L);
      out[11 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[19 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[20 + inPos]) <<  6) & 16383L);
      out[12 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[21 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[22 + inPos]) <<  8) & 16383L);
      out[13 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[22 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[23 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[24 + inPos]) <<  10) & 16383L);
      out[14 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[24 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[25 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[26 + inPos]) <<  12) & 16383L);
      out[15 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[26 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[27 + inPos]) <<  6) & 16383L);
      out[16 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[28 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[29 + inPos]) <<  8) & 16383L);
      out[17 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[29 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[30 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[31 + inPos]) <<  10) & 16383L);
      out[18 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[32 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[33 + inPos]) <<  12) & 16383L);
      out[19 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[33 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[34 + inPos]) <<  6) & 16383L);
      out[20 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[35 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[36 + inPos]) <<  8) & 16383L);
      out[21 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[36 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[37 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[38 + inPos]) <<  10) & 16383L);
      out[22 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[38 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[39 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[40 + inPos]) <<  12) & 16383L);
      out[23 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[40 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[41 + inPos]) <<  6) & 16383L);
      out[24 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[42 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[43 + inPos]) <<  8) & 16383L);
      out[25 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[43 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[44 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[45 + inPos]) <<  10) & 16383L);
      out[26 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[45 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[46 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[47 + inPos]) <<  12) & 16383L);
      out[27 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[47 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[48 + inPos]) <<  6) & 16383L);
      out[28 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in[49 + inPos]) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in[50 + inPos]) <<  8) & 16383L);
      out[29 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in[50 + inPos]) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[51 + inPos]) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in[52 + inPos]) <<  10) & 16383L);
      out[30 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[53 + inPos]) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in[54 + inPos]) <<  12) & 16383L);
      out[31 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in[54 + inPos]) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in[55 + inPos]) <<  6) & 16383L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 16383L);
      out[ 1 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 16383L);
      out[ 2 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 16383L);
      out[ 3 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 6 + inPos)) <<  6) & 16383L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 16383L);
      out[ 5 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 9 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(10 + inPos)) <<  10) & 16383L);
      out[ 6 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(12 + inPos)) <<  12) & 16383L);
      out[ 7 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(13 + inPos)) <<  6) & 16383L);
      out[ 8 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(14 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(15 + inPos)) <<  8) & 16383L);
      out[ 9 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 16383L);
      out[10 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(19 + inPos)) <<  12) & 16383L);
      out[11 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(19 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(20 + inPos)) <<  6) & 16383L);
      out[12 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(21 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(22 + inPos)) <<  8) & 16383L);
      out[13 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(22 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(23 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(24 + inPos)) <<  10) & 16383L);
      out[14 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(24 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(25 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(26 + inPos)) <<  12) & 16383L);
      out[15 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(26 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(27 + inPos)) <<  6) & 16383L);
      out[16 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(28 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(29 + inPos)) <<  8) & 16383L);
      out[17 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(29 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(30 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(31 + inPos)) <<  10) & 16383L);
      out[18 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(32 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(33 + inPos)) <<  12) & 16383L);
      out[19 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(34 + inPos)) <<  6) & 16383L);
      out[20 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(35 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(36 + inPos)) <<  8) & 16383L);
      out[21 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(36 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(37 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(38 + inPos)) <<  10) & 16383L);
      out[22 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(39 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(40 + inPos)) <<  12) & 16383L);
      out[23 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(40 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(41 + inPos)) <<  6) & 16383L);
      out[24 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(42 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 16383L);
      out[25 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(43 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(44 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(45 + inPos)) <<  10) & 16383L);
      out[26 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(45 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(46 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(47 + inPos)) <<  12) & 16383L);
      out[27 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(47 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(48 + inPos)) <<  6) & 16383L);
      out[28 + outPos] =
          //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(49 + inPos)) ) & 255L)
        | //                        [__543210]
          //                          [321098________]
            ((((long)in.get(50 + inPos)) <<  8) & 16383L);
      out[29 + outPos] =
          //                        [76______]
          //            [____________10]
            ((((long)in.get(50 + inPos)) >>  6) & 3L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(51 + inPos)) <<  2) & 1023L)
        | //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(52 + inPos)) <<  10) & 16383L);
      out[30 + outPos] =
          //                        [7654____]
          //              [__________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(53 + inPos)) <<  4) & 4095L)
        | //                        [______10]
          //                              [32____________]
            ((((long)in.get(54 + inPos)) <<  12) & 16383L);
      out[31 + outPos] =
          //                        [765432__]
          //                [________543210]
            ((((long)in.get(54 + inPos)) >>  2) & 63L)
        | //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(55 + inPos)) <<  6) & 16383L);
    }
  }

  private static final class Packer15 extends BytePackerForLong {

    private Packer15() {
      super(15);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 0 + inPos] & 32767L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [_6543210]
          //                          [4321098________]
           ((in[ 0 + inPos] & 32767L) >>> 8)
        | //                         [7_______]
          //           [______________0]
           ((in[ 1 + inPos] & 32767L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 1 + inPos] & 32767L) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [__543210]
          //                           [432109_________]
           ((in[ 1 + inPos] & 32767L) >>> 9)
        | //                         [76______]
          //            [_____________10]
           ((in[ 2 + inPos] & 32767L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 2 + inPos] & 32767L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [___43210]
          //                            [43210__________]
           ((in[ 2 + inPos] & 32767L) >>> 10)
        | //                         [765_____]
          //             [____________210]
           ((in[ 3 + inPos] & 32767L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 3 + inPos] & 32767L) >>> 3)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [____3210]
          //                             [4321___________]
           ((in[ 3 + inPos] & 32767L) >>> 11)
        | //                         [7654____]
          //              [___________3210]
           ((in[ 4 + inPos] & 32767L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 4 + inPos] & 32767L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [_____210]
          //                              [432____________]
           ((in[ 4 + inPos] & 32767L) >>> 12)
        | //                         [76543___]
          //               [__________43210]
           ((in[ 5 + inPos] & 32767L) <<  3)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 5 + inPos] & 32767L) >>> 5)) & 255);
      out[11 + outPos] = (byte)((
          //                         [______10]
          //                               [43_____________]
           ((in[ 5 + inPos] & 32767L) >>> 13)
        | //                         [765432__]
          //                [_________543210]
           ((in[ 6 + inPos] & 32767L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 6 + inPos] & 32767L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                         [_______0]
          //                                [4______________]
           ((in[ 6 + inPos] & 32767L) >>> 14)
        | //                         [7654321_]
          //                 [________6543210]
           ((in[ 7 + inPos] & 32767L) <<  1)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 7 + inPos] & 32767L) >>> 7)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 0 + inPos] & 32767L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [_6543210]
          //                          [4321098________]
           ((in[ 0 + inPos] & 32767L) >>> 8)
        | //                         [7_______]
          //           [______________0]
           ((in[ 1 + inPos] & 32767L) <<  7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 1 + inPos] & 32767L) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [__543210]
          //                           [432109_________]
           ((in[ 1 + inPos] & 32767L) >>> 9)
        | //                         [76______]
          //            [_____________10]
           ((in[ 2 + inPos] & 32767L) <<  6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 2 + inPos] & 32767L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [___43210]
          //                            [43210__________]
           ((in[ 2 + inPos] & 32767L) >>> 10)
        | //                         [765_____]
          //             [____________210]
           ((in[ 3 + inPos] & 32767L) <<  5)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 3 + inPos] & 32767L) >>> 3)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [____3210]
          //                             [4321___________]
           ((in[ 3 + inPos] & 32767L) >>> 11)
        | //                         [7654____]
          //              [___________3210]
           ((in[ 4 + inPos] & 32767L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 4 + inPos] & 32767L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [_____210]
          //                              [432____________]
           ((in[ 4 + inPos] & 32767L) >>> 12)
        | //                         [76543___]
          //               [__________43210]
           ((in[ 5 + inPos] & 32767L) <<  3)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 5 + inPos] & 32767L) >>> 5)) & 255);
      out[11 + outPos] = (byte)((
          //                         [______10]
          //                               [43_____________]
           ((in[ 5 + inPos] & 32767L) >>> 13)
        | //                         [765432__]
          //                [_________543210]
           ((in[ 6 + inPos] & 32767L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 6 + inPos] & 32767L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                         [_______0]
          //                                [4______________]
           ((in[ 6 + inPos] & 32767L) >>> 14)
        | //                         [7654321_]
          //                 [________6543210]
           ((in[ 7 + inPos] & 32767L) <<  1)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 7 + inPos] & 32767L) >>> 7)) & 255);
      out[15 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 8 + inPos] & 32767L))) & 255);
      out[16 + outPos] = (byte)((
          //                         [_6543210]
          //                          [4321098________]
           ((in[ 8 + inPos] & 32767L) >>> 8)
        | //                         [7_______]
          //           [______________0]
           ((in[ 9 + inPos] & 32767L) <<  7)) & 255);
      out[17 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 9 + inPos] & 32767L) >>> 1)) & 255);
      out[18 + outPos] = (byte)((
          //                         [__543210]
          //                           [432109_________]
           ((in[ 9 + inPos] & 32767L) >>> 9)
        | //                         [76______]
          //            [_____________10]
           ((in[10 + inPos] & 32767L) <<  6)) & 255);
      out[19 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[10 + inPos] & 32767L) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                         [___43210]
          //                            [43210__________]
           ((in[10 + inPos] & 32767L) >>> 10)
        | //                         [765_____]
          //             [____________210]
           ((in[11 + inPos] & 32767L) <<  5)) & 255);
      out[21 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[11 + inPos] & 32767L) >>> 3)) & 255);
      out[22 + outPos] = (byte)((
          //                         [____3210]
          //                             [4321___________]
           ((in[11 + inPos] & 32767L) >>> 11)
        | //                         [7654____]
          //              [___________3210]
           ((in[12 + inPos] & 32767L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[12 + inPos] & 32767L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                         [_____210]
          //                              [432____________]
           ((in[12 + inPos] & 32767L) >>> 12)
        | //                         [76543___]
          //               [__________43210]
           ((in[13 + inPos] & 32767L) <<  3)) & 255);
      out[25 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[13 + inPos] & 32767L) >>> 5)) & 255);
      out[26 + outPos] = (byte)((
          //                         [______10]
          //                               [43_____________]
           ((in[13 + inPos] & 32767L) >>> 13)
        | //                         [765432__]
          //                [_________543210]
           ((in[14 + inPos] & 32767L) <<  2)) & 255);
      out[27 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[14 + inPos] & 32767L) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                         [_______0]
          //                                [4______________]
           ((in[14 + inPos] & 32767L) >>> 14)
        | //                         [7654321_]
          //                 [________6543210]
           ((in[15 + inPos] & 32767L) <<  1)) & 255);
      out[29 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[15 + inPos] & 32767L) >>> 7)) & 255);
      out[30 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[16 + inPos] & 32767L))) & 255);
      out[31 + outPos] = (byte)((
          //                         [_6543210]
          //                          [4321098________]
           ((in[16 + inPos] & 32767L) >>> 8)
        | //                         [7_______]
          //           [______________0]
           ((in[17 + inPos] & 32767L) <<  7)) & 255);
      out[32 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[17 + inPos] & 32767L) >>> 1)) & 255);
      out[33 + outPos] = (byte)((
          //                         [__543210]
          //                           [432109_________]
           ((in[17 + inPos] & 32767L) >>> 9)
        | //                         [76______]
          //            [_____________10]
           ((in[18 + inPos] & 32767L) <<  6)) & 255);
      out[34 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[18 + inPos] & 32767L) >>> 2)) & 255);
      out[35 + outPos] = (byte)((
          //                         [___43210]
          //                            [43210__________]
           ((in[18 + inPos] & 32767L) >>> 10)
        | //                         [765_____]
          //             [____________210]
           ((in[19 + inPos] & 32767L) <<  5)) & 255);
      out[36 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[19 + inPos] & 32767L) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                         [____3210]
          //                             [4321___________]
           ((in[19 + inPos] & 32767L) >>> 11)
        | //                         [7654____]
          //              [___________3210]
           ((in[20 + inPos] & 32767L) <<  4)) & 255);
      out[38 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[20 + inPos] & 32767L) >>> 4)) & 255);
      out[39 + outPos] = (byte)((
          //                         [_____210]
          //                              [432____________]
           ((in[20 + inPos] & 32767L) >>> 12)
        | //                         [76543___]
          //               [__________43210]
           ((in[21 + inPos] & 32767L) <<  3)) & 255);
      out[40 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[21 + inPos] & 32767L) >>> 5)) & 255);
      out[41 + outPos] = (byte)((
          //                         [______10]
          //                               [43_____________]
           ((in[21 + inPos] & 32767L) >>> 13)
        | //                         [765432__]
          //                [_________543210]
           ((in[22 + inPos] & 32767L) <<  2)) & 255);
      out[42 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[22 + inPos] & 32767L) >>> 6)) & 255);
      out[43 + outPos] = (byte)((
          //                         [_______0]
          //                                [4______________]
           ((in[22 + inPos] & 32767L) >>> 14)
        | //                         [7654321_]
          //                 [________6543210]
           ((in[23 + inPos] & 32767L) <<  1)) & 255);
      out[44 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[23 + inPos] & 32767L) >>> 7)) & 255);
      out[45 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[24 + inPos] & 32767L))) & 255);
      out[46 + outPos] = (byte)((
          //                         [_6543210]
          //                          [4321098________]
           ((in[24 + inPos] & 32767L) >>> 8)
        | //                         [7_______]
          //           [______________0]
           ((in[25 + inPos] & 32767L) <<  7)) & 255);
      out[47 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[25 + inPos] & 32767L) >>> 1)) & 255);
      out[48 + outPos] = (byte)((
          //                         [__543210]
          //                           [432109_________]
           ((in[25 + inPos] & 32767L) >>> 9)
        | //                         [76______]
          //            [_____________10]
           ((in[26 + inPos] & 32767L) <<  6)) & 255);
      out[49 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[26 + inPos] & 32767L) >>> 2)) & 255);
      out[50 + outPos] = (byte)((
          //                         [___43210]
          //                            [43210__________]
           ((in[26 + inPos] & 32767L) >>> 10)
        | //                         [765_____]
          //             [____________210]
           ((in[27 + inPos] & 32767L) <<  5)) & 255);
      out[51 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[27 + inPos] & 32767L) >>> 3)) & 255);
      out[52 + outPos] = (byte)((
          //                         [____3210]
          //                             [4321___________]
           ((in[27 + inPos] & 32767L) >>> 11)
        | //                         [7654____]
          //              [___________3210]
           ((in[28 + inPos] & 32767L) <<  4)) & 255);
      out[53 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[28 + inPos] & 32767L) >>> 4)) & 255);
      out[54 + outPos] = (byte)((
          //                         [_____210]
          //                              [432____________]
           ((in[28 + inPos] & 32767L) >>> 12)
        | //                         [76543___]
          //               [__________43210]
           ((in[29 + inPos] & 32767L) <<  3)) & 255);
      out[55 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[29 + inPos] & 32767L) >>> 5)) & 255);
      out[56 + outPos] = (byte)((
          //                         [______10]
          //                               [43_____________]
           ((in[29 + inPos] & 32767L) >>> 13)
        | //                         [765432__]
          //                [_________543210]
           ((in[30 + inPos] & 32767L) <<  2)) & 255);
      out[57 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[30 + inPos] & 32767L) >>> 6)) & 255);
      out[58 + outPos] = (byte)((
          //                         [_______0]
          //                                [4______________]
           ((in[30 + inPos] & 32767L) >>> 14)
        | //                         [7654321_]
          //                 [________6543210]
           ((in[31 + inPos] & 32767L) <<  1)) & 255);
      out[59 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[31 + inPos] & 32767L) >>> 7)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 32767L);
      out[ 1 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[ 2 + inPos]) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in[ 3 + inPos]) <<  9) & 32767L);
      out[ 2 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in[ 5 + inPos]) <<  10) & 32767L);
      out[ 3 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[ 6 + inPos]) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in[ 7 + inPos]) <<  11) & 32767L);
      out[ 4 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 32767L);
      out[ 5 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[10 + inPos]) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in[11 + inPos]) <<  13) & 32767L);
      out[ 6 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in[13 + inPos]) <<  14) & 32767L);
      out[ 7 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in[13 + inPos]) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in[14 + inPos]) <<  7) & 32767L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 32767L);
      out[ 1 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in.get( 3 + inPos)) <<  9) & 32767L);
      out[ 2 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in.get( 5 + inPos)) <<  10) & 32767L);
      out[ 3 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get( 6 + inPos)) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in.get( 7 + inPos)) <<  11) & 32767L);
      out[ 4 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in.get( 9 + inPos)) <<  12) & 32767L);
      out[ 5 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(10 + inPos)) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in.get(11 + inPos)) <<  13) & 32767L);
      out[ 6 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in.get(13 + inPos)) <<  14) & 32767L);
      out[ 7 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(13 + inPos)) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(14 + inPos)) <<  7) & 32767L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 32767L);
      out[ 1 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[ 2 + inPos]) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in[ 3 + inPos]) <<  9) & 32767L);
      out[ 2 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in[ 5 + inPos]) <<  10) & 32767L);
      out[ 3 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in[ 5 + inPos]) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[ 6 + inPos]) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in[ 7 + inPos]) <<  11) & 32767L);
      out[ 4 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 32767L);
      out[ 5 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[10 + inPos]) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in[11 + inPos]) <<  13) & 32767L);
      out[ 6 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in[13 + inPos]) <<  14) & 32767L);
      out[ 7 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in[13 + inPos]) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in[14 + inPos]) <<  7) & 32767L);
      out[ 8 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in[15 + inPos]) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in[16 + inPos]) <<  8) & 32767L);
      out[ 9 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in[16 + inPos]) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[17 + inPos]) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in[18 + inPos]) <<  9) & 32767L);
      out[10 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in[18 + inPos]) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[19 + inPos]) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in[20 + inPos]) <<  10) & 32767L);
      out[11 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in[20 + inPos]) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[21 + inPos]) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in[22 + inPos]) <<  11) & 32767L);
      out[12 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[23 + inPos]) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in[24 + inPos]) <<  12) & 32767L);
      out[13 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in[24 + inPos]) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[25 + inPos]) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in[26 + inPos]) <<  13) & 32767L);
      out[14 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in[26 + inPos]) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[27 + inPos]) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in[28 + inPos]) <<  14) & 32767L);
      out[15 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in[28 + inPos]) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in[29 + inPos]) <<  7) & 32767L);
      out[16 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in[30 + inPos]) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in[31 + inPos]) <<  8) & 32767L);
      out[17 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in[31 + inPos]) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[32 + inPos]) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in[33 + inPos]) <<  9) & 32767L);
      out[18 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in[33 + inPos]) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[34 + inPos]) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in[35 + inPos]) <<  10) & 32767L);
      out[19 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in[35 + inPos]) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[36 + inPos]) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in[37 + inPos]) <<  11) & 32767L);
      out[20 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[38 + inPos]) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in[39 + inPos]) <<  12) & 32767L);
      out[21 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in[39 + inPos]) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[40 + inPos]) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in[41 + inPos]) <<  13) & 32767L);
      out[22 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in[41 + inPos]) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[42 + inPos]) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in[43 + inPos]) <<  14) & 32767L);
      out[23 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in[43 + inPos]) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in[44 + inPos]) <<  7) & 32767L);
      out[24 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in[45 + inPos]) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in[46 + inPos]) <<  8) & 32767L);
      out[25 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in[46 + inPos]) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[47 + inPos]) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in[48 + inPos]) <<  9) & 32767L);
      out[26 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in[48 + inPos]) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[49 + inPos]) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in[50 + inPos]) <<  10) & 32767L);
      out[27 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in[50 + inPos]) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[51 + inPos]) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in[52 + inPos]) <<  11) & 32767L);
      out[28 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[53 + inPos]) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in[54 + inPos]) <<  12) & 32767L);
      out[29 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in[54 + inPos]) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[55 + inPos]) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in[56 + inPos]) <<  13) & 32767L);
      out[30 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in[56 + inPos]) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[57 + inPos]) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in[58 + inPos]) <<  14) & 32767L);
      out[31 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in[58 + inPos]) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in[59 + inPos]) <<  7) & 32767L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 32767L);
      out[ 1 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in.get( 3 + inPos)) <<  9) & 32767L);
      out[ 2 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in.get( 5 + inPos)) <<  10) & 32767L);
      out[ 3 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in.get( 5 + inPos)) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get( 6 + inPos)) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in.get( 7 + inPos)) <<  11) & 32767L);
      out[ 4 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in.get( 9 + inPos)) <<  12) & 32767L);
      out[ 5 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(10 + inPos)) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in.get(11 + inPos)) <<  13) & 32767L);
      out[ 6 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in.get(13 + inPos)) <<  14) & 32767L);
      out[ 7 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(13 + inPos)) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(14 + inPos)) <<  7) & 32767L);
      out[ 8 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(15 + inPos)) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 32767L);
      out[ 9 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in.get(16 + inPos)) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(17 + inPos)) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(18 + inPos)) <<  9) & 32767L);
      out[10 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in.get(18 + inPos)) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(19 + inPos)) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(20 + inPos)) <<  10) & 32767L);
      out[11 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in.get(20 + inPos)) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(21 + inPos)) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(22 + inPos)) <<  11) & 32767L);
      out[12 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in.get(24 + inPos)) <<  12) & 32767L);
      out[13 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in.get(24 + inPos)) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(25 + inPos)) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in.get(26 + inPos)) <<  13) & 32767L);
      out[14 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in.get(26 + inPos)) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(27 + inPos)) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in.get(28 + inPos)) <<  14) & 32767L);
      out[15 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(28 + inPos)) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(29 + inPos)) <<  7) & 32767L);
      out[16 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(30 + inPos)) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(31 + inPos)) <<  8) & 32767L);
      out[17 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in.get(31 + inPos)) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(32 + inPos)) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(33 + inPos)) <<  9) & 32767L);
      out[18 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(34 + inPos)) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(35 + inPos)) <<  10) & 32767L);
      out[19 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in.get(35 + inPos)) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(36 + inPos)) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(37 + inPos)) <<  11) & 32767L);
      out[20 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(38 + inPos)) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in.get(39 + inPos)) <<  12) & 32767L);
      out[21 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in.get(39 + inPos)) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(40 + inPos)) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in.get(41 + inPos)) <<  13) & 32767L);
      out[22 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in.get(41 + inPos)) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(42 + inPos)) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in.get(43 + inPos)) <<  14) & 32767L);
      out[23 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(43 + inPos)) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(44 + inPos)) <<  7) & 32767L);
      out[24 + outPos] =
          //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(45 + inPos)) ) & 255L)
        | //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(46 + inPos)) <<  8) & 32767L);
      out[25 + outPos] =
          //                         [7_______]
          //           [______________0]
            ((((long)in.get(46 + inPos)) >>  7) & 1L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(47 + inPos)) <<  1) & 511L)
        | //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(48 + inPos)) <<  9) & 32767L);
      out[26 + outPos] =
          //                         [76______]
          //            [_____________10]
            ((((long)in.get(48 + inPos)) >>  6) & 3L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(49 + inPos)) <<  2) & 1023L)
        | //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(50 + inPos)) <<  10) & 32767L);
      out[27 + outPos] =
          //                         [765_____]
          //             [____________210]
            ((((long)in.get(50 + inPos)) >>  5) & 7L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(51 + inPos)) <<  3) & 2047L)
        | //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(52 + inPos)) <<  11) & 32767L);
      out[28 + outPos] =
          //                         [7654____]
          //              [___________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(53 + inPos)) <<  4) & 4095L)
        | //                         [_____210]
          //                              [432____________]
            ((((long)in.get(54 + inPos)) <<  12) & 32767L);
      out[29 + outPos] =
          //                         [76543___]
          //               [__________43210]
            ((((long)in.get(54 + inPos)) >>  3) & 31L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(55 + inPos)) <<  5) & 8191L)
        | //                         [______10]
          //                               [43_____________]
            ((((long)in.get(56 + inPos)) <<  13) & 32767L);
      out[30 + outPos] =
          //                         [765432__]
          //                [_________543210]
            ((((long)in.get(56 + inPos)) >>  2) & 63L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(57 + inPos)) <<  6) & 16383L)
        | //                         [_______0]
          //                                [4______________]
            ((((long)in.get(58 + inPos)) <<  14) & 32767L);
      out[31 + outPos] =
          //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(58 + inPos)) >>  1) & 127L)
        | //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(59 + inPos)) <<  7) & 32767L);
    }
  }

  private static final class Packer16 extends BytePackerForLong {

    private Packer16() {
      super(16);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535L) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535L))) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535L))) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535L))) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535L) >>> 8)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535L) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535L))) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535L))) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535L))) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535L) >>> 8)) & 255);
      out[16 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 8 + inPos] & 65535L))) & 255);
      out[17 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 8 + inPos] & 65535L) >>> 8)) & 255);
      out[18 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 9 + inPos] & 65535L))) & 255);
      out[19 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 9 + inPos] & 65535L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[10 + inPos] & 65535L))) & 255);
      out[21 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[10 + inPos] & 65535L) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[11 + inPos] & 65535L))) & 255);
      out[23 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[11 + inPos] & 65535L) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[12 + inPos] & 65535L))) & 255);
      out[25 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[12 + inPos] & 65535L) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[13 + inPos] & 65535L))) & 255);
      out[27 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[13 + inPos] & 65535L) >>> 8)) & 255);
      out[28 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[14 + inPos] & 65535L))) & 255);
      out[29 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[14 + inPos] & 65535L) >>> 8)) & 255);
      out[30 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[15 + inPos] & 65535L))) & 255);
      out[31 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[15 + inPos] & 65535L) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[16 + inPos] & 65535L))) & 255);
      out[33 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[16 + inPos] & 65535L) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[17 + inPos] & 65535L))) & 255);
      out[35 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[17 + inPos] & 65535L) >>> 8)) & 255);
      out[36 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[18 + inPos] & 65535L))) & 255);
      out[37 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[18 + inPos] & 65535L) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[19 + inPos] & 65535L))) & 255);
      out[39 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[19 + inPos] & 65535L) >>> 8)) & 255);
      out[40 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[20 + inPos] & 65535L))) & 255);
      out[41 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[20 + inPos] & 65535L) >>> 8)) & 255);
      out[42 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[21 + inPos] & 65535L))) & 255);
      out[43 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[21 + inPos] & 65535L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[22 + inPos] & 65535L))) & 255);
      out[45 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[22 + inPos] & 65535L) >>> 8)) & 255);
      out[46 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[23 + inPos] & 65535L))) & 255);
      out[47 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[23 + inPos] & 65535L) >>> 8)) & 255);
      out[48 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[24 + inPos] & 65535L))) & 255);
      out[49 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[24 + inPos] & 65535L) >>> 8)) & 255);
      out[50 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[25 + inPos] & 65535L))) & 255);
      out[51 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[25 + inPos] & 65535L) >>> 8)) & 255);
      out[52 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[26 + inPos] & 65535L))) & 255);
      out[53 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[26 + inPos] & 65535L) >>> 8)) & 255);
      out[54 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[27 + inPos] & 65535L))) & 255);
      out[55 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[27 + inPos] & 65535L) >>> 8)) & 255);
      out[56 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[28 + inPos] & 65535L))) & 255);
      out[57 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[28 + inPos] & 65535L) >>> 8)) & 255);
      out[58 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[29 + inPos] & 65535L))) & 255);
      out[59 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[29 + inPos] & 65535L) >>> 8)) & 255);
      out[60 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[30 + inPos] & 65535L))) & 255);
      out[61 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[30 + inPos] & 65535L) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[31 + inPos] & 65535L))) & 255);
      out[63 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[31 + inPos] & 65535L) >>> 8)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 2 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 3 + inPos]) <<  8) & 65535L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 4 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 5 + inPos]) <<  8) & 65535L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 6 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 7 + inPos]) <<  8) & 65535L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 8 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 9 + inPos]) <<  8) & 65535L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[10 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[11 + inPos]) <<  8) & 65535L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[12 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[13 + inPos]) <<  8) & 65535L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[14 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[15 + inPos]) <<  8) & 65535L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 3 + inPos)) <<  8) & 65535L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 5 + inPos)) <<  8) & 65535L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 65535L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 65535L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(11 + inPos)) <<  8) & 65535L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(12 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 65535L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(14 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(15 + inPos)) <<  8) & 65535L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 2 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 3 + inPos]) <<  8) & 65535L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 4 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 5 + inPos]) <<  8) & 65535L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 6 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 7 + inPos]) <<  8) & 65535L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 8 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 9 + inPos]) <<  8) & 65535L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[10 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[11 + inPos]) <<  8) & 65535L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[12 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[13 + inPos]) <<  8) & 65535L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[14 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[15 + inPos]) <<  8) & 65535L);
      out[ 8 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[16 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[17 + inPos]) <<  8) & 65535L);
      out[ 9 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[18 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[19 + inPos]) <<  8) & 65535L);
      out[10 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[20 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[21 + inPos]) <<  8) & 65535L);
      out[11 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[22 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[23 + inPos]) <<  8) & 65535L);
      out[12 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[24 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[25 + inPos]) <<  8) & 65535L);
      out[13 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[26 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[27 + inPos]) <<  8) & 65535L);
      out[14 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[28 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[29 + inPos]) <<  8) & 65535L);
      out[15 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[30 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[31 + inPos]) <<  8) & 65535L);
      out[16 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[32 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[33 + inPos]) <<  8) & 65535L);
      out[17 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[34 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[35 + inPos]) <<  8) & 65535L);
      out[18 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[36 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[37 + inPos]) <<  8) & 65535L);
      out[19 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[38 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[39 + inPos]) <<  8) & 65535L);
      out[20 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[40 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[41 + inPos]) <<  8) & 65535L);
      out[21 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[42 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[43 + inPos]) <<  8) & 65535L);
      out[22 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[44 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[45 + inPos]) <<  8) & 65535L);
      out[23 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[46 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[47 + inPos]) <<  8) & 65535L);
      out[24 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[48 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[49 + inPos]) <<  8) & 65535L);
      out[25 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[50 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[51 + inPos]) <<  8) & 65535L);
      out[26 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[52 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[53 + inPos]) <<  8) & 65535L);
      out[27 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[54 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[55 + inPos]) <<  8) & 65535L);
      out[28 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[56 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[57 + inPos]) <<  8) & 65535L);
      out[29 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[58 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[59 + inPos]) <<  8) & 65535L);
      out[30 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[60 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[61 + inPos]) <<  8) & 65535L);
      out[31 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in[62 + inPos]) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in[63 + inPos]) <<  8) & 65535L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 3 + inPos)) <<  8) & 65535L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 5 + inPos)) <<  8) & 65535L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 65535L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 65535L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(11 + inPos)) <<  8) & 65535L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(12 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 65535L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(14 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(15 + inPos)) <<  8) & 65535L);
      out[ 8 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(16 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(17 + inPos)) <<  8) & 65535L);
      out[ 9 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(18 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(19 + inPos)) <<  8) & 65535L);
      out[10 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(20 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(21 + inPos)) <<  8) & 65535L);
      out[11 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(22 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(23 + inPos)) <<  8) & 65535L);
      out[12 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(24 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(25 + inPos)) <<  8) & 65535L);
      out[13 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(26 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(27 + inPos)) <<  8) & 65535L);
      out[14 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(28 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(29 + inPos)) <<  8) & 65535L);
      out[15 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(30 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(31 + inPos)) <<  8) & 65535L);
      out[16 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(32 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(33 + inPos)) <<  8) & 65535L);
      out[17 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(34 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(35 + inPos)) <<  8) & 65535L);
      out[18 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(36 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(37 + inPos)) <<  8) & 65535L);
      out[19 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(38 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(39 + inPos)) <<  8) & 65535L);
      out[20 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(40 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(41 + inPos)) <<  8) & 65535L);
      out[21 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(42 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 65535L);
      out[22 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(44 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(45 + inPos)) <<  8) & 65535L);
      out[23 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(46 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(47 + inPos)) <<  8) & 65535L);
      out[24 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(48 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(49 + inPos)) <<  8) & 65535L);
      out[25 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(50 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(51 + inPos)) <<  8) & 65535L);
      out[26 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(52 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(53 + inPos)) <<  8) & 65535L);
      out[27 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(54 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(55 + inPos)) <<  8) & 65535L);
      out[28 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(56 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(57 + inPos)) <<  8) & 65535L);
      out[29 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(58 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(59 + inPos)) <<  8) & 65535L);
      out[30 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(60 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(61 + inPos)) <<  8) & 65535L);
      out[31 + outPos] =
          //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(62 + inPos)) ) & 255L)
        | //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(63 + inPos)) <<  8) & 65535L);
    }
  }

  private static final class Packer17 extends BytePackerForLong {

    private Packer17() {
      super(17);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 0 + inPos] & 131071L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 0 + inPos] & 131071L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [_______0]
          //                                  [6________________]
           ((in[ 0 + inPos] & 131071L) >>> 16)
        | //                           [7654321_]
          //                 [__________6543210]
           ((in[ 1 + inPos] & 131071L) <<  1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 1 + inPos] & 131071L) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [______10]
          //                                 [65_______________]
           ((in[ 1 + inPos] & 131071L) >>> 15)
        | //                           [765432__]
          //                [___________543210]
           ((in[ 2 + inPos] & 131071L) <<  2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 2 + inPos] & 131071L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [_____210]
          //                                [654______________]
           ((in[ 2 + inPos] & 131071L) >>> 14)
        | //                           [76543___]
          //               [____________43210]
           ((in[ 3 + inPos] & 131071L) <<  3)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 3 + inPos] & 131071L) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [____3210]
          //                               [6543_____________]
           ((in[ 3 + inPos] & 131071L) >>> 13)
        | //                           [7654____]
          //              [_____________3210]
           ((in[ 4 + inPos] & 131071L) <<  4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 4 + inPos] & 131071L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                           [___43210]
          //                              [65432____________]
           ((in[ 4 + inPos] & 131071L) >>> 12)
        | //                           [765_____]
          //             [______________210]
           ((in[ 5 + inPos] & 131071L) <<  5)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 5 + inPos] & 131071L) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                           [__543210]
          //                             [654321___________]
           ((in[ 5 + inPos] & 131071L) >>> 11)
        | //                           [76______]
          //            [_______________10]
           ((in[ 6 + inPos] & 131071L) <<  6)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 6 + inPos] & 131071L) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                           [_6543210]
          //                            [6543210__________]
           ((in[ 6 + inPos] & 131071L) >>> 10)
        | //                           [7_______]
          //           [________________0]
           ((in[ 7 + inPos] & 131071L) <<  7)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 7 + inPos] & 131071L) >>> 1)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 7 + inPos] & 131071L) >>> 9)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 0 + inPos] & 131071L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 0 + inPos] & 131071L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [_______0]
          //                                  [6________________]
           ((in[ 0 + inPos] & 131071L) >>> 16)
        | //                           [7654321_]
          //                 [__________6543210]
           ((in[ 1 + inPos] & 131071L) <<  1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 1 + inPos] & 131071L) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [______10]
          //                                 [65_______________]
           ((in[ 1 + inPos] & 131071L) >>> 15)
        | //                           [765432__]
          //                [___________543210]
           ((in[ 2 + inPos] & 131071L) <<  2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 2 + inPos] & 131071L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [_____210]
          //                                [654______________]
           ((in[ 2 + inPos] & 131071L) >>> 14)
        | //                           [76543___]
          //               [____________43210]
           ((in[ 3 + inPos] & 131071L) <<  3)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 3 + inPos] & 131071L) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [____3210]
          //                               [6543_____________]
           ((in[ 3 + inPos] & 131071L) >>> 13)
        | //                           [7654____]
          //              [_____________3210]
           ((in[ 4 + inPos] & 131071L) <<  4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 4 + inPos] & 131071L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                           [___43210]
          //                              [65432____________]
           ((in[ 4 + inPos] & 131071L) >>> 12)
        | //                           [765_____]
          //             [______________210]
           ((in[ 5 + inPos] & 131071L) <<  5)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 5 + inPos] & 131071L) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                           [__543210]
          //                             [654321___________]
           ((in[ 5 + inPos] & 131071L) >>> 11)
        | //                           [76______]
          //            [_______________10]
           ((in[ 6 + inPos] & 131071L) <<  6)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 6 + inPos] & 131071L) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                           [_6543210]
          //                            [6543210__________]
           ((in[ 6 + inPos] & 131071L) >>> 10)
        | //                           [7_______]
          //           [________________0]
           ((in[ 7 + inPos] & 131071L) <<  7)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 7 + inPos] & 131071L) >>> 1)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 7 + inPos] & 131071L) >>> 9)) & 255);
      out[17 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 8 + inPos] & 131071L))) & 255);
      out[18 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 8 + inPos] & 131071L) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                           [_______0]
          //                                  [6________________]
           ((in[ 8 + inPos] & 131071L) >>> 16)
        | //                           [7654321_]
          //                 [__________6543210]
           ((in[ 9 + inPos] & 131071L) <<  1)) & 255);
      out[20 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 9 + inPos] & 131071L) >>> 7)) & 255);
      out[21 + outPos] = (byte)((
          //                           [______10]
          //                                 [65_______________]
           ((in[ 9 + inPos] & 131071L) >>> 15)
        | //                           [765432__]
          //                [___________543210]
           ((in[10 + inPos] & 131071L) <<  2)) & 255);
      out[22 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[10 + inPos] & 131071L) >>> 6)) & 255);
      out[23 + outPos] = (byte)((
          //                           [_____210]
          //                                [654______________]
           ((in[10 + inPos] & 131071L) >>> 14)
        | //                           [76543___]
          //               [____________43210]
           ((in[11 + inPos] & 131071L) <<  3)) & 255);
      out[24 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[11 + inPos] & 131071L) >>> 5)) & 255);
      out[25 + outPos] = (byte)((
          //                           [____3210]
          //                               [6543_____________]
           ((in[11 + inPos] & 131071L) >>> 13)
        | //                           [7654____]
          //              [_____________3210]
           ((in[12 + inPos] & 131071L) <<  4)) & 255);
      out[26 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[12 + inPos] & 131071L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                           [___43210]
          //                              [65432____________]
           ((in[12 + inPos] & 131071L) >>> 12)
        | //                           [765_____]
          //             [______________210]
           ((in[13 + inPos] & 131071L) <<  5)) & 255);
      out[28 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[13 + inPos] & 131071L) >>> 3)) & 255);
      out[29 + outPos] = (byte)((
          //                           [__543210]
          //                             [654321___________]
           ((in[13 + inPos] & 131071L) >>> 11)
        | //                           [76______]
          //            [_______________10]
           ((in[14 + inPos] & 131071L) <<  6)) & 255);
      out[30 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[14 + inPos] & 131071L) >>> 2)) & 255);
      out[31 + outPos] = (byte)((
          //                           [_6543210]
          //                            [6543210__________]
           ((in[14 + inPos] & 131071L) >>> 10)
        | //                           [7_______]
          //           [________________0]
           ((in[15 + inPos] & 131071L) <<  7)) & 255);
      out[32 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[15 + inPos] & 131071L) >>> 1)) & 255);
      out[33 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[15 + inPos] & 131071L) >>> 9)) & 255);
      out[34 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[16 + inPos] & 131071L))) & 255);
      out[35 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[16 + inPos] & 131071L) >>> 8)) & 255);
      out[36 + outPos] = (byte)((
          //                           [_______0]
          //                                  [6________________]
           ((in[16 + inPos] & 131071L) >>> 16)
        | //                           [7654321_]
          //                 [__________6543210]
           ((in[17 + inPos] & 131071L) <<  1)) & 255);
      out[37 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[17 + inPos] & 131071L) >>> 7)) & 255);
      out[38 + outPos] = (byte)((
          //                           [______10]
          //                                 [65_______________]
           ((in[17 + inPos] & 131071L) >>> 15)
        | //                           [765432__]
          //                [___________543210]
           ((in[18 + inPos] & 131071L) <<  2)) & 255);
      out[39 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[18 + inPos] & 131071L) >>> 6)) & 255);
      out[40 + outPos] = (byte)((
          //                           [_____210]
          //                                [654______________]
           ((in[18 + inPos] & 131071L) >>> 14)
        | //                           [76543___]
          //               [____________43210]
           ((in[19 + inPos] & 131071L) <<  3)) & 255);
      out[41 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[19 + inPos] & 131071L) >>> 5)) & 255);
      out[42 + outPos] = (byte)((
          //                           [____3210]
          //                               [6543_____________]
           ((in[19 + inPos] & 131071L) >>> 13)
        | //                           [7654____]
          //              [_____________3210]
           ((in[20 + inPos] & 131071L) <<  4)) & 255);
      out[43 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[20 + inPos] & 131071L) >>> 4)) & 255);
      out[44 + outPos] = (byte)((
          //                           [___43210]
          //                              [65432____________]
           ((in[20 + inPos] & 131071L) >>> 12)
        | //                           [765_____]
          //             [______________210]
           ((in[21 + inPos] & 131071L) <<  5)) & 255);
      out[45 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[21 + inPos] & 131071L) >>> 3)) & 255);
      out[46 + outPos] = (byte)((
          //                           [__543210]
          //                             [654321___________]
           ((in[21 + inPos] & 131071L) >>> 11)
        | //                           [76______]
          //            [_______________10]
           ((in[22 + inPos] & 131071L) <<  6)) & 255);
      out[47 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[22 + inPos] & 131071L) >>> 2)) & 255);
      out[48 + outPos] = (byte)((
          //                           [_6543210]
          //                            [6543210__________]
           ((in[22 + inPos] & 131071L) >>> 10)
        | //                           [7_______]
          //           [________________0]
           ((in[23 + inPos] & 131071L) <<  7)) & 255);
      out[49 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[23 + inPos] & 131071L) >>> 1)) & 255);
      out[50 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[23 + inPos] & 131071L) >>> 9)) & 255);
      out[51 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[24 + inPos] & 131071L))) & 255);
      out[52 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[24 + inPos] & 131071L) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                           [_______0]
          //                                  [6________________]
           ((in[24 + inPos] & 131071L) >>> 16)
        | //                           [7654321_]
          //                 [__________6543210]
           ((in[25 + inPos] & 131071L) <<  1)) & 255);
      out[54 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[25 + inPos] & 131071L) >>> 7)) & 255);
      out[55 + outPos] = (byte)((
          //                           [______10]
          //                                 [65_______________]
           ((in[25 + inPos] & 131071L) >>> 15)
        | //                           [765432__]
          //                [___________543210]
           ((in[26 + inPos] & 131071L) <<  2)) & 255);
      out[56 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[26 + inPos] & 131071L) >>> 6)) & 255);
      out[57 + outPos] = (byte)((
          //                           [_____210]
          //                                [654______________]
           ((in[26 + inPos] & 131071L) >>> 14)
        | //                           [76543___]
          //               [____________43210]
           ((in[27 + inPos] & 131071L) <<  3)) & 255);
      out[58 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[27 + inPos] & 131071L) >>> 5)) & 255);
      out[59 + outPos] = (byte)((
          //                           [____3210]
          //                               [6543_____________]
           ((in[27 + inPos] & 131071L) >>> 13)
        | //                           [7654____]
          //              [_____________3210]
           ((in[28 + inPos] & 131071L) <<  4)) & 255);
      out[60 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[28 + inPos] & 131071L) >>> 4)) & 255);
      out[61 + outPos] = (byte)((
          //                           [___43210]
          //                              [65432____________]
           ((in[28 + inPos] & 131071L) >>> 12)
        | //                           [765_____]
          //             [______________210]
           ((in[29 + inPos] & 131071L) <<  5)) & 255);
      out[62 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[29 + inPos] & 131071L) >>> 3)) & 255);
      out[63 + outPos] = (byte)((
          //                           [__543210]
          //                             [654321___________]
           ((in[29 + inPos] & 131071L) >>> 11)
        | //                           [76______]
          //            [_______________10]
           ((in[30 + inPos] & 131071L) <<  6)) & 255);
      out[64 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[30 + inPos] & 131071L) >>> 2)) & 255);
      out[65 + outPos] = (byte)((
          //                           [_6543210]
          //                            [6543210__________]
           ((in[30 + inPos] & 131071L) >>> 10)
        | //                           [7_______]
          //           [________________0]
           ((in[31 + inPos] & 131071L) <<  7)) & 255);
      out[66 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[31 + inPos] & 131071L) >>> 1)) & 255);
      out[67 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[31 + inPos] & 131071L) >>> 9)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in[ 2 + inPos]) <<  16) & 131071L);
      out[ 1 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[ 2 + inPos]) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[ 3 + inPos]) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in[ 4 + inPos]) <<  15) & 131071L);
      out[ 2 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in[ 4 + inPos]) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[ 5 + inPos]) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in[ 6 + inPos]) <<  14) & 131071L);
      out[ 3 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in[ 6 + inPos]) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[ 7 + inPos]) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in[ 8 + inPos]) <<  13) & 131071L);
      out[ 4 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in[10 + inPos]) <<  12) & 131071L);
      out[ 5 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in[10 + inPos]) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[11 + inPos]) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in[12 + inPos]) <<  11) & 131071L);
      out[ 6 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in[12 + inPos]) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[13 + inPos]) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[14 + inPos]) <<  10) & 131071L);
      out[ 7 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in[14 + inPos]) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[15 + inPos]) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in[16 + inPos]) <<  9) & 131071L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 131071L);
      out[ 1 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get( 2 + inPos)) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get( 3 + inPos)) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in.get( 4 + inPos)) <<  15) & 131071L);
      out[ 2 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in.get( 4 + inPos)) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in.get( 6 + inPos)) <<  14) & 131071L);
      out[ 3 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in.get( 6 + inPos)) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get( 7 + inPos)) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get( 8 + inPos)) <<  13) & 131071L);
      out[ 4 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(10 + inPos)) <<  12) & 131071L);
      out[ 5 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in.get(10 + inPos)) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(11 + inPos)) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(12 + inPos)) <<  11) & 131071L);
      out[ 6 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(13 + inPos)) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(14 + inPos)) <<  10) & 131071L);
      out[ 7 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in.get(14 + inPos)) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(15 + inPos)) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(16 + inPos)) <<  9) & 131071L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in[ 2 + inPos]) <<  16) & 131071L);
      out[ 1 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[ 2 + inPos]) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[ 3 + inPos]) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in[ 4 + inPos]) <<  15) & 131071L);
      out[ 2 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in[ 4 + inPos]) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[ 5 + inPos]) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in[ 6 + inPos]) <<  14) & 131071L);
      out[ 3 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in[ 6 + inPos]) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[ 7 + inPos]) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in[ 8 + inPos]) <<  13) & 131071L);
      out[ 4 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in[10 + inPos]) <<  12) & 131071L);
      out[ 5 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in[10 + inPos]) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[11 + inPos]) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in[12 + inPos]) <<  11) & 131071L);
      out[ 6 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in[12 + inPos]) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[13 + inPos]) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[14 + inPos]) <<  10) & 131071L);
      out[ 7 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in[14 + inPos]) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[15 + inPos]) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in[16 + inPos]) <<  9) & 131071L);
      out[ 8 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in[17 + inPos]) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[18 + inPos]) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in[19 + inPos]) <<  16) & 131071L);
      out[ 9 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[19 + inPos]) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[20 + inPos]) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in[21 + inPos]) <<  15) & 131071L);
      out[10 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in[21 + inPos]) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[22 + inPos]) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in[23 + inPos]) <<  14) & 131071L);
      out[11 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in[23 + inPos]) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[24 + inPos]) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in[25 + inPos]) <<  13) & 131071L);
      out[12 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in[25 + inPos]) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[26 + inPos]) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in[27 + inPos]) <<  12) & 131071L);
      out[13 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in[27 + inPos]) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[28 + inPos]) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in[29 + inPos]) <<  11) & 131071L);
      out[14 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in[29 + inPos]) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[30 + inPos]) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[31 + inPos]) <<  10) & 131071L);
      out[15 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in[31 + inPos]) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[32 + inPos]) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in[33 + inPos]) <<  9) & 131071L);
      out[16 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in[34 + inPos]) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[35 + inPos]) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in[36 + inPos]) <<  16) & 131071L);
      out[17 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[36 + inPos]) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[37 + inPos]) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in[38 + inPos]) <<  15) & 131071L);
      out[18 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in[38 + inPos]) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[39 + inPos]) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in[40 + inPos]) <<  14) & 131071L);
      out[19 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in[40 + inPos]) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[41 + inPos]) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in[42 + inPos]) <<  13) & 131071L);
      out[20 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in[42 + inPos]) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[43 + inPos]) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in[44 + inPos]) <<  12) & 131071L);
      out[21 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in[44 + inPos]) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[45 + inPos]) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in[46 + inPos]) <<  11) & 131071L);
      out[22 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in[46 + inPos]) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[47 + inPos]) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[48 + inPos]) <<  10) & 131071L);
      out[23 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in[48 + inPos]) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[49 + inPos]) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in[50 + inPos]) <<  9) & 131071L);
      out[24 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in[51 + inPos]) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[52 + inPos]) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in[53 + inPos]) <<  16) & 131071L);
      out[25 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[53 + inPos]) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[54 + inPos]) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in[55 + inPos]) <<  15) & 131071L);
      out[26 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in[55 + inPos]) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[56 + inPos]) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in[57 + inPos]) <<  14) & 131071L);
      out[27 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in[57 + inPos]) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[58 + inPos]) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in[59 + inPos]) <<  13) & 131071L);
      out[28 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in[59 + inPos]) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[60 + inPos]) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in[61 + inPos]) <<  12) & 131071L);
      out[29 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in[61 + inPos]) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[62 + inPos]) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in[63 + inPos]) <<  11) & 131071L);
      out[30 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in[63 + inPos]) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[64 + inPos]) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[65 + inPos]) <<  10) & 131071L);
      out[31 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in[65 + inPos]) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[66 + inPos]) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in[67 + inPos]) <<  9) & 131071L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 131071L);
      out[ 1 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get( 2 + inPos)) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get( 3 + inPos)) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in.get( 4 + inPos)) <<  15) & 131071L);
      out[ 2 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in.get( 4 + inPos)) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in.get( 6 + inPos)) <<  14) & 131071L);
      out[ 3 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in.get( 6 + inPos)) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get( 7 + inPos)) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get( 8 + inPos)) <<  13) & 131071L);
      out[ 4 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(10 + inPos)) <<  12) & 131071L);
      out[ 5 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in.get(10 + inPos)) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(11 + inPos)) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(12 + inPos)) <<  11) & 131071L);
      out[ 6 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(13 + inPos)) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(14 + inPos)) <<  10) & 131071L);
      out[ 7 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in.get(14 + inPos)) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(15 + inPos)) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(16 + inPos)) <<  9) & 131071L);
      out[ 8 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(17 + inPos)) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(18 + inPos)) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(19 + inPos)) <<  16) & 131071L);
      out[ 9 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(19 + inPos)) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(20 + inPos)) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(21 + inPos)) <<  15) & 131071L);
      out[10 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in.get(21 + inPos)) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(22 + inPos)) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in.get(23 + inPos)) <<  14) & 131071L);
      out[11 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in.get(23 + inPos)) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(24 + inPos)) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(25 + inPos)) <<  13) & 131071L);
      out[12 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(25 + inPos)) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(27 + inPos)) <<  12) & 131071L);
      out[13 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in.get(27 + inPos)) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(28 + inPos)) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(29 + inPos)) <<  11) & 131071L);
      out[14 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in.get(29 + inPos)) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(30 + inPos)) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(31 + inPos)) <<  10) & 131071L);
      out[15 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in.get(31 + inPos)) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(32 + inPos)) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(33 + inPos)) <<  9) & 131071L);
      out[16 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(34 + inPos)) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(35 + inPos)) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(36 + inPos)) <<  16) & 131071L);
      out[17 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(36 + inPos)) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(37 + inPos)) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(38 + inPos)) <<  15) & 131071L);
      out[18 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in.get(38 + inPos)) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(39 + inPos)) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in.get(40 + inPos)) <<  14) & 131071L);
      out[19 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in.get(40 + inPos)) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(41 + inPos)) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(42 + inPos)) <<  13) & 131071L);
      out[20 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(42 + inPos)) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(43 + inPos)) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(44 + inPos)) <<  12) & 131071L);
      out[21 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in.get(44 + inPos)) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(45 + inPos)) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(46 + inPos)) <<  11) & 131071L);
      out[22 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in.get(46 + inPos)) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(47 + inPos)) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(48 + inPos)) <<  10) & 131071L);
      out[23 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in.get(48 + inPos)) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(49 + inPos)) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(50 + inPos)) <<  9) & 131071L);
      out[24 + outPos] =
          //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(51 + inPos)) ) & 255L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(52 + inPos)) <<  8) & 65535L)
        | //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(53 + inPos)) <<  16) & 131071L);
      out[25 + outPos] =
          //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(53 + inPos)) >>  1) & 127L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(54 + inPos)) <<  7) & 32767L)
        | //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(55 + inPos)) <<  15) & 131071L);
      out[26 + outPos] =
          //                           [765432__]
          //                [___________543210]
            ((((long)in.get(55 + inPos)) >>  2) & 63L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(56 + inPos)) <<  6) & 16383L)
        | //                           [_____210]
          //                                [654______________]
            ((((long)in.get(57 + inPos)) <<  14) & 131071L);
      out[27 + outPos] =
          //                           [76543___]
          //               [____________43210]
            ((((long)in.get(57 + inPos)) >>  3) & 31L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(58 + inPos)) <<  5) & 8191L)
        | //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(59 + inPos)) <<  13) & 131071L);
      out[28 + outPos] =
          //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(59 + inPos)) >>  4) & 15L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(60 + inPos)) <<  4) & 4095L)
        | //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(61 + inPos)) <<  12) & 131071L);
      out[29 + outPos] =
          //                           [765_____]
          //             [______________210]
            ((((long)in.get(61 + inPos)) >>  5) & 7L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(62 + inPos)) <<  3) & 2047L)
        | //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(63 + inPos)) <<  11) & 131071L);
      out[30 + outPos] =
          //                           [76______]
          //            [_______________10]
            ((((long)in.get(63 + inPos)) >>  6) & 3L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(64 + inPos)) <<  2) & 1023L)
        | //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(65 + inPos)) <<  10) & 131071L);
      out[31 + outPos] =
          //                           [7_______]
          //           [________________0]
            ((((long)in.get(65 + inPos)) >>  7) & 1L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(66 + inPos)) <<  1) & 511L)
        | //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(67 + inPos)) <<  9) & 131071L);
    }
  }

  private static final class Packer18 extends BytePackerForLong {

    private Packer18() {
      super(18);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 0 + inPos] & 262143L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 0 + inPos] & 262143L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[ 0 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[ 1 + inPos] & 262143L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 1 + inPos] & 262143L) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[ 1 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[ 2 + inPos] & 262143L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 2 + inPos] & 262143L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[ 2 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[ 3 + inPos] & 262143L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 3 + inPos] & 262143L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 3 + inPos] & 262143L) >>> 10)) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 4 + inPos] & 262143L))) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 4 + inPos] & 262143L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[ 4 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[ 5 + inPos] & 262143L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 5 + inPos] & 262143L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[ 5 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[ 6 + inPos] & 262143L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 6 + inPos] & 262143L) >>> 4)) & 255);
      out[15 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[ 6 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[ 7 + inPos] & 262143L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 7 + inPos] & 262143L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 7 + inPos] & 262143L) >>> 10)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 0 + inPos] & 262143L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 0 + inPos] & 262143L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[ 0 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[ 1 + inPos] & 262143L) <<  2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 1 + inPos] & 262143L) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[ 1 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[ 2 + inPos] & 262143L) <<  4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 2 + inPos] & 262143L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[ 2 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[ 3 + inPos] & 262143L) <<  6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 3 + inPos] & 262143L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 3 + inPos] & 262143L) >>> 10)) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 4 + inPos] & 262143L))) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 4 + inPos] & 262143L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[ 4 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[ 5 + inPos] & 262143L) <<  2)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 5 + inPos] & 262143L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[ 5 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[ 6 + inPos] & 262143L) <<  4)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 6 + inPos] & 262143L) >>> 4)) & 255);
      out[15 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[ 6 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[ 7 + inPos] & 262143L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 7 + inPos] & 262143L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 7 + inPos] & 262143L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 8 + inPos] & 262143L))) & 255);
      out[19 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 8 + inPos] & 262143L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[ 8 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[ 9 + inPos] & 262143L) <<  2)) & 255);
      out[21 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 9 + inPos] & 262143L) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[ 9 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[10 + inPos] & 262143L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[10 + inPos] & 262143L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[10 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[11 + inPos] & 262143L) <<  6)) & 255);
      out[25 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[11 + inPos] & 262143L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[11 + inPos] & 262143L) >>> 10)) & 255);
      out[27 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[12 + inPos] & 262143L))) & 255);
      out[28 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[12 + inPos] & 262143L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[12 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[13 + inPos] & 262143L) <<  2)) & 255);
      out[30 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[13 + inPos] & 262143L) >>> 6)) & 255);
      out[31 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[13 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[14 + inPos] & 262143L) <<  4)) & 255);
      out[32 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[14 + inPos] & 262143L) >>> 4)) & 255);
      out[33 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[14 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[15 + inPos] & 262143L) <<  6)) & 255);
      out[34 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[15 + inPos] & 262143L) >>> 2)) & 255);
      out[35 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[15 + inPos] & 262143L) >>> 10)) & 255);
      out[36 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[16 + inPos] & 262143L))) & 255);
      out[37 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[16 + inPos] & 262143L) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[16 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[17 + inPos] & 262143L) <<  2)) & 255);
      out[39 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[17 + inPos] & 262143L) >>> 6)) & 255);
      out[40 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[17 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[18 + inPos] & 262143L) <<  4)) & 255);
      out[41 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[18 + inPos] & 262143L) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[18 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[19 + inPos] & 262143L) <<  6)) & 255);
      out[43 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[19 + inPos] & 262143L) >>> 2)) & 255);
      out[44 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[19 + inPos] & 262143L) >>> 10)) & 255);
      out[45 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[20 + inPos] & 262143L))) & 255);
      out[46 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[20 + inPos] & 262143L) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[20 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[21 + inPos] & 262143L) <<  2)) & 255);
      out[48 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[21 + inPos] & 262143L) >>> 6)) & 255);
      out[49 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[21 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[22 + inPos] & 262143L) <<  4)) & 255);
      out[50 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[22 + inPos] & 262143L) >>> 4)) & 255);
      out[51 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[22 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[23 + inPos] & 262143L) <<  6)) & 255);
      out[52 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[23 + inPos] & 262143L) >>> 2)) & 255);
      out[53 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[23 + inPos] & 262143L) >>> 10)) & 255);
      out[54 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[24 + inPos] & 262143L))) & 255);
      out[55 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[24 + inPos] & 262143L) >>> 8)) & 255);
      out[56 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[24 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[25 + inPos] & 262143L) <<  2)) & 255);
      out[57 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[25 + inPos] & 262143L) >>> 6)) & 255);
      out[58 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[25 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[26 + inPos] & 262143L) <<  4)) & 255);
      out[59 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[26 + inPos] & 262143L) >>> 4)) & 255);
      out[60 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[26 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[27 + inPos] & 262143L) <<  6)) & 255);
      out[61 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[27 + inPos] & 262143L) >>> 2)) & 255);
      out[62 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[27 + inPos] & 262143L) >>> 10)) & 255);
      out[63 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[28 + inPos] & 262143L))) & 255);
      out[64 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[28 + inPos] & 262143L) >>> 8)) & 255);
      out[65 + outPos] = (byte)((
          //                            [______10]
          //                                  [76________________]
           ((in[28 + inPos] & 262143L) >>> 16)
        | //                            [765432__]
          //                [____________543210]
           ((in[29 + inPos] & 262143L) <<  2)) & 255);
      out[66 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[29 + inPos] & 262143L) >>> 6)) & 255);
      out[67 + outPos] = (byte)((
          //                            [____3210]
          //                                [7654______________]
           ((in[29 + inPos] & 262143L) >>> 14)
        | //                            [7654____]
          //              [______________3210]
           ((in[30 + inPos] & 262143L) <<  4)) & 255);
      out[68 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[30 + inPos] & 262143L) >>> 4)) & 255);
      out[69 + outPos] = (byte)((
          //                            [__543210]
          //                              [765432____________]
           ((in[30 + inPos] & 262143L) >>> 12)
        | //                            [76______]
          //            [________________10]
           ((in[31 + inPos] & 262143L) <<  6)) & 255);
      out[70 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[31 + inPos] & 262143L) >>> 2)) & 255);
      out[71 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[31 + inPos] & 262143L) >>> 10)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[ 2 + inPos]) <<  16) & 262143L);
      out[ 1 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[ 3 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[ 4 + inPos]) <<  14) & 262143L);
      out[ 2 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[ 6 + inPos]) <<  12) & 262143L);
      out[ 3 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 8 + inPos]) <<  10) & 262143L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[10 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[11 + inPos]) <<  16) & 262143L);
      out[ 5 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[13 + inPos]) <<  14) & 262143L);
      out[ 6 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[14 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[15 + inPos]) <<  12) & 262143L);
      out[ 7 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 262143L);
      out[ 1 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get( 4 + inPos)) <<  14) & 262143L);
      out[ 2 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get( 6 + inPos)) <<  12) & 262143L);
      out[ 3 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 8 + inPos)) <<  10) & 262143L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(10 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(11 + inPos)) <<  16) & 262143L);
      out[ 5 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 262143L);
      out[ 6 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(14 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(15 + inPos)) <<  12) & 262143L);
      out[ 7 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[ 2 + inPos]) <<  16) & 262143L);
      out[ 1 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[ 3 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[ 4 + inPos]) <<  14) & 262143L);
      out[ 2 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[ 6 + inPos]) <<  12) & 262143L);
      out[ 3 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 8 + inPos]) <<  10) & 262143L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[10 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[11 + inPos]) <<  16) & 262143L);
      out[ 5 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[11 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[13 + inPos]) <<  14) & 262143L);
      out[ 6 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[14 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[15 + inPos]) <<  12) & 262143L);
      out[ 7 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L);
      out[ 8 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[18 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[19 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[20 + inPos]) <<  16) & 262143L);
      out[ 9 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[20 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[21 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[22 + inPos]) <<  14) & 262143L);
      out[10 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[23 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[24 + inPos]) <<  12) & 262143L);
      out[11 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[24 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[26 + inPos]) <<  10) & 262143L);
      out[12 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[27 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[28 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[29 + inPos]) <<  16) & 262143L);
      out[13 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[29 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[30 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[31 + inPos]) <<  14) & 262143L);
      out[14 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[32 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[33 + inPos]) <<  12) & 262143L);
      out[15 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[33 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[34 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[35 + inPos]) <<  10) & 262143L);
      out[16 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[36 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[37 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[38 + inPos]) <<  16) & 262143L);
      out[17 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[38 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[39 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[40 + inPos]) <<  14) & 262143L);
      out[18 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[40 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[41 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[42 + inPos]) <<  12) & 262143L);
      out[19 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[42 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[43 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[44 + inPos]) <<  10) & 262143L);
      out[20 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[45 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[46 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[47 + inPos]) <<  16) & 262143L);
      out[21 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[47 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[48 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[49 + inPos]) <<  14) & 262143L);
      out[22 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[49 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[50 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[51 + inPos]) <<  12) & 262143L);
      out[23 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[51 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[52 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[53 + inPos]) <<  10) & 262143L);
      out[24 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[54 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[55 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[56 + inPos]) <<  16) & 262143L);
      out[25 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[56 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[57 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[58 + inPos]) <<  14) & 262143L);
      out[26 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[58 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[59 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[60 + inPos]) <<  12) & 262143L);
      out[27 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[60 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[61 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[62 + inPos]) <<  10) & 262143L);
      out[28 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in[63 + inPos]) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[64 + inPos]) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in[65 + inPos]) <<  16) & 262143L);
      out[29 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in[65 + inPos]) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[66 + inPos]) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in[67 + inPos]) <<  14) & 262143L);
      out[30 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in[67 + inPos]) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[68 + inPos]) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in[69 + inPos]) <<  12) & 262143L);
      out[31 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in[69 + inPos]) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[70 + inPos]) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in[71 + inPos]) <<  10) & 262143L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 262143L);
      out[ 1 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get( 4 + inPos)) <<  14) & 262143L);
      out[ 2 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get( 6 + inPos)) <<  12) & 262143L);
      out[ 3 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 8 + inPos)) <<  10) & 262143L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(10 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(11 + inPos)) <<  16) & 262143L);
      out[ 5 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(11 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 262143L);
      out[ 6 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(14 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(15 + inPos)) <<  12) & 262143L);
      out[ 7 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L);
      out[ 8 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(18 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(19 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(20 + inPos)) <<  16) & 262143L);
      out[ 9 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(20 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(21 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(22 + inPos)) <<  14) & 262143L);
      out[10 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(24 + inPos)) <<  12) & 262143L);
      out[11 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(24 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(26 + inPos)) <<  10) & 262143L);
      out[12 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(27 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(28 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(29 + inPos)) <<  16) & 262143L);
      out[13 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(29 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(30 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(31 + inPos)) <<  14) & 262143L);
      out[14 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(32 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(33 + inPos)) <<  12) & 262143L);
      out[15 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(34 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(35 + inPos)) <<  10) & 262143L);
      out[16 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(36 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(37 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(38 + inPos)) <<  16) & 262143L);
      out[17 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(38 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(39 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(40 + inPos)) <<  14) & 262143L);
      out[18 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(40 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(41 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(42 + inPos)) <<  12) & 262143L);
      out[19 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(42 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(43 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(44 + inPos)) <<  10) & 262143L);
      out[20 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(45 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(46 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(47 + inPos)) <<  16) & 262143L);
      out[21 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(47 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(48 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(49 + inPos)) <<  14) & 262143L);
      out[22 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(49 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(50 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(51 + inPos)) <<  12) & 262143L);
      out[23 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(51 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(52 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(53 + inPos)) <<  10) & 262143L);
      out[24 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(54 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(55 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(56 + inPos)) <<  16) & 262143L);
      out[25 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(56 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(57 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(58 + inPos)) <<  14) & 262143L);
      out[26 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(58 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(59 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(60 + inPos)) <<  12) & 262143L);
      out[27 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(60 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(61 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(62 + inPos)) <<  10) & 262143L);
      out[28 + outPos] =
          //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(63 + inPos)) ) & 255L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(64 + inPos)) <<  8) & 65535L)
        | //                            [______10]
          //                                  [76________________]
            ((((long)in.get(65 + inPos)) <<  16) & 262143L);
      out[29 + outPos] =
          //                            [765432__]
          //                [____________543210]
            ((((long)in.get(65 + inPos)) >>  2) & 63L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(66 + inPos)) <<  6) & 16383L)
        | //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(67 + inPos)) <<  14) & 262143L);
      out[30 + outPos] =
          //                            [7654____]
          //              [______________3210]
            ((((long)in.get(67 + inPos)) >>  4) & 15L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(68 + inPos)) <<  4) & 4095L)
        | //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(69 + inPos)) <<  12) & 262143L);
      out[31 + outPos] =
          //                            [76______]
          //            [________________10]
            ((((long)in.get(69 + inPos)) >>  6) & 3L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(70 + inPos)) <<  2) & 1023L)
        | //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(71 + inPos)) <<  10) & 262143L);
    }
  }

  private static final class Packer19 extends BytePackerForLong {

    private Packer19() {
      super(19);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 0 + inPos] & 524287L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 0 + inPos] & 524287L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [_____210]
          //                                  [876________________]
           ((in[ 0 + inPos] & 524287L) >>> 16)
        | //                             [76543___]
          //               [______________43210]
           ((in[ 1 + inPos] & 524287L) <<  3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 1 + inPos] & 524287L) >>> 5)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [__543210]
          //                               [876543_____________]
           ((in[ 1 + inPos] & 524287L) >>> 13)
        | //                             [76______]
          //            [_________________10]
           ((in[ 2 + inPos] & 524287L) <<  6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 2 + inPos] & 524287L) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 2 + inPos] & 524287L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [_______0]
          //                                    [8__________________]
           ((in[ 2 + inPos] & 524287L) >>> 18)
        | //                             [7654321_]
          //                 [____________6543210]
           ((in[ 3 + inPos] & 524287L) <<  1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 3 + inPos] & 524287L) >>> 7)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [____3210]
          //                                 [8765_______________]
           ((in[ 3 + inPos] & 524287L) >>> 15)
        | //                             [7654____]
          //              [_______________3210]
           ((in[ 4 + inPos] & 524287L) <<  4)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 4 + inPos] & 524287L) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                             [_6543210]
          //                              [8765432____________]
           ((in[ 4 + inPos] & 524287L) >>> 12)
        | //                             [7_______]
          //           [__________________0]
           ((in[ 5 + inPos] & 524287L) <<  7)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 5 + inPos] & 524287L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 5 + inPos] & 524287L) >>> 9)) & 255);
      out[14 + outPos] = (byte)((
          //                             [______10]
          //                                   [87_________________]
           ((in[ 5 + inPos] & 524287L) >>> 17)
        | //                             [765432__]
          //                [_____________543210]
           ((in[ 6 + inPos] & 524287L) <<  2)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 6 + inPos] & 524287L) >>> 6)) & 255);
      out[16 + outPos] = (byte)((
          //                             [___43210]
          //                                [87654______________]
           ((in[ 6 + inPos] & 524287L) >>> 14)
        | //                             [765_____]
          //             [________________210]
           ((in[ 7 + inPos] & 524287L) <<  5)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 7 + inPos] & 524287L) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 7 + inPos] & 524287L) >>> 11)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 0 + inPos] & 524287L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 0 + inPos] & 524287L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [_____210]
          //                                  [876________________]
           ((in[ 0 + inPos] & 524287L) >>> 16)
        | //                             [76543___]
          //               [______________43210]
           ((in[ 1 + inPos] & 524287L) <<  3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 1 + inPos] & 524287L) >>> 5)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [__543210]
          //                               [876543_____________]
           ((in[ 1 + inPos] & 524287L) >>> 13)
        | //                             [76______]
          //            [_________________10]
           ((in[ 2 + inPos] & 524287L) <<  6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 2 + inPos] & 524287L) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 2 + inPos] & 524287L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [_______0]
          //                                    [8__________________]
           ((in[ 2 + inPos] & 524287L) >>> 18)
        | //                             [7654321_]
          //                 [____________6543210]
           ((in[ 3 + inPos] & 524287L) <<  1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 3 + inPos] & 524287L) >>> 7)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [____3210]
          //                                 [8765_______________]
           ((in[ 3 + inPos] & 524287L) >>> 15)
        | //                             [7654____]
          //              [_______________3210]
           ((in[ 4 + inPos] & 524287L) <<  4)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 4 + inPos] & 524287L) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                             [_6543210]
          //                              [8765432____________]
           ((in[ 4 + inPos] & 524287L) >>> 12)
        | //                             [7_______]
          //           [__________________0]
           ((in[ 5 + inPos] & 524287L) <<  7)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 5 + inPos] & 524287L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 5 + inPos] & 524287L) >>> 9)) & 255);
      out[14 + outPos] = (byte)((
          //                             [______10]
          //                                   [87_________________]
           ((in[ 5 + inPos] & 524287L) >>> 17)
        | //                             [765432__]
          //                [_____________543210]
           ((in[ 6 + inPos] & 524287L) <<  2)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 6 + inPos] & 524287L) >>> 6)) & 255);
      out[16 + outPos] = (byte)((
          //                             [___43210]
          //                                [87654______________]
           ((in[ 6 + inPos] & 524287L) >>> 14)
        | //                             [765_____]
          //             [________________210]
           ((in[ 7 + inPos] & 524287L) <<  5)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 7 + inPos] & 524287L) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 7 + inPos] & 524287L) >>> 11)) & 255);
      out[19 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 8 + inPos] & 524287L))) & 255);
      out[20 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 8 + inPos] & 524287L) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                             [_____210]
          //                                  [876________________]
           ((in[ 8 + inPos] & 524287L) >>> 16)
        | //                             [76543___]
          //               [______________43210]
           ((in[ 9 + inPos] & 524287L) <<  3)) & 255);
      out[22 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 9 + inPos] & 524287L) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                             [__543210]
          //                               [876543_____________]
           ((in[ 9 + inPos] & 524287L) >>> 13)
        | //                             [76______]
          //            [_________________10]
           ((in[10 + inPos] & 524287L) <<  6)) & 255);
      out[24 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[10 + inPos] & 524287L) >>> 2)) & 255);
      out[25 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[10 + inPos] & 524287L) >>> 10)) & 255);
      out[26 + outPos] = (byte)((
          //                             [_______0]
          //                                    [8__________________]
           ((in[10 + inPos] & 524287L) >>> 18)
        | //                             [7654321_]
          //                 [____________6543210]
           ((in[11 + inPos] & 524287L) <<  1)) & 255);
      out[27 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[11 + inPos] & 524287L) >>> 7)) & 255);
      out[28 + outPos] = (byte)((
          //                             [____3210]
          //                                 [8765_______________]
           ((in[11 + inPos] & 524287L) >>> 15)
        | //                             [7654____]
          //              [_______________3210]
           ((in[12 + inPos] & 524287L) <<  4)) & 255);
      out[29 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[12 + inPos] & 524287L) >>> 4)) & 255);
      out[30 + outPos] = (byte)((
          //                             [_6543210]
          //                              [8765432____________]
           ((in[12 + inPos] & 524287L) >>> 12)
        | //                             [7_______]
          //           [__________________0]
           ((in[13 + inPos] & 524287L) <<  7)) & 255);
      out[31 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[13 + inPos] & 524287L) >>> 1)) & 255);
      out[32 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[13 + inPos] & 524287L) >>> 9)) & 255);
      out[33 + outPos] = (byte)((
          //                             [______10]
          //                                   [87_________________]
           ((in[13 + inPos] & 524287L) >>> 17)
        | //                             [765432__]
          //                [_____________543210]
           ((in[14 + inPos] & 524287L) <<  2)) & 255);
      out[34 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[14 + inPos] & 524287L) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                             [___43210]
          //                                [87654______________]
           ((in[14 + inPos] & 524287L) >>> 14)
        | //                             [765_____]
          //             [________________210]
           ((in[15 + inPos] & 524287L) <<  5)) & 255);
      out[36 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[15 + inPos] & 524287L) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[15 + inPos] & 524287L) >>> 11)) & 255);
      out[38 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[16 + inPos] & 524287L))) & 255);
      out[39 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[16 + inPos] & 524287L) >>> 8)) & 255);
      out[40 + outPos] = (byte)((
          //                             [_____210]
          //                                  [876________________]
           ((in[16 + inPos] & 524287L) >>> 16)
        | //                             [76543___]
          //               [______________43210]
           ((in[17 + inPos] & 524287L) <<  3)) & 255);
      out[41 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[17 + inPos] & 524287L) >>> 5)) & 255);
      out[42 + outPos] = (byte)((
          //                             [__543210]
          //                               [876543_____________]
           ((in[17 + inPos] & 524287L) >>> 13)
        | //                             [76______]
          //            [_________________10]
           ((in[18 + inPos] & 524287L) <<  6)) & 255);
      out[43 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[18 + inPos] & 524287L) >>> 2)) & 255);
      out[44 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[18 + inPos] & 524287L) >>> 10)) & 255);
      out[45 + outPos] = (byte)((
          //                             [_______0]
          //                                    [8__________________]
           ((in[18 + inPos] & 524287L) >>> 18)
        | //                             [7654321_]
          //                 [____________6543210]
           ((in[19 + inPos] & 524287L) <<  1)) & 255);
      out[46 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[19 + inPos] & 524287L) >>> 7)) & 255);
      out[47 + outPos] = (byte)((
          //                             [____3210]
          //                                 [8765_______________]
           ((in[19 + inPos] & 524287L) >>> 15)
        | //                             [7654____]
          //              [_______________3210]
           ((in[20 + inPos] & 524287L) <<  4)) & 255);
      out[48 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[20 + inPos] & 524287L) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                             [_6543210]
          //                              [8765432____________]
           ((in[20 + inPos] & 524287L) >>> 12)
        | //                             [7_______]
          //           [__________________0]
           ((in[21 + inPos] & 524287L) <<  7)) & 255);
      out[50 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[21 + inPos] & 524287L) >>> 1)) & 255);
      out[51 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[21 + inPos] & 524287L) >>> 9)) & 255);
      out[52 + outPos] = (byte)((
          //                             [______10]
          //                                   [87_________________]
           ((in[21 + inPos] & 524287L) >>> 17)
        | //                             [765432__]
          //                [_____________543210]
           ((in[22 + inPos] & 524287L) <<  2)) & 255);
      out[53 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[22 + inPos] & 524287L) >>> 6)) & 255);
      out[54 + outPos] = (byte)((
          //                             [___43210]
          //                                [87654______________]
           ((in[22 + inPos] & 524287L) >>> 14)
        | //                             [765_____]
          //             [________________210]
           ((in[23 + inPos] & 524287L) <<  5)) & 255);
      out[55 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[23 + inPos] & 524287L) >>> 3)) & 255);
      out[56 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[23 + inPos] & 524287L) >>> 11)) & 255);
      out[57 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[24 + inPos] & 524287L))) & 255);
      out[58 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[24 + inPos] & 524287L) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                             [_____210]
          //                                  [876________________]
           ((in[24 + inPos] & 524287L) >>> 16)
        | //                             [76543___]
          //               [______________43210]
           ((in[25 + inPos] & 524287L) <<  3)) & 255);
      out[60 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[25 + inPos] & 524287L) >>> 5)) & 255);
      out[61 + outPos] = (byte)((
          //                             [__543210]
          //                               [876543_____________]
           ((in[25 + inPos] & 524287L) >>> 13)
        | //                             [76______]
          //            [_________________10]
           ((in[26 + inPos] & 524287L) <<  6)) & 255);
      out[62 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[26 + inPos] & 524287L) >>> 2)) & 255);
      out[63 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[26 + inPos] & 524287L) >>> 10)) & 255);
      out[64 + outPos] = (byte)((
          //                             [_______0]
          //                                    [8__________________]
           ((in[26 + inPos] & 524287L) >>> 18)
        | //                             [7654321_]
          //                 [____________6543210]
           ((in[27 + inPos] & 524287L) <<  1)) & 255);
      out[65 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[27 + inPos] & 524287L) >>> 7)) & 255);
      out[66 + outPos] = (byte)((
          //                             [____3210]
          //                                 [8765_______________]
           ((in[27 + inPos] & 524287L) >>> 15)
        | //                             [7654____]
          //              [_______________3210]
           ((in[28 + inPos] & 524287L) <<  4)) & 255);
      out[67 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[28 + inPos] & 524287L) >>> 4)) & 255);
      out[68 + outPos] = (byte)((
          //                             [_6543210]
          //                              [8765432____________]
           ((in[28 + inPos] & 524287L) >>> 12)
        | //                             [7_______]
          //           [__________________0]
           ((in[29 + inPos] & 524287L) <<  7)) & 255);
      out[69 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[29 + inPos] & 524287L) >>> 1)) & 255);
      out[70 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[29 + inPos] & 524287L) >>> 9)) & 255);
      out[71 + outPos] = (byte)((
          //                             [______10]
          //                                   [87_________________]
           ((in[29 + inPos] & 524287L) >>> 17)
        | //                             [765432__]
          //                [_____________543210]
           ((in[30 + inPos] & 524287L) <<  2)) & 255);
      out[72 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[30 + inPos] & 524287L) >>> 6)) & 255);
      out[73 + outPos] = (byte)((
          //                             [___43210]
          //                                [87654______________]
           ((in[30 + inPos] & 524287L) >>> 14)
        | //                             [765_____]
          //             [________________210]
           ((in[31 + inPos] & 524287L) <<  5)) & 255);
      out[74 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[31 + inPos] & 524287L) >>> 3)) & 255);
      out[75 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[31 + inPos] & 524287L) >>> 11)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 524287L);
      out[ 1 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[ 3 + inPos]) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in[ 4 + inPos]) <<  13) & 524287L);
      out[ 2 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[ 5 + inPos]) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[ 6 + inPos]) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in[ 7 + inPos]) <<  18) & 524287L);
      out[ 3 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[ 8 + inPos]) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[ 9 + inPos]) <<  15) & 524287L);
      out[ 4 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[10 + inPos]) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[11 + inPos]) <<  12) & 524287L);
      out[ 5 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in[11 + inPos]) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[13 + inPos]) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in[14 + inPos]) <<  17) & 524287L);
      out[ 6 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in[14 + inPos]) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[15 + inPos]) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in[16 + inPos]) <<  14) & 524287L);
      out[ 7 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in[16 + inPos]) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[17 + inPos]) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in[18 + inPos]) <<  11) & 524287L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 524287L);
      out[ 1 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get( 3 + inPos)) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get( 4 + inPos)) <<  13) & 524287L);
      out[ 2 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get( 5 + inPos)) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get( 7 + inPos)) <<  18) & 524287L);
      out[ 3 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get( 8 + inPos)) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get( 9 + inPos)) <<  15) & 524287L);
      out[ 4 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(10 + inPos)) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(11 + inPos)) <<  12) & 524287L);
      out[ 5 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in.get(11 + inPos)) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(13 + inPos)) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(14 + inPos)) <<  17) & 524287L);
      out[ 6 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(14 + inPos)) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(15 + inPos)) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(16 + inPos)) <<  14) & 524287L);
      out[ 7 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in.get(16 + inPos)) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(17 + inPos)) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(18 + inPos)) <<  11) & 524287L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 524287L);
      out[ 1 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[ 3 + inPos]) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in[ 4 + inPos]) <<  13) & 524287L);
      out[ 2 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[ 5 + inPos]) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[ 6 + inPos]) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in[ 7 + inPos]) <<  18) & 524287L);
      out[ 3 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[ 8 + inPos]) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[ 9 + inPos]) <<  15) & 524287L);
      out[ 4 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[10 + inPos]) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[11 + inPos]) <<  12) & 524287L);
      out[ 5 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in[11 + inPos]) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[13 + inPos]) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in[14 + inPos]) <<  17) & 524287L);
      out[ 6 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in[14 + inPos]) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[15 + inPos]) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in[16 + inPos]) <<  14) & 524287L);
      out[ 7 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in[16 + inPos]) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[17 + inPos]) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in[18 + inPos]) <<  11) & 524287L);
      out[ 8 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in[19 + inPos]) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[20 + inPos]) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in[21 + inPos]) <<  16) & 524287L);
      out[ 9 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in[21 + inPos]) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[22 + inPos]) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in[23 + inPos]) <<  13) & 524287L);
      out[10 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in[23 + inPos]) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[24 + inPos]) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[25 + inPos]) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in[26 + inPos]) <<  18) & 524287L);
      out[11 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[26 + inPos]) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[27 + inPos]) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[28 + inPos]) <<  15) & 524287L);
      out[12 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in[28 + inPos]) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[29 + inPos]) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[30 + inPos]) <<  12) & 524287L);
      out[13 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in[30 + inPos]) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[31 + inPos]) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[32 + inPos]) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in[33 + inPos]) <<  17) & 524287L);
      out[14 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in[33 + inPos]) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[34 + inPos]) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in[35 + inPos]) <<  14) & 524287L);
      out[15 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in[35 + inPos]) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[36 + inPos]) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in[37 + inPos]) <<  11) & 524287L);
      out[16 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in[38 + inPos]) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[39 + inPos]) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in[40 + inPos]) <<  16) & 524287L);
      out[17 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in[40 + inPos]) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[41 + inPos]) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in[42 + inPos]) <<  13) & 524287L);
      out[18 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in[42 + inPos]) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[43 + inPos]) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[44 + inPos]) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in[45 + inPos]) <<  18) & 524287L);
      out[19 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[45 + inPos]) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[46 + inPos]) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[47 + inPos]) <<  15) & 524287L);
      out[20 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in[47 + inPos]) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[48 + inPos]) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[49 + inPos]) <<  12) & 524287L);
      out[21 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in[49 + inPos]) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[50 + inPos]) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[51 + inPos]) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in[52 + inPos]) <<  17) & 524287L);
      out[22 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in[52 + inPos]) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[53 + inPos]) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in[54 + inPos]) <<  14) & 524287L);
      out[23 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in[54 + inPos]) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[55 + inPos]) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in[56 + inPos]) <<  11) & 524287L);
      out[24 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in[57 + inPos]) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[58 + inPos]) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in[59 + inPos]) <<  16) & 524287L);
      out[25 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in[59 + inPos]) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[60 + inPos]) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in[61 + inPos]) <<  13) & 524287L);
      out[26 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in[61 + inPos]) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[62 + inPos]) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[63 + inPos]) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in[64 + inPos]) <<  18) & 524287L);
      out[27 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[64 + inPos]) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[65 + inPos]) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[66 + inPos]) <<  15) & 524287L);
      out[28 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in[66 + inPos]) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[67 + inPos]) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[68 + inPos]) <<  12) & 524287L);
      out[29 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in[68 + inPos]) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[69 + inPos]) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[70 + inPos]) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in[71 + inPos]) <<  17) & 524287L);
      out[30 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in[71 + inPos]) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[72 + inPos]) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in[73 + inPos]) <<  14) & 524287L);
      out[31 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in[73 + inPos]) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[74 + inPos]) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in[75 + inPos]) <<  11) & 524287L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 524287L);
      out[ 1 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get( 3 + inPos)) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get( 4 + inPos)) <<  13) & 524287L);
      out[ 2 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get( 5 + inPos)) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get( 7 + inPos)) <<  18) & 524287L);
      out[ 3 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get( 8 + inPos)) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get( 9 + inPos)) <<  15) & 524287L);
      out[ 4 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(10 + inPos)) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(11 + inPos)) <<  12) & 524287L);
      out[ 5 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in.get(11 + inPos)) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(13 + inPos)) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(14 + inPos)) <<  17) & 524287L);
      out[ 6 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(14 + inPos)) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(15 + inPos)) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(16 + inPos)) <<  14) & 524287L);
      out[ 7 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in.get(16 + inPos)) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(17 + inPos)) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(18 + inPos)) <<  11) & 524287L);
      out[ 8 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(19 + inPos)) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(20 + inPos)) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(21 + inPos)) <<  16) & 524287L);
      out[ 9 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in.get(21 + inPos)) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(22 + inPos)) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(23 + inPos)) <<  13) & 524287L);
      out[10 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in.get(23 + inPos)) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(24 + inPos)) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(25 + inPos)) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(26 + inPos)) <<  18) & 524287L);
      out[11 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(26 + inPos)) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(27 + inPos)) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(28 + inPos)) <<  15) & 524287L);
      out[12 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(28 + inPos)) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(29 + inPos)) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(30 + inPos)) <<  12) & 524287L);
      out[13 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in.get(30 + inPos)) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(31 + inPos)) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(32 + inPos)) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(33 + inPos)) <<  17) & 524287L);
      out[14 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(34 + inPos)) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(35 + inPos)) <<  14) & 524287L);
      out[15 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in.get(35 + inPos)) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(36 + inPos)) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(37 + inPos)) <<  11) & 524287L);
      out[16 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(38 + inPos)) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(39 + inPos)) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(40 + inPos)) <<  16) & 524287L);
      out[17 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in.get(40 + inPos)) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(41 + inPos)) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(42 + inPos)) <<  13) & 524287L);
      out[18 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in.get(42 + inPos)) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(43 + inPos)) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(44 + inPos)) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(45 + inPos)) <<  18) & 524287L);
      out[19 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(45 + inPos)) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(46 + inPos)) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(47 + inPos)) <<  15) & 524287L);
      out[20 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(47 + inPos)) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(48 + inPos)) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(49 + inPos)) <<  12) & 524287L);
      out[21 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in.get(49 + inPos)) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(50 + inPos)) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(51 + inPos)) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(52 + inPos)) <<  17) & 524287L);
      out[22 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(52 + inPos)) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(53 + inPos)) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(54 + inPos)) <<  14) & 524287L);
      out[23 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in.get(54 + inPos)) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(55 + inPos)) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(56 + inPos)) <<  11) & 524287L);
      out[24 + outPos] =
          //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(57 + inPos)) ) & 255L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(58 + inPos)) <<  8) & 65535L)
        | //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(59 + inPos)) <<  16) & 524287L);
      out[25 + outPos] =
          //                             [76543___]
          //               [______________43210]
            ((((long)in.get(59 + inPos)) >>  3) & 31L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(60 + inPos)) <<  5) & 8191L)
        | //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(61 + inPos)) <<  13) & 524287L);
      out[26 + outPos] =
          //                             [76______]
          //            [_________________10]
            ((((long)in.get(61 + inPos)) >>  6) & 3L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(62 + inPos)) <<  2) & 1023L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(63 + inPos)) <<  10) & 262143L)
        | //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(64 + inPos)) <<  18) & 524287L);
      out[27 + outPos] =
          //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(64 + inPos)) >>  1) & 127L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(65 + inPos)) <<  7) & 32767L)
        | //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(66 + inPos)) <<  15) & 524287L);
      out[28 + outPos] =
          //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(66 + inPos)) >>  4) & 15L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(67 + inPos)) <<  4) & 4095L)
        | //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(68 + inPos)) <<  12) & 524287L);
      out[29 + outPos] =
          //                             [7_______]
          //           [__________________0]
            ((((long)in.get(68 + inPos)) >>  7) & 1L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(69 + inPos)) <<  1) & 511L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(70 + inPos)) <<  9) & 131071L)
        | //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(71 + inPos)) <<  17) & 524287L);
      out[30 + outPos] =
          //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(71 + inPos)) >>  2) & 63L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(72 + inPos)) <<  6) & 16383L)
        | //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(73 + inPos)) <<  14) & 524287L);
      out[31 + outPos] =
          //                             [765_____]
          //             [________________210]
            ((((long)in.get(73 + inPos)) >>  5) & 7L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(74 + inPos)) <<  3) & 2047L)
        | //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(75 + inPos)) <<  11) & 524287L);
    }
  }

  private static final class Packer20 extends BytePackerForLong {

    private Packer20() {
      super(20);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 0 + inPos] & 1048575L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 0 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 0 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 1 + inPos] & 1048575L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 1 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 1 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 2 + inPos] & 1048575L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 2 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 2 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 3 + inPos] & 1048575L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 3 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 3 + inPos] & 1048575L) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 4 + inPos] & 1048575L))) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 4 + inPos] & 1048575L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 4 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 5 + inPos] & 1048575L) <<  4)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 5 + inPos] & 1048575L) >>> 4)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 5 + inPos] & 1048575L) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 6 + inPos] & 1048575L))) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 6 + inPos] & 1048575L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 6 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 7 + inPos] & 1048575L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 7 + inPos] & 1048575L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 7 + inPos] & 1048575L) >>> 12)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 0 + inPos] & 1048575L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 0 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 0 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 1 + inPos] & 1048575L) <<  4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 1 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 1 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 2 + inPos] & 1048575L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 2 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 2 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 3 + inPos] & 1048575L) <<  4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 3 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 3 + inPos] & 1048575L) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 4 + inPos] & 1048575L))) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 4 + inPos] & 1048575L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 4 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 5 + inPos] & 1048575L) <<  4)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 5 + inPos] & 1048575L) >>> 4)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 5 + inPos] & 1048575L) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 6 + inPos] & 1048575L))) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 6 + inPos] & 1048575L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 6 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 7 + inPos] & 1048575L) <<  4)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 7 + inPos] & 1048575L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 7 + inPos] & 1048575L) >>> 12)) & 255);
      out[20 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 8 + inPos] & 1048575L))) & 255);
      out[21 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 8 + inPos] & 1048575L) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[ 8 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[ 9 + inPos] & 1048575L) <<  4)) & 255);
      out[23 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 9 + inPos] & 1048575L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 9 + inPos] & 1048575L) >>> 12)) & 255);
      out[25 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[10 + inPos] & 1048575L))) & 255);
      out[26 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[10 + inPos] & 1048575L) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[10 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[11 + inPos] & 1048575L) <<  4)) & 255);
      out[28 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[11 + inPos] & 1048575L) >>> 4)) & 255);
      out[29 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[11 + inPos] & 1048575L) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[12 + inPos] & 1048575L))) & 255);
      out[31 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[12 + inPos] & 1048575L) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[12 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[13 + inPos] & 1048575L) <<  4)) & 255);
      out[33 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[13 + inPos] & 1048575L) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[13 + inPos] & 1048575L) >>> 12)) & 255);
      out[35 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[14 + inPos] & 1048575L))) & 255);
      out[36 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[14 + inPos] & 1048575L) >>> 8)) & 255);
      out[37 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[14 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[15 + inPos] & 1048575L) <<  4)) & 255);
      out[38 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[15 + inPos] & 1048575L) >>> 4)) & 255);
      out[39 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[15 + inPos] & 1048575L) >>> 12)) & 255);
      out[40 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[16 + inPos] & 1048575L))) & 255);
      out[41 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[16 + inPos] & 1048575L) >>> 8)) & 255);
      out[42 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[16 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[17 + inPos] & 1048575L) <<  4)) & 255);
      out[43 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[17 + inPos] & 1048575L) >>> 4)) & 255);
      out[44 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[17 + inPos] & 1048575L) >>> 12)) & 255);
      out[45 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[18 + inPos] & 1048575L))) & 255);
      out[46 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[18 + inPos] & 1048575L) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[18 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[19 + inPos] & 1048575L) <<  4)) & 255);
      out[48 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[19 + inPos] & 1048575L) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[19 + inPos] & 1048575L) >>> 12)) & 255);
      out[50 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[20 + inPos] & 1048575L))) & 255);
      out[51 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[20 + inPos] & 1048575L) >>> 8)) & 255);
      out[52 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[20 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[21 + inPos] & 1048575L) <<  4)) & 255);
      out[53 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[21 + inPos] & 1048575L) >>> 4)) & 255);
      out[54 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[21 + inPos] & 1048575L) >>> 12)) & 255);
      out[55 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[22 + inPos] & 1048575L))) & 255);
      out[56 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[22 + inPos] & 1048575L) >>> 8)) & 255);
      out[57 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[22 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[23 + inPos] & 1048575L) <<  4)) & 255);
      out[58 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[23 + inPos] & 1048575L) >>> 4)) & 255);
      out[59 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[23 + inPos] & 1048575L) >>> 12)) & 255);
      out[60 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[24 + inPos] & 1048575L))) & 255);
      out[61 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[24 + inPos] & 1048575L) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[24 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[25 + inPos] & 1048575L) <<  4)) & 255);
      out[63 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[25 + inPos] & 1048575L) >>> 4)) & 255);
      out[64 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[25 + inPos] & 1048575L) >>> 12)) & 255);
      out[65 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[26 + inPos] & 1048575L))) & 255);
      out[66 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[26 + inPos] & 1048575L) >>> 8)) & 255);
      out[67 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[26 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[27 + inPos] & 1048575L) <<  4)) & 255);
      out[68 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[27 + inPos] & 1048575L) >>> 4)) & 255);
      out[69 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[27 + inPos] & 1048575L) >>> 12)) & 255);
      out[70 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[28 + inPos] & 1048575L))) & 255);
      out[71 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[28 + inPos] & 1048575L) >>> 8)) & 255);
      out[72 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[28 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[29 + inPos] & 1048575L) <<  4)) & 255);
      out[73 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[29 + inPos] & 1048575L) >>> 4)) & 255);
      out[74 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[29 + inPos] & 1048575L) >>> 12)) & 255);
      out[75 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[30 + inPos] & 1048575L))) & 255);
      out[76 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[30 + inPos] & 1048575L) >>> 8)) & 255);
      out[77 + outPos] = (byte)((
          //                              [____3210]
          //                                  [9876________________]
           ((in[30 + inPos] & 1048575L) >>> 16)
        | //                              [7654____]
          //              [________________3210]
           ((in[31 + inPos] & 1048575L) <<  4)) & 255);
      out[78 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[31 + inPos] & 1048575L) >>> 4)) & 255);
      out[79 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[31 + inPos] & 1048575L) >>> 12)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 1048575L);
      out[ 1 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 4 + inPos]) <<  12) & 1048575L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 5 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 6 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 7 + inPos]) <<  16) & 1048575L);
      out[ 3 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 1048575L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[10 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[11 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[12 + inPos]) <<  16) & 1048575L);
      out[ 5 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[12 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[13 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[14 + inPos]) <<  12) & 1048575L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[15 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[16 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[17 + inPos]) <<  16) & 1048575L);
      out[ 7 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[18 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[19 + inPos]) <<  12) & 1048575L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 1048575L);
      out[ 1 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 4 + inPos)) <<  12) & 1048575L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 6 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 7 + inPos)) <<  16) & 1048575L);
      out[ 3 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 9 + inPos)) <<  12) & 1048575L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(11 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(12 + inPos)) <<  16) & 1048575L);
      out[ 5 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(13 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(14 + inPos)) <<  12) & 1048575L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(15 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(17 + inPos)) <<  16) & 1048575L);
      out[ 7 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(19 + inPos)) <<  12) & 1048575L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 1048575L);
      out[ 1 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 4 + inPos]) <<  12) & 1048575L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 5 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 6 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 7 + inPos]) <<  16) & 1048575L);
      out[ 3 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 1048575L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[10 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[11 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[12 + inPos]) <<  16) & 1048575L);
      out[ 5 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[12 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[13 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[14 + inPos]) <<  12) & 1048575L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[15 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[16 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[17 + inPos]) <<  16) & 1048575L);
      out[ 7 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[18 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[19 + inPos]) <<  12) & 1048575L);
      out[ 8 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[20 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[21 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[22 + inPos]) <<  16) & 1048575L);
      out[ 9 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[23 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[24 + inPos]) <<  12) & 1048575L);
      out[10 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[25 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[26 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[27 + inPos]) <<  16) & 1048575L);
      out[11 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[27 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[28 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[29 + inPos]) <<  12) & 1048575L);
      out[12 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[30 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[31 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[32 + inPos]) <<  16) & 1048575L);
      out[13 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[32 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[33 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[34 + inPos]) <<  12) & 1048575L);
      out[14 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[35 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[36 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[37 + inPos]) <<  16) & 1048575L);
      out[15 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[38 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[39 + inPos]) <<  12) & 1048575L);
      out[16 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[40 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[41 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[42 + inPos]) <<  16) & 1048575L);
      out[17 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[42 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[43 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[44 + inPos]) <<  12) & 1048575L);
      out[18 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[45 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[46 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[47 + inPos]) <<  16) & 1048575L);
      out[19 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[47 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[48 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[49 + inPos]) <<  12) & 1048575L);
      out[20 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[50 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[51 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[52 + inPos]) <<  16) & 1048575L);
      out[21 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[53 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[54 + inPos]) <<  12) & 1048575L);
      out[22 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[55 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[56 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[57 + inPos]) <<  16) & 1048575L);
      out[23 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[57 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[58 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[59 + inPos]) <<  12) & 1048575L);
      out[24 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[60 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[61 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[62 + inPos]) <<  16) & 1048575L);
      out[25 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[62 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[63 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[64 + inPos]) <<  12) & 1048575L);
      out[26 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[65 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[66 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[67 + inPos]) <<  16) & 1048575L);
      out[27 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[67 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[68 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[69 + inPos]) <<  12) & 1048575L);
      out[28 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[70 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[71 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[72 + inPos]) <<  16) & 1048575L);
      out[29 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[72 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[73 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[74 + inPos]) <<  12) & 1048575L);
      out[30 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in[75 + inPos]) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[76 + inPos]) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in[77 + inPos]) <<  16) & 1048575L);
      out[31 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in[77 + inPos]) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[78 + inPos]) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in[79 + inPos]) <<  12) & 1048575L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 1048575L);
      out[ 1 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 4 + inPos)) <<  12) & 1048575L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 6 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 7 + inPos)) <<  16) & 1048575L);
      out[ 3 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 9 + inPos)) <<  12) & 1048575L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(11 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(12 + inPos)) <<  16) & 1048575L);
      out[ 5 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(13 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(14 + inPos)) <<  12) & 1048575L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(15 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(17 + inPos)) <<  16) & 1048575L);
      out[ 7 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(19 + inPos)) <<  12) & 1048575L);
      out[ 8 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(20 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(21 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(22 + inPos)) <<  16) & 1048575L);
      out[ 9 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(24 + inPos)) <<  12) & 1048575L);
      out[10 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(25 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(26 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(27 + inPos)) <<  16) & 1048575L);
      out[11 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(28 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(29 + inPos)) <<  12) & 1048575L);
      out[12 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(30 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(31 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(32 + inPos)) <<  16) & 1048575L);
      out[13 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(33 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(34 + inPos)) <<  12) & 1048575L);
      out[14 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(35 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(36 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(37 + inPos)) <<  16) & 1048575L);
      out[15 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(38 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(39 + inPos)) <<  12) & 1048575L);
      out[16 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(40 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(41 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(42 + inPos)) <<  16) & 1048575L);
      out[17 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(42 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(43 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(44 + inPos)) <<  12) & 1048575L);
      out[18 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(45 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(46 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(47 + inPos)) <<  16) & 1048575L);
      out[19 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(47 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(48 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(49 + inPos)) <<  12) & 1048575L);
      out[20 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(50 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(51 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(52 + inPos)) <<  16) & 1048575L);
      out[21 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(53 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(54 + inPos)) <<  12) & 1048575L);
      out[22 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(55 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(56 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(57 + inPos)) <<  16) & 1048575L);
      out[23 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(57 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(58 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(59 + inPos)) <<  12) & 1048575L);
      out[24 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(60 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(61 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(62 + inPos)) <<  16) & 1048575L);
      out[25 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(62 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(63 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(64 + inPos)) <<  12) & 1048575L);
      out[26 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(65 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(66 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(67 + inPos)) <<  16) & 1048575L);
      out[27 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(67 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(68 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(69 + inPos)) <<  12) & 1048575L);
      out[28 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(70 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(71 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(72 + inPos)) <<  16) & 1048575L);
      out[29 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(72 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(73 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(74 + inPos)) <<  12) & 1048575L);
      out[30 + outPos] =
          //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(75 + inPos)) ) & 255L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(76 + inPos)) <<  8) & 65535L)
        | //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(77 + inPos)) <<  16) & 1048575L);
      out[31 + outPos] =
          //                              [7654____]
          //              [________________3210]
            ((((long)in.get(77 + inPos)) >>  4) & 15L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(78 + inPos)) <<  4) & 4095L)
        | //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(79 + inPos)) <<  12) & 1048575L);
    }
  }

  private static final class Packer21 extends BytePackerForLong {

    private Packer21() {
      super(21);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 0 + inPos] & 2097151L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 0 + inPos] & 2097151L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [___43210]
          //                                  [09876________________]
           ((in[ 0 + inPos] & 2097151L) >>> 16)
        | //                               [765_____]
          //             [__________________210]
           ((in[ 1 + inPos] & 2097151L) <<  5)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 1 + inPos] & 2097151L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 1 + inPos] & 2097151L) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [______10]
          //                                     [09___________________]
           ((in[ 1 + inPos] & 2097151L) >>> 19)
        | //                               [765432__]
          //                [_______________543210]
           ((in[ 2 + inPos] & 2097151L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 2 + inPos] & 2097151L) >>> 6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [_6543210]
          //                                [0987654______________]
           ((in[ 2 + inPos] & 2097151L) >>> 14)
        | //                               [7_______]
          //           [____________________0]
           ((in[ 3 + inPos] & 2097151L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 3 + inPos] & 2097151L) >>> 1)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 3 + inPos] & 2097151L) >>> 9)) & 255);
      out[10 + outPos] = (byte)((
          //                               [____3210]
          //                                   [0987_________________]
           ((in[ 3 + inPos] & 2097151L) >>> 17)
        | //                               [7654____]
          //              [_________________3210]
           ((in[ 4 + inPos] & 2097151L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 4 + inPos] & 2097151L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 4 + inPos] & 2097151L) >>> 12)) & 255);
      out[13 + outPos] = (byte)((
          //                               [_______0]
          //                                      [0____________________]
           ((in[ 4 + inPos] & 2097151L) >>> 20)
        | //                               [7654321_]
          //                 [______________6543210]
           ((in[ 5 + inPos] & 2097151L) <<  1)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 5 + inPos] & 2097151L) >>> 7)) & 255);
      out[15 + outPos] = (byte)((
          //                               [__543210]
          //                                 [098765_______________]
           ((in[ 5 + inPos] & 2097151L) >>> 15)
        | //                               [76______]
          //            [___________________10]
           ((in[ 6 + inPos] & 2097151L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 6 + inPos] & 2097151L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 6 + inPos] & 2097151L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                               [_____210]
          //                                    [098__________________]
           ((in[ 6 + inPos] & 2097151L) >>> 18)
        | //                               [76543___]
          //               [________________43210]
           ((in[ 7 + inPos] & 2097151L) <<  3)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 7 + inPos] & 2097151L) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 7 + inPos] & 2097151L) >>> 13)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 0 + inPos] & 2097151L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 0 + inPos] & 2097151L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [___43210]
          //                                  [09876________________]
           ((in[ 0 + inPos] & 2097151L) >>> 16)
        | //                               [765_____]
          //             [__________________210]
           ((in[ 1 + inPos] & 2097151L) <<  5)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 1 + inPos] & 2097151L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 1 + inPos] & 2097151L) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [______10]
          //                                     [09___________________]
           ((in[ 1 + inPos] & 2097151L) >>> 19)
        | //                               [765432__]
          //                [_______________543210]
           ((in[ 2 + inPos] & 2097151L) <<  2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 2 + inPos] & 2097151L) >>> 6)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [_6543210]
          //                                [0987654______________]
           ((in[ 2 + inPos] & 2097151L) >>> 14)
        | //                               [7_______]
          //           [____________________0]
           ((in[ 3 + inPos] & 2097151L) <<  7)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 3 + inPos] & 2097151L) >>> 1)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 3 + inPos] & 2097151L) >>> 9)) & 255);
      out[10 + outPos] = (byte)((
          //                               [____3210]
          //                                   [0987_________________]
           ((in[ 3 + inPos] & 2097151L) >>> 17)
        | //                               [7654____]
          //              [_________________3210]
           ((in[ 4 + inPos] & 2097151L) <<  4)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 4 + inPos] & 2097151L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 4 + inPos] & 2097151L) >>> 12)) & 255);
      out[13 + outPos] = (byte)((
          //                               [_______0]
          //                                      [0____________________]
           ((in[ 4 + inPos] & 2097151L) >>> 20)
        | //                               [7654321_]
          //                 [______________6543210]
           ((in[ 5 + inPos] & 2097151L) <<  1)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 5 + inPos] & 2097151L) >>> 7)) & 255);
      out[15 + outPos] = (byte)((
          //                               [__543210]
          //                                 [098765_______________]
           ((in[ 5 + inPos] & 2097151L) >>> 15)
        | //                               [76______]
          //            [___________________10]
           ((in[ 6 + inPos] & 2097151L) <<  6)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 6 + inPos] & 2097151L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 6 + inPos] & 2097151L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                               [_____210]
          //                                    [098__________________]
           ((in[ 6 + inPos] & 2097151L) >>> 18)
        | //                               [76543___]
          //               [________________43210]
           ((in[ 7 + inPos] & 2097151L) <<  3)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 7 + inPos] & 2097151L) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 7 + inPos] & 2097151L) >>> 13)) & 255);
      out[21 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 8 + inPos] & 2097151L))) & 255);
      out[22 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 8 + inPos] & 2097151L) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                               [___43210]
          //                                  [09876________________]
           ((in[ 8 + inPos] & 2097151L) >>> 16)
        | //                               [765_____]
          //             [__________________210]
           ((in[ 9 + inPos] & 2097151L) <<  5)) & 255);
      out[24 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 9 + inPos] & 2097151L) >>> 3)) & 255);
      out[25 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 9 + inPos] & 2097151L) >>> 11)) & 255);
      out[26 + outPos] = (byte)((
          //                               [______10]
          //                                     [09___________________]
           ((in[ 9 + inPos] & 2097151L) >>> 19)
        | //                               [765432__]
          //                [_______________543210]
           ((in[10 + inPos] & 2097151L) <<  2)) & 255);
      out[27 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[10 + inPos] & 2097151L) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                               [_6543210]
          //                                [0987654______________]
           ((in[10 + inPos] & 2097151L) >>> 14)
        | //                               [7_______]
          //           [____________________0]
           ((in[11 + inPos] & 2097151L) <<  7)) & 255);
      out[29 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[11 + inPos] & 2097151L) >>> 1)) & 255);
      out[30 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[11 + inPos] & 2097151L) >>> 9)) & 255);
      out[31 + outPos] = (byte)((
          //                               [____3210]
          //                                   [0987_________________]
           ((in[11 + inPos] & 2097151L) >>> 17)
        | //                               [7654____]
          //              [_________________3210]
           ((in[12 + inPos] & 2097151L) <<  4)) & 255);
      out[32 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[12 + inPos] & 2097151L) >>> 4)) & 255);
      out[33 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[12 + inPos] & 2097151L) >>> 12)) & 255);
      out[34 + outPos] = (byte)((
          //                               [_______0]
          //                                      [0____________________]
           ((in[12 + inPos] & 2097151L) >>> 20)
        | //                               [7654321_]
          //                 [______________6543210]
           ((in[13 + inPos] & 2097151L) <<  1)) & 255);
      out[35 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[13 + inPos] & 2097151L) >>> 7)) & 255);
      out[36 + outPos] = (byte)((
          //                               [__543210]
          //                                 [098765_______________]
           ((in[13 + inPos] & 2097151L) >>> 15)
        | //                               [76______]
          //            [___________________10]
           ((in[14 + inPos] & 2097151L) <<  6)) & 255);
      out[37 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[14 + inPos] & 2097151L) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[14 + inPos] & 2097151L) >>> 10)) & 255);
      out[39 + outPos] = (byte)((
          //                               [_____210]
          //                                    [098__________________]
           ((in[14 + inPos] & 2097151L) >>> 18)
        | //                               [76543___]
          //               [________________43210]
           ((in[15 + inPos] & 2097151L) <<  3)) & 255);
      out[40 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[15 + inPos] & 2097151L) >>> 5)) & 255);
      out[41 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[15 + inPos] & 2097151L) >>> 13)) & 255);
      out[42 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[16 + inPos] & 2097151L))) & 255);
      out[43 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[16 + inPos] & 2097151L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                               [___43210]
          //                                  [09876________________]
           ((in[16 + inPos] & 2097151L) >>> 16)
        | //                               [765_____]
          //             [__________________210]
           ((in[17 + inPos] & 2097151L) <<  5)) & 255);
      out[45 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[17 + inPos] & 2097151L) >>> 3)) & 255);
      out[46 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[17 + inPos] & 2097151L) >>> 11)) & 255);
      out[47 + outPos] = (byte)((
          //                               [______10]
          //                                     [09___________________]
           ((in[17 + inPos] & 2097151L) >>> 19)
        | //                               [765432__]
          //                [_______________543210]
           ((in[18 + inPos] & 2097151L) <<  2)) & 255);
      out[48 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[18 + inPos] & 2097151L) >>> 6)) & 255);
      out[49 + outPos] = (byte)((
          //                               [_6543210]
          //                                [0987654______________]
           ((in[18 + inPos] & 2097151L) >>> 14)
        | //                               [7_______]
          //           [____________________0]
           ((in[19 + inPos] & 2097151L) <<  7)) & 255);
      out[50 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[19 + inPos] & 2097151L) >>> 1)) & 255);
      out[51 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[19 + inPos] & 2097151L) >>> 9)) & 255);
      out[52 + outPos] = (byte)((
          //                               [____3210]
          //                                   [0987_________________]
           ((in[19 + inPos] & 2097151L) >>> 17)
        | //                               [7654____]
          //              [_________________3210]
           ((in[20 + inPos] & 2097151L) <<  4)) & 255);
      out[53 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[20 + inPos] & 2097151L) >>> 4)) & 255);
      out[54 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[20 + inPos] & 2097151L) >>> 12)) & 255);
      out[55 + outPos] = (byte)((
          //                               [_______0]
          //                                      [0____________________]
           ((in[20 + inPos] & 2097151L) >>> 20)
        | //                               [7654321_]
          //                 [______________6543210]
           ((in[21 + inPos] & 2097151L) <<  1)) & 255);
      out[56 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[21 + inPos] & 2097151L) >>> 7)) & 255);
      out[57 + outPos] = (byte)((
          //                               [__543210]
          //                                 [098765_______________]
           ((in[21 + inPos] & 2097151L) >>> 15)
        | //                               [76______]
          //            [___________________10]
           ((in[22 + inPos] & 2097151L) <<  6)) & 255);
      out[58 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[22 + inPos] & 2097151L) >>> 2)) & 255);
      out[59 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[22 + inPos] & 2097151L) >>> 10)) & 255);
      out[60 + outPos] = (byte)((
          //                               [_____210]
          //                                    [098__________________]
           ((in[22 + inPos] & 2097151L) >>> 18)
        | //                               [76543___]
          //               [________________43210]
           ((in[23 + inPos] & 2097151L) <<  3)) & 255);
      out[61 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[23 + inPos] & 2097151L) >>> 5)) & 255);
      out[62 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[23 + inPos] & 2097151L) >>> 13)) & 255);
      out[63 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[24 + inPos] & 2097151L))) & 255);
      out[64 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[24 + inPos] & 2097151L) >>> 8)) & 255);
      out[65 + outPos] = (byte)((
          //                               [___43210]
          //                                  [09876________________]
           ((in[24 + inPos] & 2097151L) >>> 16)
        | //                               [765_____]
          //             [__________________210]
           ((in[25 + inPos] & 2097151L) <<  5)) & 255);
      out[66 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[25 + inPos] & 2097151L) >>> 3)) & 255);
      out[67 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[25 + inPos] & 2097151L) >>> 11)) & 255);
      out[68 + outPos] = (byte)((
          //                               [______10]
          //                                     [09___________________]
           ((in[25 + inPos] & 2097151L) >>> 19)
        | //                               [765432__]
          //                [_______________543210]
           ((in[26 + inPos] & 2097151L) <<  2)) & 255);
      out[69 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[26 + inPos] & 2097151L) >>> 6)) & 255);
      out[70 + outPos] = (byte)((
          //                               [_6543210]
          //                                [0987654______________]
           ((in[26 + inPos] & 2097151L) >>> 14)
        | //                               [7_______]
          //           [____________________0]
           ((in[27 + inPos] & 2097151L) <<  7)) & 255);
      out[71 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[27 + inPos] & 2097151L) >>> 1)) & 255);
      out[72 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[27 + inPos] & 2097151L) >>> 9)) & 255);
      out[73 + outPos] = (byte)((
          //                               [____3210]
          //                                   [0987_________________]
           ((in[27 + inPos] & 2097151L) >>> 17)
        | //                               [7654____]
          //              [_________________3210]
           ((in[28 + inPos] & 2097151L) <<  4)) & 255);
      out[74 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[28 + inPos] & 2097151L) >>> 4)) & 255);
      out[75 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[28 + inPos] & 2097151L) >>> 12)) & 255);
      out[76 + outPos] = (byte)((
          //                               [_______0]
          //                                      [0____________________]
           ((in[28 + inPos] & 2097151L) >>> 20)
        | //                               [7654321_]
          //                 [______________6543210]
           ((in[29 + inPos] & 2097151L) <<  1)) & 255);
      out[77 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[29 + inPos] & 2097151L) >>> 7)) & 255);
      out[78 + outPos] = (byte)((
          //                               [__543210]
          //                                 [098765_______________]
           ((in[29 + inPos] & 2097151L) >>> 15)
        | //                               [76______]
          //            [___________________10]
           ((in[30 + inPos] & 2097151L) <<  6)) & 255);
      out[79 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[30 + inPos] & 2097151L) >>> 2)) & 255);
      out[80 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[30 + inPos] & 2097151L) >>> 10)) & 255);
      out[81 + outPos] = (byte)((
          //                               [_____210]
          //                                    [098__________________]
           ((in[30 + inPos] & 2097151L) >>> 18)
        | //                               [76543___]
          //               [________________43210]
           ((in[31 + inPos] & 2097151L) <<  3)) & 255);
      out[82 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[31 + inPos] & 2097151L) >>> 5)) & 255);
      out[83 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[31 + inPos] & 2097151L) >>> 13)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 2097151L);
      out[ 1 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[ 3 + inPos]) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[ 4 + inPos]) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in[ 5 + inPos]) <<  19) & 2097151L);
      out[ 2 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[ 6 + inPos]) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[ 7 + inPos]) <<  14) & 2097151L);
      out[ 3 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[ 8 + inPos]) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[ 9 + inPos]) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[10 + inPos]) <<  17) & 2097151L);
      out[ 4 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[12 + inPos]) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in[13 + inPos]) <<  20) & 2097151L);
      out[ 5 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[13 + inPos]) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[14 + inPos]) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[15 + inPos]) <<  15) & 2097151L);
      out[ 6 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in[18 + inPos]) <<  18) & 2097151L);
      out[ 7 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in[18 + inPos]) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[19 + inPos]) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[20 + inPos]) <<  13) & 2097151L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 2097151L);
      out[ 1 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get( 4 + inPos)) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in.get( 5 + inPos)) <<  19) & 2097151L);
      out[ 2 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get( 6 + inPos)) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get( 7 + inPos)) <<  14) & 2097151L);
      out[ 3 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get( 8 + inPos)) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get( 9 + inPos)) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(10 + inPos)) <<  17) & 2097151L);
      out[ 4 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(12 + inPos)) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(13 + inPos)) <<  20) & 2097151L);
      out[ 5 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(13 + inPos)) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(14 + inPos)) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(15 + inPos)) <<  15) & 2097151L);
      out[ 6 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(18 + inPos)) <<  18) & 2097151L);
      out[ 7 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in.get(18 + inPos)) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(19 + inPos)) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(20 + inPos)) <<  13) & 2097151L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 2097151L);
      out[ 1 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[ 3 + inPos]) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[ 4 + inPos]) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in[ 5 + inPos]) <<  19) & 2097151L);
      out[ 2 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[ 6 + inPos]) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[ 7 + inPos]) <<  14) & 2097151L);
      out[ 3 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[ 8 + inPos]) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[ 9 + inPos]) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[10 + inPos]) <<  17) & 2097151L);
      out[ 4 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[12 + inPos]) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in[13 + inPos]) <<  20) & 2097151L);
      out[ 5 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[13 + inPos]) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[14 + inPos]) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[15 + inPos]) <<  15) & 2097151L);
      out[ 6 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in[15 + inPos]) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in[18 + inPos]) <<  18) & 2097151L);
      out[ 7 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in[18 + inPos]) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[19 + inPos]) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[20 + inPos]) <<  13) & 2097151L);
      out[ 8 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[21 + inPos]) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[22 + inPos]) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in[23 + inPos]) <<  16) & 2097151L);
      out[ 9 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in[23 + inPos]) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[24 + inPos]) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[25 + inPos]) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in[26 + inPos]) <<  19) & 2097151L);
      out[10 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in[26 + inPos]) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[27 + inPos]) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[28 + inPos]) <<  14) & 2097151L);
      out[11 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in[28 + inPos]) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[29 + inPos]) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[30 + inPos]) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[31 + inPos]) <<  17) & 2097151L);
      out[12 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[32 + inPos]) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[33 + inPos]) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in[34 + inPos]) <<  20) & 2097151L);
      out[13 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[34 + inPos]) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[35 + inPos]) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[36 + inPos]) <<  15) & 2097151L);
      out[14 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in[36 + inPos]) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[37 + inPos]) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[38 + inPos]) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in[39 + inPos]) <<  18) & 2097151L);
      out[15 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in[39 + inPos]) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[40 + inPos]) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[41 + inPos]) <<  13) & 2097151L);
      out[16 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[42 + inPos]) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[43 + inPos]) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in[44 + inPos]) <<  16) & 2097151L);
      out[17 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in[44 + inPos]) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[45 + inPos]) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[46 + inPos]) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in[47 + inPos]) <<  19) & 2097151L);
      out[18 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in[47 + inPos]) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[48 + inPos]) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[49 + inPos]) <<  14) & 2097151L);
      out[19 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in[49 + inPos]) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[50 + inPos]) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[51 + inPos]) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[52 + inPos]) <<  17) & 2097151L);
      out[20 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[53 + inPos]) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[54 + inPos]) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in[55 + inPos]) <<  20) & 2097151L);
      out[21 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[55 + inPos]) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[56 + inPos]) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[57 + inPos]) <<  15) & 2097151L);
      out[22 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in[57 + inPos]) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[58 + inPos]) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[59 + inPos]) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in[60 + inPos]) <<  18) & 2097151L);
      out[23 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in[60 + inPos]) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[61 + inPos]) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[62 + inPos]) <<  13) & 2097151L);
      out[24 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[63 + inPos]) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[64 + inPos]) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in[65 + inPos]) <<  16) & 2097151L);
      out[25 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in[65 + inPos]) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[66 + inPos]) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[67 + inPos]) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in[68 + inPos]) <<  19) & 2097151L);
      out[26 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in[68 + inPos]) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[69 + inPos]) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[70 + inPos]) <<  14) & 2097151L);
      out[27 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in[70 + inPos]) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[71 + inPos]) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[72 + inPos]) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[73 + inPos]) <<  17) & 2097151L);
      out[28 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in[73 + inPos]) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[74 + inPos]) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[75 + inPos]) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in[76 + inPos]) <<  20) & 2097151L);
      out[29 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[76 + inPos]) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[77 + inPos]) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[78 + inPos]) <<  15) & 2097151L);
      out[30 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in[78 + inPos]) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[79 + inPos]) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[80 + inPos]) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in[81 + inPos]) <<  18) & 2097151L);
      out[31 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in[81 + inPos]) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[82 + inPos]) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[83 + inPos]) <<  13) & 2097151L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 2097151L);
      out[ 1 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get( 4 + inPos)) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in.get( 5 + inPos)) <<  19) & 2097151L);
      out[ 2 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get( 6 + inPos)) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get( 7 + inPos)) <<  14) & 2097151L);
      out[ 3 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get( 8 + inPos)) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get( 9 + inPos)) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(10 + inPos)) <<  17) & 2097151L);
      out[ 4 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(12 + inPos)) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(13 + inPos)) <<  20) & 2097151L);
      out[ 5 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(13 + inPos)) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(14 + inPos)) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(15 + inPos)) <<  15) & 2097151L);
      out[ 6 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in.get(15 + inPos)) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(18 + inPos)) <<  18) & 2097151L);
      out[ 7 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in.get(18 + inPos)) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(19 + inPos)) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(20 + inPos)) <<  13) & 2097151L);
      out[ 8 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(21 + inPos)) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(22 + inPos)) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(23 + inPos)) <<  16) & 2097151L);
      out[ 9 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in.get(23 + inPos)) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(24 + inPos)) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(25 + inPos)) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(26 + inPos)) <<  19) & 2097151L);
      out[10 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(26 + inPos)) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(27 + inPos)) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(28 + inPos)) <<  14) & 2097151L);
      out[11 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in.get(28 + inPos)) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(29 + inPos)) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(30 + inPos)) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(31 + inPos)) <<  17) & 2097151L);
      out[12 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(32 + inPos)) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(33 + inPos)) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(34 + inPos)) <<  20) & 2097151L);
      out[13 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(34 + inPos)) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(35 + inPos)) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(36 + inPos)) <<  15) & 2097151L);
      out[14 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in.get(36 + inPos)) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(37 + inPos)) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(38 + inPos)) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(39 + inPos)) <<  18) & 2097151L);
      out[15 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in.get(39 + inPos)) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(40 + inPos)) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(41 + inPos)) <<  13) & 2097151L);
      out[16 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(42 + inPos)) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(44 + inPos)) <<  16) & 2097151L);
      out[17 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in.get(44 + inPos)) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(45 + inPos)) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(46 + inPos)) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(47 + inPos)) <<  19) & 2097151L);
      out[18 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(47 + inPos)) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(48 + inPos)) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(49 + inPos)) <<  14) & 2097151L);
      out[19 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in.get(49 + inPos)) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(50 + inPos)) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(51 + inPos)) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(52 + inPos)) <<  17) & 2097151L);
      out[20 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(53 + inPos)) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(54 + inPos)) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(55 + inPos)) <<  20) & 2097151L);
      out[21 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(55 + inPos)) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(56 + inPos)) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(57 + inPos)) <<  15) & 2097151L);
      out[22 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in.get(57 + inPos)) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(58 + inPos)) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(59 + inPos)) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(60 + inPos)) <<  18) & 2097151L);
      out[23 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in.get(60 + inPos)) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(61 + inPos)) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(62 + inPos)) <<  13) & 2097151L);
      out[24 + outPos] =
          //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(63 + inPos)) ) & 255L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(64 + inPos)) <<  8) & 65535L)
        | //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(65 + inPos)) <<  16) & 2097151L);
      out[25 + outPos] =
          //                               [765_____]
          //             [__________________210]
            ((((long)in.get(65 + inPos)) >>  5) & 7L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(66 + inPos)) <<  3) & 2047L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(67 + inPos)) <<  11) & 524287L)
        | //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(68 + inPos)) <<  19) & 2097151L);
      out[26 + outPos] =
          //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(68 + inPos)) >>  2) & 63L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(69 + inPos)) <<  6) & 16383L)
        | //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(70 + inPos)) <<  14) & 2097151L);
      out[27 + outPos] =
          //                               [7_______]
          //           [____________________0]
            ((((long)in.get(70 + inPos)) >>  7) & 1L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(71 + inPos)) <<  1) & 511L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(72 + inPos)) <<  9) & 131071L)
        | //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(73 + inPos)) <<  17) & 2097151L);
      out[28 + outPos] =
          //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(73 + inPos)) >>  4) & 15L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(74 + inPos)) <<  4) & 4095L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(75 + inPos)) <<  12) & 1048575L)
        | //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(76 + inPos)) <<  20) & 2097151L);
      out[29 + outPos] =
          //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(76 + inPos)) >>  1) & 127L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(77 + inPos)) <<  7) & 32767L)
        | //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(78 + inPos)) <<  15) & 2097151L);
      out[30 + outPos] =
          //                               [76______]
          //            [___________________10]
            ((((long)in.get(78 + inPos)) >>  6) & 3L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(79 + inPos)) <<  2) & 1023L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(80 + inPos)) <<  10) & 262143L)
        | //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(81 + inPos)) <<  18) & 2097151L);
      out[31 + outPos] =
          //                               [76543___]
          //               [________________43210]
            ((((long)in.get(81 + inPos)) >>  3) & 31L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(82 + inPos)) <<  5) & 8191L)
        | //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(83 + inPos)) <<  13) & 2097151L);
    }
  }

  private static final class Packer22 extends BytePackerForLong {

    private Packer22() {
      super(22);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 0 + inPos] & 4194303L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 0 + inPos] & 4194303L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[ 0 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[ 1 + inPos] & 4194303L) <<  6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 1 + inPos] & 4194303L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 1 + inPos] & 4194303L) >>> 10)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[ 1 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[ 2 + inPos] & 4194303L) <<  4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 2 + inPos] & 4194303L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 2 + inPos] & 4194303L) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[ 2 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[ 3 + inPos] & 4194303L) <<  2)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 3 + inPos] & 4194303L) >>> 6)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 3 + inPos] & 4194303L) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 4 + inPos] & 4194303L))) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 4 + inPos] & 4194303L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[ 4 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[ 5 + inPos] & 4194303L) <<  6)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 5 + inPos] & 4194303L) >>> 2)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 5 + inPos] & 4194303L) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[ 5 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[ 6 + inPos] & 4194303L) <<  4)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 6 + inPos] & 4194303L) >>> 4)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 6 + inPos] & 4194303L) >>> 12)) & 255);
      out[19 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[ 6 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[ 7 + inPos] & 4194303L) <<  2)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 7 + inPos] & 4194303L) >>> 6)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 7 + inPos] & 4194303L) >>> 14)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 0 + inPos] & 4194303L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 0 + inPos] & 4194303L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[ 0 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[ 1 + inPos] & 4194303L) <<  6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 1 + inPos] & 4194303L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 1 + inPos] & 4194303L) >>> 10)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[ 1 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[ 2 + inPos] & 4194303L) <<  4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 2 + inPos] & 4194303L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 2 + inPos] & 4194303L) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[ 2 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[ 3 + inPos] & 4194303L) <<  2)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 3 + inPos] & 4194303L) >>> 6)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 3 + inPos] & 4194303L) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 4 + inPos] & 4194303L))) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 4 + inPos] & 4194303L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[ 4 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[ 5 + inPos] & 4194303L) <<  6)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 5 + inPos] & 4194303L) >>> 2)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 5 + inPos] & 4194303L) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[ 5 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[ 6 + inPos] & 4194303L) <<  4)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 6 + inPos] & 4194303L) >>> 4)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 6 + inPos] & 4194303L) >>> 12)) & 255);
      out[19 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[ 6 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[ 7 + inPos] & 4194303L) <<  2)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 7 + inPos] & 4194303L) >>> 6)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 7 + inPos] & 4194303L) >>> 14)) & 255);
      out[22 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 8 + inPos] & 4194303L))) & 255);
      out[23 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 8 + inPos] & 4194303L) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[ 8 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[ 9 + inPos] & 4194303L) <<  6)) & 255);
      out[25 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 9 + inPos] & 4194303L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 9 + inPos] & 4194303L) >>> 10)) & 255);
      out[27 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[ 9 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[10 + inPos] & 4194303L) <<  4)) & 255);
      out[28 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[10 + inPos] & 4194303L) >>> 4)) & 255);
      out[29 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[10 + inPos] & 4194303L) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[10 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[11 + inPos] & 4194303L) <<  2)) & 255);
      out[31 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[11 + inPos] & 4194303L) >>> 6)) & 255);
      out[32 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[11 + inPos] & 4194303L) >>> 14)) & 255);
      out[33 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[12 + inPos] & 4194303L))) & 255);
      out[34 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[12 + inPos] & 4194303L) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[12 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[13 + inPos] & 4194303L) <<  6)) & 255);
      out[36 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[13 + inPos] & 4194303L) >>> 2)) & 255);
      out[37 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[13 + inPos] & 4194303L) >>> 10)) & 255);
      out[38 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[13 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[14 + inPos] & 4194303L) <<  4)) & 255);
      out[39 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[14 + inPos] & 4194303L) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[14 + inPos] & 4194303L) >>> 12)) & 255);
      out[41 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[14 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[15 + inPos] & 4194303L) <<  2)) & 255);
      out[42 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[15 + inPos] & 4194303L) >>> 6)) & 255);
      out[43 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[15 + inPos] & 4194303L) >>> 14)) & 255);
      out[44 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[16 + inPos] & 4194303L))) & 255);
      out[45 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[16 + inPos] & 4194303L) >>> 8)) & 255);
      out[46 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[16 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[17 + inPos] & 4194303L) <<  6)) & 255);
      out[47 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[17 + inPos] & 4194303L) >>> 2)) & 255);
      out[48 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[17 + inPos] & 4194303L) >>> 10)) & 255);
      out[49 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[17 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[18 + inPos] & 4194303L) <<  4)) & 255);
      out[50 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[18 + inPos] & 4194303L) >>> 4)) & 255);
      out[51 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[18 + inPos] & 4194303L) >>> 12)) & 255);
      out[52 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[18 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[19 + inPos] & 4194303L) <<  2)) & 255);
      out[53 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[19 + inPos] & 4194303L) >>> 6)) & 255);
      out[54 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[19 + inPos] & 4194303L) >>> 14)) & 255);
      out[55 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[20 + inPos] & 4194303L))) & 255);
      out[56 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[20 + inPos] & 4194303L) >>> 8)) & 255);
      out[57 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[20 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[21 + inPos] & 4194303L) <<  6)) & 255);
      out[58 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[21 + inPos] & 4194303L) >>> 2)) & 255);
      out[59 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[21 + inPos] & 4194303L) >>> 10)) & 255);
      out[60 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[21 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[22 + inPos] & 4194303L) <<  4)) & 255);
      out[61 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[22 + inPos] & 4194303L) >>> 4)) & 255);
      out[62 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[22 + inPos] & 4194303L) >>> 12)) & 255);
      out[63 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[22 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[23 + inPos] & 4194303L) <<  2)) & 255);
      out[64 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[23 + inPos] & 4194303L) >>> 6)) & 255);
      out[65 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[23 + inPos] & 4194303L) >>> 14)) & 255);
      out[66 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[24 + inPos] & 4194303L))) & 255);
      out[67 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[24 + inPos] & 4194303L) >>> 8)) & 255);
      out[68 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[24 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[25 + inPos] & 4194303L) <<  6)) & 255);
      out[69 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[25 + inPos] & 4194303L) >>> 2)) & 255);
      out[70 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[25 + inPos] & 4194303L) >>> 10)) & 255);
      out[71 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[25 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[26 + inPos] & 4194303L) <<  4)) & 255);
      out[72 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[26 + inPos] & 4194303L) >>> 4)) & 255);
      out[73 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[26 + inPos] & 4194303L) >>> 12)) & 255);
      out[74 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[26 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[27 + inPos] & 4194303L) <<  2)) & 255);
      out[75 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[27 + inPos] & 4194303L) >>> 6)) & 255);
      out[76 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[27 + inPos] & 4194303L) >>> 14)) & 255);
      out[77 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[28 + inPos] & 4194303L))) & 255);
      out[78 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[28 + inPos] & 4194303L) >>> 8)) & 255);
      out[79 + outPos] = (byte)((
          //                                [__543210]
          //                                  [109876________________]
           ((in[28 + inPos] & 4194303L) >>> 16)
        | //                                [76______]
          //            [____________________10]
           ((in[29 + inPos] & 4194303L) <<  6)) & 255);
      out[80 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[29 + inPos] & 4194303L) >>> 2)) & 255);
      out[81 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[29 + inPos] & 4194303L) >>> 10)) & 255);
      out[82 + outPos] = (byte)((
          //                                [____3210]
          //                                    [1098__________________]
           ((in[29 + inPos] & 4194303L) >>> 18)
        | //                                [7654____]
          //              [__________________3210]
           ((in[30 + inPos] & 4194303L) <<  4)) & 255);
      out[83 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[30 + inPos] & 4194303L) >>> 4)) & 255);
      out[84 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[30 + inPos] & 4194303L) >>> 12)) & 255);
      out[85 + outPos] = (byte)((
          //                                [______10]
          //                                      [10____________________]
           ((in[30 + inPos] & 4194303L) >>> 20)
        | //                                [765432__]
          //                [________________543210]
           ((in[31 + inPos] & 4194303L) <<  2)) & 255);
      out[86 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[31 + inPos] & 4194303L) >>> 6)) & 255);
      out[87 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[31 + inPos] & 4194303L) >>> 14)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 4194303L);
      out[ 1 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[ 4 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[ 5 + inPos]) <<  18) & 4194303L);
      out[ 2 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[ 7 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[ 8 + inPos]) <<  20) & 4194303L);
      out[ 3 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[ 9 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[10 + inPos]) <<  14) & 4194303L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[11 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[12 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[13 + inPos]) <<  16) & 4194303L);
      out[ 5 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[13 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[14 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[15 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[16 + inPos]) <<  18) & 4194303L);
      out[ 6 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[17 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[18 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[19 + inPos]) <<  20) & 4194303L);
      out[ 7 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[19 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[20 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[21 + inPos]) <<  14) & 4194303L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 4194303L);
      out[ 1 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get( 4 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get( 5 + inPos)) <<  18) & 4194303L);
      out[ 2 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get( 7 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get( 8 + inPos)) <<  20) & 4194303L);
      out[ 3 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get( 9 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(10 + inPos)) <<  14) & 4194303L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(11 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(13 + inPos)) <<  16) & 4194303L);
      out[ 5 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(13 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(14 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(15 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(16 + inPos)) <<  18) & 4194303L);
      out[ 6 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(17 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(18 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(19 + inPos)) <<  20) & 4194303L);
      out[ 7 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(19 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(20 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(21 + inPos)) <<  14) & 4194303L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 4194303L);
      out[ 1 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[ 4 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[ 5 + inPos]) <<  18) & 4194303L);
      out[ 2 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[ 7 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[ 8 + inPos]) <<  20) & 4194303L);
      out[ 3 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[ 9 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[10 + inPos]) <<  14) & 4194303L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[11 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[12 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[13 + inPos]) <<  16) & 4194303L);
      out[ 5 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[13 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[14 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[15 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[16 + inPos]) <<  18) & 4194303L);
      out[ 6 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[17 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[18 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[19 + inPos]) <<  20) & 4194303L);
      out[ 7 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[19 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[20 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[21 + inPos]) <<  14) & 4194303L);
      out[ 8 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[22 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[23 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[24 + inPos]) <<  16) & 4194303L);
      out[ 9 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[24 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[26 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[27 + inPos]) <<  18) & 4194303L);
      out[10 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[27 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[28 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[29 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[30 + inPos]) <<  20) & 4194303L);
      out[11 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[30 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[31 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[32 + inPos]) <<  14) & 4194303L);
      out[12 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[33 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[34 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[35 + inPos]) <<  16) & 4194303L);
      out[13 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[35 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[36 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[37 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[38 + inPos]) <<  18) & 4194303L);
      out[14 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[38 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[39 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[40 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[41 + inPos]) <<  20) & 4194303L);
      out[15 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[41 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[42 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[43 + inPos]) <<  14) & 4194303L);
      out[16 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[44 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[45 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[46 + inPos]) <<  16) & 4194303L);
      out[17 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[46 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[47 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[48 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[49 + inPos]) <<  18) & 4194303L);
      out[18 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[49 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[50 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[51 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[52 + inPos]) <<  20) & 4194303L);
      out[19 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[52 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[53 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[54 + inPos]) <<  14) & 4194303L);
      out[20 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[55 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[56 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[57 + inPos]) <<  16) & 4194303L);
      out[21 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[57 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[58 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[59 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[60 + inPos]) <<  18) & 4194303L);
      out[22 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[60 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[61 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[62 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[63 + inPos]) <<  20) & 4194303L);
      out[23 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[63 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[64 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[65 + inPos]) <<  14) & 4194303L);
      out[24 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[66 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[67 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[68 + inPos]) <<  16) & 4194303L);
      out[25 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[68 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[69 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[70 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[71 + inPos]) <<  18) & 4194303L);
      out[26 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[71 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[72 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[73 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[74 + inPos]) <<  20) & 4194303L);
      out[27 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[74 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[75 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[76 + inPos]) <<  14) & 4194303L);
      out[28 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in[77 + inPos]) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[78 + inPos]) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in[79 + inPos]) <<  16) & 4194303L);
      out[29 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in[79 + inPos]) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[80 + inPos]) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[81 + inPos]) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[82 + inPos]) <<  18) & 4194303L);
      out[30 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in[82 + inPos]) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[83 + inPos]) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[84 + inPos]) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in[85 + inPos]) <<  20) & 4194303L);
      out[31 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in[85 + inPos]) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[86 + inPos]) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in[87 + inPos]) <<  14) & 4194303L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 4194303L);
      out[ 1 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get( 4 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get( 5 + inPos)) <<  18) & 4194303L);
      out[ 2 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get( 7 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get( 8 + inPos)) <<  20) & 4194303L);
      out[ 3 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get( 9 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(10 + inPos)) <<  14) & 4194303L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(11 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(13 + inPos)) <<  16) & 4194303L);
      out[ 5 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(13 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(14 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(15 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(16 + inPos)) <<  18) & 4194303L);
      out[ 6 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(17 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(18 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(19 + inPos)) <<  20) & 4194303L);
      out[ 7 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(19 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(20 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(21 + inPos)) <<  14) & 4194303L);
      out[ 8 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(22 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(23 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(24 + inPos)) <<  16) & 4194303L);
      out[ 9 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(24 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(26 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(27 + inPos)) <<  18) & 4194303L);
      out[10 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(28 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(29 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(30 + inPos)) <<  20) & 4194303L);
      out[11 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(30 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(31 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(32 + inPos)) <<  14) & 4194303L);
      out[12 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(33 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(34 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(35 + inPos)) <<  16) & 4194303L);
      out[13 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(35 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(36 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(37 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(38 + inPos)) <<  18) & 4194303L);
      out[14 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(39 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(40 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(41 + inPos)) <<  20) & 4194303L);
      out[15 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(41 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(42 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(43 + inPos)) <<  14) & 4194303L);
      out[16 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(44 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(45 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(46 + inPos)) <<  16) & 4194303L);
      out[17 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(46 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(47 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(48 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(49 + inPos)) <<  18) & 4194303L);
      out[18 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(49 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(50 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(51 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(52 + inPos)) <<  20) & 4194303L);
      out[19 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(52 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(53 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(54 + inPos)) <<  14) & 4194303L);
      out[20 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(55 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(56 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(57 + inPos)) <<  16) & 4194303L);
      out[21 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(57 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(58 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(59 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(60 + inPos)) <<  18) & 4194303L);
      out[22 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(60 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(61 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(62 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(63 + inPos)) <<  20) & 4194303L);
      out[23 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(63 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(64 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(65 + inPos)) <<  14) & 4194303L);
      out[24 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(66 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(67 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(68 + inPos)) <<  16) & 4194303L);
      out[25 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(68 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(69 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(70 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(71 + inPos)) <<  18) & 4194303L);
      out[26 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(71 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(72 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(73 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(74 + inPos)) <<  20) & 4194303L);
      out[27 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(74 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(75 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(76 + inPos)) <<  14) & 4194303L);
      out[28 + outPos] =
          //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(77 + inPos)) ) & 255L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(78 + inPos)) <<  8) & 65535L)
        | //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(79 + inPos)) <<  16) & 4194303L);
      out[29 + outPos] =
          //                                [76______]
          //            [____________________10]
            ((((long)in.get(79 + inPos)) >>  6) & 3L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(80 + inPos)) <<  2) & 1023L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(81 + inPos)) <<  10) & 262143L)
        | //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(82 + inPos)) <<  18) & 4194303L);
      out[30 + outPos] =
          //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(82 + inPos)) >>  4) & 15L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(83 + inPos)) <<  4) & 4095L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(84 + inPos)) <<  12) & 1048575L)
        | //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(85 + inPos)) <<  20) & 4194303L);
      out[31 + outPos] =
          //                                [765432__]
          //                [________________543210]
            ((((long)in.get(85 + inPos)) >>  2) & 63L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(86 + inPos)) <<  6) & 16383L)
        | //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(87 + inPos)) <<  14) & 4194303L);
    }
  }

  private static final class Packer23 extends BytePackerForLong {

    private Packer23() {
      super(23);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 0 + inPos] & 8388607L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 0 + inPos] & 8388607L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 0 + inPos] & 8388607L) >>> 16)
        | //                                 [7_______]
          //           [______________________0]
           ((in[ 1 + inPos] & 8388607L) <<  7)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 1 + inPos] & 8388607L) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 1 + inPos] & 8388607L) >>> 9)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 1 + inPos] & 8388607L) >>> 17)
        | //                                 [76______]
          //            [_____________________10]
           ((in[ 2 + inPos] & 8388607L) <<  6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 2 + inPos] & 8388607L) >>> 2)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 2 + inPos] & 8388607L) >>> 10)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 2 + inPos] & 8388607L) >>> 18)
        | //                                 [765_____]
          //             [____________________210]
           ((in[ 3 + inPos] & 8388607L) <<  5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 3 + inPos] & 8388607L) >>> 3)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 3 + inPos] & 8388607L) >>> 11)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 3 + inPos] & 8388607L) >>> 19)
        | //                                 [7654____]
          //              [___________________3210]
           ((in[ 4 + inPos] & 8388607L) <<  4)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 4 + inPos] & 8388607L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 4 + inPos] & 8388607L) >>> 12)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [_____210]
          //                                      [210____________________]
           ((in[ 4 + inPos] & 8388607L) >>> 20)
        | //                                 [76543___]
          //               [__________________43210]
           ((in[ 5 + inPos] & 8388607L) <<  3)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 5 + inPos] & 8388607L) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 5 + inPos] & 8388607L) >>> 13)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [______10]
          //                                       [21_____________________]
           ((in[ 5 + inPos] & 8388607L) >>> 21)
        | //                                 [765432__]
          //                [_________________543210]
           ((in[ 6 + inPos] & 8388607L) <<  2)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 6 + inPos] & 8388607L) >>> 6)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 6 + inPos] & 8388607L) >>> 14)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [_______0]
          //                                        [2______________________]
           ((in[ 6 + inPos] & 8388607L) >>> 22)
        | //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 7 + inPos] & 8388607L) <<  1)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 7 + inPos] & 8388607L) >>> 7)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 7 + inPos] & 8388607L) >>> 15)) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 0 + inPos] & 8388607L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 0 + inPos] & 8388607L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 0 + inPos] & 8388607L) >>> 16)
        | //                                 [7_______]
          //           [______________________0]
           ((in[ 1 + inPos] & 8388607L) <<  7)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 1 + inPos] & 8388607L) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 1 + inPos] & 8388607L) >>> 9)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 1 + inPos] & 8388607L) >>> 17)
        | //                                 [76______]
          //            [_____________________10]
           ((in[ 2 + inPos] & 8388607L) <<  6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 2 + inPos] & 8388607L) >>> 2)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 2 + inPos] & 8388607L) >>> 10)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 2 + inPos] & 8388607L) >>> 18)
        | //                                 [765_____]
          //             [____________________210]
           ((in[ 3 + inPos] & 8388607L) <<  5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 3 + inPos] & 8388607L) >>> 3)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 3 + inPos] & 8388607L) >>> 11)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 3 + inPos] & 8388607L) >>> 19)
        | //                                 [7654____]
          //              [___________________3210]
           ((in[ 4 + inPos] & 8388607L) <<  4)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 4 + inPos] & 8388607L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 4 + inPos] & 8388607L) >>> 12)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [_____210]
          //                                      [210____________________]
           ((in[ 4 + inPos] & 8388607L) >>> 20)
        | //                                 [76543___]
          //               [__________________43210]
           ((in[ 5 + inPos] & 8388607L) <<  3)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 5 + inPos] & 8388607L) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 5 + inPos] & 8388607L) >>> 13)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [______10]
          //                                       [21_____________________]
           ((in[ 5 + inPos] & 8388607L) >>> 21)
        | //                                 [765432__]
          //                [_________________543210]
           ((in[ 6 + inPos] & 8388607L) <<  2)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 6 + inPos] & 8388607L) >>> 6)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 6 + inPos] & 8388607L) >>> 14)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [_______0]
          //                                        [2______________________]
           ((in[ 6 + inPos] & 8388607L) >>> 22)
        | //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 7 + inPos] & 8388607L) <<  1)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 7 + inPos] & 8388607L) >>> 7)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 7 + inPos] & 8388607L) >>> 15)) & 255);
      out[23 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 8 + inPos] & 8388607L))) & 255);
      out[24 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 8 + inPos] & 8388607L) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 8 + inPos] & 8388607L) >>> 16)
        | //                                 [7_______]
          //           [______________________0]
           ((in[ 9 + inPos] & 8388607L) <<  7)) & 255);
      out[26 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 9 + inPos] & 8388607L) >>> 1)) & 255);
      out[27 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 9 + inPos] & 8388607L) >>> 9)) & 255);
      out[28 + outPos] = (byte)((
          //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 9 + inPos] & 8388607L) >>> 17)
        | //                                 [76______]
          //            [_____________________10]
           ((in[10 + inPos] & 8388607L) <<  6)) & 255);
      out[29 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[10 + inPos] & 8388607L) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[10 + inPos] & 8388607L) >>> 10)) & 255);
      out[31 + outPos] = (byte)((
          //                                 [___43210]
          //                                    [21098__________________]
           ((in[10 + inPos] & 8388607L) >>> 18)
        | //                                 [765_____]
          //             [____________________210]
           ((in[11 + inPos] & 8388607L) <<  5)) & 255);
      out[32 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[11 + inPos] & 8388607L) >>> 3)) & 255);
      out[33 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[11 + inPos] & 8388607L) >>> 11)) & 255);
      out[34 + outPos] = (byte)((
          //                                 [____3210]
          //                                     [2109___________________]
           ((in[11 + inPos] & 8388607L) >>> 19)
        | //                                 [7654____]
          //              [___________________3210]
           ((in[12 + inPos] & 8388607L) <<  4)) & 255);
      out[35 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[12 + inPos] & 8388607L) >>> 4)) & 255);
      out[36 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[12 + inPos] & 8388607L) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                                 [_____210]
          //                                      [210____________________]
           ((in[12 + inPos] & 8388607L) >>> 20)
        | //                                 [76543___]
          //               [__________________43210]
           ((in[13 + inPos] & 8388607L) <<  3)) & 255);
      out[38 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[13 + inPos] & 8388607L) >>> 5)) & 255);
      out[39 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[13 + inPos] & 8388607L) >>> 13)) & 255);
      out[40 + outPos] = (byte)((
          //                                 [______10]
          //                                       [21_____________________]
           ((in[13 + inPos] & 8388607L) >>> 21)
        | //                                 [765432__]
          //                [_________________543210]
           ((in[14 + inPos] & 8388607L) <<  2)) & 255);
      out[41 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[14 + inPos] & 8388607L) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[14 + inPos] & 8388607L) >>> 14)) & 255);
      out[43 + outPos] = (byte)((
          //                                 [_______0]
          //                                        [2______________________]
           ((in[14 + inPos] & 8388607L) >>> 22)
        | //                                 [7654321_]
          //                 [________________6543210]
           ((in[15 + inPos] & 8388607L) <<  1)) & 255);
      out[44 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[15 + inPos] & 8388607L) >>> 7)) & 255);
      out[45 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[15 + inPos] & 8388607L) >>> 15)) & 255);
      out[46 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[16 + inPos] & 8388607L))) & 255);
      out[47 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[16 + inPos] & 8388607L) >>> 8)) & 255);
      out[48 + outPos] = (byte)((
          //                                 [_6543210]
          //                                  [2109876________________]
           ((in[16 + inPos] & 8388607L) >>> 16)
        | //                                 [7_______]
          //           [______________________0]
           ((in[17 + inPos] & 8388607L) <<  7)) & 255);
      out[49 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[17 + inPos] & 8388607L) >>> 1)) & 255);
      out[50 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[17 + inPos] & 8388607L) >>> 9)) & 255);
      out[51 + outPos] = (byte)((
          //                                 [__543210]
          //                                   [210987_________________]
           ((in[17 + inPos] & 8388607L) >>> 17)
        | //                                 [76______]
          //            [_____________________10]
           ((in[18 + inPos] & 8388607L) <<  6)) & 255);
      out[52 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[18 + inPos] & 8388607L) >>> 2)) & 255);
      out[53 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[18 + inPos] & 8388607L) >>> 10)) & 255);
      out[54 + outPos] = (byte)((
          //                                 [___43210]
          //                                    [21098__________________]
           ((in[18 + inPos] & 8388607L) >>> 18)
        | //                                 [765_____]
          //             [____________________210]
           ((in[19 + inPos] & 8388607L) <<  5)) & 255);
      out[55 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[19 + inPos] & 8388607L) >>> 3)) & 255);
      out[56 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[19 + inPos] & 8388607L) >>> 11)) & 255);
      out[57 + outPos] = (byte)((
          //                                 [____3210]
          //                                     [2109___________________]
           ((in[19 + inPos] & 8388607L) >>> 19)
        | //                                 [7654____]
          //              [___________________3210]
           ((in[20 + inPos] & 8388607L) <<  4)) & 255);
      out[58 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[20 + inPos] & 8388607L) >>> 4)) & 255);
      out[59 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[20 + inPos] & 8388607L) >>> 12)) & 255);
      out[60 + outPos] = (byte)((
          //                                 [_____210]
          //                                      [210____________________]
           ((in[20 + inPos] & 8388607L) >>> 20)
        | //                                 [76543___]
          //               [__________________43210]
           ((in[21 + inPos] & 8388607L) <<  3)) & 255);
      out[61 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[21 + inPos] & 8388607L) >>> 5)) & 255);
      out[62 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[21 + inPos] & 8388607L) >>> 13)) & 255);
      out[63 + outPos] = (byte)((
          //                                 [______10]
          //                                       [21_____________________]
           ((in[21 + inPos] & 8388607L) >>> 21)
        | //                                 [765432__]
          //                [_________________543210]
           ((in[22 + inPos] & 8388607L) <<  2)) & 255);
      out[64 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[22 + inPos] & 8388607L) >>> 6)) & 255);
      out[65 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[22 + inPos] & 8388607L) >>> 14)) & 255);
      out[66 + outPos] = (byte)((
          //                                 [_______0]
          //                                        [2______________________]
           ((in[22 + inPos] & 8388607L) >>> 22)
        | //                                 [7654321_]
          //                 [________________6543210]
           ((in[23 + inPos] & 8388607L) <<  1)) & 255);
      out[67 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[23 + inPos] & 8388607L) >>> 7)) & 255);
      out[68 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[23 + inPos] & 8388607L) >>> 15)) & 255);
      out[69 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[24 + inPos] & 8388607L))) & 255);
      out[70 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[24 + inPos] & 8388607L) >>> 8)) & 255);
      out[71 + outPos] = (byte)((
          //                                 [_6543210]
          //                                  [2109876________________]
           ((in[24 + inPos] & 8388607L) >>> 16)
        | //                                 [7_______]
          //           [______________________0]
           ((in[25 + inPos] & 8388607L) <<  7)) & 255);
      out[72 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[25 + inPos] & 8388607L) >>> 1)) & 255);
      out[73 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[25 + inPos] & 8388607L) >>> 9)) & 255);
      out[74 + outPos] = (byte)((
          //                                 [__543210]
          //                                   [210987_________________]
           ((in[25 + inPos] & 8388607L) >>> 17)
        | //                                 [76______]
          //            [_____________________10]
           ((in[26 + inPos] & 8388607L) <<  6)) & 255);
      out[75 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[26 + inPos] & 8388607L) >>> 2)) & 255);
      out[76 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[26 + inPos] & 8388607L) >>> 10)) & 255);
      out[77 + outPos] = (byte)((
          //                                 [___43210]
          //                                    [21098__________________]
           ((in[26 + inPos] & 8388607L) >>> 18)
        | //                                 [765_____]
          //             [____________________210]
           ((in[27 + inPos] & 8388607L) <<  5)) & 255);
      out[78 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[27 + inPos] & 8388607L) >>> 3)) & 255);
      out[79 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[27 + inPos] & 8388607L) >>> 11)) & 255);
      out[80 + outPos] = (byte)((
          //                                 [____3210]
          //                                     [2109___________________]
           ((in[27 + inPos] & 8388607L) >>> 19)
        | //                                 [7654____]
          //              [___________________3210]
           ((in[28 + inPos] & 8388607L) <<  4)) & 255);
      out[81 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[28 + inPos] & 8388607L) >>> 4)) & 255);
      out[82 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[28 + inPos] & 8388607L) >>> 12)) & 255);
      out[83 + outPos] = (byte)((
          //                                 [_____210]
          //                                      [210____________________]
           ((in[28 + inPos] & 8388607L) >>> 20)
        | //                                 [76543___]
          //               [__________________43210]
           ((in[29 + inPos] & 8388607L) <<  3)) & 255);
      out[84 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[29 + inPos] & 8388607L) >>> 5)) & 255);
      out[85 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[29 + inPos] & 8388607L) >>> 13)) & 255);
      out[86 + outPos] = (byte)((
          //                                 [______10]
          //                                       [21_____________________]
           ((in[29 + inPos] & 8388607L) >>> 21)
        | //                                 [765432__]
          //                [_________________543210]
           ((in[30 + inPos] & 8388607L) <<  2)) & 255);
      out[87 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[30 + inPos] & 8388607L) >>> 6)) & 255);
      out[88 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[30 + inPos] & 8388607L) >>> 14)) & 255);
      out[89 + outPos] = (byte)((
          //                                 [_______0]
          //                                        [2______________________]
           ((in[30 + inPos] & 8388607L) >>> 22)
        | //                                 [7654321_]
          //                 [________________6543210]
           ((in[31 + inPos] & 8388607L) <<  1)) & 255);
      out[90 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[31 + inPos] & 8388607L) >>> 7)) & 255);
      out[91 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[31 + inPos] & 8388607L) >>> 15)) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                  [_______________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                                 [76543210]
          //                          [_______54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                                 [_6543210]
          //                                  [2109876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 8388607L);
      out[ 1 + outPos] =
          //                                 [7_______]
          //           [______________________0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L)
        | //                                 [76543210]
          //                   [______________87654321_]
            ((((long)in[ 3 + inPos]) <<  1) & 511L)
        | //                                 [76543210]
          //                           [______65432109_________]
            ((((long)in[ 4 + inPos]) <<  9) & 131071L)
        | //                                 [__543210]
          //                                   [210987_________________]
            ((((long)in[ 5 + inPos]) <<  17) & 8388607L);
      out[ 2 + outPos] =
          //                                 [76______]
          //            [_____________________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L)
        | //                                 [76543210]
          //                    [_____________98765432__]
            ((((long)in[ 6 + inPos]) <<  2) & 1023L)
        | //                                 [76543210]
          //                            [_____76543210__________]
            ((((long)in[ 7 + inPos]) <<  10) & 262143L)
        | //                                 [___43210]
          //                                    [21098__________________]
            ((((long)in[ 8 + inPos]) <<  18) & 8388607L);
      out[ 3 + outPos] =
          //                                 [765_____]
          //             [____________________210]
            ((((long)in[ 8 + inPos]) >>  5) & 7L)
        | //                                 [76543210]
          //                     [____________09876543___]
            ((((long)in[ 9 + inPos]) <<  3) & 2047L)
        | //                                 [76543210]
          //                             [____87654321___________]
            ((((long)in[10 + inPos]) <<  11) & 524287L)
        | //                                 [____3210]
          //                                     [2109___________________]
            ((((long)in[11 + inPos]) <<  19) & 8388607L);
      out[ 4 + outPos] =
          //                                 [7654____]
          //              [___________________3210]
            ((((long)in[11 + inPos]) >>  4) & 15L)
        | //                                 [76543210]
          //                      [___________10987654____]
            ((((long)in[12 + inPos]) <<  4) & 4095L)
        | //                                 [76543210]
          //                              [___98765432____________]
            ((((long)in[13 + inPos]) <<  12) & 1048575L)
        | //                                 [_____210]
          //                                      [210____________________]
            ((((long)in[14 + inPos]) <<  20) & 8388607L);
      out[ 5 + outPos] =
          //                                 [76543___]
          //               [__________________43210]
            ((((long)in[14 + inPos]) >>  3) & 31L)
        | //                                 [76543210]
          //                       [__________21098765_____]
            ((((long)in[15 + inPos]) <<  5) & 8191L)
        | //                                 [76543210]
          //                               [__09876543_____________]
            ((((long)in[16 + inPos]) <<  13) & 2097151L)
        | //                                 [______10]
          //                                       [21_____________________]
            ((((long)in[17 + inPos]) <<  21) & 8388607L);
      out[ 6 + outPos] =
          //                                 [765432__]
          //                [_________________543210]
            ((((long)in[17 + inPos]) >>  2) & 63L)
        | //                                 [76543210]
          //                        [_________32109876______]
            ((((long)in[18 + inPos]) <<  6) & 16383L)
        | //                                 [76543210]
          //                                [_10987654______________]
            ((((long)in[19 + inPos]) <<  14) & 4194303L)
        | //                                 [_______0]
          //                                        [2______________________]
            ((((long)in[20 + inPos]) <<  22) & 8388607L);
      out[ 7 + outPos] =
          //                                 [7654321_]
          //                 [________________6543210]
            ((((long)in[20 + inPos]) >>  1) & 127L)
        | //                                 [76543210]
          //                         [________43210987_______]
            ((((long)in[21 + inPos]) <<  7) & 32767L)
        | //                                 [76543210]
          //                                 [21098765_______________]
            ((((long)in[22 + inPos]) <<  15) & 8388607L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                  [_______________76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L)
        | //                                 [76543210]
          //                          [_______54321098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 65535L)
        | //                                 [_6543210]
          //                                  [2109876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 8388607L);
      out[ 1 + outPos] =
          //                                 [7_______]
          //           [______________________0]
            ((((long)in.get( 2 + inPos)) >>  7) & 1L)
        | //                                 [76543210]
          //                   [______________87654321_]
            ((((long)in.get( 3 + inPos)) <<  1) & 511L)
        | //                                 [76543210]
          //                           [______65432109_________]
            ((((long)in.get( 4 + inPos)) <<  9) & 131071L)
        | //                                 [__543210]
          //                                   [210987_________________]
            ((((long)in.get( 5 + inPos)) <<  17) & 8388607L);
      out[ 2 + outPos] =
          //                                 [76______]
          //            [_____________________10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L)
        | //                                 [76543210]
          //                    [_____________98765432__]
            ((((long)in.get( 6 + inPos)) <<  2) & 1023L)
        | //                                 [76543210]
          //                            [_____76543210__________]
            ((((long)in.get( 7 + inPos)) <<  10) & 262143L)
        | //                                 [___43210]
          //                                    [21098__________________]
            ((((long)in.get( 8 + inPos)) <<  18) & 8388607L);
      out[ 3 + outPos] =
          //                                 [765_____]
          //             [____________________210]
            ((((long)in.get( 8 + inPos)) >>  5) & 7L)
        | //                                 [76543210]
          //                     [____________09876543___]
            ((((long)in.get( 9 + inPos)) <<  3) & 2047L)
        | //                                 [76543210]
          //                             [____87654321___________]
            ((((long)in.get(10 + inPos)) <<  11) & 524287L)
        | //                                 [____3210]
          //                                     [2109___________________]
            ((((long)in.get(11 + inPos)) <<  19) & 8388607L);
      out[ 4 + outPos] =
          //                                 [7654____]
          //              [___________________3210]
            ((((long)in.get(11 + inPos)) >>  4) & 15L)
        | //                                 [76543210]
          //                      [___________10987654____]
            ((((long)in.get(12 + inPos)) <<  4) & 4095L)
        | //                                 [76543210]
          //                              [___98765432____________]
            ((((long)in.get(13 + inPos)) <<  12) & 1048575L)
        | //                                 [_____210]
          //                                      [210____________________]
            ((((long)in.get(14 + inPos)) <<  20) & 8388607L);
      out[ 5 + outPos] =
          //                                 [76543___]
          //               [__________________43210]
            ((((long)in.get(14 + inPos)) >>  3) & 31L)
        | //                                 [76543210]
          //                       [__________21098765_____]
            ((((long)in.get(15 + inPos)) <<  5) & 8191L)
        | //                                 [76543210]
          //                               [__09876543_____________]
            ((((long)in.get(16 + inPos)) <<  13) & 2097151L)
        | //                                 [______10]
          //                                       [21_____________________]
            ((((long)in.get(17 + inPos)) <<  21) & 8388607L);
      out[ 6 + outPos] =
          //                                 [765432__]
          //                [_________________543210]
            ((((long)in.get(17 + inPos)) >>  2) & 63L)
        | //                                 [76543210]
          //                        [_________32109876______]
            ((((long)in.get(18 + inPos)) <<  6) & 16383L)
        | //                                 [76543210]
          //                                [_10987654______________]
            ((((long)in.get(19 + inPos)) <<  14) & 4194303L)
        | //                                 [_______0]
          //                                        [2______________________]
            ((((long)in.get(20 + inPos)) <<  22) & 8388607L);
      out[ 7 + outPos] =
          //                                 [7654321_]
          //                 [________________6543210]
            ((((long)in.get(20 + inPos)) >>  1) & 127L)
        | //                                 [76543210]
          //                         [________43210987_______]
            ((((long)in.get(21 + inPos)) <<  7) & 32767L)
        | //                                 [76543210]
          //                                 [21098765_______________]
            ((((long)in.get(22 + inPos)) <<  15) & 8388607L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                  [_______________76543210]
            ((((long)in[ 0 + inPos]) ) & 255L)
        | //                                 [76543210]
          //                          [_______54321098________]
            ((((long)in[ 1 + inPos]) <<  8) & 65535L)
        | //                                 [_6543210]
          //                                  [2109876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 8388607L);
      out[ 1 + outPos] =
          //                                 [7_______]
          //           [______________________0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L)
        | //                                 [76543210]
          //                   [______________87654321_]
            ((((long)in[ 3 + inPos]) <<  1) & 511L)
        | //                                 [76543210]
          //                           [______65432109_________]
            ((((long)in[ 4 + inPos]) <<  9) & 131071L)
        | //                                 [__543210]
          //                                   [210987_________________]
            ((((long)in[ 5 + inPos]) <<  17) & 8388607L);
      out[ 2 + outPos] =
          //                                 [76______]
          //            [_____________________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L)
        | //                                 [76543210]
          //                    [_____________98765432__]
            ((((long)in[ 6 + inPos]) <<  2) & 1023L)
        | //                                 [76543210]
          //                            [_____76543210__________]
            ((((long)in[ 7 + inPos]) <<  10) & 262143L)
        | //                                 [___43210]
          //                                    [21098__________________]
            ((((long)in[ 8 + inPos]) <<  18) & 8388607L);
      out[ 3 + outPos] =
          //                                 [765_____]
          //             [____________________210]
            ((((long)in[ 8 + inPos]) >>  5) & 7L)
        | //                                 [76543210]
          //                     [____________09876543___]
            ((((long)in[ 9 + inPos]) <<  3) & 2047L)
        | //                                 [76543210]
          //                             [____87654321___________]
            ((((long)in[10 + inPos]) <