/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.codec.ZstandardCodec;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class TestZstandardCodec {
    private final Path inputPath = new Path("src/test/java/org/apache/parquet/hadoop/example/TestInputOutputFormat.java");

    @Test
    public void testZstdCodec() throws IOException {
        ZstandardCodec codec = new ZstandardCodec();
        Configuration conf = new Configuration();
        boolean[] pools = new boolean[]{false, true};
        int[] levels = new int[]{1, 4, 7, 10, 13, 16, 19, 22};
        int[] dataSizes = new int[]{0, 1, 10, 1024, 0x100000};
        for (boolean pool : pools) {
            for (int i = 0; i < levels.length; ++i) {
                conf.setBoolean("parquet.compression.codec.zstd.bufferPool.enabled", pool);
                conf.setInt("parquet.compression.codec.zstd.level", levels[i]);
                codec.setConf(conf);
                for (int j = 0; j < dataSizes.length; ++j) {
                    this.testZstd(codec, dataSizes[j]);
                }
            }
        }
    }

    private void testZstd(ZstandardCodec codec, int dataSize) throws IOException {
        byte[] data = new byte[dataSize];
        new Random().nextBytes(data);
        BytesInput compressedData = this.compress(codec, BytesInput.from((byte[])data));
        byte[] decompressedData = this.decompress(codec, compressedData, data.length);
        Assert.assertArrayEquals((byte[])data, (byte[])decompressedData);
    }

    private BytesInput compress(ZstandardCodec codec, BytesInput bytes) throws IOException {
        ByteArrayOutputStream compressedOutBuffer = new ByteArrayOutputStream((int)bytes.size());
        CompressionOutputStream cos = codec.createOutputStream((OutputStream)compressedOutBuffer, null);
        bytes.writeAllTo((OutputStream)cos);
        cos.close();
        return BytesInput.from((ByteArrayOutputStream)compressedOutBuffer);
    }

    private byte[] decompress(ZstandardCodec codec, BytesInput bytes, int uncompressedSize) throws IOException {
        CompressionInputStream is = codec.createInputStream((InputStream)bytes.toInputStream(), null);
        byte[] decompressed = BytesInput.from((InputStream)is, (int)uncompressedSize).toByteArray();
        is.close();
        return decompressed;
    }

    @Test
    public void testZstdConfWithMr() throws Exception {
        long fileSizeLowLevel = this.runMrWithConf(1);
        CodecFactory.CODEC_BY_NAME.clear();
        long fileSizeHighLevel = this.runMrWithConf(22);
        Assert.assertTrue((fileSizeLowLevel > fileSizeHighLevel ? 1 : 0) != 0);
    }

    private long runMrWithConf(int level) throws Exception {
        JobConf jobConf = new JobConf();
        Configuration conf = new Configuration();
        jobConf.setInt("parquet.compression.codec.zstd.level", level);
        jobConf.setInt("parquet.compression.codec.zstd.workers", 4);
        Path path = new Path(Files.createTempDirectory("zstd" + level, new FileAttribute[0]).toAbsolutePath().toString());
        RunningJob mapRedJob = this.runMapReduceJob(CompressionCodecName.ZSTD, jobConf, conf, path);
        Assert.assertTrue((boolean)mapRedJob.isSuccessful());
        return this.getFileSize(path, conf);
    }

    private RunningJob runMapReduceJob(CompressionCodecName codec, JobConf jobConf, Configuration conf, Path parquetPath) throws IOException, ClassNotFoundException, InterruptedException {
        String writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
        FileSystem fileSystem = parquetPath.getFileSystem(conf);
        fileSystem.delete(parquetPath, true);
        jobConf.setInputFormat(TextInputFormat.class);
        TextInputFormat.addInputPath((JobConf)jobConf, (Path)this.inputPath);
        jobConf.setNumReduceTasks(0);
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        DeprecatedParquetOutputFormat.setCompression((Configuration)jobConf, (CompressionCodecName)codec);
        DeprecatedParquetOutputFormat.setOutputPath((JobConf)jobConf, (Path)parquetPath);
        DeprecatedParquetOutputFormat.setWriteSupportClass((Configuration)jobConf, GroupWriteSupport.class);
        GroupWriteSupport.setSchema((MessageType)MessageTypeParser.parseMessageType((String)writeSchema), (Configuration)jobConf);
        jobConf.setMapperClass(DumpMapper.class);
        return JobClient.runJob((JobConf)jobConf);
    }

    private long getFileSize(Path parquetPath, Configuration conf) throws IOException {
        for (FileStatus file : parquetPath.getFileSystem(conf).listStatus(parquetPath)) {
            if (!file.getPath().getName().endsWith(".parquet")) continue;
            return file.getLen();
        }
        return -1L;
    }

    public static class DumpMapper
    implements Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        public void configure(JobConf job) {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)job));
        }

        public void map(LongWritable key, Text value, OutputCollector<Void, Group> outputCollector, Reporter reporter) throws IOException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            outputCollector.collect(null, (Object)group);
        }

        public void close() {
        }
    }
}

