/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.TestBloomFiltering;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAdaptiveBlockSplitBloomFiltering
extends TestBloomFiltering {
    @BeforeClass
    public static void createFiles() throws IOException {
        TestAdaptiveBlockSplitBloomFiltering.createFiles(true);
    }

    public TestAdaptiveBlockSplitBloomFiltering(Path file, boolean isEncrypted) {
        super(file, isEncrypted);
    }

    @Override
    @Test
    public void testSimpleFiltering() throws IOException {
        super.testSimpleFiltering();
    }

    @Override
    @Test
    public void testNestedFiltering() throws IOException {
        super.testNestedFiltering();
    }

    @Override
    @Test
    public void checkBloomFilterSize() throws IOException {
        FileDecryptionProperties fileDecryptionProperties = this.getFileDecryptionProperties();
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(fileDecryptionProperties).build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)this.getFile(), (Configuration)new Configuration());
        try (ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions);){
            fileReader.getRowGroups().forEach(block -> {
                BloomFilterReader bloomFilterReader = fileReader.getBloomFilterDataReader(block);
                block.getColumns().stream().filter(column -> column.getBloomFilterOffset() > 0L).forEach(column -> {
                    int bitsetSize = bloomFilterReader.readBloomFilter(column).getBitsetSize();
                    Assert.assertTrue((bitsetSize <= 2048 ? 1 : 0) != 0);
                });
            });
        }
    }
}

