/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import org.apache.parquet.hadoop.LruCache;
import org.junit.Assert;
import org.junit.Test;

public class TestLruCache {
    private static final String DEFAULT_KEY = "test";

    @Test
    public void testMaxSize() {
        LruCache cache = new LruCache(1);
        String oldKey = DEFAULT_KEY;
        String newKey = oldKey + "_new";
        SimpleValue oldValue = new SimpleValue(true, true);
        cache.put((Object)oldKey, (LruCache.Value)oldValue);
        Assert.assertEquals((Object)oldValue, (Object)cache.getCurrentValue((Object)oldKey));
        Assert.assertEquals((long)1L, (long)cache.size());
        SimpleValue newValue = new SimpleValue(true, true);
        cache.put((Object)newKey, (LruCache.Value)newValue);
        Assert.assertNull((Object)cache.getCurrentValue((Object)oldKey));
        Assert.assertEquals((Object)newValue, (Object)cache.getCurrentValue((Object)newKey));
        Assert.assertEquals((long)1L, (long)cache.size());
    }

    @Test
    public void testOlderValueIsIgnored() {
        LruCache cache = new LruCache(1);
        SimpleValue currentValue = new SimpleValue(true, true);
        SimpleValue notAsCurrentValue = new SimpleValue(true, false);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)currentValue);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)notAsCurrentValue);
        Assert.assertEquals((String)"The existing value in the cache was overwritten", (Object)currentValue, (Object)cache.getCurrentValue((Object)DEFAULT_KEY));
    }

    @Test
    public void testOutdatedValueIsIgnored() {
        LruCache cache = new LruCache(1);
        SimpleValue outdatedValue = new SimpleValue(false, true);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)outdatedValue);
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNull((Object)cache.getCurrentValue((Object)DEFAULT_KEY));
    }

    @Test
    public void testCurrentValueOverwritesExisting() {
        LruCache cache = new LruCache(1);
        SimpleValue currentValue = new SimpleValue(true, true);
        SimpleValue notAsCurrentValue = new SimpleValue(true, false);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)notAsCurrentValue);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)currentValue);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((String)"The existing value in the cache was NOT overwritten", (Object)currentValue, (Object)cache.getCurrentValue((Object)DEFAULT_KEY));
    }

    @Test
    public void testGetOutdatedValueReturnsNull() {
        LruCache cache = new LruCache(1);
        SimpleValue value = new SimpleValue(true, true);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)value);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)value, (Object)cache.getCurrentValue((Object)DEFAULT_KEY));
        value.setCurrent(false);
        Assert.assertNull((String)"The value should not be current anymore", (Object)cache.getCurrentValue((Object)DEFAULT_KEY));
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testRemove() {
        LruCache cache = new LruCache(1);
        SimpleValue value = new SimpleValue(true, true);
        cache.put((Object)DEFAULT_KEY, (LruCache.Value)value);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)value, (Object)cache.getCurrentValue((Object)DEFAULT_KEY));
        Assert.assertEquals((Object)value, (Object)cache.remove((Object)DEFAULT_KEY));
        Assert.assertNull((Object)cache.getCurrentValue((Object)DEFAULT_KEY));
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testClear() {
        LruCache cache = new LruCache(2);
        String key1 = "test1";
        String key2 = "test2";
        SimpleValue value = new SimpleValue(true, true);
        cache.put((Object)key1, (LruCache.Value)value);
        cache.put((Object)key2, (LruCache.Value)value);
        Assert.assertEquals((Object)value, (Object)cache.getCurrentValue((Object)key1));
        Assert.assertEquals((Object)value, (Object)cache.getCurrentValue((Object)key2));
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.clear();
        Assert.assertNull((Object)cache.getCurrentValue((Object)key1));
        Assert.assertNull((Object)cache.getCurrentValue((Object)key2));
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    private static final class SimpleValue
    implements LruCache.Value<String, SimpleValue> {
        private boolean current;
        private boolean newerThan;

        public SimpleValue(boolean current, boolean newerThan) {
            this.current = current;
            this.newerThan = newerThan;
        }

        public boolean isCurrent(String key) {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public boolean isNewerThan(SimpleValue otherValue) {
            return this.newerThan;
        }
    }
}

