/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util.wrapped.io;

import org.apache.parquet.hadoop.util.wrapped.io.FileRangeBridge;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileRangeBridge {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileRangeBridge.class);
    static final String CLASSNAME = "org.apache.hadoop.fs.FileRange";

    @Before
    public void setUp() {
        try {
            this.getClass().getClassLoader().loadClass(CLASSNAME);
        }
        catch (ReflectiveOperationException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testInstantiate() throws Throwable {
        new FileRangeBridge();
    }

    @Test
    public void testFileRangeBridgeAvailable() throws Throwable {
        Assert.assertNotNull((String)"FileRangeBridge instance null", (Object)FileRangeBridge.instance());
        Assert.assertTrue((String)"Bridge not available", (boolean)FileRangeBridge.bridgeAvailable());
    }

    @Test
    public void testCreateFileRange() {
        String reference = "backref";
        FileRangeBridge.WrappedFileRange range = FileRangeBridge.instance().createFileRange(512L, 16384, (Object)reference);
        LOG.info("created range {}", (Object)range);
        Assert.assertNotNull((String)"null range", (Object)range);
        Assert.assertNotNull((String)"null range instance", (Object)range.getFileRange());
        Assert.assertEquals((String)("offset of " + range), (long)512L, (long)range.getOffset());
        Assert.assertEquals((String)("length of " + range), (long)16384L, (long)range.getLength());
        Assert.assertSame((String)("backref of " + range), (Object)reference, (Object)range.getReference());
        Assert.assertNull((String)"non-null range future", (Object)range.getData());
    }

    @Test
    public void testCreateInvalidRange() {
        FileRangeBridge.instance().createFileRange(-1L, -1, null);
    }
}

