/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class LosslessFactory {
    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(PDDocument document, BufferedImage image) throws IOException {
        PDDeviceColorSpace deviceColorSpace;
        int bpc;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int height = image.getHeight();
        int width = image.getWidth();
        if (image.getType() == 10 && image.getColorModel().getPixelSize() <= 8 || image.getType() == 12 && image.getColorModel().getPixelSize() == 1) {
            MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);
            bpc = image.getColorModel().getPixelSize();
            deviceColorSpace = PDDeviceGray.INSTANCE;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    mcios.writeBits(image.getRGB(x, y) & 0xFF, bpc);
                }
                while (mcios.getBitOffset() != 0) {
                    mcios.writeBit(0);
                }
            }
            mcios.flush();
            mcios.close();
        } else {
            bpc = 8;
            deviceColorSpace = PDDeviceRGB.INSTANCE;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Color color = new Color(image.getRGB(x, y));
                    bos.write(color.getRed());
                    bos.write(color.getGreen());
                    bos.write(color.getBlue());
                }
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, bos.toByteArray(), image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        PDImageXObject xAlpha = LosslessFactory.createAlphaFromARGBImage(document, image);
        if (xAlpha != null) {
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)xAlpha);
        }
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage(PDDocument document, BufferedImage image) throws IOException {
        int bpc;
        if (!image.getColorModel().hasAlpha()) {
            return null;
        }
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (alphaRaster == null) {
            return LosslessFactory.createAlphaFromARGBImage2(document, image);
        }
        int[] pixels = alphaRaster.getPixels(0, 0, alphaRaster.getWidth(), alphaRaster.getHeight(), (int[])null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (image.getTransparency() == 2) {
            bpc = 1;
            MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);
            int width = alphaRaster.getWidth();
            int p = 0;
            for (int pixel : pixels) {
                mcios.writeBit(pixel);
                if (++p % width != 0) continue;
                while (mcios.getBitOffset() != 0) {
                    mcios.writeBit(0);
                }
            }
            mcios.flush();
            mcios.close();
        } else {
            bpc = 8;
            for (int pixel : pixels) {
                bos.write(pixel);
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, bos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage2(PDDocument document, BufferedImage bi) throws IOException {
        int bpc;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (bi.getTransparency() == 2) {
            bpc = 1;
            MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);
            int h = bi.getHeight();
            for (int y = 0; y < h; ++y) {
                int w = bi.getWidth();
                for (int x = 0; x < w; ++x) {
                    int alpha = bi.getRGB(x, y) >>> 24;
                    mcios.writeBit(alpha);
                }
                while (mcios.getBitOffset() != 0) {
                    mcios.writeBit(0);
                }
            }
            mcios.flush();
            mcios.close();
        } else {
            bpc = 8;
            int h = bi.getHeight();
            for (int y = 0; y < h; ++y) {
                int w = bi.getWidth();
                for (int x = 0; x < w; ++x) {
                    int alpha = bi.getRGB(x, y) >>> 24;
                    bos.write(alpha);
                }
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, bos.toByteArray(), bi.getWidth(), bi.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }
}

