/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.text;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.util.Internal;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFEffectContainer;
import org.apache.poi.xddf.usermodel.XDDFEffectList;
import org.apache.poi.xddf.usermodel.XDDFExtensionList;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFGradientFillProperties;
import org.apache.poi.xddf.usermodel.XDDFGroupFillProperties;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFNoFillProperties;
import org.apache.poi.xddf.usermodel.XDDFPatternFillProperties;
import org.apache.poi.xddf.usermodel.XDDFPictureFillProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.text.CapsType;
import org.apache.poi.xddf.usermodel.text.StrikeType;
import org.apache.poi.xddf.usermodel.text.UnderlineType;
import org.apache.poi.xddf.usermodel.text.XDDFFont;
import org.apache.poi.xddf.usermodel.text.XDDFHyperlink;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;

public class XDDFRunProperties {
    private CTTextCharacterProperties props;

    public XDDFRunProperties() {
        this(CTTextCharacterProperties.Factory.newInstance());
    }

    @Internal
    public XDDFRunProperties(CTTextCharacterProperties properties) {
        this.props = properties;
    }

    @Internal
    protected CTTextCharacterProperties getXmlObject() {
        return this.props;
    }

    public void setBaseline(Integer value) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetBaseline(), () -> ((CTTextCharacterProperties)this.props).unsetBaseline(), arg_0 -> ((CTTextCharacterProperties)this.props).setBaseline(arg_0), value);
    }

    public void setDirty(Boolean dirty) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetDirty(), () -> ((CTTextCharacterProperties)this.props).unsetDirty(), arg_0 -> ((CTTextCharacterProperties)this.props).setDirty(arg_0), dirty);
    }

    public void setSpellError(Boolean error) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetErr(), () -> ((CTTextCharacterProperties)this.props).unsetErr(), arg_0 -> ((CTTextCharacterProperties)this.props).setErr(arg_0), error);
    }

    public void setNoProof(Boolean noproof) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetNoProof(), () -> ((CTTextCharacterProperties)this.props).unsetNoProof(), arg_0 -> ((CTTextCharacterProperties)this.props).setNoProof(arg_0), noproof);
    }

    public void setNormalizeHeights(Boolean normalize) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetNormalizeH(), () -> ((CTTextCharacterProperties)this.props).unsetNormalizeH(), arg_0 -> ((CTTextCharacterProperties)this.props).setNormalizeH(arg_0), normalize);
    }

    public void setKumimoji(Boolean kumimoji) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetKumimoji(), () -> ((CTTextCharacterProperties)this.props).unsetKumimoji(), arg_0 -> ((CTTextCharacterProperties)this.props).setKumimoji(arg_0), kumimoji);
    }

    public void setBold(Boolean bold) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetB(), () -> ((CTTextCharacterProperties)this.props).unsetB(), arg_0 -> ((CTTextCharacterProperties)this.props).setB(arg_0), bold);
    }

    public void setItalic(Boolean italic) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetI(), () -> ((CTTextCharacterProperties)this.props).unsetI(), arg_0 -> ((CTTextCharacterProperties)this.props).setI(arg_0), italic);
    }

    public void setFontSize(Double size) {
        if (size != null && (size < 1.0 || 400.0 < size)) {
            throw new IllegalArgumentException("Minimum inclusive = 1. Maximum inclusive = 400.");
        }
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetSz(), () -> ((CTTextCharacterProperties)this.props).unsetSz(), arg_0 -> ((CTTextCharacterProperties)this.props).setSz(arg_0), size == null ? null : Integer.valueOf((int)(100.0 * size)));
    }

    public void setFillProperties(XDDFFillProperties properties) {
        if (this.props.isSetBlipFill()) {
            this.props.unsetBlipFill();
        }
        if (this.props.isSetGradFill()) {
            this.props.unsetGradFill();
        }
        if (this.props.isSetGrpFill()) {
            this.props.unsetGrpFill();
        }
        if (this.props.isSetNoFill()) {
            this.props.unsetNoFill();
        }
        if (this.props.isSetPattFill()) {
            this.props.unsetPattFill();
        }
        if (this.props.isSetSolidFill()) {
            this.props.unsetSolidFill();
        }
        if (properties == null) {
            return;
        }
        if (properties instanceof XDDFGradientFillProperties) {
            this.props.setGradFill(((XDDFGradientFillProperties)properties).getXmlObject());
        } else if (properties instanceof XDDFGroupFillProperties) {
            this.props.setGrpFill(((XDDFGroupFillProperties)properties).getXmlObject());
        } else if (properties instanceof XDDFNoFillProperties) {
            this.props.setNoFill(((XDDFNoFillProperties)properties).getXmlObject());
        } else if (properties instanceof XDDFPatternFillProperties) {
            this.props.setPattFill(((XDDFPatternFillProperties)properties).getXmlObject());
        } else if (properties instanceof XDDFPictureFillProperties) {
            this.props.setBlipFill(((XDDFPictureFillProperties)properties).getXmlObject());
        } else if (properties instanceof XDDFSolidFillProperties) {
            this.props.setSolidFill(((XDDFSolidFillProperties)properties).getXmlObject());
        }
    }

    public void setCharacterKerning(Double kerning) {
        if (kerning != null && (kerning < 0.0 || 4000.0 < kerning)) {
            throw new IllegalArgumentException("Minimum inclusive = 0. Maximum inclusive = 4000.");
        }
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetKern(), () -> ((CTTextCharacterProperties)this.props).unsetKern(), arg_0 -> ((CTTextCharacterProperties)this.props).setKern(arg_0), kerning == null ? null : Integer.valueOf((int)(100.0 * kerning)));
    }

    public void setCharacterSpacing(Double spacing) {
        if (spacing != null && (spacing < -4000.0 || 4000.0 < spacing)) {
            throw new IllegalArgumentException("Minimum inclusive = -4000. Maximum inclusive = 4000.");
        }
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetSpc(), () -> ((CTTextCharacterProperties)this.props).unsetSpc(), arg_0 -> ((CTTextCharacterProperties)this.props).setSpc(arg_0), spacing == null ? null : Integer.valueOf((int)(100.0 * spacing)));
    }

    public void setFonts(XDDFFont[] fonts) {
        block6: for (XDDFFont font : fonts) {
            CTTextFont xml = font.getXmlObject();
            switch (font.getGroup()) {
                case COMPLEX_SCRIPT: {
                    XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetCs(), () -> ((CTTextCharacterProperties)this.props).unsetCs(), arg_0 -> ((CTTextCharacterProperties)this.props).setCs(arg_0), xml);
                    continue block6;
                }
                case EAST_ASIAN: {
                    XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetEa(), () -> ((CTTextCharacterProperties)this.props).unsetEa(), arg_0 -> ((CTTextCharacterProperties)this.props).setEa(arg_0), xml);
                    continue block6;
                }
                case LATIN: {
                    XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetLatin(), () -> ((CTTextCharacterProperties)this.props).unsetLatin(), arg_0 -> ((CTTextCharacterProperties)this.props).setLatin(arg_0), xml);
                    continue block6;
                }
                case SYMBOL: {
                    XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetSym(), () -> ((CTTextCharacterProperties)this.props).unsetSym(), arg_0 -> ((CTTextCharacterProperties)this.props).setSym(arg_0), xml);
                }
            }
        }
    }

    public void setUnderline(UnderlineType underline) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetU(), () -> ((CTTextCharacterProperties)this.props).unsetU(), arg_0 -> ((CTTextCharacterProperties)this.props).setU(arg_0), underline == null ? null : underline.underlying);
    }

    public void setStrikeThrough(StrikeType strike) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetStrike(), () -> ((CTTextCharacterProperties)this.props).unsetStrike(), arg_0 -> ((CTTextCharacterProperties)this.props).setStrike(arg_0), strike == null ? null : strike.underlying);
    }

    public void setCapitals(CapsType caps) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetCap(), () -> ((CTTextCharacterProperties)this.props).unsetCap(), arg_0 -> ((CTTextCharacterProperties)this.props).setCap(arg_0), caps == null ? null : caps.underlying);
    }

    public void setHyperlink(XDDFHyperlink link) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetHlinkClick(), () -> ((CTTextCharacterProperties)this.props).unsetHlinkClick(), arg_0 -> ((CTTextCharacterProperties)this.props).setHlinkClick(arg_0), link == null ? null : link.getXmlObject());
    }

    public void setMouseOver(XDDFHyperlink link) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetHlinkMouseOver(), () -> ((CTTextCharacterProperties)this.props).unsetHlinkMouseOver(), arg_0 -> ((CTTextCharacterProperties)this.props).setHlinkMouseOver(arg_0), link == null ? null : link.getXmlObject());
    }

    public void setLanguage(Locale lang) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetLang(), () -> ((CTTextCharacterProperties)this.props).unsetLang(), arg_0 -> ((CTTextCharacterProperties)this.props).setLang(arg_0), lang == null ? null : lang.toLanguageTag());
    }

    public void setAlternativeLanguage(Locale lang) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetAltLang(), () -> ((CTTextCharacterProperties)this.props).unsetAltLang(), arg_0 -> ((CTTextCharacterProperties)this.props).setAltLang(arg_0), lang == null ? null : lang.toLanguageTag());
    }

    public void setHighlight(XDDFColor color) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetHighlight(), () -> ((CTTextCharacterProperties)this.props).unsetHighlight(), arg_0 -> ((CTTextCharacterProperties)this.props).setHighlight(arg_0), color == null ? null : color.getColorContainer());
    }

    public void setLineProperties(XDDFLineProperties properties) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetLn(), () -> ((CTTextCharacterProperties)this.props).unsetLn(), arg_0 -> ((CTTextCharacterProperties)this.props).setLn(arg_0), properties == null ? null : properties.getXmlObject());
    }

    public void setBookmark(String bookmark) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetBmk(), () -> ((CTTextCharacterProperties)this.props).unsetBmk(), arg_0 -> ((CTTextCharacterProperties)this.props).setBmk(arg_0), bookmark);
    }

    public XDDFExtensionList getExtensionList() {
        if (this.props.isSetExtLst()) {
            return new XDDFExtensionList(this.props.getExtLst());
        }
        return null;
    }

    public void setExtensionList(XDDFExtensionList list) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetExtLst(), () -> ((CTTextCharacterProperties)this.props).unsetExtLst(), arg_0 -> ((CTTextCharacterProperties)this.props).setExtLst(arg_0), list == null ? null : list.getXmlObject());
    }

    public XDDFEffectContainer getEffectContainer() {
        if (this.props.isSetEffectDag()) {
            return new XDDFEffectContainer(this.props.getEffectDag());
        }
        return null;
    }

    public void setEffectContainer(XDDFEffectContainer container) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetEffectDag(), () -> ((CTTextCharacterProperties)this.props).unsetEffectDag(), arg_0 -> ((CTTextCharacterProperties)this.props).setEffectDag(arg_0), container == null ? null : container.getXmlObject());
    }

    public XDDFEffectList getEffectList() {
        if (this.props.isSetEffectLst()) {
            return new XDDFEffectList(this.props.getEffectLst());
        }
        return null;
    }

    public void setEffectList(XDDFEffectList list) {
        XDDFRunProperties.update(() -> ((CTTextCharacterProperties)this.props).isSetEffectLst(), () -> ((CTTextCharacterProperties)this.props).unsetEffectLst(), arg_0 -> ((CTTextCharacterProperties)this.props).setEffectLst(arg_0), list == null ? null : list.getXmlObject());
    }

    private static <T> void update(Supplier<Boolean> isSet, Runnable unset, Consumer<T> setter, T val) {
        if (val != null) {
            setter.accept(val);
        } else if (isSet.get().booleanValue()) {
            unset.run();
        }
    }
}

