/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.util.ExceptionUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xslf.XSLFReadException;
import org.apache.poi.xslf.usermodel.XMLSlideShow;

public final class XSLFParser {
    private XSLFParser() {
    }

    public static XMLSlideShow parse(InputStream stream) throws XSLFReadException, IOException {
        try {
            return new XMLSlideShow(stream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
        catch (Exception e) {
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
    }

    public static XMLSlideShow parse(InputStream stream, boolean closeStream) throws XSLFReadException, IOException {
        try {
            return new XMLSlideShow(stream, closeStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
        catch (Exception e) {
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
    }

    public static XMLSlideShow parse(File file) throws XSLFReadException {
        OPCPackage pkg = null;
        try {
            pkg = OPCPackage.open(file);
            return new XMLSlideShow(pkg);
        }
        catch (Error | RuntimeException e) {
            if (pkg != null) {
                IOUtils.closeQuietly((Closeable)pkg);
            }
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
        catch (Exception e) {
            if (pkg != null) {
                IOUtils.closeQuietly((Closeable)pkg);
            }
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
    }

    public static XMLSlideShow parse(OPCPackage pkg) throws XSLFReadException {
        try {
            return new XMLSlideShow(pkg);
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
        catch (Exception e) {
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLSlideShow parse(PackagePart packagePart) throws XSLFReadException, IOException {
        try (InputStream is = packagePart.getInputStream();){
            XMLSlideShow xMLSlideShow = new XMLSlideShow(is);
            return xMLSlideShow;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (!ExceptionUtil.isFatal((Throwable)e)) throw new XSLFReadException("Exception reading XMLSlideShow", e);
            throw e;
        }
        catch (Exception e) {
            throw new XSLFReadException("Exception reading XMLSlideShow", e);
        }
    }
}

