/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;

public final class HSLFHyperlink {
    public static final byte LINK_NEXTSLIDE = 0;
    public static final byte LINK_PREVIOUSSLIDE = 1;
    public static final byte LINK_FIRSTSLIDE = 2;
    public static final byte LINK_LASTSLIDE = 3;
    public static final byte LINK_SLIDENUMBER = 7;
    public static final byte LINK_URL = 8;
    public static final byte LINK_NULL = -1;
    private int id = -1;
    private int type;
    private String address;
    private String title;
    private int startIndex;
    private int endIndex;

    public int getType() {
        return this.type;
    }

    public void setType(int val) {
        this.type = val;
        switch (this.type) {
            case 0: {
                this.title = "NEXT";
                this.address = "1,-1,NEXT";
                break;
            }
            case 1: {
                this.title = "PREV";
                this.address = "1,-1,PREV";
                break;
            }
            case 2: {
                this.title = "FIRST";
                this.address = "1,-1,FIRST";
                break;
            }
            case 3: {
                this.title = "LAST";
                this.address = "1,-1,LAST";
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.title = "";
                this.address = "";
            }
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(HSLFSlide slide) {
        String href = slide._getSheetNumber() + "," + slide.getSlideNumber() + ",Slide " + slide.getSlideNumber();
        this.setAddress(href);
        this.setTitle("Slide " + slide.getSlideNumber());
        this.setType(7);
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String str) {
        this.title = str;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public static List<HSLFHyperlink> find(HSLFTextShape shape) {
        return HSLFHyperlink.find(shape.getTextParagraphs());
    }

    public static List<HSLFHyperlink> find(List<HSLFTextParagraph> paragraphs) {
        ArrayList<HSLFHyperlink> lst = new ArrayList<HSLFHyperlink>();
        if (paragraphs == null || paragraphs.isEmpty()) {
            return lst;
        }
        HSLFTextParagraph firstPara = paragraphs.get(0);
        HSLFSlideShow ppt = firstPara.getSheet().getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return lst;
        }
        Record[] records = firstPara.getRecords();
        HSLFHyperlink.find(records, exobj, lst);
        return lst;
    }

    public static HSLFHyperlink find(HSLFShape shape) {
        ArrayList<HSLFHyperlink> lst = new ArrayList<HSLFHyperlink>();
        HSLFSlideShow ppt = shape.getSheet().getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return null;
        }
        EscherContainerRecord spContainer = shape.getSpContainer();
        Iterator it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = (EscherRecord)it.next();
            if (obj.getRecordId() != -4079) continue;
            byte[] data = obj.serialize();
            Record[] records = Record.findChildRecords(data, 8, data.length - 8);
            HSLFHyperlink.find(records, exobj, lst);
        }
        return lst.size() == 1 ? (HSLFHyperlink)lst.get(0) : null;
    }

    private static void find(Record[] records, ExObjList exobj, List<HSLFHyperlink> out) {
        if (records == null) {
            return;
        }
        for (int i = 0; i < records.length; ++i) {
            InteractiveInfo hldr;
            InteractiveInfoAtom info;
            int id;
            ExHyperlink linkRecord;
            if (!(records[i] instanceof InteractiveInfo) || (linkRecord = exobj.get(id = (info = (hldr = (InteractiveInfo)records[i]).getInteractiveInfoAtom()).getHyperlinkID())) == null) continue;
            HSLFHyperlink link = new HSLFHyperlink();
            link.title = linkRecord.getLinkTitle();
            link.address = linkRecord.getLinkURL();
            link.type = info.getAction();
            out.add(link);
            if (i + 1 >= records.length || !(records[i + 1] instanceof TxInteractiveInfoAtom)) continue;
            TxInteractiveInfoAtom txinfo = (TxInteractiveInfoAtom)records[++i];
            link.startIndex = txinfo.getStartIndex();
            link.endIndex = txinfo.getEndIndex();
        }
    }
}

