/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.mapper.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.exception.InitMapperException;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.impl.DigesterDescriptorReader;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.MappingDescriptor;

public class DigesterMapperImpl
implements Mapper {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$mapper$impl$DigesterMapperImpl == null ? (class$org$apache$portals$graffito$jcr$mapper$impl$DigesterMapperImpl = DigesterMapperImpl.class$("org.apache.portals.graffito.jcr.mapper.impl.DigesterMapperImpl")) : class$org$apache$portals$graffito$jcr$mapper$impl$DigesterMapperImpl));
    private MappingDescriptor mappingDescriptor;
    private Collection rootClassDescriptors = new ArrayList();
    private String[] mappingFiles;
    private InputStream[] mappingStreams;
    private DigesterDescriptorReader descriptorReader;
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$mapper$impl$DigesterMapperImpl;

    public DigesterMapperImpl() {
    }

    public DigesterMapperImpl(String xmlFile) {
        this.mappingFiles = new String[]{xmlFile};
        this.buildMapper();
    }

    public DigesterMapperImpl(String[] files) {
        this.mappingFiles = files;
        this.buildMapper();
    }

    public DigesterMapperImpl(InputStream stream) {
        this.mappingStreams = new InputStream[]{stream};
        this.buildMapper();
    }

    public DigesterMapperImpl(InputStream[] streams) {
        this.mappingStreams = streams;
        this.buildMapper();
    }

    public void setMappingFile(String file) {
        this.setMappingFiles(new String[]{file});
        this.buildMapper();
    }

    public void setMappingFiles(String[] files) {
        this.mappingFiles = files;
    }

    public void setMappingStream(InputStream stream) {
        this.setMappingStreams(new InputStream[]{stream});
    }

    public void setMappingStreams(InputStream[] streams) {
        this.mappingStreams = streams;
    }

    public void setDescriptorReader(DigesterDescriptorReader reader) {
        this.descriptorReader = reader;
    }

    private Mapper buildMapper() {
        int i;
        if (this.descriptorReader == null) {
            this.descriptorReader = new DigesterDescriptorReader();
        }
        if (this.mappingFiles != null && this.mappingFiles.length > 0) {
            log.info((Object)("Read the xml mapping file : " + this.mappingFiles[0]));
            this.mappingDescriptor = this.descriptorReader.loadClassDescriptors(this.mappingFiles[0]);
            this.mappingDescriptor.setMapper(this);
            for (i = 1; i < this.mappingFiles.length; ++i) {
                log.info((Object)("Read the xml mapping file : " + this.mappingFiles[i]));
                MappingDescriptor anotherMappingDescriptor = this.descriptorReader.loadClassDescriptors(this.mappingFiles[i]);
                this.mappingDescriptor.getClassDescriptorsByClassName().putAll(anotherMappingDescriptor.getClassDescriptorsByClassName());
                this.mappingDescriptor.getClassDescriptorsByNodeType().putAll(anotherMappingDescriptor.getClassDescriptorsByNodeType());
            }
        } else if (this.mappingStreams != null && this.mappingStreams.length > 0) {
            log.info((Object)("Read the stream mapping file : " + this.mappingStreams[0].toString()));
            this.mappingDescriptor = this.descriptorReader.loadClassDescriptors(this.mappingStreams[0]);
            this.mappingDescriptor.setMapper(this);
            for (i = 1; i < this.mappingStreams.length; ++i) {
                log.info((Object)("Read the stream mapping file : " + this.mappingStreams[i].toString()));
                MappingDescriptor anotherMappingDescriptor = this.descriptorReader.loadClassDescriptors(this.mappingStreams[i]);
                this.mappingDescriptor.getClassDescriptorsByClassName().putAll(anotherMappingDescriptor.getClassDescriptorsByClassName());
                this.mappingDescriptor.getClassDescriptorsByNodeType().putAll(anotherMappingDescriptor.getClassDescriptorsByNodeType());
            }
        }
        if (null != this.mappingDescriptor) {
            List errors = new ArrayList();
            errors = this.solveReferences(errors);
            if (!(errors = this.validateDescriptors(errors, this.rootClassDescriptors)).isEmpty()) {
                throw new InitMapperException("Mapping files contain errors." + this.getErrorMessage(errors));
            }
        } else {
            throw new InitMapperException("No mappings were provided");
        }
        return this;
    }

    private List solveReferences(List errors) {
        Iterator it = this.mappingDescriptor.getClassDescriptorsByClassName().entrySet().iterator();
        while (it.hasNext()) {
            Collection interfaces;
            Map.Entry entry = it.next();
            ClassDescriptor cd = (ClassDescriptor)entry.getValue();
            if (null != cd.getExtend() && !"".equals(cd.getExtend())) {
                ClassDescriptor superClassDescriptor = this.mappingDescriptor.getClassDescriptorByName(cd.getExtend());
                if (null == superClassDescriptor) {
                    errors.add("Cannot find mapping for class " + cd.getExtend() + " referenced as extends from " + cd.getClassName());
                } else {
                    log.debug((Object)("Class " + cd.getClassName() + " extends " + cd.getExtend()));
                    cd.setSuperClassDescriptor(superClassDescriptor);
                }
            } else {
                this.rootClassDescriptors.add(cd);
            }
            if ((interfaces = cd.getImplements()).size() <= 0) continue;
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                String interfaceName = (String)iterator.next();
                ClassDescriptor interfaceClassDescriptor = this.mappingDescriptor.getClassDescriptorByName(interfaceName);
                if (null == interfaceClassDescriptor) {
                    errors.add("Cannot find mapping for interface " + interfaceName + " referenced as implements from " + cd.getClassName());
                    continue;
                }
                log.debug((Object)("Class " + cd.getClassName() + " implements " + interfaceName));
                interfaceClassDescriptor.addDescendantClassDescriptor(cd);
            }
        }
        return errors;
    }

    private List validateDescriptors(List errors, Collection classDescriptors) {
        Iterator it = classDescriptors.iterator();
        while (it.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)it.next();
            try {
                classDescriptor.afterPropertiesSet();
                if (!classDescriptor.hasDescendants()) continue;
                errors = this.validateDescriptors(errors, classDescriptor.getDescendantClassDescriptors());
            }
            catch (JcrMappingException jme) {
                log.warn((Object)("Mapping of class " + classDescriptor.getClassName() + " is invalid"), (Throwable)jme);
                errors.add(jme.getMessage());
            }
        }
        return errors;
    }

    private String getErrorMessage(List errors) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            buf.append(lineSep).append(it.next());
        }
        return buf.toString();
    }

    public ClassDescriptor getClassDescriptorByClass(Class clazz) {
        return this.mappingDescriptor.getClassDescriptorByName(clazz.getName());
    }

    public ClassDescriptor getClassDescriptorByNodeType(String jcrNodeType) {
        return this.mappingDescriptor.getClassDescriptorByNodeType(jcrNodeType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

