/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.mapper.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.mapper.model.BeanDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.CollectionDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.FieldDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.ImplementDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.MappingDescriptor;
import org.apache.portals.graffito.jcr.reflection.ReflectionUtils;

public class ClassDescriptor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$mapper$model$ClassDescriptor == null ? (class$org$apache$portals$graffito$jcr$mapper$model$ClassDescriptor = ClassDescriptor.class$("org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor")) : class$org$apache$portals$graffito$jcr$mapper$model$ClassDescriptor));
    private static final String NODETYPE_PER_HIERARCHY = "nodetypeperhierarchy";
    private static final String NODETYPE_PER_CONCRETECLASS = "nodetypeperconcreteclass";
    private MappingDescriptor mappingDescriptor;
    private ClassDescriptor superClassDescriptor;
    private Collection descendantClassDescriptors = new ArrayList();
    private String className;
    private String jcrNodeType;
    private String jcrSuperTypes;
    private String[] jcrMixinTypes = new String[0];
    private FieldDescriptor idFieldDescriptor;
    private FieldDescriptor pathFieldDescriptor;
    private Map fieldDescriptors = new HashMap();
    private Map beanDescriptors = new HashMap();
    private Map collectionDescriptors = new HashMap();
    private Map fieldNames = new HashMap();
    private String superClassName;
    private String extendsStrategy;
    private boolean isAbstract = false;
    private boolean hasDescendant = false;
    private boolean hasDiscriminator = true;
    private boolean isInterface = false;
    private List interfaces = new ArrayList();
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$mapper$model$ClassDescriptor;

    public void setAbstract(boolean flag) {
        this.isAbstract = flag;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setInterface(boolean flag) {
        this.isInterface = flag;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean hasInterfaces() {
        return this.interfaces.size() > 0;
    }

    public void setDiscriminator(boolean flag) {
        this.hasDiscriminator = flag;
    }

    public boolean hasDiscriminator() {
        return this.hasDiscriminator;
    }

    public boolean usesNodeTypePerHierarchyStrategy() {
        return NODETYPE_PER_HIERARCHY.equals(this.extendsStrategy);
    }

    public boolean usesNodeTypePerConcreteClassStrategy() {
        return NODETYPE_PER_CONCRETECLASS.equals(this.extendsStrategy);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJcrNodeType() {
        return this.jcrNodeType;
    }

    public void setJcrNodeType(String jcrNodeType) {
        this.jcrNodeType = jcrNodeType;
    }

    public void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        fieldDescriptor.setClassDescriptor(this);
        if (fieldDescriptor.isId()) {
            this.idFieldDescriptor = fieldDescriptor;
        }
        if (fieldDescriptor.isPath()) {
            this.pathFieldDescriptor = fieldDescriptor;
        }
        this.fieldDescriptors.put(fieldDescriptor.getFieldName(), fieldDescriptor);
        this.fieldNames.put(fieldDescriptor.getFieldName(), fieldDescriptor.getJcrName());
    }

    public void addImplementDescriptor(ImplementDescriptor implementDescriptor) {
        this.interfaces.add(implementDescriptor.getInterfaceName());
    }

    public FieldDescriptor getFieldDescriptor(String fieldName) {
        return (FieldDescriptor)this.fieldDescriptors.get(fieldName);
    }

    public Collection getFieldDescriptors() {
        return this.fieldDescriptors.values();
    }

    public void addBeanDescriptor(BeanDescriptor beanDescriptor) {
        beanDescriptor.setClassDescriptor(this);
        this.beanDescriptors.put(beanDescriptor.getFieldName(), beanDescriptor);
        this.fieldNames.put(beanDescriptor.getFieldName(), beanDescriptor.getJcrName());
    }

    public BeanDescriptor getBeanDescriptor(String fieldName) {
        return (BeanDescriptor)this.beanDescriptors.get(fieldName);
    }

    public Collection getBeanDescriptors() {
        return this.beanDescriptors.values();
    }

    public void addCollectionDescriptor(CollectionDescriptor collectionDescriptor) {
        collectionDescriptor.setClassDescriptor(this);
        this.collectionDescriptors.put(collectionDescriptor.getFieldName(), collectionDescriptor);
        this.fieldNames.put(collectionDescriptor.getFieldName(), collectionDescriptor.getJcrName());
    }

    public CollectionDescriptor getCollectionDescriptor(String fieldName) {
        return (CollectionDescriptor)this.collectionDescriptors.get(fieldName);
    }

    public Collection getCollectionDescriptors() {
        return this.collectionDescriptors.values();
    }

    public FieldDescriptor getIdFieldDescriptor() {
        return this.idFieldDescriptor;
    }

    public FieldDescriptor getPathFieldDescriptor() {
        if (null != this.pathFieldDescriptor) {
            return this.pathFieldDescriptor;
        }
        if (null != this.superClassDescriptor) {
            return this.superClassDescriptor.getPathFieldDescriptor();
        }
        return null;
    }

    public boolean hasIdField() {
        return this.idFieldDescriptor != null && !this.idFieldDescriptor.equals("");
    }

    public String getJcrName(String fieldName) {
        String jcrName = (String)this.fieldNames.get(fieldName);
        if (this.isInterface && jcrName == null) {
            return this.getJcrNameFromDescendants(this, fieldName);
        }
        return jcrName;
    }

    private String getJcrNameFromDescendants(ClassDescriptor classDescriptor, String fieldName) {
        Iterator descendants = classDescriptor.getDescendantClassDescriptors().iterator();
        if (descendants.hasNext()) {
            ClassDescriptor descendant = (ClassDescriptor)descendants.next();
            String jcrName = (String)descendant.fieldNames.get(fieldName);
            if (jcrName != null) {
                return jcrName;
            }
            return this.getJcrNameFromDescendants(descendant, fieldName);
        }
        return null;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public String getJcrSuperTypes() {
        return this.jcrSuperTypes;
    }

    public void setJcrSuperTypes(String superTypes) {
        this.jcrSuperTypes = superTypes;
    }

    public String[] getJcrMixinTypes() {
        return this.jcrMixinTypes;
    }

    public void setJcrMixinTypes(String[] mixinTypes) {
        if (null != mixinTypes && mixinTypes.length == 1) {
            this.jcrMixinTypes = mixinTypes[0].split(" *, *");
        }
    }

    public MappingDescriptor getMappingDescriptor() {
        return this.mappingDescriptor;
    }

    public void setMappingDescriptor(MappingDescriptor mappingDescriptor) {
        this.mappingDescriptor = mappingDescriptor;
    }

    public void afterPropertiesSet() {
        this.validateClassName();
        this.validateBeanFields();
        this.lookupSuperDescriptor();
        this.lookupInheritanceSettings();
    }

    private void validateClassName() {
        try {
            ReflectionUtils.forName(this.className);
        }
        catch (JcrMappingException e) {
            throw new JcrMappingException("Class used in descriptor not found : " + this.className);
        }
    }

    private void validateBeanFields() {
        Iterator beanDescriptorIterator = this.beanDescriptors.values().iterator();
        while (beanDescriptorIterator.hasNext()) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)beanDescriptorIterator.next();
            if (!beanDescriptor.isProxy() || !beanDescriptor.isInline()) continue;
            throw new JcrMappingException("Bean field can not be proxy and inline - class : " + this.className + " - bean field :" + beanDescriptor.getFieldName());
        }
    }

    private void lookupSuperDescriptor() {
        if (null != this.superClassDescriptor) {
            this.hasDiscriminator = this.superClassDescriptor.hasDiscriminator();
            if (!this.isInterface) {
                this.fieldDescriptors = this.mergeFields(this.fieldDescriptors, this.superClassDescriptor.getFieldDescriptors());
                this.beanDescriptors = this.mergeBeans(this.beanDescriptors, this.superClassDescriptor.getBeanDescriptors());
                this.collectionDescriptors = this.mergeCollections(this.collectionDescriptors, this.superClassDescriptor.getCollectionDescriptors());
                this.fieldNames.putAll(this.superClassDescriptor.getFieldNames());
            }
        }
    }

    private void lookupInheritanceSettings() {
        if (null != this.superClassDescriptor || this.hasDescendants() || this.hasInterfaces()) {
            this.extendsStrategy = this.hasDiscriminator() ? NODETYPE_PER_HIERARCHY : NODETYPE_PER_CONCRETECLASS;
        }
    }

    public String getExtend() {
        return this.superClassName;
    }

    public void setExtend(String className) {
        this.superClassName = className;
    }

    public ClassDescriptor getSuperClassDescriptor() {
        return this.superClassDescriptor;
    }

    public Collection getDescendantClassDescriptors() {
        return this.descendantClassDescriptors;
    }

    public ClassDescriptor getDescendantClassDescriptor(String nodeType) {
        Iterator iterator = this.descendantClassDescriptors.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor;
            ClassDescriptor descendantClassDescriptor = (ClassDescriptor)iterator.next();
            if (descendantClassDescriptor.getJcrNodeType().equals(nodeType)) {
                return descendantClassDescriptor;
            }
            if (!descendantClassDescriptor.hasDescendants() || (classDescriptor = descendantClassDescriptor.getDescendantClassDescriptor(nodeType)) == null) continue;
            return classDescriptor;
        }
        return null;
    }

    public void addDescendantClassDescriptor(ClassDescriptor classDescriptor) {
        this.descendantClassDescriptors.add(classDescriptor);
        this.hasDescendant = true;
    }

    public boolean hasDescendants() {
        return this.hasDescendant;
    }

    public void setSuperClassDescriptor(ClassDescriptor superClassDescriptor) {
        this.superClassDescriptor = superClassDescriptor;
        superClassDescriptor.addDescendantClassDescriptor(this);
    }

    public Collection getImplements() {
        return this.interfaces;
    }

    private Map mergeFields(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, FieldDescriptor> merged = new HashMap<String, FieldDescriptor>(existing);
        Iterator it = superSource.iterator();
        while (it.hasNext()) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)it.next();
            if (merged.containsKey(fieldDescriptor.getFieldName())) continue;
            merged.put(fieldDescriptor.getFieldName(), fieldDescriptor);
        }
        return merged;
    }

    private Map mergeBeans(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, BeanDescriptor> merged = new HashMap<String, BeanDescriptor>(existing);
        Iterator it = superSource.iterator();
        while (it.hasNext()) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)it.next();
            if (merged.containsKey(beanDescriptor.getFieldName())) continue;
            merged.put(beanDescriptor.getFieldName(), beanDescriptor);
        }
        return merged;
    }

    private Map mergeCollections(Map existing, Collection superSource) {
        if (null == superSource) {
            return existing;
        }
        HashMap<String, CollectionDescriptor> merged = new HashMap<String, CollectionDescriptor>(existing);
        Iterator it = superSource.iterator();
        while (it.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)it.next();
            if (merged.containsKey(collectionDescriptor.getFieldName())) continue;
            merged.put(collectionDescriptor.getFieldName(), collectionDescriptor);
        }
        return merged;
    }

    public String toString() {
        return "Class Descriptor : " + this.getClassName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

