/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.collectionconverter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.CollectionDescriptor;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollection;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollectionUtil;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.portals.graffito.jcr.persistence.objectconverter.ObjectConverter;
import org.apache.portals.graffito.jcr.reflection.ReflectionUtils;

public class DefaultCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    private static final String COLLECTION_ELEMENT_NAME = "collection-element";

    public DefaultCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) throws RepositoryException {
        if (collection == null) {
            return;
        }
        String jcrName = collectionDescriptor.getJcrName();
        if (jcrName == null) {
            throw new JcrMappingException("The JcrName attribute is not defined for the CollectionDescriptor : " + collectionDescriptor.getFieldName() + " for the classdescriptor : " + collectionDescriptor.getClassDescriptor().getClassName());
        }
        Node collectionNode = parentNode.addNode(jcrName);
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Iterator collectionIterator = collection.getIterator();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
            } else {
                elementJcrName = COLLECTION_ELEMENT_NAME;
            }
            this.objectConverter.insert(session, collectionNode, elementJcrName, item);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (collection == null) {
            if (parentNode.hasNode(jcrName)) {
                parentNode.getNode(jcrName).remove();
            }
            return;
        }
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Node collectionNode = parentNode.getNode(jcrName);
        if (!elementClassDescriptor.hasIdField()) {
            collectionNode.remove();
            collectionNode = parentNode.addNode(jcrName);
        }
        Iterator collectionIterator = collection.getIterator();
        HashMap updatedItems = new HashMap();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
                if (collectionNode.hasNode(elementJcrName)) {
                    this.objectConverter.update(session, collectionNode, elementJcrName, item);
                } else {
                    this.objectConverter.insert(session, collectionNode, elementJcrName, item);
                }
                updatedItems.put(elementJcrName, item);
                continue;
            }
            elementJcrName = COLLECTION_ELEMENT_NAME;
            this.objectConverter.insert(session, collectionNode, elementJcrName, item);
        }
        if (elementClassDescriptor.hasIdField()) {
            NodeIterator nodeIterator = collectionNode.getNodes();
            ArrayList<Node> removeNodes = new ArrayList<Node>();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                if (updatedItems.containsKey(child.getName())) continue;
                removeNodes.add(child);
            }
            for (int i = 0; i < removeNodes.size(); ++i) {
                ((Node)removeNodes.get(i)).remove();
            }
        }
    }

    protected ManageableCollection doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode == null || !parentNode.hasNode(jcrName)) {
            return null;
        }
        ManageableCollection collection = ManageableCollectionUtil.getManageableCollection(collectionFieldClass);
        Node collectionNode = parentNode.getNode(jcrName);
        NodeIterator children = collectionNode.getNodes();
        Class elementClass = ReflectionUtils.forName(collectionDescriptor.getElementClassName());
        while (children.hasNext()) {
            Node itemNode = children.nextNode();
            Object item = this.objectConverter.getObject(session, itemNode.getPath());
            collection.addObject(item);
        }
        return collection;
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return parentNode == null || !parentNode.hasNode(jcrName);
    }
}

