/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.query.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.AtomicTypeConverter;
import org.apache.portals.graffito.jcr.query.Filter;

public class FilterImpl
implements Filter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$query$impl$FilterImpl == null ? (class$org$apache$portals$graffito$jcr$query$impl$FilterImpl = FilterImpl.class$("org.apache.portals.graffito.jcr.query.impl.FilterImpl")) : class$org$apache$portals$graffito$jcr$query$impl$FilterImpl));
    private Class claszz;
    private String scope = "";
    private String jcrExpression = "";
    private ClassDescriptor classDescriptor;
    private Map atomicTypeConverters;
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$query$impl$FilterImpl;

    public FilterImpl(ClassDescriptor classDescriptor, Map atomicTypeConverters, Class clazz) {
        this.claszz = clazz;
        this.atomicTypeConverters = atomicTypeConverters;
        this.classDescriptor = classDescriptor;
    }

    public Class getFilterClass() {
        return this.claszz;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public Filter addContains(String scope, String fullTextSearch) {
        String jcrExpression = null;
        jcrExpression = scope.equals(".") ? "jcr:contains(., '" + fullTextSearch + "')" : "jcr:contains(@" + this.getJcrFieldName(scope) + ", '" + fullTextSearch + "')";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addBetween(String fieldAttributeName, Object value1, Object value2) {
        String jcrExpression = "( @" + this.getJcrFieldName(fieldAttributeName) + " >= " + this.getStringValue(value1) + " and @" + this.getJcrFieldName(fieldAttributeName) + " <= " + this.getStringValue(value2) + ")";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addEqualTo(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " = " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addGreaterOrEqualThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " >= " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addGreaterThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " > " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLessOrEqualThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " <= " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLessThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " < " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLike(String fieldAttributeName, Object value) {
        String jcrExpression = "jcr:like(@" + this.getJcrFieldName(fieldAttributeName) + ", '" + value + "')";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addNotEqualTo(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " != " + this.getStringValue(value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addNotNull(String fieldAttributeName) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addIsNull(String fieldAttributeName) {
        String jcrExpression = "not(@" + this.getJcrFieldName(fieldAttributeName) + ")";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addOrFilter(Filter filter) {
        this.jcrExpression = null == this.jcrExpression || "".equals(this.jcrExpression) ? ((FilterImpl)filter).getJcrExpression() : "(" + this.jcrExpression + ")  or ( " + ((FilterImpl)filter).getJcrExpression() + ")";
        return this;
    }

    public Filter addAndFilter(Filter filter) {
        this.jcrExpression = null == this.jcrExpression || "".equals(this.jcrExpression) ? ((FilterImpl)filter).getJcrExpression() : "(" + this.jcrExpression + ") and  ( " + ((FilterImpl)filter).getJcrExpression() + ")";
        return this;
    }

    public Filter addJCRExpression(String jcrExpression) {
        this.addExpression(jcrExpression);
        return this;
    }

    private String getJcrFieldName(String fieldAttribute) {
        String jcrFieldName = this.classDescriptor.getJcrName(fieldAttribute);
        if (jcrFieldName == null) {
            log.error((Object)("Impossible to find the jcrFieldName for the attribute :" + fieldAttribute));
        }
        return jcrFieldName;
    }

    private String getStringValue(Object value) {
        AtomicTypeConverter atomicTypeConverter = (AtomicTypeConverter)this.atomicTypeConverters.get(value.getClass());
        return atomicTypeConverter.getStringValue(value);
    }

    public String getJcrExpression() {
        return this.jcrExpression;
    }

    private void addExpression(String jcrExpression) {
        if (this.jcrExpression.length() > 0) {
            this.jcrExpression = this.jcrExpression + " and ";
        }
        this.jcrExpression = this.jcrExpression + jcrExpression;
    }

    public String toString() {
        return this.getJcrExpression();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

