/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.query.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.query.Filter;
import org.apache.portals.graffito.jcr.query.Query;
import org.apache.portals.graffito.jcr.query.QueryManager;
import org.apache.portals.graffito.jcr.query.impl.FilterImpl;
import org.apache.portals.graffito.jcr.query.impl.QueryImpl;

public class QueryManagerImpl
implements QueryManager {
    private Mapper mapper;
    private Map atomicTypeConverters;

    public QueryManagerImpl(Mapper mapper, Map atomicTypeConverters) {
        this.mapper = mapper;
        this.atomicTypeConverters = atomicTypeConverters;
    }

    public Filter createFilter(Class classQuery) {
        return new FilterImpl(this.mapper.getClassDescriptorByClass(classQuery), this.atomicTypeConverters, classQuery);
    }

    public Query createQuery(Filter filter) {
        return new QueryImpl(filter, this.mapper);
    }

    public String buildJCRExpression(Query query) {
        Filter filter = query.getFilter();
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(filter.getFilterClass());
        if (classDescriptor.hasDiscriminator()) {
            Filter discrininatorFilter = this.buildDiscriminatorFilter(query, classDescriptor);
            filter = filter.addAndFilter(discrininatorFilter);
        }
        String jcrExp = "";
        jcrExp = filter.getScope() != null && !filter.getScope().equals("") ? jcrExp + "/jcr:root" + filter.getScope() + "element(*, " : jcrExp + "//element(*, ";
        jcrExp = jcrExp + this.getNodeType(filter) + ") ";
        String filterExp = ((FilterImpl)filter).getJcrExpression();
        if (filterExp != null && !filterExp.equals("")) {
            jcrExp = jcrExp + "[" + filterExp + "]";
        }
        jcrExp = jcrExp + ((QueryImpl)query).getOrderByExpression();
        return jcrExp;
    }

    private Filter buildDiscriminatorFilter(Query query, ClassDescriptor classDescriptor) {
        Filter discriminatorFilter = this.createFilter(query.getFilter().getFilterClass());
        if (!classDescriptor.isAbstract() && !classDescriptor.isInterface()) {
            discriminatorFilter.addJCRExpression("@graffito:classname='" + classDescriptor.getClassName() + "'");
        }
        if (classDescriptor.hasDescendants()) {
            Iterator descendantDescriptorIterator = classDescriptor.getDescendantClassDescriptors().iterator();
            while (descendantDescriptorIterator.hasNext()) {
                ClassDescriptor descendantClassDescriptor = (ClassDescriptor)descendantDescriptorIterator.next();
                discriminatorFilter = discriminatorFilter.addOrFilter(this.buildDiscriminatorFilter(query, descendantClassDescriptor));
            }
        }
        return discriminatorFilter;
    }

    private String getNodeType(Filter filter) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(filter.getFilterClass());
        String jcrNodeType = classDescriptor.getJcrNodeType();
        if (jcrNodeType == null || jcrNodeType.equals("")) {
            return "nt:unstructured";
        }
        return jcrNodeType;
    }
}

