/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.log4j.Logger;

public class SimpleAccessManager
implements AccessManager {
    private static Logger log = Logger.getLogger((Class)(class$org$apache$portals$graffito$jcr$security$SimpleAccessManager == null ? (class$org$apache$portals$graffito$jcr$security$SimpleAccessManager = SimpleAccessManager.class$("org.apache.portals.graffito.jcr.security.SimpleAccessManager")) : class$org$apache$portals$graffito$jcr$security$SimpleAccessManager));
    protected Subject subject;
    protected HierarchyManager hierMgr;
    private boolean initialized = false;
    protected boolean system = false;
    protected boolean anonymous = false;
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$security$SimpleAccessManager;
    static /* synthetic */ Class class$org$apache$jackrabbit$core$security$AnonymousPrincipal;
    static /* synthetic */ Class class$org$apache$jackrabbit$core$security$SystemPrincipal;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.subject = context.getSubject();
        this.hierMgr = context.getHierarchyManager();
        this.anonymous = !this.subject.getPrincipals(class$org$apache$jackrabbit$core$security$AnonymousPrincipal == null ? (class$org$apache$jackrabbit$core$security$AnonymousPrincipal = SimpleAccessManager.class$("org.apache.jackrabbit.core.security.AnonymousPrincipal")) : class$org$apache$jackrabbit$core$security$AnonymousPrincipal).isEmpty();
        this.system = !this.subject.getPrincipals(class$org$apache$jackrabbit$core$security$SystemPrincipal == null ? (class$org$apache$jackrabbit$core$security$SystemPrincipal = SimpleAccessManager.class$("org.apache.jackrabbit.core.security.SystemPrincipal")) : class$org$apache$jackrabbit$core$security$SystemPrincipal).isEmpty();
        this.initialized = true;
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.initialized = false;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return;
        }
        if (this.anonymous && ((permissions & 2) == 2 || (permissions & 4) == 4)) {
            throw new AccessDeniedException();
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return true;
        }
        return !this.anonymous || (permissions & 2) != 2 && (permissions & 4) != 4;
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

