/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.transaction.jackrabbit;

import javax.jcr.Session;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.XASession;

public class UserTransactionImpl
implements UserTransaction {
    private static byte counter = 0;
    private final XAResource xares;
    private Xid xid;
    private int status = 6;

    public UserTransactionImpl(Session session) {
        if (!(session instanceof XASession)) {
            throw new IllegalArgumentException("Session not of type XASession");
        }
        this.xares = ((XASession)session).getXAResource();
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.status != 6) {
            throw new IllegalStateException("Transaction already active");
        }
        try {
            byte by = counter;
            counter = (byte)(by + 1);
            this.xid = new XidImpl(by);
            this.xares.start(this.xid, 0);
            this.status = 0;
        }
        catch (XAException e) {
            throw new SystemException("Unable to begin transaction: XA_ERR=" + e.errorCode);
        }
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            this.xares.end(this.xid, 0x4000000);
            this.status = 7;
            this.xares.prepare(this.xid);
            this.status = 2;
            this.status = 8;
            this.xares.commit(this.xid, false);
            this.status = 3;
        }
        catch (XAException e) {
            if (e.errorCode >= 100 && e.errorCode <= 107) {
                throw new RollbackException();
            }
            throw new SystemException("Unable to commit transaction: XA_ERR=" + e.errorCode);
        }
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            this.xares.end(this.xid, 0x20000000);
            this.status = 9;
            this.xares.rollback(this.xid);
            this.status = 4;
        }
        catch (XAException e) {
            throw new SystemException("Unable to rollback transaction: XA_ERR=" + e.errorCode);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException("Transaction not active");
        }
        this.status = 1;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    class XidImpl
    implements Xid {
        private final byte[] globalTxId;

        public XidImpl(byte globalTxNumber) {
            this.globalTxId = new byte[]{globalTxNumber};
        }

        public int getFormatId() {
            return 0;
        }

        public byte[] getBranchQualifier() {
            return new byte[0];
        }

        public byte[] getGlobalTransactionId() {
            return this.globalTxId;
        }
    }
}

