/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderPortlet;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.services.container.FilterChainImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterManagerImpl
implements FilterManager {
    private static final Logger LOG = LoggerFactory.getLogger(FilterManagerImpl.class);
    private FilterChainImpl filterchain;
    private PortletApplicationDefinition portletApp;
    private String portletName;
    private String lifeCycle;

    public FilterManagerImpl(PortletWindow portletWindow, String lifeCycle) {
        PortletDefinition pd = portletWindow.getPortletDefinition();
        this.portletApp = pd.getApplication();
        this.portletName = pd.getPortletName();
        this.lifeCycle = lifeCycle;
        this.filterchain = new FilterChainImpl(lifeCycle);
        this.initFilterChain();
    }

    public void setBeanManager(BeanManager bm) {
        this.filterchain.setBeanManager(bm);
    }

    private void initFilterChain() {
        List filterMappingList = this.portletApp.getFilterMappings();
        if (filterMappingList != null) {
            for (FilterMapping filterMapping : filterMappingList) {
                if (!this.isFilter(filterMapping, this.portletName)) continue;
                List filterList = this.portletApp.getFilters();
                for (Filter filter : filterList) {
                    if (!filter.getFilterName().equals(filterMapping.getFilterName()) || !this.isLifeCycle(filter, this.lifeCycle)) continue;
                    this.filterchain.addFilter(filter);
                }
            }
        }
    }

    public void processFilter(EventRequest req, EventResponse res, EventPortlet eventPortlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter(req, res, eventPortlet, portletContext);
    }

    public void processFilter(ResourceRequest req, ResourceResponse res, ResourceServingPortlet resourceServingPortlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.reset();
        this.filterchain.processFilter(req, res, resourceServingPortlet, portletContext);
    }

    public void processFilter(RenderRequest req, RenderResponse res, Portlet portlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter(req, res, portlet, portletContext);
    }

    public void processFilter(HeaderRequest req, HeaderResponse res, HeaderPortlet portlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter(req, res, portlet, portletContext);
    }

    public void processFilter(ActionRequest req, ActionResponse res, Portlet portlet, PortletContext portletContext) throws PortletException, IOException {
        this.filterchain.processFilter(req, res, portlet, portletContext);
    }

    private boolean isLifeCycle(Filter filter, String lifeCycle) {
        List lifeCyclesList = filter.getLifecycles();
        for (String string : lifeCyclesList) {
            if (!string.equals(lifeCycle)) continue;
            return true;
        }
        return false;
    }

    private boolean isFilter(FilterMapping filterMapping, String portletName) {
        List portletNamesList = filterMapping.getPortletNames();
        for (String portletNameFromFilterList : portletNamesList) {
            if (portletNameFromFilterList.endsWith("*")) {
                if (portletNameFromFilterList.length() == 1) {
                    return true;
                }
                portletNameFromFilterList = portletNameFromFilterList.substring(0, portletNameFromFilterList.length() - 1);
                if (portletName.length() < portletNameFromFilterList.length() || !portletName.substring(0, portletNameFromFilterList.length()).equals(portletNameFromFilterList)) continue;
                return true;
            }
            if (!portletNameFromFilterList.equals(portletName)) continue;
            return true;
        }
        return false;
    }
}

