/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.container.PortletStateAwareResponseContextImpl;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletActionResponseContextImpl
extends PortletStateAwareResponseContextImpl
implements PortletActionResponseContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletActionResponseContextImpl.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private boolean redirect;
    private String redirectLocation;
    private String renderURLParamName;

    public PortletActionResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, PortletRequestContext requestContext) {
        super(container, containerRequest, containerResponse, window, requestContext);
        this.setLifecycle("ACTION_PHASE");
    }

    public String getResponseURL() {
        if (!this.isReleased()) {
            this.close();
            if (!this.redirect || this.renderURLParamName != null) {
                PortalURL url = PortalRequestContext.getContext((HttpServletRequest)this.getServletRequest()).createPortalURL();
                if (this.redirect) {
                    try {
                        String fragment = this.redirectLocation.replaceFirst("^([^#]*)(#.*)$", "$2");
                        String base = this.redirectLocation.replaceFirst("^([^#]*)(#.*)$", "$1");
                        boolean hasFragment = !fragment.equals(this.redirectLocation);
                        boolean hasQuery = base.indexOf("?") >= 0;
                        StringBuilder urlBuilder = new StringBuilder(128);
                        urlBuilder.append(base);
                        urlBuilder.append(hasQuery ? "&" : "?");
                        urlBuilder.append(URLEncoder.encode(this.renderURLParamName, "UTF-8")).append("=");
                        urlBuilder.append(URLEncoder.encode(url.toURL(true), "UTF-8"));
                        urlBuilder.append(hasFragment ? fragment : "");
                        if (isTrace) {
                            StringBuilder txt = new StringBuilder();
                            txt.append("hasFragment: ").append(hasFragment);
                            txt.append(", fragment: ").append(hasFragment ? fragment : "n/a");
                            txt.append(", hasQuery: ").append(hasQuery);
                            txt.append(", paramName: ").append(this.renderURLParamName);
                            txt.append("\n   Original redirect location: ").append(this.redirectLocation);
                            txt.append("\n   Complete URL: ").append(urlBuilder.toString());
                            LOG.debug(txt.toString());
                        }
                        return urlBuilder.toString();
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }
                return url.toURL(false);
            }
            return this.redirectLocation;
        }
        return null;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(String location) {
        this.setRedirect(location, null);
    }

    public void setRedirect(String location, String renderURLParamName) {
        if (!this.isClosed()) {
            this.redirectLocation = location;
            this.renderURLParamName = renderURLParamName;
            this.redirect = true;
        }
    }
}

