/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletAsyncEvent;
import javax.portlet.PortletAsyncListener;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.driver.services.container.PortletAsyncContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletAsyncContextListener
implements AsyncListener {
    private static final Logger LOG = LoggerFactory.getLogger(PortletAsyncContextListener.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    List<Entry> listeners = new ArrayList<Entry>();
    private long start = System.currentTimeMillis();
    private final PortletAsyncContextImpl pactx;

    public PortletAsyncContextListener(PortletAsyncContextImpl pactx) {
        this.pactx = pactx;
    }

    public void addListener(AsyncListener l) {
        this.listeners.add(new Entry(l, null, null));
    }

    public void addListener(AsyncListener l, ServletRequest req, ServletResponse resp) {
        this.listeners.add(new Entry(l, req, resp));
    }

    public void addListener(PortletAsyncListener l) {
        this.listeners.add(new Entry(l, null, null));
    }

    public void addListener(PortletAsyncListener l, ResourceRequest req, ResourceResponse resp) {
        this.listeners.add(new Entry(l, req, resp));
    }

    private void trace(String meth) {
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Firing ").append(meth).append(" event for ");
            txt.append(this.listeners.size()).append(" listeners.");
            int hcnt = 0;
            int pcnt = 0;
            for (Entry e : this.listeners) {
                if (e.hlis != null) {
                    ++hcnt;
                }
                if (e.plis == null) continue;
                ++pcnt;
            }
            txt.append(", # AsyncListeners: ").append(hcnt);
            txt.append(", # PortletAsyncListeners: ").append(pcnt);
            LOG.trace(txt.toString());
        }
    }

    public void onComplete(AsyncEvent evt) throws IOException {
        this.trace("onComplete");
        this.pactx.registerContext(true);
        for (Entry l : this.listeners) {
            AsyncEvent lisevt;
            if (l.hlis != null) {
                lisevt = new AsyncEvent((AsyncContext)this.pactx, l.hreq, l.hresp);
                l.hlis.onComplete(lisevt);
                continue;
            }
            lisevt = new PortletAsyncEvent((PortletAsyncContext)this.pactx, l.preq, l.presp);
            l.plis.onComplete((PortletAsyncEvent)lisevt);
        }
        this.pactx.deregisterContext(true);
        this.pactx.setComplete(true);
        long delta = System.currentTimeMillis() - this.start;
        StringBuilder txt = new StringBuilder(128);
        txt.append("Completed. Execution time: ").append(delta).append(" milliseconds.");
        txt.append(" Releasing: ");
        HttpServletRequest hreq = (HttpServletRequest)evt.getSuppliedRequest();
        if (hreq != null) {
            ResourceRequest rreq = (ResourceRequest)hreq.getAttribute("javax.portlet.request");
            if (rreq != null) {
                txt.append("portlet-scoped attributes; ");
                rreq.removeAttribute("javax.portlet.request");
                rreq.removeAttribute("javax.portlet.response");
                rreq.removeAttribute("javax.portlet.config");
                rreq.removeAttribute("javax.portlet.asyncMethod");
                PortletResourceResponseContext respctx = (PortletResourceResponseContext)rreq.getAttribute(PortletInvokerService.RESPONSE_CONTEXT);
                if (respctx != null) {
                    txt.append("response context resources; ");
                    respctx.close();
                    respctx.release();
                }
            } else {
                txt.append("... no resource request stuff. Couldn't get resource request; ");
            }
            txt.append("container-scoped attributes; ");
            hreq.removeAttribute("org.apache.pluto.core.method");
            hreq.removeAttribute("javax.portlet.request");
            hreq.removeAttribute("javax.portlet.response");
            hreq.removeAttribute("FilterManager");
        } else {
            txt.append("... no servlet request stuff. Couldn't get servlet request.");
        }
        txt.append(" Removing contextual info.");
        this.pactx.removeContext();
        HttpServletPortletRequestWrapper wrapper = (HttpServletPortletRequestWrapper)this.pactx.getAsyncRequestWrapper();
        if (wrapper != null) {
            txt.append(" Closing the request wrapper.");
            wrapper.endAsyncProcessing();
        } else {
            txt.append(" Couldn't get the request wrapper.");
        }
        if (isDebug) {
            LOG.debug(txt.toString());
        }
    }

    public void onError(AsyncEvent evt) throws IOException {
        this.trace("onError");
        this.pactx.registerContext(true);
        for (Entry l : this.listeners) {
            AsyncEvent lisevt;
            if (l.hlis != null) {
                lisevt = new AsyncEvent((AsyncContext)this.pactx, l.hreq, l.hresp);
                l.hlis.onError(lisevt);
                continue;
            }
            lisevt = new PortletAsyncEvent((PortletAsyncContext)this.pactx, l.preq, l.presp);
            l.plis.onError((PortletAsyncEvent)lisevt);
        }
        this.pactx.deregisterContext(true);
        long delta = System.currentTimeMillis() - this.start;
        StringBuilder txt = new StringBuilder(128);
        txt.append("Error after ").append(delta).append(" milliseconds.");
        try {
            AsyncContext ctx = evt.getAsyncContext();
            ctx.complete();
            txt.append(" Portlet container completed request processing on behalf of the application.");
        }
        catch (IllegalStateException e) {
            txt.append(" An earlier listener has already dispatched or completed request.");
        }
        catch (Exception e) {
            // empty catch block
        }
        txt.append(", Exception: ").append(evt.getThrowable().getMessage());
        if (isDebug) {
            LOG.debug(txt.toString());
        }
    }

    public void onStartAsync(AsyncEvent evt) throws IOException {
        this.trace("onStartAsync");
        ArrayList<Entry> entries = new ArrayList<Entry>(this.listeners);
        this.listeners.clear();
        this.pactx.registerContext(true);
        for (Entry l : entries) {
            AsyncEvent lisevt;
            if (l.hlis != null) {
                lisevt = new AsyncEvent((AsyncContext)this.pactx, l.hreq, l.hresp);
                l.hlis.onStartAsync(lisevt);
                continue;
            }
            lisevt = new PortletAsyncEvent((PortletAsyncContext)this.pactx, l.preq, l.presp);
            l.plis.onStartAsync((PortletAsyncEvent)lisevt);
        }
        this.pactx.deregisterContext(true);
        long delta = System.currentTimeMillis() - this.start;
        StringBuilder txt = new StringBuilder(128);
        txt.append("Async started again after ").append(delta).append(" milliseconds.");
        if (isDebug) {
            LOG.debug(txt.toString());
        }
        AsyncContext ctx = evt.getAsyncContext();
        ctx.addListener((AsyncListener)this);
    }

    public void onTimeout(AsyncEvent evt) throws IOException {
        this.trace("onTimeout");
        this.pactx.registerContext(true);
        for (Entry l : this.listeners) {
            AsyncEvent lisevt;
            if (l.hlis != null) {
                lisevt = new AsyncEvent((AsyncContext)this.pactx, l.hreq, l.hresp);
                l.hlis.onTimeout(lisevt);
                continue;
            }
            lisevt = new PortletAsyncEvent((PortletAsyncContext)this.pactx, l.preq, l.presp);
            l.plis.onTimeout((PortletAsyncEvent)lisevt);
        }
        this.pactx.deregisterContext(true);
        long delta = System.currentTimeMillis() - this.start;
        StringBuilder txt = new StringBuilder(128);
        txt.append("Timeout after ").append(delta).append(" milliseconds.");
        boolean warn = false;
        AsyncContext ctx = evt.getAsyncContext();
        try {
            ctx.getRequest();
            try {
                ctx.complete();
                txt.append(" Portlet container completed request processing on behalf of the application.");
                warn = true;
            }
            catch (IllegalStateException e) {
                txt.append(" An earlier listener has dispatched again.");
            }
            catch (Exception e) {
                txt.append(" Exception occured while completing request: " + e.toString());
            }
        }
        catch (Exception e) {
            txt.append(" Async processing was completed by the application.");
        }
        if (warn) {
            LOG.warn(txt.toString());
        } else if (isDebug) {
            LOG.debug(txt.toString());
        }
    }

    private class Entry {
        public AsyncListener hlis;
        public ServletRequest hreq;
        public ServletResponse hresp;
        public PortletAsyncListener plis;
        public ResourceRequest preq;
        public ResourceResponse presp;

        public Entry(AsyncListener lis, ServletRequest req, ServletResponse resp) {
            this.hlis = lis;
            this.hreq = req;
            this.hresp = resp;
        }

        public Entry(PortletAsyncListener lis, ResourceRequest req, ResourceResponse resp) {
            this.plis = lis;
            this.preq = req;
            this.presp = resp;
        }
    }
}

