/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import org.apache.pluto.container.PortletAsyncManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletAsyncContextualRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PortletAsyncContextualRunner.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private PortletAsyncManager pactx;
    private Runnable targetRunner;

    public void init(PortletAsyncManager pactx, Runnable targetRunner) {
        this.pactx = pactx;
        this.targetRunner = targetRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (isTrace) {
            LOG.trace("Initializing contextual environment and launching runner in thread: " + Thread.currentThread().getId());
        }
        try {
            this.pactx.registerContext(false);
            this.targetRunner.run();
        }
        catch (Exception e) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Exception running thread: ").append(e.toString());
        }
        finally {
            if (isTrace) {
                LOG.trace("Shutting down contextual environment for thread: " + Thread.currentThread().getId());
            }
            this.pactx.deregisterContext(false);
        }
    }
}

