/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.services.container.PortletMimeResponseContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletResourceResponseContextImpl
extends PortletMimeResponseContextImpl
implements PortletResourceResponseContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletResourceResponseContextImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();

    public PortletResourceResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, PortletRequestContext requestContext) {
        super(container, containerRequest, containerResponse, window, requestContext);
        this.setLifecycle("RESOURCE_PHASE");
    }

    public void setCharacterEncoding(String charset) {
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Setting character encoding.");
            txt.append(" charset: ").append(charset);
            txt.append(" isClosed: ").append(this.isClosed());
            LOGGER.trace(txt.toString());
        }
        if (!this.isClosed()) {
            this.getServletResponse().setCharacterEncoding(charset);
        }
    }

    public void setContentLength(int len) {
        if (!this.isClosed()) {
            this.getServletResponse().setContentLength(len);
        }
    }

    public void setContentLengthLong(long len) {
        if (!this.isClosed()) {
            this.getServletResponse().setContentLengthLong(len);
        }
    }

    public void setLocale(Locale locale) {
        if (!this.isClosed()) {
            this.getServletResponse().setLocale(locale);
        }
    }

    public void setStatus(int sc) {
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Setting character encoding.");
            txt.append(" status code: ").append(sc);
            txt.append(" isClosed: ").append(this.isClosed());
            LOGGER.trace(txt.toString());
        }
        if (!this.isClosed()) {
            this.getServletResponse().setStatus(sc);
        }
    }

    public int getStatus() {
        return this.getServletResponse().getStatus();
    }
}

