/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.HeaderData;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletStateAwareResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.ResourceURLProvider;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.container.PortletURLProviderImpl;
import org.apache.pluto.driver.services.container.ResourceURLProviderImpl;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public abstract class PortletResponseContextImpl
implements PortletResponseContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletResponseContextImpl.class);
    private PortletContainer container;
    private HttpServletRequest containerRequest;
    private HttpServletResponse containerResponse;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private PortletWindow window;
    private PortalURL portalURL;
    private boolean closed;
    private boolean released;
    private String lifecycle;
    private boolean isSetPropsAllowed = false;
    private static final Set<String> disallowedHeaders = new HashSet<String>(Arrays.asList("ACCEPT-PATCH", "ACCEPT-RANGES", "AGE", "ALLOW", "CACHE-CONTROL", "CONNECTION", "CONTENT-DISPOSITION", "CONTENT-ENCODING", "CONTENT-LANGUAGE", "CONTENT-LENGTH", "CONTENT-LOCATION", "CONTENT-MD5", "CONTENT-RANGE", "CONTENT-TYPE", "DATE", "ETAG", "EXPIRES", "LAST-MODIFIED", "LINK", "LOCATION", "P3P", "PRAGMA", "PROXY-AUTHENTICATE", "PUBLIC-KEY-PINS", "REFRESH", "RETRY-AFTER", "SERVER", "SET-COOKIE", "STATUS", "STRICT-TRANSPORT-SECURITY", "TRAILER", "TRANSFER-ENCODING", "UPGRADE", "VARY", "VIA", "WWW-AUTHENTICATE", "X-FRAME-OPTIONS"));
    private static final String VALID_HEADER_CHARS = "^[a-zA-Z0-9!#$%&'*+-.^_`|~]+$";
    protected final HeaderData headerData = new HeaderData();
    private final PortletRequestContext requestContext;

    public PortletResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, PortletRequestContext requestContext) {
        this.container = container;
        this.containerRequest = containerRequest;
        this.containerResponse = containerResponse;
        this.window = window;
        this.portalURL = PortalRequestContext.getContext((HttpServletRequest)containerRequest).createPortalURL();
        this.requestContext = requestContext;
    }

    public PortletRequestContext getRequestContext() {
        return this.requestContext;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean isSetPropsAllowed() {
        return this.isSetPropsAllowed;
    }

    public void setPropsAllowed(boolean isSetPropsAllowed) {
        this.isSetPropsAllowed = isSetPropsAllowed;
    }

    public boolean isHeaderBufferActive() {
        return this.isSetPropsAllowed && !this.lifecycle.equals("RESOURCE_PHASE");
    }

    public HeaderData getHeaderData() {
        return this.headerData;
    }

    protected PortalURL getPortalURL() {
        return this.portalURL;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected boolean isReleased() {
        return this.released;
    }

    public void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public void addProperty(Cookie cookie) {
        if (!this.isClosed() && this.isSetPropsAllowed) {
            if (this.lifecycle.matches("RESOURCE_PHASE")) {
                this.containerResponse.addCookie(cookie);
            } else {
                this.headerData.addCookie(cookie);
            }
        }
    }

    public void addProperty(String key, Element element) {
        if (!key.equals("javax.portlet.markup.head.element")) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring attempt to add document head element with key: ").append(key);
            txt.append(" rather than the required: ").append("javax.portlet.markup.head.element");
            LOG.warn(txt.toString());
        } else if (!this.isClosed() && this.isSetPropsAllowed && element != null && (this.lifecycle.equals("RENDER_PHASE") || this.lifecycle.equals("HEADER_PHASE"))) {
            this.headerData.addHeaderTag(element);
        }
    }

    public void addProperty(String key, String value) {
        if (value == null) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring attempt to add property with null value. Key: ").append(key);
            LOG.warn(txt.toString());
        } else if (!key.matches(VALID_HEADER_CHARS)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring attempt to add key containing disallowed characters. Key: ").append(key);
            txt.append(", value: ").append(value);
            LOG.warn(txt.toString());
        } else if (!this.lifecycle.matches("RESOURCE_PHASE") && disallowedHeaders.contains(key.toUpperCase())) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring disallowed HTTP header: ").append(key);
            txt.append(" with value: ").append(value);
            LOG.warn(txt.toString());
        } else if (!this.isClosed() && this.isSetPropsAllowed) {
            if (this.lifecycle.matches("RESOURCE_PHASE")) {
                this.containerResponse.addHeader(key, value);
            } else {
                this.headerData.addHttpHeader(key, value);
            }
        }
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring attempt to add property with null value. Key: ").append(key);
            LOG.warn(txt.toString());
        } else if (!key.matches(VALID_HEADER_CHARS)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring attempt to add key containing disallowed characters. Key: ").append(key);
            txt.append(", value: ").append(value);
            LOG.warn(txt.toString());
        } else if (!this.lifecycle.matches("RESOURCE_PHASE") && disallowedHeaders.contains(key.toUpperCase())) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring disallowed HTTP header: ").append(key);
            txt.append(" with value: ").append(value);
            LOG.warn(txt.toString());
        } else if (!this.isClosed() && this.isSetPropsAllowed) {
            if (this.lifecycle.matches("RESOURCE_PHASE")) {
                this.containerResponse.addHeader(key, value);
            } else {
                this.headerData.setHttpHeader(key, value);
            }
        }
    }

    public Element createElement(String tagName) throws DOMException {
        return this.headerData.createElement(tagName);
    }

    public String getProperty(String key) {
        List vals;
        String val = null;
        if (!this.isClosed() && this.isSetPropsAllowed && !(vals = (List)this.headerData.getHttpHeaders().get(key)).isEmpty()) {
            val = (String)vals.get(0);
        }
        return val;
    }

    public Collection<String> getPropertyValues(String key) {
        ArrayList<String> vals = new ArrayList<String>();
        if (!this.isClosed() && this.isSetPropsAllowed) {
            vals.addAll((Collection)this.headerData.getHttpHeaders().get(key));
        }
        return vals;
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (!this.isClosed() && this.isSetPropsAllowed) {
            names.addAll(this.headerData.getHttpHeaders().keySet());
        }
        return names;
    }

    public void processHttpHeaders() {
        for (Cookie c : this.headerData.getCookies()) {
            this.containerResponse.addCookie(c);
        }
        Map headers = this.headerData.getHttpHeaders();
        for (String name : headers.keySet()) {
            for (String val : (List)headers.get(name)) {
                this.containerResponse.addHeader(name, val);
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public HttpServletRequest getContainerRequest() {
        return this.containerRequest;
    }

    public HttpServletResponse getContainerResponse() {
        return this.containerResponse;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void release() {
        this.closed = true;
        this.released = true;
        this.container = null;
        this.servletRequest = null;
        this.servletResponse = null;
        this.window = null;
    }

    public ResourceURLProvider getResourceURLProvider() {
        return this.isReleased() ? null : new ResourceURLProviderImpl(this.servletRequest, this.window);
    }

    public PortletURLProvider getPortletURLProvider(PortletURLProvider.TYPE type) {
        return this.isClosed() ? null : new PortletURLProviderImpl(this.getPortalURL(), type, this.getPortletWindow(), this.getRequestContext());
    }

    public void setActionScopedId(String windowId, String[] values) {
        if (this instanceof PortletStateAwareResponseContext) {
            ((PortletStateAwareResponseContext)this).getRenderParameters(windowId).setValues("javax.portlet.as", values);
        } else {
            PortalURLParameter pup = new PortalURLParameter(windowId, "javax.portlet.as", values, "rp");
            if (values == null) {
                this.getPortalURL().removeParameter(pup);
            } else {
                pup.setPersistent(true);
                this.getPortalURL().setParameter(pup);
            }
        }
    }
}

