/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.apache.pluto.driver.url.PortletParameterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletURLProviderImpl
implements PortletURLProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletURLProviderImpl.class);
    private static final boolean isDebug = LOGGER.isDebugEnabled();
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    private final PortalURL url;
    private final PortletParameterFactory paramFactory;
    private final PortletURLProvider.TYPE type;
    private final String window;
    private Map<String, List<String>> properties;
    private static final HashMap<PortletURLProvider.ParamType, String> paramTypeMap = new HashMap();
    private static final HashMap<PortalURL.URLType, PortletURLProvider.TYPE> urlTypeMap;

    protected static final void load() {
        if (isDebug) {
            LOGGER.debug("Loaded.");
        }
    }

    public PortletURLProviderImpl(PortalURL url, PortletURLProvider.TYPE type, PortletWindow portletWindow, PortletRequestContext reqctx) {
        StringBuilder txt;
        this.url = url.clone();
        this.type = type;
        this.window = portletWindow.getId().getStringId();
        this.paramFactory = this.url.getPortletParameterFactory(reqctx);
        if (isTrace) {
            txt = new StringBuilder("Constructing PortalURLProviderImpl. ");
            txt.append("type=").append(type);
            txt.append(", URL type=").append(url.getType());
            txt.append(", target=").append(this.window);
            txt.append(", URL target=").append(url.getTargetWindow());
            LOGGER.debug(txt.toString());
        }
        if (isTrace) {
            txt = new StringBuilder("Before clearing parameters for window: ");
            txt.append(this.window);
            for (PortalURLParameter p : this.url.getParameters()) {
                if (!p.getWindowId().equals(this.window)) continue;
                txt.append("\nName: ").append(p.getName());
                txt.append(", Type: ").append(p.getType());
                txt.append(", Values: ").append(Arrays.toString(p.getValues()));
            }
            txt.append("\nActive Public Render Parameters:");
            PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
            List pups = mapper.getPRPsForWindow(this.window, false);
            for (PortalURLPublicParameter p : pups) {
                txt.append("\nName: ").append(p.getName());
                txt.append(", Type: ").append(p.getType());
                txt.append(", isRemoved: ").append(p.isRemoved());
                txt.append(", Values: ").append(Arrays.toString(p.getValues()));
            }
            LOGGER.debug(txt.toString());
        }
        this.url.setTargetWindow(this.window);
        this.url.clearParameters(this.window, "re");
        this.url.clearParameters(this.window, "ap");
        switch (type) {
            case ACTION: {
                this.url.setType(PortalURL.URLType.Action);
                break;
            }
            case RESOURCE: {
                this.url.setType(PortalURL.URLType.Resource);
                this.url.setCacheability("cacheLevelPage");
                break;
            }
            default: {
                this.url.setType(PortalURL.URLType.Render);
                if (url.isVersion3(this.window)) break;
                this.url.clearParameters(this.window, "rp");
            }
        }
        if (isTrace) {
            txt = new StringBuilder("Constructed PortalURLProviderImpl, set type. ");
            txt.append("new URL type=").append(this.url.getType());
            LOGGER.debug(txt.toString());
        }
    }

    public PortletURLProviderImpl(PortalURL url, PortletWindow portletWindow, PortletRequestContext reqctx) {
        this.url = url;
        this.type = urlTypeMap.get(url.getType());
        this.window = portletWindow.getId().getStringId();
        this.paramFactory = this.url.getPortletParameterFactory(reqctx);
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Created 'read-only' URL provider.");
            txt.append(" type=").append(this.type);
            txt.append(", URL type=").append(url.getType());
            txt.append(", window=").append(this.window);
            txt.append(", URL target=").append(url.getTargetWindow());
            LOGGER.debug(txt.toString());
        }
    }

    public PortalURL apply() {
        StringBuilder txt;
        if (isTrace) {
            txt = new StringBuilder("apply URL values: ");
            txt.append("type=").append(this.type);
            txt.append(", URL type=").append(this.url.getType());
            txt.append(", target=").append(this.url.getTargetWindow());
            LOGGER.debug(txt.toString());
        }
        if (isTrace) {
            txt = new StringBuilder("URL Parameters for window: ");
            txt.append(this.window);
            for (PortalURLParameter p : this.url.getParameters()) {
                if (!p.getWindowId().equals(this.window)) continue;
                txt.append("\nName: ").append(p.getName());
                txt.append(", Type: ").append(p.getType());
                txt.append(", Values: ").append(Arrays.toString(p.getValues()));
            }
            txt.append("\nActive Public Render Parameters:");
            PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
            List pups = mapper.getPRPsForWindow(this.window, false);
            for (PortalURLPublicParameter p : pups) {
                txt.append("\nName: ").append(p.getName());
                txt.append(", Type: ").append(p.getType());
                txt.append(", isRemoved: ").append(p.isRemoved());
                txt.append(", Values: ").append(Arrays.toString(p.getValues()));
            }
            LOGGER.debug(txt.toString());
        }
        return this.url;
    }

    public PortletURLProvider.TYPE getType() {
        return this.type;
    }

    public void setPortletMode(PortletMode mode) {
        this.url.setPortletMode(this.window, mode);
    }

    public PortletMode getPortletMode() {
        return this.url.getPortletMode(this.window);
    }

    public void setWindowState(WindowState state) {
        this.url.setWindowState(this.window, state);
    }

    public WindowState getWindowState() {
        return this.url.getWindowState(this.window);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        throw new PortletSecurityException("setSecure is not supported.");
    }

    public boolean isSecure() {
        return false;
    }

    public String getCacheability() {
        return this.url.getCacheability();
    }

    public void setCacheability(String cacheLevel) {
        this.url.setCacheability(cacheLevel);
    }

    public String getResourceID() {
        return this.url.getResourceID();
    }

    public void setResourceID(String resourceID) {
        this.url.setResourceID(resourceID);
    }

    public String toURL() {
        return this.toURL(false);
    }

    public String toURL(boolean absolute) {
        return this.apply().toURL(absolute);
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        String result = this.apply().toURL(false);
        if (escapeXML) {
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("'", "&#039;");
            result = result.replaceAll("\"", "&#034;");
        }
        out.write(result);
    }

    public Appendable append(Appendable out, boolean escapeXML) throws IOException {
        String result = this.apply().toURL(false);
        if (escapeXML) {
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("'", "&#039;");
            result = result.replaceAll("\"", "&#034;");
        }
        out.append(result);
        return out;
    }

    public Map<String, List<String>> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        }
        return this.properties;
    }

    public void addPublicRenderParameter(String windowId, String name, String[] values) {
        this.paramFactory.addPublicRenderParameter(windowId, name, values);
    }

    public void removePublicRenderParameter(String windowId, String name) {
        this.paramFactory.removePublicRenderParameter(windowId, name);
    }

    public boolean isPublicRenderParameter(String windowId, String name) {
        return this.paramFactory.isPublicRenderParameter(windowId, name);
    }

    public Set<String> getPrivateParameterNames(String windowId) {
        return this.paramFactory.getPrivateParameterNames(windowId);
    }

    public String[] getParameterValues(String windowId, String name) {
        return this.paramFactory.getParameterValues(windowId, name);
    }

    public void setParameter(String windowId, String name, String[] values) {
        this.paramFactory.setParameter(windowId, name, values);
    }

    public void removeParameter(String windowId, String name) {
        this.paramFactory.removeParameter(windowId, name);
    }

    public Map<String, String[]> getParameterMap(String windowId, PortletURLProvider.ParamType type) {
        return this.paramFactory.getParameterMap(windowId, paramTypeMap.get(type));
    }

    public void setParameter(String windowId, String name, PortletURLProvider.ParamType type, String[] values) {
        this.paramFactory.setParameter(windowId, name, paramTypeMap.get(type), values);
    }

    public void removeParameter(String windowId, String name, PortletURLProvider.ParamType type) {
        this.paramFactory.removeParameter(windowId, name, paramTypeMap.get(type));
    }

    public Set<String> getPublicParameterNames(String windowId) {
        return this.paramFactory.getPublicParameterNames(windowId);
    }

    public void setAuthenticated(boolean authenticated) {
        this.url.setAuthenticated(authenticated);
    }

    public boolean getAuthenticated() {
        return this.url.getAuthenticated();
    }

    public void setFragmentIdentifier(String fragment) {
        this.url.setFragmentIdentifier(fragment);
    }

    public String getFragmentIdentifier() {
        return this.url.getFragmentIdentifier();
    }

    public void clearParameters(String windowId, PortletURLProvider.ParamType type) {
        this.url.clearParameters(windowId, paramTypeMap.get(type));
    }

    static {
        paramTypeMap.put(PortletURLProvider.ParamType.ACTION, "ap");
        paramTypeMap.put(PortletURLProvider.ParamType.RENDER, "rp");
        paramTypeMap.put(PortletURLProvider.ParamType.RESOURCE, "re");
        paramTypeMap.put(PortletURLProvider.ParamType.PUBLIC, "sp");
        urlTypeMap = new HashMap();
        urlTypeMap.put(PortalURL.URLType.Action, PortletURLProvider.TYPE.ACTION);
        urlTypeMap.put(PortalURL.URLType.PartialAction, PortletURLProvider.TYPE.ACTION);
        urlTypeMap.put(PortalURL.URLType.AjaxAction, PortletURLProvider.TYPE.ACTION);
        urlTypeMap.put(PortalURL.URLType.Portal, PortletURLProvider.TYPE.RENDER);
        urlTypeMap.put(PortalURL.URLType.Render, PortletURLProvider.TYPE.RENDER);
        urlTypeMap.put(PortalURL.URLType.Resource, PortletURLProvider.TYPE.RESOURCE);
    }
}

