/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.List;
import java.util.Set;
import org.apache.pluto.container.PageResourceId;
import org.apache.pluto.driver.services.impl.resource.ResourceConfig;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PageResources;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.apache.pluto.driver.services.portal.admin.RenderConfigAdminService;

public class RenderConfigServiceImpl
implements RenderConfigService,
RenderConfigAdminService {
    private final ResourceConfig config;

    public RenderConfigServiceImpl(ResourceConfig config) {
        this.config = config;
    }

    public String getPortalName() {
        return this.config.getPortalName();
    }

    public String getPortalVersion() {
        return this.config.getPortalVersion();
    }

    public String getContainerName() {
        return this.config.getContainerName();
    }

    public Set<String> getSupportedPortletModes() {
        return this.config.getSupportedPortletModes();
    }

    public Set<String> getSupportedWindowStates() {
        return this.config.getSupportedWindowStates();
    }

    public List<PageConfig> getPages() {
        return this.config.getRenderConfig().getPages();
    }

    public PageConfig getDefaultPage() {
        return this.config.getRenderConfig().getPageConfig(null);
    }

    public PageConfig getPage(String id) {
        return this.config.getRenderConfig().getPageConfig(id);
    }

    public void addPage(PageConfig pageConfig) {
        this.config.getRenderConfig().addPage(pageConfig);
    }

    public void removePage(PageConfig pageConfig) {
        this.config.getRenderConfig().removePage(pageConfig);
    }

    public PageResources getPageResources() {
        return this.config.getResources();
    }

    public List<PageResourceId> getDefaultPageDependencies() {
        return this.config.getDefaultPageDependencies();
    }
}

