/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.pluto.driver.services.impl.resource.ResourceConfig;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.RenderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ResourceConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceConfigReader.class);
    public static final String CONFIG_FILE = "/WEB-INF/pluto-portal-driver-config.xml";
    private static ResourceConfigReader factory;
    private Digester digester = new Digester();

    public static ResourceConfigReader getFactory() {
        if (factory == null) {
            factory = new ResourceConfigReader();
        }
        return factory;
    }

    private ResourceConfigReader() {
        this.digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.init();
    }

    public ResourceConfig parse(InputStream in) throws IOException, SAXException {
        return (ResourceConfig)this.digester.parse(in);
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting up digester...");
        }
        this.digester.addObjectCreate("pluto-portal-driver", ResourceConfig.class);
        this.digester.addBeanPropertySetter("pluto-portal-driver/portal-name", "portalName");
        this.digester.addBeanPropertySetter("pluto-portal-driver/portal-version", "portalVersion");
        this.digester.addBeanPropertySetter("pluto-portal-driver/container-name", "containerName");
        this.digester.addCallMethod("pluto-portal-driver/supports/portlet-mode", "addSupportedPortletMode", 0);
        this.digester.addCallMethod("pluto-portal-driver/supports/window-state", "addSupportedWindowState", 0);
        this.digester.addCallMethod("pluto-portal-driver/page-resources/page-resource", "addResource", 5);
        this.digester.addCallParam("pluto-portal-driver/page-resources/page-resource/identifier/name", 0);
        this.digester.addCallParam("pluto-portal-driver/page-resources/page-resource/identifier/scope", 1);
        this.digester.addCallParam("pluto-portal-driver/page-resources/page-resource/identifier/version", 2);
        this.digester.addCallParam("pluto-portal-driver/page-resources/page-resource/source", 3, "type");
        this.digester.addCallParam("pluto-portal-driver/page-resources/page-resource/source", 4);
        this.digester.addCallMethod("pluto-portal-driver/page-resources/default-resource", "addDefaultPageDependency", 3);
        this.digester.addCallParam("pluto-portal-driver/page-resources/default-resource/name", 0);
        this.digester.addCallParam("pluto-portal-driver/page-resources/default-resource/scope", 1);
        this.digester.addCallParam("pluto-portal-driver/page-resources/default-resource/version", 2);
        this.digester.addObjectCreate("pluto-portal-driver/render-config", RenderConfig.class);
        this.digester.addSetProperties("pluto-portal-driver/render-config", "default", "defaultPageId");
        this.digester.addObjectCreate("pluto-portal-driver/render-config/page", PageConfig.class);
        this.digester.addSetProperties("pluto-portal-driver/render-config/page");
        this.digester.addCallMethod("pluto-portal-driver/render-config/page/portlet", "addPortlet", 2);
        this.digester.addCallParam("pluto-portal-driver/render-config/page/portlet", 0, "context");
        this.digester.addCallParam("pluto-portal-driver/render-config/page/portlet", 1, "name");
        this.digester.addCallMethod("pluto-portal-driver/render-config/page/dependency", "addPageDependency", 3);
        this.digester.addCallParam("pluto-portal-driver/render-config/page/dependency/name", 0);
        this.digester.addCallParam("pluto-portal-driver/render-config/page/dependency/scope", 1);
        this.digester.addCallParam("pluto-portal-driver/render-config/page/dependency/version", 2);
        this.digester.addSetNext("pluto-portal-driver/render-config/page", "addPage");
        this.digester.addSetNext("pluto-portal-driver/render-config", "setRenderConfig");
    }
}

