/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.SupportedModesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedModesServiceImpl
implements SupportedModesService {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedModesServiceImpl.class);
    private Set<PortletMode> supportedPortletModesByPortal = new HashSet<PortletMode>();
    private final PropertyConfigService propertyService;
    private final PortletContextService portletContextService;
    private final PortletRegistryService portletRegistry;

    public SupportedModesServiceImpl(PropertyConfigService propertyService, PortletContextService portletContextService, PortletRegistryService portletRegistry) {
        this.propertyService = propertyService;
        this.portletContextService = portletContextService;
        this.portletRegistry = portletRegistry;
        this.loadPortalModes();
    }

    public boolean isPortletModeSupported(String portletId, String mode) {
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder();
            txt.append("Determining support for PM: ").append(mode);
            txt.append(", portletID: ").append(portletId);
            txt.append(", by portal: ").append(this.isPortletModeSupportedByPortal(mode));
            txt.append(", by portlet: ").append(this.isPortletModeSupportedByPortlet(portletId, mode));
            txt.append(", is portlet managed: ").append(this.isPortletManagedMode(portletId, mode));
            LOG.debug(txt.toString());
        }
        return this.isPortletModeSupportedByPortal(mode) && this.isPortletModeSupportedByPortlet(portletId, mode) || this.isPortletManagedMode(portletId, mode);
    }

    public boolean isPortletModeSupportedByPortal(String mode) {
        return this.supportedPortletModesByPortal.contains(new PortletMode(mode));
    }

    public boolean isPortletModeSupportedByPortlet(String portletId, String mode) {
        String applicationId;
        if (mode.equalsIgnoreCase(PortletMode.VIEW.toString())) {
            return true;
        }
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        try {
            if (this.portletRegistry == null) {
                LOG.error("Optional Portlet Registry Service not found.");
                throw new PortletContainerException("Optional Portlet Registry Service not found.");
            }
            PortletApplicationDefinition ctx = this.portletRegistry.getPortletApplication(applicationName);
            for (Supports sd : ctx.getPortlet(portletName).getSupports()) {
                if (!sd.getMimeType().matches("(?:\\*|\\*/\\*|text/html|text/\\*)")) continue;
                for (String pm : sd.getPortletModes()) {
                    if (!pm.equalsIgnoreCase(mode)) continue;
                    return true;
                }
            }
        }
        catch (PortletContainerException e) {
            LOG.error("Error determining mode support.", (Throwable)e);
        }
        LOG.info("Portlet mode '" + mode + "' not found for portletId: '" + portletId + "'");
        return false;
    }

    private void loadPortalModes() {
        LOG.debug("Loading supported portal modes...");
        for (String mode : this.propertyService.getSupportedPortletModes()) {
            LOG.debug("Loading mode [" + mode + "]");
            this.supportedPortletModesByPortal.add(new PortletMode(mode));
        }
        LOG.debug("Loaded [" + this.supportedPortletModesByPortal.size() + "] supported portal modes");
    }

    public boolean isPortletManagedMode(String portletId, String mode) {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        try {
            PortletApplicationDefinition portletApp = this.portletRegistry.getPortletApplication(applicationName);
            for (CustomPortletMode customMode : portletApp.getCustomPortletModes()) {
                boolean isPortletManagedMode = !customMode.isPortalManaged();
                if (!isPortletManagedMode || !customMode.getPortletMode().equalsIgnoreCase(mode)) continue;
                return true;
            }
        }
        catch (PortletContainerException e) {
            LOG.error("Error determining portlet managed mode support, so we assume that it is false.", (Throwable)e);
        }
        return false;
    }

    public Set<PortletMode> getSupportedPortletModes(String portletId) throws PortletContainerException {
        String applicationId;
        HashSet<PortletMode> modeSet = new HashSet<PortletMode>();
        modeSet.add(PortletMode.VIEW);
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        if (this.portletRegistry == null) {
            LOG.error("Optional Portlet Registry Service not found.");
            throw new PortletContainerException("Optional Portlet Registry Service not found.");
        }
        PortletApplicationDefinition portletApp = this.portletRegistry.getPortletApplication(applicationName);
        for (Supports sd : portletApp.getPortlet(portletName).getSupports()) {
            if (!sd.getMimeType().matches("(?:\\*|\\*/\\*|text/html|text/\\*)")) continue;
            for (String pm : sd.getPortletModes()) {
                modeSet.add(new PortletMode(pm));
            }
        }
        return modeSet;
    }

    public PortletConfig getPortletConfig(String portletId) throws PortletContainerException {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        return this.portletContextService.getPortletConfig(applicationName, portletName);
    }
}

